/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.business.other.impl.OtherStorageOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherStorageOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class OtherStorageOrderPreemptionChoiceAction
extends AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(OtherStorageOrderPreemptionChoiceAction.class);
    @Resource
    private IInOtherStorageOrderDetailDomain inOtherStorageOrderDetailDomain;
    @Resource
    protected ICalcInventoryService calcInventoryService;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IOrderUnitConversionRecordDomain iOrderUnitConversionRecordDomain;

    @Override
    public void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
        log.info("\u8fdb\u5165\u4e86\u66f4\u65b0\u5176\u4ed6\u51fa\u5165\u7684OtherStorageOrderPreemptionChoiceAction\u9884\u5360\u52a8\u4f5c");
        StatemachineExecutorBo<InOtherStorageOrderEo> executorBo = StatemachineHelper.getExecutorBo(context);
        DgOtherStorageOrderTypeEnum orderTypeEnum = DgOtherStorageOrderTypeEnum.getByCode(((InOtherStorageOrderEo)executorBo.getEo()).getType());
        List inOtherStorageOrderDetailEos = (List)executorBo.getVariables().get(OtherStorageOrderContextEnum.OTHER_STORAGE_ORDER_DETAIL.getCode());
        InOtherStorageOrderEo eo = (InOtherStorageOrderEo)executorBo.getEo();
        Map<Object, OrderUnitConversionRecordDto> unitConversionRecordDtoMap = this.unitProcess(eo, inOtherStorageOrderDetailEos, true);
        this.orderUnitConversionRecordService.otherOrderVolumeAndWeightProcess(eo.getStorageOrderNo(), inOtherStorageOrderDetailEos);
        if (StrUtil.equals((CharSequence)"out", (CharSequence)orderTypeEnum.getFlag())) {
            PreemptDto preemptParam = new PreemptDto();
            if (StrUtil.equals((CharSequence)eo.getType(), (CharSequence)DgOtherStorageOrderTypeEnum.PARTS_REQUISITION.getCode())) {
                preemptParam.setValidNegative(Boolean.valueOf(false));
            }
            preemptParam.setSourceNo(eo.getStorageOrderNo());
            preemptParam.setSourceType(eo.getBusinessType());
            preemptParam.setRemark("\u9884\u5360");
            preemptParam.setExternalOrderNo(eo.getExternalOrderNo());
            preemptParam.setBusinessType(eo.getBusinessType());
            preemptParam.setNoneLineNo(Boolean.valueOf(true));
            ArrayList detailParams = Lists.newArrayList();
            for (InOtherStorageOrderDetailEo detailReqDto : inOtherStorageOrderDetailEos) {
                CalcDetailDto detailParam = new CalcDetailDto();
                OrderUnitConversionRecordDto orderUnitConversionRecordDto = unitConversionRecordDtoMap.get(this.getKey(detailReqDto.getSkuCode(), detailReqDto.getUnit()));
                detailParam.setNum(orderUnitConversionRecordDto.getToNum());
                detailParam.setSkuCode(detailReqDto.getSkuCode());
                String warehouseCode = eo.getWarehouseCode();
                detailParam.setLogicWarehouseCode(warehouseCode);
                detailParam.setInventoryProperty(detailParam.getInventoryProperty());
                detailParam.setBatch(detailReqDto.getBatch());
                preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
                detailParams.add(detailParam);
            }
            preemptParam.setDetails((List)detailParams);
            List<InventoryUsageRecordEo> inventoryUsageRecordEos = this.calcInventoryService.updatePreempt(preemptParam);
            log.info("\u5176\u4ed6\u51fa\u5165\u9884\u5360\u52a8\u4f5c:{}", (Object)preemptParam.getNoneBatch());
            log.info("\u66f4\u65b0\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(inventoryUsageRecordEos));
            if (preemptParam.getNoneBatch().booleanValue()) {
                this.updateOrderDetail(executorBo, inOtherStorageOrderDetailEos, inventoryUsageRecordEos);
            } else {
                this.inOtherStorageOrderDetailDomain.getMapper().updateBatchByIds(inOtherStorageOrderDetailEos);
            }
            if (InventoryConfig.isCanSupplyInventory()) {
                BaseOrderBaseContext baseOrderBaseContext = new BaseOrderBaseContext();
                baseOrderBaseContext.setRelevanceNo(eo.getStorageOrderNo());
                baseOrderBaseContext.setRelevanceTableName(CsRelevanceTableNameEnum.IN_OTHER_STORAGE_ORDER);
                baseOrderBaseContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
                baseOrderBaseContext.setBusinessType(eo.getBusinessType());
                baseOrderBaseContext.setExternalOrderNo(eo.getExternalOrderNo());
                InventoryConfig.getPushShareDispatchAble().push(baseOrderBaseContext);
            }
        } else {
            this.inOtherStorageOrderDetailDomain.getMapper().updateBatchByIds(inOtherStorageOrderDetailEos);
        }
    }

    private void updateOrderDetail(StatemachineExecutorBo<InOtherStorageOrderEo> executorBo, List<InOtherStorageOrderDetailEo> inOtherStorageOrderDetailEos, List<InventoryUsageRecordEo> inventoryUsageRecordEos) {
        log.info("updateOrderDetail-inOtherStorageOrderDetailEos\uff1a{}, inventoryPreemptionEos:{}", (Object)JSONObject.toJSONString(inOtherStorageOrderDetailEos), (Object)JSONObject.toJSONString(inventoryUsageRecordEos));
        Map inOtherStorageOrderDetailEoMap = inOtherStorageOrderDetailEos.stream().collect(Collectors.toMap(r -> r.getStorageOrderNo() + r.getSkuCode(), Function.identity(), (o, o1) -> o));
        Map<Object, OrderUnitConversionRecordDto> unitConversionRecordDtoMap = this.unitProcess(executorBo.getEo(), inOtherStorageOrderDetailEos, false);
        List inOtherStorageOrderDetailEoList = inventoryUsageRecordEos.stream().map(r -> {
            InOtherStorageOrderDetailEo otherStorageOrderDetailEo = (InOtherStorageOrderDetailEo)inOtherStorageOrderDetailEoMap.get(r.getSourceNo() + r.getSkuCode());
            log.info("inOtherStorageOrderDetailEoMap\u4e2d\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\u505a\u66f4\u65b0\u64cd\u4f5c\uff1a{}", (Object)JSONObject.toJSONString((Object)otherStorageOrderDetailEo));
            if (Objects.isNull(otherStorageOrderDetailEo)) {
                return null;
            }
            InOtherStorageOrderDetailEo inOtherStorageOrderDetailEo = new InOtherStorageOrderDetailEo();
            BeanUtil.copyProperties((Object)otherStorageOrderDetailEo, (Object)inOtherStorageOrderDetailEo, (String[])new String[0]);
            OrderUnitConversionRecordDto orderUnitConversionRecordDto = (OrderUnitConversionRecordDto)unitConversionRecordDtoMap.get(this.getKey(r.getSkuCode(), inOtherStorageOrderDetailEo.getUnit()));
            BigDecimal quantity = UnitTransferUtils.pareSaleNum((BigDecimal)r.getPreemptNum(), (OrderUnitConversionRecordDto)orderUnitConversionRecordDto, (boolean)false);
            inOtherStorageOrderDetailEo.setQuantity(quantity);
            BigDecimal volume = BigDecimalUtils.multiply((BigDecimal)otherStorageOrderDetailEo.getVolume(), (BigDecimal)BigDecimalUtils.divide((BigDecimal)quantity, (BigDecimal)otherStorageOrderDetailEo.getQuantity(), (int)6));
            BigDecimal weight = BigDecimalUtils.multiply((BigDecimal)otherStorageOrderDetailEo.getWeight(), (BigDecimal)BigDecimalUtils.divide((BigDecimal)quantity, (BigDecimal)otherStorageOrderDetailEo.getQuantity(), (int)6));
            inOtherStorageOrderDetailEo.setId(null);
            inOtherStorageOrderDetailEo.setStorageOrderNo(r.getSourceNo());
            inOtherStorageOrderDetailEo.setSkuCode(r.getSkuCode());
            inOtherStorageOrderDetailEo.setSkuName(r.getSkuName());
            inOtherStorageOrderDetailEo.setBatch(r.getBatch());
            inOtherStorageOrderDetailEo.setSpecification(otherStorageOrderDetailEo.getSpecification());
            inOtherStorageOrderDetailEo.setVolume(volume);
            inOtherStorageOrderDetailEo.setWeight(weight);
            return inOtherStorageOrderDetailEo;
        }).collect(Collectors.toList());
        InOtherStorageOrderDetailEo inOtherStorageOrderDetailEo = new InOtherStorageOrderDetailEo();
        inOtherStorageOrderDetailEo.setStorageOrderNo(executorBo.getEo().getStorageOrderNo());
        this.inOtherStorageOrderDetailDomain.delete((BaseEo)inOtherStorageOrderDetailEo);
        this.inOtherStorageOrderDetailDomain.insertBatch(inOtherStorageOrderDetailEoList);
    }

    private Map<Object, OrderUnitConversionRecordDto> unitProcess(InOtherStorageOrderEo inOtherStorageOrderEo, List<InOtherStorageOrderDetailEo> inOtherStorageOrderDetailEos, boolean canSave) {
        ArrayList unitConversionDetails = new ArrayList();
        inOtherStorageOrderDetailEos.forEach(detailEo -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(detailEo.getUnit());
            unitConversionDetail.setSkuCode(detailEo.getSkuCode());
            unitConversionDetail.setCurNum(detailEo.getQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(inOtherStorageOrderEo.getStorageOrderNo());
        orderUnitConversionReqDto.setType(inOtherStorageOrderEo.getType());
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
        return orderUnitConversionRecordDtos.stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private Object getKey(String skuCode, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + currentUnit;
    }
}

