/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.takeStock.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.convert.entity.InventoryTakeStockOrderItemConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryTakeStockOrderItemDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryTakeStockOrderItemDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryTakeStockOrderItemPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryTakeStockOrderItemEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.business.takeStock.IInventoryTakeStockOrderItemService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class InventoryTakeStockOrderItemServiceImpl
extends BaseServiceImpl<InventoryTakeStockOrderItemDto, InventoryTakeStockOrderItemEo, IInventoryTakeStockOrderItemDomain>
implements IInventoryTakeStockOrderItemService {
    @Resource
    protected ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;

    public InventoryTakeStockOrderItemServiceImpl(IInventoryTakeStockOrderItemDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryTakeStockOrderItemDto, InventoryTakeStockOrderItemEo> converter() {
        return InventoryTakeStockOrderItemConverter.INSTANCE;
    }

    @Override
    public List<InventoryTakeStockOrderItemDto> queryByOrderNo(String orderNo) {
        List itemEos = ((ExtQueryChainWrapper)((IInventoryTakeStockOrderItemDomain)this.domain).filter().eq((Object)"order_no", (Object)orderNo)).list();
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return null;
        }
        return this.converter().toDtoList(itemEos);
    }

    @Override
    public RestResponse<PageInfo<InventoryTakeStockOrderItemDto>> queryPage(InventoryTakeStockOrderItemPageReqDto dto) {
        List<String> skuCodeList;
        PageInfo pageInfo = (PageInfo)this.page((BaseDto)BeanCopyUtil.copy((Object)dto, InventoryTakeStockOrderItemDto.class), dto.getPageNum(), dto.getPageSize()).getData();
        List list = pageInfo.getList();
        List warehouseCodes = list.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getWarehouseCode())).map(InventoryTakeStockOrderItemDto::getWarehouseCode).collect(Collectors.toList());
        Map warehouseMap = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", new Object[]{CollectionUtil.isNotEmpty(warehouseCodes) ? warehouseCodes : ""})).list().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        HashMap skuMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)list) && CollectionUtil.isNotEmpty(skuCodeList = list.stream().map(InventoryTakeStockOrderItemDto::getSkuCode).collect(Collectors.toList()))) {
            List dtoList = this.itemDataQueryHelper.getByCodes(skuCodeList);
            Map dtoMap = dtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o1, o2) -> o1));
            skuMap.putAll(dtoMap);
        }
        list.forEach(o -> {
            if (skuMap.containsKey(o.getSkuCode())) {
                ItemSkuDto itemSkuDgRespDto = (ItemSkuDto)skuMap.get(o.getSkuCode());
                o.setSkuDisplayName(itemSkuDgRespDto.getSkuDisplayName());
                o.setBarCode(itemSkuDgRespDto.getBarCode());
            }
            if (warehouseMap.containsKey(o.getWarehouseCode())) {
                o.setOrganizationCode(((LogicWarehouseEo)warehouseMap.get(o.getWarehouseCode())).getOrganizationCode());
                o.setOrganizationName(((LogicWarehouseEo)warehouseMap.get(o.getWarehouseCode())).getOrganizationName());
            }
        });
        return new RestResponse((Object)pageInfo);
    }
}

