/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDetailDataQueryHelperImpl;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransferOrderReissueExe {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderReissueExe.class);
    @Resource
    private ITransferOrderDas transferOrderDas;
    @Resource
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private ItemDetailDataQueryHelperImpl itemDetailDataQueryHelper;
    @Resource
    private ICommonsMqService commonsMqService;

    public void reissue(String transferOrderNo) {
        if (!InventoryConfig.isTransferOrderReissue()) {
            return;
        }
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(transferOrderNo);
        List noticeOrderDetailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByRelevanceNo(transferOrderNo);
        if (CollectionUtils.isEmpty((Collection)noticeOrderDetailEoList)) {
            return;
        }
        List<ReceiveDeliveryNoticeOrderDetailEo> waitItemList = (noticeOrderDetailEoList = noticeOrderDetailEoList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getPreOrderNo())).collect(Collectors.toList())).stream().filter(item -> item.getPlanQuantity().compareTo(item.getDoneQuantity()) > 0).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(waitItemList)) {
            log.info("\u65e0\u5dee\u5f02,\u4e0d\u65b0\u589e\u8c03\u62e8\u5355");
            return;
        }
        log.info("\u8c03\u62e8\u5355: {}\u5173\u95ed\u540e\u5269\u4f59\u672a\u53d1\u8d27\u5546\u54c1: {}\uff0c\u91cd\u65b0\u53d1\u8d77\u8c03\u62e8\u5355", (Object)transferOrderNo, (Object)JSON.toJSONString(waitItemList));
        TransferOrderComboReqDto dto = new TransferOrderComboReqDto();
        dto.setCommitType("SAVE");
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        DtoHelper.eo2Dto((BaseEo)transferOrderEo, (BaseVo)transferOrderReqDto);
        transferOrderReqDto.setId(null);
        transferOrderReqDto.setTransferOrderNo(null);
        transferOrderReqDto.setExternalOrderNo(transferOrderEo.getTransferOrderNo());
        transferOrderReqDto.setShipmentEnterpriseCode(null);
        transferOrderReqDto.setShipmentEnterpriseName(null);
        transferOrderReqDto.setSourceShipmentEnterpriseCode(null);
        transferOrderReqDto.setShipmentSourceId(null);
        transferOrderReqDto.setShipmentSourceStatus(null);
        dto.setTransferOrderReqDto(transferOrderReqDto);
        ArrayList detailList = new ArrayList();
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq(StringUtils.isNotBlank((CharSequence)transferOrderNo), (Object)"document_code", (Object)transferOrderNo)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode() + o.getToUnit(), Function.identity(), (o2, o1) -> o2));
        List<String> skuCodes = waitItemList.stream().map(ReceiveDeliveryNoticeOrderDetailEo::getSkuCode).collect(Collectors.toList());
        List skuDgRespDtoList = this.itemDataQueryHelper.getByCodes(skuCodes);
        Map itemSkuMap = skuDgRespDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o2, o1) -> o2));
        List itemSkuDetailRespList = this.itemDetailDataQueryHelper.getByCodes(skuCodes);
        Map itemStorageSkuMap = itemSkuDetailRespList.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (o2, o1) -> o2));
        waitItemList.forEach(item -> {
            TransferOrderDetailReqDto detailReqDto = new TransferOrderDetailReqDto();
            ItemSkuDto itemSku = (ItemSkuDto)itemSkuMap.get(item.getSkuCode());
            if (itemSku == null) {
                return;
            }
            detailReqDto.setQuantity(item.getPlanQuantity().subtract(item.getDoneQuantity()));
            detailReqDto.setUnit(itemSku.getUnit());
            if (unitConversionMap.containsKey(item.getRelevanceNo() + item.getSkuCode() + itemSku.getUnit())) {
                this.unitConversion(detailReqDto, (OrderUnitConversionRecordEo)unitConversionMap.get(item.getRelevanceNo() + item.getSkuCode() + itemSku.getUnit()));
            }
            detailReqDto.setSkuCode(item.getSkuCode());
            detailReqDto.setSkuName(item.getSkuName());
            detailReqDto.setBatch(item.getBatch());
            detailReqDto.setInventoryProperty(item.getInventoryProperty());
            DgItemSkuDetailRespDto detailRespDto = (DgItemSkuDetailRespDto)itemStorageSkuMap.get(item.getSkuCode());
            if (detailRespDto != null) {
                detailReqDto.setStorageCondition(String.valueOf(detailRespDto.getStorage()));
            }
            detailList.add(detailReqDto);
        });
        dto.setDetailList(detailList);
        log.info("************************************************");
        log.info("\u53d1\u9001 {} MQ\u6d88\u606f: {}", (Object)"REISSUE_TRANSFER_ORDER", (Object)JSON.toJSONString((Object)dto));
        this.commonsMqService.publishMessage("SINGLE_TOPIC", "REISSUE_TRANSFER_ORDER", (Object)JSON.toJSONString((Object)dto));
    }

    private void unitConversion(TransferOrderDetailReqDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        BigDecimal toRate;
        dto.setUnit(unitConversionEo.getUnit());
        BigDecimal rate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getNum().divide(unitConversionEo.getToNum(), 6, RoundingMode.HALF_UP);
        BigDecimal bigDecimal = toRate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getToNum().divide(unitConversionEo.getNum(), 6, RoundingMode.HALF_UP);
        if (BigDecimalUtils.gt((BigDecimal)rate, (BigDecimal)toRate).booleanValue()) {
            dto.setQuantity(BigDecimalUtils.multiply((BigDecimal)dto.getQuantity(), (BigDecimal)rate));
        } else {
            dto.setQuantity(BigDecimalUtils.divide((BigDecimal)dto.getQuantity(), (BigDecimal)toRate));
        }
    }
}

