/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.inventory.dao.das.IReceiveDeliveryNoticeOrderDas;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalEvent;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class TransferOrderWithdrawExe {
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderWithdrawExe.class);
    @Resource
    private ITransferOrderDas transferOrderDas;
    @Autowired
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IReceiveDeliveryNoticeOrderDas receiveDeliveryNoticeOrderDas;

    public void waitingSecondWithdrawApprovalWithdraw(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        TransferOrderEo transferOrderEo = this.getContext(context);
        transferOrderEo.setApprovalStatus(TransferOrderApprovalState.PRIMARY_PENDING.getCode());
        transferOrderEo.setOrderStatus(TransferOrderStatus.WAITING_APPROVAL.code());
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
    }

    public void waitingForShipmentWithdraw(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        TransferOrderEo transferOrderEo = this.getContext(context);
        boolean isSuccessfullyWithdrawTheNotification = this.notificationWithdrawStep(transferOrderEo.getTransferOrderNo());
        AssertUtils.isTrue((boolean)isSuccessfullyWithdrawTheNotification, (String)"\u64a4\u56de\u901a\u77e5\u5355\u5931\u8d25\uff0c\u8c03\u62e8\u5355\u64a4\u56de\u5931\u8d25");
        transferOrderEo.setApprovalStatus(TransferOrderApprovalState.PRIMARY_PENDING.getCode());
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
    }

    private TransferOrderEo getContext(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        TransferOrderApprovalState sourceState = (TransferOrderApprovalState)context.getSource().getId();
        TransferOrderApprovalState targetState = (TransferOrderApprovalState)context.getTarget().getId();
        TransferOrderApprovalEvent event = (TransferOrderApprovalEvent)context.getEvent();
        logger.info("\u72b6\u6001\u673a: {}, \u63a5\u6536\u5230\u4e8b\u4ef6: {}, \u4ece {} \u72b6\u6001\u8f6c\u6362\u5230 {} \u72b6\u6001", new Object[]{context.getStateMachine().getId(), event.getDesc(), sourceState.getDesc(), targetState.getDesc()});
        String transferOrderNo = (String)context.getExtendedState().get((Object)"transferOrderNo", String.class);
        return this.transferOrderDas.selectByTransferOrderNo(transferOrderNo);
    }

    protected boolean wmsWithdrawStep(String transferOrderNo) {
        return true;
    }

    public boolean notificationWithdrawStep(String transferOrderNo) {
        ArrayList<String> orderStatus = new ArrayList<String>(4);
        orderStatus.add(BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode());
        orderStatus.add(BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode());
        orderStatus.add(BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        orderStatus.add(BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode());
        ArrayList<String> orderTypeList = new ArrayList<String>(2);
        orderTypeList.add("delivery");
        orderTypeList.add("receive");
        List csDeliveryNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDas.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).in((Object)"order_status", orderStatus)).in((Object)"order_type", orderTypeList)).list();
        if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderEoList)) {
            for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : csDeliveryNoticeOrderEoList) {
                BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(deliveryNoticeOrderEo.getDocumentNo()).sourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER_RELEASE.getCode()).build();
                commonCancelBo.setCancelBizOrder(Boolean.FALSE);
                if ("receive".equals(deliveryNoticeOrderEo.getOrderType())) {
                    this.baseOrderFacade.receiveNoticeOrderCancel(commonCancelBo);
                    continue;
                }
                commonCancelBo.setUpdateInventory(false);
                this.baseOrderFacade.deliveryNoticeOrderCancel(commonCancelBo);
            }
        }
        return true;
    }
}

