/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.action;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsInventoryStrategyEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.TransferGoodsStatusEnum;
import com.yunxi.dg.base.center.enums.TransferOrderEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.OrderUnitConversionRecordConverter;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDetailDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderApprovalExe;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderDeliveryExe;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderInventoryExe;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderLogisticsMappingAction;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.message.TransferGoodsOrderDetailDto;
import com.yunxi.dg.base.center.message.TransferGoodsOrderDto;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalEvent;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransferOrderApprovalAction {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderApprovalAction.class);
    @Resource
    private TransferOrderInventoryExe transferOrderInventoryExe;
    @Resource
    private ITransferOrderDas transferOrderDas;
    @Resource
    private ITransferOrderDetailDas transferOrderDetailDas;
    @Resource
    private TransferOrderApprovalExe transferOrderApprovalExe;
    @Resource
    private TransferOrderDeliveryExe deliveryExe;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private TransferOrderLogisticsMappingAction logisticsMappingAction;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Autowired
    protected IPhysicsWarehouseDomain physicsWarehouseDomain;

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void submitPrimary(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        log.debug("----------------------------\u8c03\u62e8\u5355\u63d0\u4ea4----------------------------------------------");
        Map variables = context.getExtendedState().getVariables();
        PreemptDto preemptParam = (PreemptDto)context.getExtendedState().get((Object)"preemptParam", PreemptDto.class);
        String outLogicWarehouseCode = (String)context.getExtendedState().get((Object)"outLogicWarehouseCode", String.class);
        String orderStatus = (String)context.getExtendedState().get((Object)"orderStatus", String.class);
        String approvalStatus = (String)context.getExtendedState().get((Object)"approvalStatus", String.class);
        String externalProcessState = (String)context.getExtendedState().get((Object)"externalProcessState", String.class);
        List detailList = (List)variables.get("detailList");
        this.transferOrderInventoryExe.preemptLogicInventory(preemptParam, outLogicWarehouseCode, (List<TransferOrderDetailReqDto>)detailList);
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(preemptParam.getSourceNo());
        if (InventoryConfig.isCanSupplyInventory() && InventoryConfig.getPushShareDispatchAble().canPush(PushAble.CanPushBo.builder().logicWarehouseCode(outLogicWarehouseCode).build())) {
            BaseOrderBaseContext baseOrderBaseContext = new BaseOrderBaseContext();
            baseOrderBaseContext.setRelevanceNo(transferOrderEo.getTransferOrderNo());
            baseOrderBaseContext.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
            baseOrderBaseContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
            baseOrderBaseContext.setBusinessType(transferOrderEo.getSubType());
            baseOrderBaseContext.setExternalOrderNo(transferOrderEo.getExternalOrderNo());
            InventoryConfig.getPushShareDispatchAble().push(baseOrderBaseContext);
        }
        if (transferOrderEo != null) {
            if (StringUtils.isNotBlank((CharSequence)orderStatus)) {
                transferOrderEo.setOrderStatus(orderStatus);
            } else {
                transferOrderEo.setOrderStatus(TransferOrderStatus.WAITING_APPROVAL.code());
            }
            if (StringUtils.isNotBlank((CharSequence)approvalStatus)) {
                transferOrderEo.setApprovalStatus(approvalStatus);
            } else {
                transferOrderEo.setApprovalStatus(TransferOrderApprovalState.PRIMARY_PENDING.getCode());
            }
            transferOrderEo.setExternalProcessState(externalProcessState);
            this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        }
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void hangUp(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        log.debug("----------------------------\u8c03\u62e8\u5355\u6302\u8d77----------------------------------------------");
        String orderNo = (String)context.getExtendedState().get((Object)"transferOrderNo", String.class);
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(orderNo);
        if (transferOrderEo != null) {
            transferOrderEo.setOrderStatus(TransferOrderApprovalState.TRANSFER_HANG_UP.getCode());
            this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        }
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void unHangUp(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        log.info("----------------------------\u8c03\u62e8\u5355\u89e3\u6302----------------------------------------------");
        String transferNo = (String)context.getExtendedState().get((Object)"transferOrderNo", String.class);
        TransferGoodsOrderDto transferGoodsOrderDto = (TransferGoodsOrderDto)context.getExtendedState().get((Object)"transferGoodsOrderDto", TransferGoodsOrderDto.class);
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(transferNo);
        if (TransferGoodsStatusEnum.isLendGoods((String)transferGoodsOrderDto.getOrderStatus()) && transferGoodsOrderDto.getOrderDetail().stream().anyMatch(x -> BigDecimalUtils.notEquals((BigDecimal)x.getQuantity(), (BigDecimal)x.getCompleteQuantity()))) {
            List transferOrderDetailEoList = ((ExtQueryChainWrapper)this.transferOrderDetailDomain.filter().eq((Object)"transfer_order_no", (Object)transferNo)).list();
            this.modifyTransferDetailNumber(transferOrderDetailEoList, transferGoodsOrderDto);
            ArrayList<TransferOrderDetailReqDto> detailList = new ArrayList<TransferOrderDetailReqDto>();
            DtoHelper.eoList2DtoList((Collection)transferOrderDetailEoList, detailList, TransferOrderDetailReqDto.class);
            this.transferOrderInventoryExe.preemptLogicInventory(this.buildPreempt(transferOrderEo), transferOrderEo.getOutLogicWarehouseCode(), detailList);
        }
        if (transferOrderEo != null) {
            transferOrderEo.setOrderStatus(TransferOrderStatus.WAITING_APPROVAL.code());
            this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        }
    }

    private void modifyTransferDetailNumber(List<TransferOrderDetailEo> transferOrderDetailEoList, TransferGoodsOrderDto transferGoodsOrderDto) {
        Map<String, BigDecimal> skuCode2UnLendNumMap = transferGoodsOrderDto.getOrderDetail().stream().collect(Collectors.toMap(TransferGoodsOrderDetailDto::getSkuCode, x -> BigDecimalUtils.subtract((BigDecimal)x.getQuantity(), (BigDecimal)x.getCompleteQuantity()), (o, o1) -> o));
        Map orderUnitConversionRecordDtoMap = this.orderUnitConversionRecordService.getRecordByOrderNo(transferGoodsOrderDto.getPreOrderNo()).stream().map(arg_0 -> ((OrderUnitConversionRecordConverter)OrderUnitConversionRecordConverter.INSTANCE).toDto(arg_0)).collect(Collectors.toMap(OrderUnitConversionRecordDto::getSkuCode, Function.identity(), (o, o1) -> o));
        String orderNo = transferGoodsOrderDto.getPreOrderNo();
        ArrayList updateList = new ArrayList();
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        calculateWeightAndVolumeBo.setVolumeDetailBos(transferOrderDetailEoList.stream().peek(r -> {
            if (skuCode2UnLendNumMap.containsKey(r.getSkuCode())) {
                BigDecimal unLendNum = (BigDecimal)skuCode2UnLendNumMap.get(r.getSkuCode());
                OrderUnitConversionRecordDto orderUnitConversionRecordDto = (OrderUnitConversionRecordDto)orderUnitConversionRecordDtoMap.get(r.getSkuCode());
                if (!orderUnitConversionRecordDto.getToUnit().equals(r.getUnit())) {
                    unLendNum = UnitTransferUtils.pareSaleNum((BigDecimal)unLendNum, (OrderUnitConversionRecordDto)orderUnitConversionRecordDto, (boolean)false);
                }
                log.info("\u53d8\u66f4\u8c03\u62e8\u5355\u5546\u54c1\uff1a{}\uff0c\u539f\u59cb\u6570\u91cf\uff1a{}\uff0c \u53d8\u66f4\u540e\u6570\u91cf\uff1a{}", new Object[]{r.getSkuCode(), r.getQuantity(), BigDecimalUtils.subtract((BigDecimal)r.getQuantity(), (BigDecimal)unLendNum)});
                r.setQuantity(BigDecimalUtils.subtract((BigDecimal)r.getQuantity(), (BigDecimal)unLendNum));
            }
            updateList.add(r);
        }).map(eo -> {
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
            calculateWeightAndVolumeDetailBo.setQuantity(eo.getQuantity());
            calculateWeightAndVolumeDetailBo.setUnit(eo.getUnit());
            calculateWeightAndVolumeDetailBo.setSkuCode(eo.getSkuCode());
            return calculateWeightAndVolumeDetailBo;
        }).collect(Collectors.toList()));
        calculateWeightAndVolumeBo.setDocumentCode(orderNo);
        calculateWeightAndVolumeBo.setCanTransferNum(false);
        Map<String, BasicOrderDtoExtension> volumeMap = null;
        try {
            volumeMap = this.orderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        }
        catch (Exception e) {
            log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38:{},:{}", new Object[]{e.getMessage(), orderNo, e});
            volumeMap = new HashMap<String, BasicOrderDtoExtension>();
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            for (TransferOrderDetailEo detailEo : updateList) {
                BasicOrderDtoExtension extension = volumeMap.get(detailEo.getSkuCode() + InventoryConfig.getCommonSeparate() + detailEo.getQuantity());
                if (extension != null) {
                    detailEo.setVolume(extension.getVolume());
                    detailEo.setWeight(extension.getWeight());
                }
                this.transferOrderDetailDomain.updateSelective((BaseEo)detailEo);
            }
        }
    }

    private PreemptDto buildPreempt(TransferOrderEo transferOrderEo) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(transferOrderEo.getTransferOrderNo());
        preemptParam.setExternalOrderNo(transferOrderEo.getPreOrderNo());
        preemptParam.setSourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER_PREEMPT.getCode());
        preemptParam.setBusinessType(transferOrderEo.getType());
        preemptParam.setValidNegative(Boolean.valueOf(true));
        preemptParam.setNoneLineNo(Boolean.valueOf(true));
        if (transferOrderEo.getNoBatch() != null && transferOrderEo.getNoBatch() == 1) {
            preemptParam.setNoneBatch(Boolean.valueOf(true));
            preemptParam.setShoutBatch(Boolean.valueOf(false));
        }
        return preemptParam;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void passPrimary(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        TransferOrderEo order = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
        if (StringUtils.isNotBlank((CharSequence)order.getShipmentEnterpriseCode())) {
            this.logisticsMappingAction.verify(order.getOutLogicWarehouseCode(), order.getShipmentEnterpriseCode());
        }
        String orderStatus = (String)context.getExtendedState().get((Object)"orderStatus", String.class);
        String approvalStatus = (String)context.getExtendedState().get((Object)"approvalStatus", String.class);
        String externalProcessState = (String)context.getExtendedState().get((Object)"externalProcessState", String.class);
        if (StringUtils.isNotBlank((CharSequence)orderStatus)) {
            order.setOrderStatus(orderStatus);
        } else {
            order.setOrderStatus(TransferOrderStatus.WAITING_SECONDARY_APPROVAL.code());
        }
        if (StringUtils.isNotBlank((CharSequence)approvalStatus)) {
            order.setApprovalStatus(TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode());
        } else {
            order.setApprovalStatus(approvalStatus);
        }
        order.setExternalProcessState(externalProcessState);
        this.transferOrderDas.updateSelective((BaseEo)order);
        String remark = (String)context.getExtendedState().get((Object)"remark", String.class);
        this.transferOrderApprovalExe.insertAuditLog("audit_pass", remark, order.getTransferOrderNo(), order.getType());
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void rejectPrimary(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        TransferOrderEo order = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
        this.transferOrderInventoryExe.release(order.getTransferOrderNo(), order.getType(), true);
        order.setOrderStatus(TransferOrderStatus.APPROVAL_REJECT.code());
        order.setApprovalStatus(TransferOrderApprovalState.PRIMARY_REJECTED.getCode());
        this.transferOrderDas.updateSelective((BaseEo)order);
        String remark = (String)context.getExtendedState().get((Object)"remark", String.class);
        this.transferOrderApprovalExe.insertAuditLog("audit_failed", remark, order.getTransferOrderNo(), order.getType());
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void passSecondary(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        boolean flag;
        log.info("============\u72b6\u6001\u673a\u8c03\u62e8\u5355\u66f4\u65b0\u4fe1\u606f===============\uff1a{}", (Object)JSONObject.toJSONString(context));
        TransferOrderEo transferOrderEo = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
        Boolean virtualOrderAutoComplete = (Boolean)context.getExtendedState().get((Object)"virtualOrderAutoComplete", Boolean.class);
        String remark = (String)context.getExtendedState().get((Object)"remark", String.class);
        String externalProcessState = (String)context.getExtendedState().get((Object)"externalProcessState", String.class);
        TransferOrderTypeEnum transferOrderTypeEnum = TransferOrderTypeEnum.getEnumByCode((String)transferOrderEo.getType());
        boolean bl = flag = transferOrderTypeEnum != null && CsInventoryStrategyEnum.VIRTUAL.getCode().equalsIgnoreCase(transferOrderTypeEnum.getVirtualTag()) || virtualOrderAutoComplete != false || YesNoEnum.YES.getValue().equals(transferOrderEo.getIsVirtual());
        if (TransferOrderTypeEnum.REVERSE_O_TO_O_TRANSFER.getCode().equals(transferOrderEo.getType()) || TransferOrderTypeEnum.DISMANTLING_TRANSFER.getCode().equals(transferOrderEo.getType()) || TransferOrderTypeEnum.TRANSFER_ACCOUNT.getCode().equalsIgnoreCase(transferOrderEo.getType())) {
            flag = true;
        }
        boolean canAutoIn = flag;
        boolean sendWms = flag;
        if (InventoryConfig.isEnableInOutAutoComplete() && !flag) {
            PhysicsWarehouseEo outPhysicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)transferOrderEo.getOutPhysicsWarehouseCode())).one();
            AssertUtil.assertNotNull((Object)outPhysicsWarehouseEo, (String)"\u8c03\u51fa\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            flag = 1 != outPhysicsWarehouseEo.getInterconnectionFlag();
            PhysicsWarehouseEo inPhysicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)transferOrderEo.getInPhysicsWarehouseCode())).one();
            AssertUtil.assertNotNull((Object)inPhysicsWarehouseEo, (String)"\u8c03\u5165\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            canAutoIn = 1 != inPhysicsWarehouseEo.getInterconnectionFlag();
            sendWms = 1 != inPhysicsWarehouseEo.getInterconnectionFlag();
        }
        log.info("\u8c03\u62e8\u662f\u5426\u51fa\u5165\u5e93\uff0c\u51fa\u5e93\u662f\u5426\u81ea\u52a8\u5b8c\u6210\uff1a{}\uff0c \u5165\u5e93\u662f\u5426\u81ea\u52a8\u5b8c\u6210\uff1a{}", (Object)flag, (Object)canAutoIn);
        if (flag) {
            log.info("\u66f4\u65b0\u865a\u62df\u8c03\u62e8\u5355\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)transferOrderEo));
            transferOrderEo.setOrderStatus(TransferOrderStatus.COMPLETED.code());
            this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
            this.transferOrderApprovalExe.insertAuditLog("audit_pass", remark, transferOrderEo.getTransferOrderNo(), transferOrderEo.getType());
            this.virtuallyTransfer(transferOrderEo, canAutoIn, sendWms);
            return;
        }
        ArrayList typeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_B_C.getCode(), TransferOrderTypeEnum.EXTERNAL_WAREHOUSE_B_C.getCode()});
        transferOrderEo.setOrderStatus(TransferOrderStatus.WAITING_FOR_DELIVERY.code());
        transferOrderEo.setShipmentStatus(TransferOrderDeliveryState.WAITING_FOR_DELIVERY.getCode());
        transferOrderEo.setApprovalStatus(TransferOrderApprovalState.SECONDARY_APPROVED.getCode());
        transferOrderEo.setDeliveryStatus(TransferOrderReceiveState.WAITING_FOR_DELIVERY.getCode());
        log.info("\u66f4\u65b0\u8c03\u62e8\u5355\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)transferOrderEo));
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        this.transferOrderApprovalExe.insertAuditLog("audit_pass", remark, transferOrderEo.getTransferOrderNo(), transferOrderEo.getType());
        CsTransferOrderRespDto respDto = (CsTransferOrderRespDto)BeanUtil.copyProperties((Object)transferOrderEo, CsTransferOrderRespDto.class, (String[])new String[0]);
        List detailList = this.transferOrderDetailDas.queryByTransferOrderNo(respDto.getTransferOrderNo());
        this.deliveryExe.generateDeliveryNoticeOrder(respDto, detailList, false);
    }

    private void virtuallyTransfer(TransferOrderEo transferOrderEo, boolean canAutoIn, boolean sendWms) {
        CsTransferOrderRespDto respDto = (CsTransferOrderRespDto)BeanUtil.copyProperties((Object)transferOrderEo, CsTransferOrderRespDto.class, (String[])new String[0]);
        List detailList = this.transferOrderDetailDas.queryByTransferOrderNo(respDto.getTransferOrderNo());
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = this.deliveryExe.getReceiveDeliveryNoticeOrderFacadeBo(respDto, detailList, true);
        facadeBo.setAutoComplete(true);
        if (TransferOrderEnum.TRANSFER_POSITION_ORDER.getCode().equals(transferOrderEo.getOrderType())) {
            facadeBo.setValidNegative(Boolean.FALSE);
        }
        facadeBo.setLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
        facadeBo.setLogicWarehouseName(respDto.getOutLogicWarehouseName());
        facadeBo.setPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
        facadeBo.setPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
        facadeBo.setTransferInLogicWarehouseCode(respDto.getInLogicWarehouseCode());
        facadeBo.setCanProcessIn(canAutoIn);
        boolean dispatcherOrderGenerate = Optional.ofNullable(transferOrderEo.getRemark()).orElse("").startsWith("\u6536\u53d1\u5dee\u5f02\u5904\u7406\u5355\u53f7");
        if (dispatcherOrderGenerate || StringUtils.isNotEmpty((CharSequence)respDto.getSourceSystem()) && "WMS".equalsIgnoreCase(respDto.getSourceSystem()) || TransferOrderEnum.INTER_ORGANIZATION_TRANSACTION_ORDER.getCode().equals(transferOrderEo.getOrderType())) {
            facadeBo.setSendWms(false);
        }
        log.info("\u865a\u62df\u8c03\u62e8\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)facadeBo));
        this.baseOrderFacade.deliveryNoticeOrderGen(facadeBo);
        if (canAutoIn) {
            facadeBo.setLogicWarehouseCode(respDto.getInLogicWarehouseCode());
            facadeBo.setLogicWarehouseName(respDto.getInLogicWarehouseName());
            facadeBo.setPhysicsWarehouseCode(respDto.getInPhysicsWarehouseCode());
            facadeBo.setPhysicsWarehouseName(respDto.getInPhysicsWarehouseName());
            this.baseOrderFacade.receiveNoticeOrderGen(facadeBo);
        }
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void rejectSecondary(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        TransferOrderEo order = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
        this.transferOrderInventoryExe.release(order.getTransferOrderNo(), order.getType(), true);
        order.setOrderStatus(TransferOrderStatus.APPROVAL_REJECT.code());
        order.setApprovalStatus(TransferOrderApprovalState.SECONDARY_REJECTED.getCode());
        this.transferOrderDas.updateSelective((BaseEo)order);
        String remark = (String)context.getExtendedState().get((Object)"remark", String.class);
        this.transferOrderApprovalExe.insertAuditLog("audit_failed", remark, order.getTransferOrderNo(), order.getType());
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void borrowGoods(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        TransferOrderEo order = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
    }
}

