/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.dao.mapper.StateMachineMapper;
import com.yunxi.dg.base.center.inventory.eo.StateMachineEo;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import javax.annotation.Resource;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.stereotype.Component;

@Component
public class DeliveryStateMachinePersist
implements StateMachinePersist<TransferOrderDeliveryState, TransferOrderDeliveryEvent, String> {
    @Resource
    private StateMachineMapper stateMachineMapper;

    private String convertToJson(StateMachineContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> ctx) {
        return JSON.toJSONString(ctx);
    }

    public void write(StateMachineContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> context, String transferOrderNo) throws Exception {
        StateMachineEo db = this.stateMachineMapper.selectByTypeAndMachineKey("DELIVERY", transferOrderNo);
        if (db == null) {
            StateMachineEo entity = new StateMachineEo();
            entity.setMachineKey(transferOrderNo);
            entity.setStatus(((TransferOrderDeliveryState)context.getState()).getCode());
            entity.setType("DELIVERY");
            this.stateMachineMapper.insert((Object)entity);
        } else {
            StateMachineEo entity = new StateMachineEo();
            entity.setId(db.getId());
            entity.setMachineKey(transferOrderNo);
            entity.setStatus(((TransferOrderDeliveryState)context.getState()).getCode());
            entity.setType("DELIVERY");
            this.stateMachineMapper.updateById((BaseEo)entity);
        }
    }

    public StateMachineContext<TransferOrderDeliveryState, TransferOrderDeliveryEvent> read(String transferOrderNo) throws Exception {
        StateMachineEo entity = this.stateMachineMapper.selectByTypeAndMachineKey("DELIVERY", transferOrderNo);
        if (entity != null) {
            TransferOrderDeliveryState approvalState = TransferOrderDeliveryState.getByCode((String)entity.getStatus());
            return new DefaultStateMachineContext((Object)approvalState, null, null, null, null, transferOrderNo);
        }
        return new DefaultStateMachineContext((Object)TransferOrderDeliveryState.WAITING_FOR_DELIVERY, null, null, null, null, transferOrderNo);
    }
}

