/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.helper;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.message.TransferGoodsOrderDto;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalEvent;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.stereotype.Component;

@Component
public class TransferOrderApprovalHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferOrderApprovalHelper.class);
    @Resource
    private ILockService lockService;
    @Resource
    private StateMachineFactory<TransferOrderApprovalState, TransferOrderApprovalEvent> approvalStateMachineFactory;
    @Autowired
    private StateMachinePersister<TransferOrderApprovalState, TransferOrderApprovalEvent, String> approvalStateMachinePersister;

    public boolean sendAuditEvent(TransferOrderApprovalEvent event, TransferOrderEo transferOrderEo, String remark, Boolean virtualOrderAutoComplete) {
        Mutex finalLock;
        String stateMachineKey = transferOrderEo.getTransferOrderNo();
        String key = "STATEMACHINE:EXECUTOR:" + stateMachineKey;
        int i = 60;
        LOGGER.info("\u8c03\u62e8\u5355\u5ba1\u6838\u4e8b\u4ef6key\uff1a{}", (Object)key);
        Mutex lock = null;
        StateMachine approvalStateMachine = this.approvalStateMachineFactory.getStateMachine(transferOrderEo.getTransferOrderNo());
        boolean result = false;
        try {
            lock = this.lockService.lock(key, "1", i, i * 2, TimeUnit.SECONDS);
            approvalStateMachine.start();
            this.approvalStateMachinePersister.restore(approvalStateMachine, (Object)transferOrderEo.getTransferOrderNo());
            approvalStateMachine.getExtendedState().getVariables().put("transferOrderEo", transferOrderEo);
            approvalStateMachine.getExtendedState().getVariables().put("transferOrderNo", transferOrderEo.getTransferOrderNo());
            approvalStateMachine.getExtendedState().getVariables().put("virtualOrderAutoComplete", virtualOrderAutoComplete);
            if (StringUtils.isNotBlank((CharSequence)remark)) {
                approvalStateMachine.getExtendedState().getVariables().put("remark", remark);
            }
            String preStatus = ((TransferOrderApprovalState)approvalStateMachine.getState().getId()).getCode();
            result = approvalStateMachine.sendEvent((Object)event);
            String errMsg = (String)approvalStateMachine.getExtendedState().getVariables().get("errMsg");
            if (result && StringUtils.isEmpty((CharSequence)errMsg)) {
                this.approvalStateMachinePersister.persist(approvalStateMachine, (Object)transferOrderEo.getTransferOrderNo());
            } else {
                LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u53d1\u8d27\u72b6\u6001\u673a", preStatus, event.getDesc(), false});
                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                    throw new BizException(errMsg);
                }
            }
            finalLock = lock;
        }
        catch (Exception e) {
            try {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
                throw new BizException(e.getMessage());
            }
            catch (Throwable throwable) {
                Mutex finalLock2 = lock;
                InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
                approvalStateMachine.stop();
                throw throwable;
            }
        }
        InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
        approvalStateMachine.stop();
        return result;
    }

    public void submitPrimary(PreemptDto preemptParam, List<TransferOrderDetailReqDto> detailList, TransferOrderReqDto transferOrderReqDto, TransferOrderEo transferOrderEo, List<TransferOrderDetailEo> detailEoList) {
        Mutex finalLock;
        String transferOrderNo = transferOrderEo.getTransferOrderNo();
        String key = "STATEMACHINE:EXECUTOR:" + transferOrderNo;
        int i = 60;
        LOGGER.info("\u8c03\u62e8\u5355\u63d0\u4ea4\u4e8b\u4ef6key\uff1a{}", (Object)key);
        Mutex lock = null;
        StateMachine approvalStateMachine = this.approvalStateMachineFactory.getStateMachine(transferOrderNo);
        try {
            lock = this.lockService.lock(key, "1", i, i * 2, TimeUnit.SECONDS);
            approvalStateMachine.start();
            this.approvalStateMachinePersister.restore(approvalStateMachine, (Object)transferOrderNo);
            approvalStateMachine.getExtendedState().getVariables().put("transferOrderEo", transferOrderEo);
            approvalStateMachine.getExtendedState().getVariables().put("preemptParam", preemptParam);
            approvalStateMachine.getExtendedState().getVariables().put("detailList", detailList);
            approvalStateMachine.getExtendedState().getVariables().put("outLogicWarehouseCode", transferOrderReqDto.getOutLogicWarehouseCode());
            approvalStateMachine.getExtendedState().getVariables().put("transferEo", transferOrderEo);
            approvalStateMachine.getExtendedState().getVariables().put("transferOrderReqDto", transferOrderReqDto);
            approvalStateMachine.getExtendedState().getVariables().put("detailEoList", detailEoList);
            String preStatus = ((TransferOrderApprovalState)approvalStateMachine.getState().getId()).getCode();
            boolean result = approvalStateMachine.sendEvent((Object)TransferOrderApprovalEvent.SUBMIT_PRIMARY);
            String errMsg = (String)approvalStateMachine.getExtendedState().getVariables().get("errMsg");
            if (result && StringUtils.isEmpty((CharSequence)errMsg)) {
                this.approvalStateMachinePersister.persist(approvalStateMachine, (Object)transferOrderNo);
            } else {
                LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u53d1\u8d27\u72b6\u6001\u673a", preStatus, TransferOrderDeliveryEvent.WAITING_FOR_DELIVERY_WITHDRAW.getDesc(), false});
                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                    throw new BizException(errMsg);
                }
            }
            finalLock = lock;
        }
        catch (Exception e) {
            try {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
                throw new BizException(e.getMessage());
            }
            catch (Throwable throwable) {
                Mutex finalLock2 = lock;
                InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
                approvalStateMachine.stop();
                throw throwable;
            }
        }
        InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
        approvalStateMachine.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(TransferOrderApprovalEvent event, String transferOrderNo) {
        Mutex finalLock;
        String key = "STATEMACHINE:EXECUTOR:" + transferOrderNo;
        int i = 60;
        Mutex lock = null;
        StateMachine approvalStateMachine = this.approvalStateMachineFactory.getStateMachine(transferOrderNo);
        try {
            lock = this.lockService.lock(key, "1", i, i * 2, TimeUnit.SECONDS);
            approvalStateMachine.start();
            this.approvalStateMachinePersister.restore(approvalStateMachine, (Object)transferOrderNo);
            approvalStateMachine.getExtendedState().getVariables().put("transferOrderNo", transferOrderNo);
            String preStatus = ((TransferOrderApprovalState)approvalStateMachine.getState().getId()).getCode();
            boolean result = approvalStateMachine.sendEvent((Object)event);
            LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u5ba1\u6838\u72b6\u6001\u673a", preStatus, event.getDesc(), result});
            if (!result) {
                LOGGER.error("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u5ba1\u6838\u72b6\u6001\u673a", preStatus, event.getDesc(), false});
                String errMsg = (String)approvalStateMachine.getExtendedState().getVariables().get("errMsg");
                throw new BizException(errMsg);
            }
            this.approvalStateMachinePersister.persist(approvalStateMachine, (Object)transferOrderNo);
            finalLock = lock;
        }
        catch (Exception e) {
            Mutex finalLock2;
            try {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
                finalLock2 = lock;
            }
            catch (Throwable throwable) {
                Mutex finalLock3 = lock;
                InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock3));
                approvalStateMachine.stop();
                throw throwable;
            }
            InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock3));
            approvalStateMachine.stop();
        }
        InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock3));
        approvalStateMachine.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUnHangUpEvent(TransferOrderApprovalEvent event, String transferOrderNo, TransferGoodsOrderDto transferGoodsOrderDto) {
        Mutex finalLock;
        String key = "STATEMACHINE:EXECUTOR:" + transferOrderNo;
        int i = 60;
        Mutex lock = null;
        StateMachine approvalStateMachine = this.approvalStateMachineFactory.getStateMachine(transferOrderNo);
        try {
            lock = this.lockService.lock(key, "1", i, i * 2, TimeUnit.SECONDS);
            approvalStateMachine.start();
            this.approvalStateMachinePersister.restore(approvalStateMachine, (Object)transferOrderNo);
            approvalStateMachine.getExtendedState().getVariables().put("transferOrderNo", transferOrderNo);
            approvalStateMachine.getExtendedState().getVariables().put("transferGoodsOrderDto", transferGoodsOrderDto);
            String preStatus = ((TransferOrderApprovalState)approvalStateMachine.getState().getId()).getCode();
            boolean result = approvalStateMachine.sendEvent((Object)event);
            LOGGER.info("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u5ba1\u6838\u72b6\u6001\u673a", preStatus, event.getDesc(), result});
            if (result) {
                this.approvalStateMachinePersister.persist(approvalStateMachine, (Object)transferOrderNo);
            } else {
                LOGGER.error("\u72b6\u6001\u673a: {}, \u524d\u7f6e\u72b6\u6001: {}, \u4e8b\u4ef6: {}, \u6267\u884c\u7ed3\u679c: {}", new Object[]{"\u5ba1\u6838\u72b6\u6001\u673a", preStatus, event.getDesc(), false});
            }
            finalLock = lock;
        }
        catch (Exception e) {
            Mutex finalLock2;
            try {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
                finalLock2 = lock;
            }
            catch (Throwable throwable) {
                Mutex finalLock3 = lock;
                InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock3));
                approvalStateMachine.stop();
                throw throwable;
            }
            InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock3));
            approvalStateMachine.stop();
        }
        InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock3));
        approvalStateMachine.stop();
    }
}

