/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.data.DataDictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptLendDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.FindDetailInventoyBo;
import com.yunxi.dg.base.center.inventory.service.calc.FindInventoryBo;
import com.yunxi.dg.base.center.inventory.service.calc.IPreemptAble;
import com.yunxi.dg.base.center.inventory.service.calc.RdsCalcExecuteManager;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PreemptAbleImpl
extends BaseAble
implements IPreemptAble {
    private static final Logger log = LoggerFactory.getLogger(PreemptAbleImpl.class);
    @Resource
    private IPcpDictQueryApiProxy pcpDictQueryApiProxy;
    @Resource
    private RdsCalcExecuteManager rdsCalcExecuteManager;

    @Override
    protected void check(CalcDto dto) {
        super.check(dto);
        PreemptDto dto1 = (PreemptDto)dto;
        dto1.setIsSaleOrder((Boolean)ObjectUtil.defaultIfNull((Object)((PreemptDto)dto).getIsSaleOrder(), (Object)false));
    }

    @Override
    public List<InventoryUsageRecordEo> preempt(PreemptDto dto) {
        log.info("warehouse inventory preempt(\u9884\u5360), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        List details = dto.getDetails();
        List inventoryUsageRecordEos = this.inventoryPreemptionDomain.queryBySourceNo(dto.getSourceNo());
        if (CollectionUtil.isNotEmpty((Collection)inventoryUsageRecordEos)) {
            if (!dto.getExistsForError().booleanValue()) {
                return inventoryUsageRecordEos;
            }
            throw new BizException(String.format("\u8be5\u5355\u636e[%s]\u5df2\u5b58\u5728\u6709\u6548\u9884\u5360\u8bb0\u5f55", dto.getSourceNo()));
        }
        List<String> logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List<String> skuCodes = details.stream().map(CalcDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(logicWarehouseCodes);
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodes);
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        if (dto.getDetails().stream().allMatch(r -> StringUtils.isNotBlank((CharSequence)r.getBatch()))) {
            return this.shoutPreempt(dto, skuDtoList, logicWarehouseEos);
        }
        return this.totalPreempt(dto, skuDtoList, logicWarehouseEos);
    }

    @Override
    public List<InventoryUsageRecordEo> updatePreempt(PreemptDto dto) {
        List inventoryUsageRecordEos;
        log.info("warehouse inventory updatePreempt(\u66f4\u65b0\u9884\u5360), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        List details = dto.getDetails();
        dto.setRemark("\u66f4\u65b0\u9884\u5360");
        Set logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).collect(Collectors.toSet());
        Set skuCodes = details.stream().map(CalcDetailDto::getSkuCode).collect(Collectors.toSet());
        ArrayList<String> releaseNos = new ArrayList<String>();
        releaseNos.add(dto.getSourceNo());
        if (StrUtil.isNotEmpty((CharSequence)dto.getReleaseDocumentNo())) {
            releaseNos.addAll(Arrays.stream(dto.getReleaseDocumentNo().split(",")).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)(inventoryUsageRecordEos = this.inventoryPreemptionDomain.queryBySourceNos(releaseNos)))) {
            ArrayList releaseDetails = Lists.newArrayList();
            for (InventoryUsageRecordEo preemptionEo : inventoryUsageRecordEos) {
                CalcDetailDto releaseDetail = new CalcDetailDto();
                releaseDetail.setNum(BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()));
                PreemptAbleImpl.settingBatch(preemptionEo, releaseDetail);
                releaseDetail.setSourceNo(preemptionEo.getSourceNo());
                releaseDetail.setSourceType(preemptionEo.getSourceType());
                releaseDetail.setBusinessType(preemptionEo.getBusinessType());
                releaseDetail.setLineNo(preemptionEo.getLineNo());
                releaseDetail.setSkuCode(preemptionEo.getSkuCode());
                releaseDetail.setLogicWarehouseCode(preemptionEo.getWarehouseCode());
                releaseDetail.setInventoryProperty(preemptionEo.getInventoryProperty());
                releaseDetail.setPreemptId(preemptionEo.getId());
                releaseDetail.setBeforePreemptNum(BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)preemptionEo.getReleaseNum()));
                releaseDetail.setAfterPreemptNum(BigDecimalUtils.subtract((BigDecimal)preemptionEo.getPreemptNum(), (BigDecimal)releaseDetail.getNum()));
                releaseDetails.add(releaseDetail);
            }
            dto.setReleaseDetails((List)releaseDetails);
            log.info("warehouse inventory updatePreempt(\u66f4\u65b0\u9884\u5360), merge param:{}", (Object)JSON.toJSONString((Object)dto));
            if (CollectionUtil.isNotEmpty((Collection)releaseDetails)) {
                logicWarehouseCodes.addAll(releaseDetails.stream().map(CalcDetailDto::getLogicWarehouseCode).collect(Collectors.toList()));
                skuCodes.addAll(releaseDetails.stream().map(CalcDetailDto::getSkuCode).collect(Collectors.toList()));
            }
            List preemptIds = inventoryUsageRecordEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.inventoryPreemptionDomain.allRelease(preemptIds);
        }
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(Lists.newArrayList(logicWarehouseCodes));
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(Lists.newArrayList(skuCodes));
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        if (!dto.getNoneBatch().booleanValue()) {
            return this.shoutPreempt(dto, skuDtoList, logicWarehouseEos);
        }
        return this.totalPreempt(dto, skuDtoList, logicWarehouseEos);
    }

    @Override
    @Deprecated
    public List<InventoryUsageRecordEo> batchPreempt(List<PreemptDto> dtoList) {
        log.info("warehouse inventory batchPreempt(\u6279\u91cf\u9884\u5360), param:{}", (Object)JSON.toJSONString(dtoList));
        for (PreemptDto preemptDto : dtoList) {
            this.check((CalcDto)preemptDto);
            this.checkDetails((CalcDto)preemptDto);
        }
        List sourceNos = dtoList.stream().map(CalcDto::getSourceNo).distinct().collect(Collectors.toList());
        List inventoryUsageRecordEos = this.inventoryPreemptionDomain.queryBySourceNos(sourceNos);
        if (CollectionUtil.isNotEmpty((Collection)inventoryUsageRecordEos)) {
            List existsNos = inventoryUsageRecordEos.stream().map(InventoryUsageRecordEo::getSourceNo).distinct().collect(Collectors.toList());
            throw new BizException(String.format("\u4ee5\u4e0b\u5355\u636e\u5df2\u5b58\u5728\u9884\u5360\u8bb0\u5f55: %s", existsNos));
        }
        HashSet logicWarehouseCodes = Sets.newHashSet();
        HashSet skuCodes = Sets.newHashSet();
        HashSet batches = Sets.newHashSet();
        HashSet propertySet = Sets.newHashSet();
        List<Object> logicInventoryEos = Lists.newArrayList();
        for (PreemptDto preemptDto : dtoList) {
            for (CalcDetailDto detail : preemptDto.getDetails()) {
                logicWarehouseCodes.add(detail.getLogicWarehouseCode());
                skuCodes.add(detail.getSkuCode());
                batches.add(detail.getBatch());
                batches.add(detail.getInventoryProperty());
            }
        }
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(Lists.newArrayList((Iterable)logicWarehouseCodes));
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(Lists.newArrayList((Iterable)skuCodes));
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        Boolean noneBatch = dtoList.get(0).getNoneBatch();
        if (null == noneBatch) {
            noneBatch = true;
        }
        if (!noneBatch.booleanValue() || !InventoryConfig.isNoneBatch()) {
            logicInventoryEos = this.queryLogicInventoryEos(new FindDetailInventoyBo(skuDtoList, logicWarehouseEos, Lists.newArrayList((Iterable)batches), new HashSet<String>(), new ArrayList<String>()));
            AssertUtils.notEmpty((Collection)logicInventoryEos, (String)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        } else {
            List<LogicInventoryEo> noneBatchLogicInventoryEos = this.queryLogicInventoryEos(new FindDetailInventoyBo(skuDtoList, logicWarehouseEos, Lists.newArrayList(), new HashSet<String>(), new ArrayList<String>()));
            HashSet shoutLogicInventoryEos = Sets.newHashSet();
            for (PreemptDto preemptDto : dtoList) {
                shoutLogicInventoryEos.addAll(this.shoutLogicInventoryEosAndSetDetails(preemptDto, logicWarehouseEos, skuDtoList, noneBatchLogicInventoryEos));
            }
            logicInventoryEos.addAll(shoutLogicInventoryEos);
        }
        List<LogicInventoryTotalEo> logicInventoryTotalEos = this.queryLogicInventoryTotalEos(new FindInventoryBo(skuDtoList, logicWarehouseEos, new ArrayList<String>(propertySet)));
        AssertUtils.notEmpty(logicInventoryTotalEos, (String)"\u603b\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
        return this.doBatchPreempt(dtoList, logicInventoryEos, logicInventoryTotalEos, skuDtoList, logicWarehouseEos);
    }

    protected List<InventoryUsageRecordEo> shoutPreempt(PreemptDto dto, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
        List details = dto.getDetails();
        List<String> batches = details.stream().map(CalcDetailDto::getBatch).distinct().collect(Collectors.toList());
        List<String> inventoryPropertyList = details.stream().map(CalcDetailDto::getInventoryProperty).distinct().collect(Collectors.toList());
        List<LogicInventoryEo> logicInventoryEos = this.queryLogicInventoryEos(new FindDetailInventoyBo(skuDtoList, logicWarehouseEos, batches, details.stream().map(r -> this.getKey(r.getLogicWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty())).collect(Collectors.toSet()), inventoryPropertyList));
        AssertUtils.notEmpty(logicInventoryEos, (String)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        List<LogicInventoryTotalEo> logicInventoryTotalEos = this.queryLogicInventoryTotalEos(new FindInventoryBo(skuDtoList, logicWarehouseEos, inventoryPropertyList));
        AssertUtils.notEmpty(logicInventoryTotalEos, (String)"\u903b\u8f91\u603b\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        return this.doPreempt(new DoPreemptBo(dto, logicInventoryEos, logicInventoryTotalEos, skuDtoList, logicWarehouseEos));
    }

    protected List<InventoryUsageRecordEo> totalPreempt(PreemptDto dto, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
        List<String> inventoryPropertyList = dto.getDetails().stream().map(CalcDetailDto::getInventoryProperty).distinct().collect(Collectors.toList());
        List<LogicInventoryEo> logicInventoryEos = this.queryLogicInventoryEos(new FindDetailInventoyBo(skuDtoList, logicWarehouseEos, Lists.newArrayList(), new HashSet<String>(), inventoryPropertyList));
        List<LogicInventoryEo> shoutLogicInventoryEos = InventoryConfig.isNoneBatch() ? logicInventoryEos : this.shoutLogicInventoryEosAndSetDetails(dto, logicWarehouseEos, skuDtoList, logicInventoryEos);
        this.checkDetails((CalcDto)dto);
        List<LogicInventoryTotalEo> logicInventoryTotalEos = this.queryLogicInventoryTotalEos(new FindInventoryBo(skuDtoList, logicWarehouseEos, inventoryPropertyList));
        AssertUtils.notEmpty(logicInventoryTotalEos, (String)"\u603b\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
        return this.doPreempt(new DoPreemptBo(dto, shoutLogicInventoryEos, logicInventoryTotalEos, skuDtoList, logicWarehouseEos));
    }

    private List<InventoryUsageRecordEo> doPreempt(DoPreemptBo doPreemptBo) {
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(doPreemptBo);
        Map<String, BigDecimal> lessNumMap = this.getLessNumMap(doPreemptBo.getDto(), doPreemptBo.getLogicInventoryEos(), doPreemptBo.getLogicInventoryTotalEos());
        ArrayList<Pair<InventoryUsageRecordEo, CalcDetailDto>> markRelationList = new ArrayList<Pair<InventoryUsageRecordEo, CalcDetailDto>>();
        List<InventoryUsageRecordEo> preemptionEos = this.createPreemptionEos(doPreemptBo.getDto(), doPreemptBo.getSkuDtoList(), doPreemptBo.getLogicWarehouseEos(), lessNumMap, markRelationList);
        this.setInventoryPreemptionDocument(preemptionEos);
        this.inventoryPreemptionDomain.insertBatch(preemptionEos);
        for (Pair pair : markRelationList) {
            if (((CalcDetailDto)pair.value).getPreetConsumer() == null) continue;
            ((CalcDetailDto)pair.value).getPreetConsumer().accept(((InventoryUsageRecordEo)pair.key).getId());
        }
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(doPreemptBo.getLogicWarehouseEos()).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(doPreemptBo.getLogicWarehouseEos()).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
        return preemptionEos;
    }

    private void setInventoryPreemptionDocument(List<InventoryUsageRecordEo> preemptionEoList) {
        if (CollUtil.isEmpty(preemptionEoList)) {
            return;
        }
        Set businessTypeSet = preemptionEoList.stream().map(InventoryUsageRecordEo::getBusinessType).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        if (CollUtil.isEmpty(businessTypeSet)) {
            return;
        }
        List dictDtoList = null;
        try {
            dictDtoList = this.dictDataQueryHelper.getByCodes(Lists.newArrayList(businessTypeSet));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u914d\u7f6e\u5f02\u5e38:{}", (Object)e.getMessage());
            return;
        }
        if (CollUtil.isEmpty(dictDtoList)) {
            return;
        }
        block2: for (InventoryUsageRecordEo preemptionEo : preemptionEoList) {
            String documentCode;
            String businessType = preemptionEo.getBusinessType();
            if (StrUtil.isBlank((CharSequence)businessType) || StrUtil.isNotBlank((CharSequence)(documentCode = preemptionEo.getDocumentCode()))) continue;
            for (DataDictDto dictDto : dictDtoList) {
                if (!StrUtil.equals((CharSequence)businessType, (CharSequence)dictDto.getSubValue())) continue;
                preemptionEo.setDocumentCode(dictDto.getGroupCode());
                preemptionEo.setDocumentName(dictDto.getDef1());
                continue block2;
            }
        }
    }

    private List<InventoryUsageRecordEo> doBatchPreempt(List<PreemptDto> dtoList, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
        ArrayList logicCalcDtoList = Lists.newArrayList();
        ArrayList logicTotalCalcDtoList = Lists.newArrayList();
        ArrayList preemptionEoList = Lists.newArrayList();
        ArrayList calcLogicInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcLogicInventoryEos, logicInventoryEos, LogicInventoryEo.class);
        for (PreemptDto preemptDto : dtoList) {
            CalcInventoryDto logicCalcDto = this.createLogicCalcDto(preemptDto, logicInventoryEos);
            CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
            Map<String, BigDecimal> lessNumMap = this.getLessNumMap(preemptDto, logicInventoryEos, logicInventoryTotalEos);
            List<InventoryUsageRecordEo> preemptionEos = this.createPreemptionEos(preemptDto, skuDtoList, logicWarehouseEos, lessNumMap, null);
            preemptionEoList.addAll(preemptionEos);
            logicCalcDtoList.add(logicCalcDto);
            logicTotalCalcDtoList.add(logicTotalCalcDto);
        }
        this.inventoryPreemptionDomain.insertBatch((List)preemptionEoList);
        this.saveLog(this.doBatchCalc(logicCalcDtoList, logicTotalCalcDtoList, logicWarehouseEos, calcLogicInventoryEos, logicInventoryTotalEos));
        return preemptionEoList;
    }

    private Map<String, BigDecimal> getLessNumMap(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        HashMap map = Maps.newHashMap();
        boolean noneBatch = InventoryConfig.isNoneBatch();
        if (noneBatch) {
            return map;
        }
        List calcDetailDtos = BeanUtil.copyToList((Collection)dto.getDetails(), CalcDetailDto.class);
        calcDetailDtos.stream().collect(Collectors.toMap(c -> this.getTotalKey(c.getSkuCode(), c.getLogicWarehouseCode(), c.getInventoryProperty()), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        })).values().forEach(detail -> {
            LogicInventoryTotalEo logicInventoryTotalEo = logicInventoryTotalEos.stream().filter(o -> StringUtils.equals((CharSequence)detail.getLogicWarehouseCode(), (CharSequence)o.getWarehouseCode()) && StringUtils.equals((CharSequence)detail.getSkuCode(), (CharSequence)o.getSkuCode())).findFirst().orElseThrow(() -> new BizException(StrUtil.format((CharSequence)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u4ed3\u5e93\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801 %s, \u6279\u6b21: %s", (Object[])new Object[]{detail.getLogicWarehouseCode(), detail.getSkuCode()})));
            BigDecimal afterTotalAvailable = BigDecimalUtils.subtract((BigDecimal)logicInventoryTotalEo.getAvailable(), (BigDecimal)detail.getNum());
            BigDecimal lessNum = BigDecimal.ZERO;
            if (BigDecimalUtils.ltZero((BigDecimal)afterTotalAvailable).booleanValue()) {
                lessNum = BigDecimalUtils.leZero((BigDecimal)logicInventoryTotalEo.getAvailable()) != false ? detail.getNum() : afterTotalAvailable;
            }
            map.put(this.getKey(detail.getLogicWarehouseCode(), detail.getSkuCode(), detail.getBatch(), detail.getInventoryProperty()), lessNum);
        });
        return map;
    }

    public CalcInventoryDto createLogicCalcDto(DoPreemptBo doPreemptBo) {
        PreemptDto dto = doPreemptBo.getDto();
        List<LogicInventoryEo> logicInventoryEos = doPreemptBo.getLogicInventoryEos();
        CalcInventoryDto calcInventoryDto = this.createBaseLogicCalcDto(doPreemptBo.getDto());
        ArrayList details = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)dto.getReleaseDetails())) {
            for (CalcDetailDto releaseDetail : dto.getReleaseDetails()) {
                CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
                detailDto.setOperate((String)DataExtractUtils.ifNullElse((Object)dto.getRemark(), (Object)"\u91ca\u653e\u9884\u5360"));
                detailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
                detailDto.setChangeAvailable(releaseDetail.getNum());
                detailDto.setSourceNo(releaseDetail.getSourceNo());
                detailDto.setSourceType(releaseDetail.getSourceType());
                if (dto.getIsSaleOrder().booleanValue()) {
                    detailDto.setChangeAllocate(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
                }
                detailDto.setBusinessType(releaseDetail.getBusinessType());
                detailDto.setWarehouseCode(releaseDetail.getLogicWarehouseCode());
                detailDto.setSkuCode(releaseDetail.getSkuCode());
                PreemptAbleImpl.settingBatch(detailDto, releaseDetail);
                detailDto.setBatch(releaseDetail.getBatch());
                detailDto.setValidNegative(Boolean.valueOf(false));
                detailDto.setInventoryProperty(releaseDetail.getInventoryProperty());
                detailDto.setPreemptId(releaseDetail.getPreemptId());
                detailDto.setBeforePreemptNum(releaseDetail.getBeforePreemptNum());
                detailDto.setAfterPreemptNum(releaseDetail.getAfterPreemptNum());
                details.add(detailDto);
            }
        }
        this.getLogicInventoryEos(logicInventoryEos, dto.getReleaseDetails());
        this.batchDetailProcess(doPreemptBo, dto, logicInventoryEos, details);
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    public void getLogicInventoryEos(List<LogicInventoryEo> logicInventoryEos, List<CalcDetailDto> releaseDetails) {
        CalcExecuteBo calcExecuteBo = this.rdsCalcExecuteManager.getCalcBatchExecuteBo();
        log.info("\u8fdb\u884c\u91ca\u653e\u9884\u5360\u52a0\u5230\u903b\u8f91\u4ed3\u5e93\u5b58\u7684\u64cd\u4f5c:{}", (Object)JSON.toJSONString((Object)calcExecuteBo));
        if (Objects.nonNull(calcExecuteBo)) {
            List inventoryDetailDtos = calcExecuteBo.getCalcDto().stream().flatMap(r -> r.getDetails().stream()).map(r -> (CalcInventoryDetailDto)BeanUtil.copyProperties((Object)r, CalcInventoryDetailDto.class, (String[])new String[0])).collect(Collectors.toList());
            Map detailDtoMap = inventoryDetailDtos.stream().collect(Collectors.toMap(r -> this.getKey(r.getWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty()), Function.identity(), (o, o1) -> {
                o.setChangePreempt(BigDecimalUtils.add((BigDecimal)o.getChangePreempt(), (BigDecimal)o1.getChangePreempt()));
                o.setChangeAvailable(BigDecimalUtils.add((BigDecimal)o.getChangeAvailable(), (BigDecimal)o1.getChangeAvailable()));
                o.setChangeBalance(BigDecimalUtils.add((BigDecimal)o.getChangeBalance(), (BigDecimal)o1.getChangeBalance()));
                return o;
            }));
            logicInventoryEos.forEach(v -> Optional.ofNullable(detailDtoMap.get(this.getKey(v.getWarehouseCode(), v.getSkuCode(), v.getBatch(), v.getInventoryProperty()))).ifPresent(r -> {
                v.setAvailable(BigDecimalUtils.add((BigDecimal)v.getAvailable(), (BigDecimal)r.getChangeAvailable()));
                v.setBalance(BigDecimalUtils.add((BigDecimal)v.getBalance(), (BigDecimal)r.getChangeBalance()));
                v.setPreempt(BigDecimalUtils.add((BigDecimal)v.getPreempt(), (BigDecimal)r.getChangePreempt()));
            }));
            Set<String> keys = logicInventoryEos.stream().map(v -> this.getKey(v.getWarehouseCode(), v.getSkuCode(), v.getBatch(), v.getInventoryProperty())).collect(Collectors.toSet());
            keys.forEach(detailDtoMap::remove);
            if (!detailDtoMap.isEmpty()) {
                logicInventoryEos.addAll(detailDtoMap.values().stream().map(r -> {
                    LogicInventoryEo logicInventoryEo = (LogicInventoryEo)BeanUtil.copyProperties((Object)r, LogicInventoryEo.class, (String[])new String[0]);
                    logicInventoryEo.setPreempt(r.getChangePreempt());
                    logicInventoryEo.setAvailable(r.getChangeAvailable());
                    logicInventoryEo.setBalance(r.getChangeBalance());
                    return logicInventoryEo;
                }).filter(r -> BigDecimalUtils.gtZero((BigDecimal)r.getAvailable())).collect(Collectors.toList()));
            }
        }
        if (CollectionUtils.isNotEmpty(releaseDetails)) {
            Map calcDetailDtoMap = releaseDetails.stream().collect(Collectors.toMap(r -> this.getKey(r.getLogicWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty()), Function.identity(), (o, o1) -> o));
            logicInventoryEos.forEach(v -> Optional.ofNullable(calcDetailDtoMap.get(this.getKey(v.getWarehouseCode(), v.getSkuCode(), v.getBatch(), v.getInventoryProperty()))).ifPresent(r -> {
                v.setAvailable(BigDecimalUtils.add((BigDecimal)v.getAvailable(), (BigDecimal)r.getNum()));
                v.setPreempt(BigDecimalUtils.subtract((BigDecimal)v.getPreempt(), (BigDecimal)r.getNum()));
            }));
        }
        log.info("\u8fdb\u884c\u91ca\u653e\u9884\u5360\u52a0\u5230\u903b\u8f91\u4ed3\u5e93\u5b58\u7684\u64cd\u4f5c,\u6700\u7ec8\u5e93\u5b58\u4e3a:{}", (Object)JSON.toJSONString(logicInventoryEos));
    }

    private void batchDetailProcess(DoPreemptBo doPreemptBo, PreemptDto dto, List<LogicInventoryEo> logicInventoryEos, List<CalcInventoryDetailDto> details) {
        boolean lendEnable = dto.isLendEnable();
        if (lendEnable) {
            if (dto.isOldBatchPriority()) {
                this.batchPriority(dto, logicInventoryEos);
            } else if (this.availablePriority(doPreemptBo, dto, details)) {
                return;
            }
        }
        this.detailBuilder(dto, details);
    }

    private void batchPriority(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos) {
        logicInventoryEos.clear();
        logicInventoryEos.addAll(this.getLogicInventoryEos(dto));
        HashMap warehouseSkuLendMapping = new HashMap(10);
        dto.getDetails().stream().filter(d -> Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).isPresent()).forEach(d -> {
            String totalKey = this.getTotalKey(d.getLogicWarehouseCode(), d.getSkuCode(), d.getInventoryProperty());
            warehouseSkuLendMapping.put(this.getTotalKey(d.getLendDto().getLendKey(), d.getSkuCode(), d.getInventoryProperty()), totalKey);
        });
        Map<String, List<LogicInventoryEo>> canDispatchMap = logicInventoryEos.stream().sorted(Comparator.comparing(LogicInventoryEo::getBatch)).collect(Collectors.groupingBy(r -> warehouseSkuLendMapping.containsKey(this.getTotalKey(r.getWarehouseCode(), r.getSkuCode(), r.getInventoryProperty())) ? (String)warehouseSkuLendMapping.get(this.getTotalKey(r.getWarehouseCode(), r.getSkuCode(), r.getInventoryProperty())) : this.getTotalKey(r.getWarehouseCode(), r.getSkuCode(), r.getInventoryProperty())));
        List calcDetailDtos = BeanUtil.copyToList((Collection)dto.getDetails(), CalcDetailDto.class);
        Map needMap = calcDetailDtos.stream().collect(Collectors.toMap(c -> this.getTotalKey(c.getLogicWarehouseCode(), c.getSkuCode(), c.getInventoryProperty()), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        }));
        Map<String, BigDecimal> batchAvaMap = logicInventoryEos.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch(), Collectors.mapping(LogicInventoryEo::getAvailable, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        HashMap matchDetailsMap = new HashMap(10);
        needMap.forEach((totalKey, needDetail) -> {
            List canList = ((List)canDispatchMap.get(totalKey)).stream().sorted(Comparator.comparing(LogicInventoryEo::getBatch).thenComparing(r -> warehouseSkuLendMapping.containsKey(this.getTotalKey(r.getWarehouseCode(), r.getSkuCode(), r.getInventoryProperty())) ? 1 : 0)).collect(Collectors.toList());
            BigDecimal num = needDetail.getNum();
            ArrayList<CalcDetailDto> matchDetails = new ArrayList<CalcDetailDto>();
            String[] s = totalKey.split(InventoryConfig.getCommonSeparate());
            for (int i = 0; i < canList.size() && !BigDecimalUtils.leZero((BigDecimal)num).booleanValue(); ++i) {
                boolean lastFlag;
                LogicInventoryEo logicInventoryEo = (LogicInventoryEo)canList.get(i);
                String batchKey = logicInventoryEo.getSkuCode() + InventoryConfig.getCommonSeparate() + logicInventoryEo.getBatch();
                BigDecimal realDecimal = (BigDecimal)batchAvaMap.get(batchKey);
                BigDecimal available = BigDecimalUtils.gt((BigDecimal)realDecimal, (BigDecimal)logicInventoryEo.getAvailable()) != false ? logicInventoryEo.getAvailable() : realDecimal;
                CalcDetailDto calcDetailDto = new CalcDetailDto();
                calcDetailDto.setNeedLendNum(BigDecimal.ZERO);
                calcDetailDto.setCanLendNum(BigDecimal.ZERO);
                calcDetailDto.setLogicWarehouseCode(logicInventoryEo.getWarehouseCode());
                calcDetailDto.setSkuCode(logicInventoryEo.getSkuCode());
                calcDetailDto.setBatch(logicInventoryEo.getBatch());
                boolean bl = lastFlag = canList.size() - 1 == i;
                if (!lastFlag && BigDecimalUtils.leZero((BigDecimal)available).booleanValue()) continue;
                if (num.compareTo(available) > 0 && !lastFlag) {
                    calcDetailDto.setNum(available);
                    batchAvaMap.compute(batchKey, (k, v) -> BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)available));
                    num = BigDecimalUtils.subtract((BigDecimal)num, (BigDecimal)available);
                } else {
                    calcDetailDto.setNum(num);
                    if (lastFlag && BigDecimalUtils.leZero((BigDecimal)available).booleanValue()) {
                        calcDetailDto.setNeedLendNum(num);
                        batchAvaMap.put(batchKey, BigDecimal.ZERO);
                    } else {
                        batchAvaMap.compute(batchKey, (k, v) -> BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)available));
                        num = BigDecimal.ZERO;
                    }
                }
                matchDetails.add(calcDetailDto);
            }
            Map<String, BigDecimal> avaMap = logicInventoryEos.stream().collect(Collectors.toMap(r -> this.getKey(r.getWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty()), LogicInventoryEo::getAvailable, (o, o1) -> o));
            List detailDtos = matchDetails.stream().collect(Collectors.groupingBy(CalcDetailDto::getBatch)).values().stream().map(value -> {
                if (value.size() > 1) {
                    CalcDetailDto lendDetail;
                    CalcDetailDto calcDetailDto;
                    if (((CalcDetailDto)value.get(0)).getLogicWarehouseCode().equals(s[0])) {
                        calcDetailDto = (CalcDetailDto)value.get(0);
                        lendDetail = (CalcDetailDto)value.get(1);
                    } else {
                        calcDetailDto = (CalcDetailDto)value.get(1);
                        lendDetail = (CalcDetailDto)value.get(0);
                    }
                    calcDetailDto.setNeedLendNum(lendDetail.getNum());
                    BigDecimal lendAvailable = (BigDecimal)avaMap.get(this.getKey(lendDetail.getLogicWarehouseCode(), lendDetail.getSkuCode(), lendDetail.getBatch(), lendDetail.getInventoryProperty()));
                    calcDetailDto.setCanLendNum(lendAvailable);
                    calcDetailDto.setNum(BigDecimalUtils.add((BigDecimal)calcDetailDto.getNum(), (BigDecimal)lendDetail.getNum()));
                    BigDecimal available = (BigDecimal)avaMap.get(this.getKey(calcDetailDto.getLogicWarehouseCode(), lendDetail.getSkuCode(), lendDetail.getBatch(), lendDetail.getInventoryProperty()));
                    AssertUtils.isTrue((boolean)BigDecimalUtils.geZero((BigDecimal)BigDecimalUtils.subtract((BigDecimal)calcDetailDto.getNum(), (BigDecimal)BigDecimalUtils.add((BigDecimal)lendAvailable, (BigDecimal)available))), (String)"\u501f\u5360\u6279\u6b21\u53ef\u7528\u4e0d\u8db3:{}", (String)JSONObject.toJSONString((Object)calcDetailDto));
                    return calcDetailDto;
                }
                if (!((CalcDetailDto)value.get(0)).getLogicWarehouseCode().equals(s[0])) {
                    CalcDetailDto calcDetailDto = (CalcDetailDto)value.get(0);
                    BigDecimal available = (BigDecimal)avaMap.get(this.getKey(calcDetailDto.getLogicWarehouseCode(), calcDetailDto.getSkuCode(), calcDetailDto.getBatch(), calcDetailDto.getInventoryProperty()));
                    calcDetailDto.setNeedLendNum(calcDetailDto.getNum());
                    calcDetailDto.setCanLendNum(available);
                    calcDetailDto.setLogicWarehouseCode(s[0]);
                }
                return (CalcDetailDto)value.get(0);
            }).collect(Collectors.toList());
            matchDetailsMap.put(totalKey, detailDtos);
        });
        log.info("\u501f\u5360\u5339\u914d:{}", (Object)JSONObject.toJSONString(matchDetailsMap));
        dto.setDetails(matchDetailsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private List<LogicInventoryEo> getLogicInventoryEos(PreemptDto dto) {
        Set warehouseCodeSet = dto.getDetails().stream().filter(d -> Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).isPresent()).map(c -> c.getLendDto().getLendKey()).collect(Collectors.toSet());
        warehouseCodeSet.addAll(dto.getDetails().stream().map(CalcDetailDto::getLogicWarehouseCode).collect(Collectors.toList()));
        HashSet filterKeySet = new HashSet(10);
        if (dto.getShoutBatch().booleanValue()) {
            dto.getDetails().forEach(d -> {
                filterKeySet.add(d.getLogicWarehouseCode() + InventoryConfig.getCommonSeparate() + d.getSkuCode() + InventoryConfig.getCommonSeparate() + d.getBatch());
                Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).ifPresent(r -> filterKeySet.add(r.getLendKey() + InventoryConfig.getCommonSeparate() + d.getSkuCode() + InventoryConfig.getCommonSeparate() + d.getBatch()));
            });
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().in((Object)"warehouse_code", warehouseCodeSet)).in((Object)"sku_code", (Collection)dto.getDetails().stream().map(CalcDetailDto::getSkuCode).collect(Collectors.toSet()))).in(dto.getShoutBatch().booleanValue(), (Object)"batch", (Collection)dto.getDetails().stream().map(CalcDetailDto::getBatch).collect(Collectors.toSet()))).list().stream().filter(r -> dto.getShoutBatch() == false || filterKeySet.contains(r.getWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch())).collect(Collectors.toList());
    }

    private boolean availablePriority(DoPreemptBo doPreemptBo, PreemptDto dto, List<CalcInventoryDetailDto> details) {
        Map<String, BigDecimal> totalLessMap = this.getLessMap(doPreemptBo, dto);
        if (totalLessMap.isEmpty()) {
            this.detailBuilder(dto, details);
            return true;
        }
        List<LogicInventoryEo> logicInventoryEoList = this.getLogicInventoryEos(dto);
        Map lendWarehouseMap = logicInventoryEoList.stream().collect(Collectors.toMap(inv -> this.getKey(inv.getWarehouseCode(), inv.getSkuCode(), inv.getBatch(), inv.getInventoryProperty()), Function.identity()));
        Map<String, List<LogicInventoryEo>> canLendMap = logicInventoryEoList.stream().collect(Collectors.groupingBy(inv -> this.getTotalKey(inv.getWarehouseCode(), inv.getSkuCode(), inv.getInventoryProperty())));
        Map finalLendWarehouseMap = lendWarehouseMap;
        HashMap<String, BigDecimal> batchLessMap = new HashMap<String, BigDecimal>(10);
        HashMap lendWarehouseSkuMapping = new HashMap(10);
        dto.getDetails().stream().filter(d -> totalLessMap.containsKey(this.getTotalKey(d.getLogicWarehouseCode(), d.getSkuCode(), d.getInventoryProperty())) && Optional.ofNullable(d.getLendDto()).filter(r -> PreemptLendDto.LendType.WAREHOUSE.equals((Object)r.getLendType())).isPresent() && canLendMap.containsKey(this.getTotalKey(d.getLendDto().getLendKey(), d.getSkuCode(), d.getInventoryProperty()))).forEach(d -> {
            String key = this.getKey(d.getLogicWarehouseCode(), d.getSkuCode(), d.getBatch(), d.getInventoryProperty());
            String lendKey = this.getKey(d.getLendDto().getLendKey(), d.getSkuCode(), d.getBatch(), d.getInventoryProperty());
            String totalKey = this.getTotalKey(d.getLogicWarehouseCode(), d.getSkuCode(), d.getInventoryProperty());
            lendWarehouseSkuMapping.put(totalKey, this.getTotalKey(d.getLendDto().getLendKey(), d.getSkuCode(), d.getInventoryProperty()));
            Optional.ofNullable(finalLendWarehouseMap.get(lendKey)).ifPresent(logicInventoryEo -> {
                BigDecimal less = (BigDecimal)totalLessMap.get(totalKey);
                BigDecimal afterLess = BigDecimalUtils.subtract((BigDecimal)less, (BigDecimal)logicInventoryEo.getAvailable());
                if (BigDecimalUtils.gtZero((BigDecimal)afterLess).booleanValue()) {
                    totalLessMap.put(totalKey, afterLess);
                    finalLendWarehouseMap.remove(lendKey);
                    d.setNeedLendNum(logicInventoryEo.getAvailable());
                    batchLessMap.put(key, logicInventoryEo.getAvailable());
                } else {
                    logicInventoryEo.setAvailable(logicInventoryEo.getAvailable().subtract(less));
                    totalLessMap.remove(totalKey);
                    d.setNeedLendNum(less);
                    batchLessMap.put(key, less);
                }
            });
        });
        AssertUtils.isTrue((!dto.isLendForceBatchEnable() || totalLessMap.isEmpty() ? 1 : 0) != 0, (String)"\u501f\u9884\u5360\u5e93\u5b58\u4e0d\u8db3");
        if (!totalLessMap.isEmpty()) {
            ArrayList removeList = Lists.newArrayList();
            totalLessMap.forEach((k, v) -> {
                List inventoryEoList = finalLendWarehouseMap.entrySet().stream().filter(r -> ((String)r.getKey()).startsWith((String)lendWarehouseSkuMapping.get(k))).map(Map.Entry::getValue).collect(Collectors.toList());
                BigDecimal less = v;
                for (LogicInventoryEo logicInventoryEo : inventoryEoList) {
                    BigDecimal afterLess = less.subtract(logicInventoryEo.getAvailable());
                    if (!BigDecimalUtils.gtZero((BigDecimal)afterLess).booleanValue()) {
                        removeList.add(k);
                        BigDecimal finalLess = less;
                        batchLessMap.compute(k + InventoryConfig.getCommonSeparate() + logicInventoryEo.getBatch(), (k1, v1) -> BigDecimalUtils.check((BigDecimal)((BigDecimal)batchLessMap.get(k1))).add(finalLess));
                        return;
                    }
                    batchLessMap.compute(k + InventoryConfig.getCommonSeparate() + logicInventoryEo.getBatch(), (k1, v1) -> BigDecimalUtils.check((BigDecimal)((BigDecimal)batchLessMap.get(k1))).add(logicInventoryEo.getAvailable()));
                    less = afterLess;
                }
            });
            removeList.forEach(totalLessMap::remove);
            AssertUtils.isTrue((boolean)totalLessMap.isEmpty(), (String)"\u501f\u9884\u5360\u5e93\u5b58\u4e0d\u8db3");
            Map detailDtoMap = dto.getDetails().stream().peek(r -> r.setNeedLendNum(BigDecimalUtils.check((BigDecimal)r.getNeedLendNum()))).collect(Collectors.toMap(inv -> this.getKey(inv.getLogicWarehouseCode(), inv.getSkuCode(), inv.getBatch(), inv.getInventoryProperty()), Function.identity()));
            batchLessMap.forEach((k, v) -> {
                if (detailDtoMap.containsKey(k)) {
                    CalcDetailDto calcDetailDto = (CalcDetailDto)detailDtoMap.get(k);
                    if (calcDetailDto.getNeedLendNum().compareTo((BigDecimal)v) < 0) {
                        calcDetailDto.setNum(BigDecimalUtils.add((BigDecimal)calcDetailDto.getNum(), (BigDecimal)BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)calcDetailDto.getNeedLendNum())));
                        calcDetailDto.setNeedLendNum(v);
                    }
                } else {
                    CalcDetailDto calcDetailDto = new CalcDetailDto();
                    calcDetailDto.setNum(v);
                    calcDetailDto.setNeedLendNum(v);
                    String[] s = k.split(InventoryConfig.getCommonSeparate());
                    calcDetailDto.setLogicWarehouseCode(s[0]);
                    calcDetailDto.setSkuCode(s[1]);
                    calcDetailDto.setBatch(s[2]);
                    calcDetailDto.setInventoryProperty(s[3]);
                    dto.getDetails().add(calcDetailDto);
                    detailDtoMap.entrySet().stream().filter(r -> ((String)r.getKey()).startsWith(this.getTotalKey(s[0], s[1], s[3])) && ((CalcDetailDto)r.getValue()).getNum().subtract(((CalcDetailDto)r.getValue()).getNeedLendNum()).compareTo((BigDecimal)v) > -1).findFirst().ifPresent(d -> ((CalcDetailDto)d.getValue()).setNum(((CalcDetailDto)d.getValue()).getNum().subtract((BigDecimal)v)));
                }
            });
        }
        return false;
    }

    private void detailBuilder(PreemptDto dto, List<CalcInventoryDetailDto> details) {
        for (CalcDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            detailDto.setChangePreempt(pd.getNum());
            if (dto.getIsSaleOrder().booleanValue()) {
                detailDto.setChangeAllocate(pd.getNum());
            }
            detailDto.setLendInventory(pd.getCanLendNum());
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setInventoryProperty(pd.getInventoryProperty());
            PreemptAbleImpl.settingBatch(detailDto, pd);
            if ("99999999-hidden".equals(pd.getBatch())) {
                detailDto.setValidNegative(Boolean.valueOf(false));
            } else {
                detailDto.setValidNegative(dto.getValidNegative());
            }
            detailDto.setAfterPreemptNum(pd.getNum());
            detailDto.setExpireTime(pd.getExpireDate());
            detailDto.setProduceTime(pd.getProduceDate());
            details.add(detailDto);
            pd.setPreetConsumer(arg_0 -> ((CalcInventoryDetailDto)detailDto).setPreemptId(arg_0));
        }
    }

    private Map<String, BigDecimal> getLessMap(DoPreemptBo doPreemptBo, PreemptDto dto) {
        List calcDetailDtos = BeanUtil.copyToList((Collection)dto.getDetails(), CalcDetailDto.class);
        Map<String, BigDecimal> lessMap = calcDetailDtos.stream().collect(Collectors.toMap(c -> this.getTotalKey(c.getLogicWarehouseCode(), c.getSkuCode(), c.getInventoryProperty()), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        })).values().stream().collect(Collectors.toMap(c -> this.getTotalKey(c.getLogicWarehouseCode(), c.getSkuCode(), c.getInventoryProperty()), detail -> {
            LogicInventoryTotalEo logicInventoryTotalEo = doPreemptBo.getLogicInventoryTotalEos().stream().filter(o -> StringUtils.equals((CharSequence)detail.getLogicWarehouseCode(), (CharSequence)o.getWarehouseCode()) && StringUtils.equals((CharSequence)detail.getSkuCode(), (CharSequence)o.getSkuCode())).findFirst().orElseThrow(() -> new BizException(StrUtil.format((CharSequence)"\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u4ed3\u5e93\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801 %s, \u6279\u6b21: %s", (Object[])new Object[]{detail.getLogicWarehouseCode(), detail.getSkuCode()})));
            BigDecimal afterTotalAvailable = BigDecimalUtils.subtract((BigDecimal)logicInventoryTotalEo.getAvailable(), (BigDecimal)detail.getNum());
            BigDecimal lessNum = BigDecimal.ZERO;
            if (BigDecimalUtils.ltZero((BigDecimal)afterTotalAvailable).booleanValue()) {
                lessNum = BigDecimalUtils.leZero((BigDecimal)logicInventoryTotalEo.getAvailable()) != false ? detail.getNum() : afterTotalAvailable;
            }
            return BigDecimalUtils.abs((BigDecimal)lessNum);
        }));
        HashMap filterLessMap = Maps.newHashMap();
        lessMap.forEach((k, v) -> {
            if (BigDecimalUtils.gtZero((BigDecimal)v).booleanValue()) {
                filterLessMap.put(k, v);
            }
        });
        return filterLessMap;
    }

    private void lendProcess(List<LogicInventoryEo> logicInventoryEos, boolean lendEnable, CalcDetailDto pd, CalcInventoryDetailDto detailDto, Map<String, LogicInventoryEo> lendWarehouseMap) {
        Optional.ofNullable(pd.getLendDto()).filter(r -> lendEnable).ifPresent(lendDto -> {
            LogicInventoryEo logicInventoryEo = logicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)pd.getLogicWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)pd.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)pd.getBatch())).findFirst().orElse(null);
            AssertUtils.isFalse((null == logicInventoryEo ? 1 : 0) != 0, (String)String.format("\u903b\u8f91\u5e93\u5b58\u67e5\u8be2\u4fe1\u606f\u4e0d\u5b58\u5728, \u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s, \u6279\u6b21: %s", pd.getLogicWarehouseCode(), pd.getSkuCode(), pd.getBatch()));
            switch (lendDto.getLendType()) {
                case WAREHOUSE: {
                    Optional.ofNullable(lendWarehouseMap.get(this.getKey(lendDto.getLendKey(), pd.getSkuCode(), pd.getBatch(), detailDto.getInventoryProperty()))).ifPresent(r -> detailDto.setLendInventory(r.getAvailable()));
                    break;
                }
                case INVENTORY_TYPE_TRANSIT: {
                    detailDto.setLendInventory(BigDecimalUtils.check((BigDecimal)logicInventoryEo.getIntransit()));
                    break;
                }
                case INVENTORY_TYPE_WAIT_RECEIVE: {
                    detailDto.setLendInventory(BigDecimalUtils.check((BigDecimal)logicInventoryEo.getFutureIn()));
                    break;
                }
                case INVENTORY_PROPERTY_WAIT_INSPECTION: {
                    break;
                }
            }
        });
    }

    public CalcInventoryDto createLogicCalcDto(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos) {
        return this.createLogicCalcDto(dto, (CalcDetailDto source, CalcInventoryDetailDto target) -> {
            LogicInventoryEo logicInventoryEo = logicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)source.getLogicWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)source.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)source.getBatch())).findFirst().orElse(null);
            AssertUtils.isFalse((null == logicInventoryEo ? 1 : 0) != 0, (String)String.format("\u903b\u8f91\u5e93\u5b58\u67e5\u8be2\u4fe1\u606f\u4e0d\u5b58\u5728, \u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s, \u6279\u6b21: %s", source.getLogicWarehouseCode(), source.getSkuCode(), source.getBatch()));
            target.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)source.getNum()));
            target.setChangePreempt(source.getNum());
            if (dto.getIsSaleOrder().booleanValue()) {
                target.setChangeAllocate(source.getNum());
            }
            logicInventoryEo.setAvailable(BigDecimalUtils.subtract((BigDecimal)logicInventoryEo.getAvailable(), (BigDecimal)source.getNum()));
        });
    }

    private List<InventoryUsageRecordEo> createPreemptionEos(PreemptDto dto, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos, Map<String, BigDecimal> lessNumMap, List<Pair<InventoryUsageRecordEo, CalcDetailDto>> markRelationList) {
        ArrayList inventoryUsageRecordEos = Lists.newArrayList();
        for (int i = 0; i < dto.getDetails().size(); ++i) {
            CalcDetailDto detail = (CalcDetailDto)dto.getDetails().get(i);
            ItemSkuDto skuDto = skuDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detail.getSkuCode())).findFirst().orElse(null);
            AssertUtils.notNull((Object)skuDto, (String)"\u5546\u54c1\u67e5\u8be2\u4e0d\u5b58\u5728");
            LogicWarehouseEo logicWarehouseEo = logicWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detail.getLogicWarehouseCode())).findFirst().orElse(null);
            AssertUtils.notNull((Object)logicWarehouseEo, (String)"\u903b\u8f91\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
            String mapKey = this.getKey(logicWarehouseEo.getWarehouseCode(), skuDto.getSkuCode(), detail.getBatch(), detail.getInventoryProperty());
            BigDecimal lessNum = lessNumMap.get(mapKey);
            InventoryUsageRecordEo inventoryPreemptEo = this.createInventoryPreemptEo(dto, detail, skuDto, logicWarehouseEo, Optional.ofNullable(detail.getNeedLendNum()).orElse(lessNum));
            if (null == inventoryPreemptEo.getLineNo()) {
                inventoryPreemptEo.setLineNo(Long.valueOf((long)(i + 1) * 10L));
            }
            if (markRelationList != null) {
                markRelationList.add((Pair<InventoryUsageRecordEo, CalcDetailDto>)Pair.newof((Object)inventoryPreemptEo, (Object)detail));
            }
            inventoryUsageRecordEos.add(inventoryPreemptEo);
        }
        this.setSourceType(inventoryUsageRecordEos);
        return inventoryUsageRecordEos;
    }

    private void setSourceType(List<InventoryUsageRecordEo> inventoryUsageRecordEos) {
        if (CollUtil.isEmpty(inventoryUsageRecordEos)) {
            return;
        }
        Set businessTypeSet = inventoryUsageRecordEos.stream().map(InventoryUsageRecordEo::getBusinessType).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        if (CollUtil.isEmpty(businessTypeSet)) {
            return;
        }
        List dictDtoList = null;
        try {
            dictDtoList = this.dictDataQueryHelper.getByCodes(Lists.newArrayList(businessTypeSet));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u914d\u7f6e\u5f02\u5e38:{}", (Object)e.getMessage());
            return;
        }
        if (CollUtil.isEmpty(dictDtoList)) {
            return;
        }
        block2: for (InventoryUsageRecordEo inventoryUsageRecordEo : inventoryUsageRecordEos) {
            String businessType = inventoryUsageRecordEo.getBusinessType();
            if (StrUtil.isBlank((CharSequence)businessType)) continue;
            for (DataDictDto dictDto : dictDtoList) {
                if (!StrUtil.equals((CharSequence)businessType, (CharSequence)dictDto.getSubValue())) continue;
                inventoryUsageRecordEo.setSourceType(dictDto.getCode());
                continue block2;
            }
        }
    }

    private InventoryUsageRecordEo createInventoryPreemptEo(PreemptDto dto, CalcDetailDto detail, ItemSkuDto skuDto, LogicWarehouseEo warehouseEo, BigDecimal lessNum) {
        InventoryUsageRecordEo inventoryUsageRecordEo = this.getBaseInventoryUsageRecordEo(dto, detail, skuDto, warehouseEo);
        inventoryUsageRecordEo.setActivityFlag(YesNoHelper.NO);
        inventoryUsageRecordEo.setRemark(dto.getRemark());
        inventoryUsageRecordEo.setBusinessType(dto.getBusinessType());
        Optional.ofNullable(detail.getLendDto()).ifPresent(lendDto -> inventoryUsageRecordEo.setExtension(JSONObject.toJSONString((Object)lendDto)));
        inventoryUsageRecordEo.setLessNum(BigDecimalUtils.abs((BigDecimal)lessNum));
        if (InventoryConfig.isPreemptHiddenBatch() && "99999999-hidden".equals(inventoryUsageRecordEo.getBatch())) {
            inventoryUsageRecordEo.setBatch(null);
        }
        return inventoryUsageRecordEo;
    }

    private static class DoPreemptBo {
        private final PreemptDto dto;
        private final List<LogicInventoryEo> logicInventoryEos;
        private final List<LogicInventoryTotalEo> logicInventoryTotalEos;
        private final List<ItemSkuDto> skuDtoList;
        private final List<LogicWarehouseEo> logicWarehouseEos;

        private DoPreemptBo(PreemptDto dto, List<LogicInventoryEo> logicInventoryEos, List<LogicInventoryTotalEo> logicInventoryTotalEos, List<ItemSkuDto> skuDtoList, List<LogicWarehouseEo> logicWarehouseEos) {
            this.dto = dto;
            this.logicInventoryEos = logicInventoryEos;
            this.logicInventoryTotalEos = logicInventoryTotalEos;
            this.skuDtoList = skuDtoList;
            this.logicWarehouseEos = logicWarehouseEos;
        }

        public PreemptDto getDto() {
            return this.dto;
        }

        public List<LogicInventoryEo> getLogicInventoryEos() {
            return this.logicInventoryEos;
        }

        public List<LogicInventoryTotalEo> getLogicInventoryTotalEos() {
            return this.logicInventoryTotalEos;
        }

        public List<ItemSkuDto> getSkuDtoList() {
            return this.skuDtoList;
        }

        public List<LogicWarehouseEo> getLogicWarehouseEos() {
            return this.logicWarehouseEos;
        }
    }
}

