/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.FindDetailInventoyBo;
import com.yunxi.dg.base.center.inventory.service.calc.ISyncAble;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncAbleImpl
extends BaseAble
implements ISyncAble {
    private static final Logger log = LoggerFactory.getLogger(SyncAbleImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void sync(List<LogicInventoryDto> inventoryList) {
        log.info("\u5e93\u5b58\u540c\u6b65\u62a5\u6587:{}", (Object)JSONUtil.toJsonStr(inventoryList));
        List<String> warehouseCodes = inventoryList.stream().map(LogicInventoryDto::getWarehouseCode).collect(Collectors.toList());
        List<String> skuCodes = inventoryList.stream().map(LogicInventoryDto::getSkuCode).collect(Collectors.toList());
        List<String> batchList = inventoryList.stream().peek(r -> r.setBatch((String)ObjectUtil.defaultIfNull((Object)r.getBatch(), (Object)InventoryConfig.getDefaultBatch()))).map(LogicInventoryDto::getBatch).collect(Collectors.toList());
        List<String> inventoryPropertyList = inventoryList.stream().peek(r -> r.setInventoryProperty((String)ObjectUtil.defaultIfNull((Object)r.getInventoryProperty(), (Object)LogicWarehouseQualityEnum.QUALIFIED.getCode()))).map(LogicInventoryDto::getInventoryProperty).collect(Collectors.toList());
        Set<String> filterKeys = inventoryList.stream().map(r -> this.getKey(r.getWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty())).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(skuCodes)) {
            return;
        }
        List<ItemSkuDto> itemSkuDtos = this.itemDataQueryHelper.getByCodes(skuCodes);
        List<LogicWarehouseEo> warehouseEos = this.logicWarehouseDataQueryHelper.getByCodes(warehouseCodes);
        List<LogicInventoryEo> logicInventoryEos = this.queryLogicInventoryEos(new FindDetailInventoyBo(itemSkuDtos, warehouseEos, batchList, filterKeys, inventoryPropertyList));
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo("sync");
        calcInventoryDto.setSourceType("sync");
        calcInventoryDto.setBusinessType("sync");
        calcInventoryDto.setRemark("\u5e93\u5b58\u5f02\u52a8\u540c\u6b65");
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        Map inventoryEoMap = logicInventoryEos.stream().collect(Collectors.toMap(r -> this.getKey(r.getWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty()), Function.identity()));
        calcInventoryDto.setDetails(inventoryList.stream().map(r -> {
            CalcInventoryDetailDto detailDto = (CalcInventoryDetailDto)BeanUtil.copyProperties((Object)r, CalcInventoryDetailDto.class, (String[])new String[0]);
            String key = this.getKey(r.getWarehouseCode(), r.getSkuCode(), r.getBatch(), r.getInventoryProperty());
            BigDecimal hasNum = Optional.ofNullable(inventoryEoMap.get(key)).map(LogicInventoryEo::getBalance).orElse(BigDecimal.ZERO);
            BigDecimal change = BigDecimalUtils.subtract((BigDecimal)r.getAvailable(), (BigDecimal)hasNum);
            detailDto.setChangeBalance(change);
            detailDto.setChangeAvailable(change);
            detailDto.setValidNegative(Boolean.valueOf(false));
            return detailDto;
        }).collect(Collectors.toList()));
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(calcInventoryDto);
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(warehouseEos).updateModel(true).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{calcInventoryDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(warehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }
}

