/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.DictEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.feishu.FeishuMsgMessageReqDto;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.OverchargeDifferenceEvent;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.IOverchargeProcessor;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeMetaBo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeResultBo;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractOverchargeProcessor
implements IOverchargeProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractOverchargeProcessor.class);
    @Resource
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Resource
    private ILogicInventoryDomain logicInventoryDomain;
    @Resource
    public ITransferOrderDomain transferOrderDomain;
    @Autowired
    public IPcpDictQueryApiProxy pcpDictQueryApiProxy;
    @Resource
    private ICommonsMqService commonsMqService;

    protected AbstractOverchargeProcessor() {
    }

    @Override
    public OverchargeResultBo overchargeCheck(OverchargeMetaBo overchargeMetaBo) {
        Map<String, List<InOutNoticeOrderDetailEo>> noticeDetailBatchMap = overchargeMetaBo.getBatchNoticeDetailEos().stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
        BigDecimal decimal = this.buildOverchargeProportion(overchargeMetaBo.getNoticeOrderEo());
        log.info("wmsOperate==>\u8d85\u6536\u6bd4\u4f8b\u4fe1\u606f,overchargeProportion:{}", (Object)JSON.toJSONString((Object)decimal));
        log.info("\u5f00\u59cb\u5904\u7406\u6302\u8d77\u5224\u65ad................");
        log.info("noticeDetails: {}", (Object)JSON.toJSONString(noticeDetailBatchMap));
        log.info("wmsDetails: {}", (Object)JSON.toJSONString(overchargeMetaBo.getWmsDetailDtos()));
        boolean isEqualBatch = InventoryConfig.isNoneBatch() || this.checkEqualBatch(noticeDetailBatchMap, overchargeMetaBo);
        boolean isEqualSum = this.checkEqualSum(noticeDetailBatchMap, overchargeMetaBo.getWmsDetailDtos());
        boolean isGtSum = this.checkGt(noticeDetailBatchMap, overchargeMetaBo.getWmsDetailDtos());
        log.info("isEqualBatch: {}\uff0cisEqualSum: {}\uff0cisGtSum\uff1a{}", new Object[]{isEqualBatch, isEqualSum, isGtSum});
        OverchargeResultBo overchargeResultBo = this.doOverchargeCheck(overchargeMetaBo, isEqualSum, isEqualBatch, isGtSum);
        log.info("overchargeResultBo\uff1a{}", (Object)JSON.toJSONString((Object)overchargeResultBo));
        if (CsPlannedOrderItemStatusEnum.OVERCHARGE.getCode().equals(overchargeResultBo.getItemStatus()) || CsPlannedOrderItemStatusEnum.DIFFERENCE.getCode().equals(overchargeResultBo.getItemStatus())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("overchargeResultBo", JSON.toJSONString((Object)overchargeResultBo));
            map.put("noticeOrderEo", JSON.toJSONString((Object)overchargeMetaBo.getNoticeOrderEo()));
            InventoryConfig.pushEvent(new OverchargeDifferenceEvent(map));
        }
        AssertUtil.isFalse((overchargeResultBo.isOvercharge() && !InventoryConfig.isCanHangUp() ? 1 : 0) != 0, (String)("\u5355\u636e\u8d85\u6536\u8d85\u53d1\u6821\u9a8c\u5f02\u5e38:" + overchargeResultBo.getReason()));
        if (!overchargeResultBo.isOvercharge() && InventoryConfig.isInventoryInsufficientHangUp()) {
            overchargeResultBo = this.checkWmsOutDetail(overchargeMetaBo);
        }
        if (!overchargeResultBo.isOvercharge() && CollectionUtils.isNotEmpty(overchargeMetaBo.getPackageDetailDtos())) {
            overchargeResultBo = this.checkPackage(overchargeMetaBo);
        }
        if (overchargeResultBo.isOvercharge()) {
            String code = overchargeMetaBo.getCsRelevanceTableNameEnum().getCode();
            if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(code)) {
                String relevanceNo = overchargeMetaBo.getNoticeOrderEo().getRelevanceNo();
                FeishuMsgMessageReqDto messageReqDto = new FeishuMsgMessageReqDto();
                messageReqDto.setOrderNo(relevanceNo);
                messageReqDto.setMsgConfigCode("TRANSFER_ORDER_OVERCHARGE");
                messageReqDto.setMsgContents(relevanceNo);
                this.commonsMqService.sendSingleMessage("FEISHU_SEND_MSG_TAG", (Object)JSON.toJSONString((Object)messageReqDto));
            }
        }
        return overchargeResultBo;
    }

    @NotNull
    private OverchargeResultBo checkWmsOutDetail(OverchargeMetaBo overchargeMetaBo) {
        List<BasicsDetailReqDto> detailDtos = overchargeMetaBo.getWmsDetailDtos();
        InOutNoticeOrderEo noticeOrderEo = overchargeMetaBo.getNoticeOrderEo();
        if (overchargeMetaBo.getInFlag().booleanValue()) {
            return OverchargeResultBo.getSuccess();
        }
        String warehouseCode = noticeOrderEo.getOutLogicWarehouseCode();
        HashSet skuCodeList = new HashSet();
        HashSet inventoryPropertyList = new HashSet();
        HashSet batchList = new HashSet();
        detailDtos.forEach(e -> {
            skuCodeList.add(e.getSkuCode());
            inventoryPropertyList.add(e.getInventoryProperty());
            if (StringUtils.isNotBlank((CharSequence)e.getBatch())) {
                batchList.add(e.getBatch());
            }
        });
        ArrayList csLogicInventoryEos = new ArrayList();
        if (CollectionUtils.isNotEmpty(batchList)) {
            List logicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).eq(LogicInventoryEo::getWarehouseCode, (Object)warehouseCode)).in(LogicInventoryEo::getSkuCode, skuCodeList)).in(LogicInventoryEo::getInventoryProperty, inventoryPropertyList)).in(LogicInventoryEo::getBatch, batchList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            CubeBeanUtils.copyCollection(csLogicInventoryEos, (Collection)logicInventoryEos, LogicInventoryEo.class);
        } else {
            List logicInventoryTotalEos = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryTotalEo.class).eq(LogicInventoryTotalEo::getWarehouseCode, (Object)warehouseCode)).in(LogicInventoryTotalEo::getSkuCode, skuCodeList)).in(LogicInventoryTotalEo::getInventoryProperty, inventoryPropertyList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            CubeBeanUtils.copyCollection(csLogicInventoryEos, (Collection)logicInventoryTotalEos, LogicInventoryEo.class);
        }
        Map map = csLogicInventoryEos.stream().collect(Collectors.toMap(e -> this.getMapKey(e.getSkuCode(), e.getInventoryProperty(), e.getBatch()), Function.identity(), (k1, k2) -> k1));
        for (BasicsDetailReqDto wmsDetail : detailDtos) {
            String key = CollectionUtils.isNotEmpty(batchList) ? this.getMapKey(wmsDetail.getSkuCode(), wmsDetail.getInventoryProperty(), wmsDetail.getBatch()) : this.getMapKey(wmsDetail.getSkuCode(), wmsDetail.getInventoryProperty(), null);
            LogicInventoryEo csLogicInventoryEo = (LogicInventoryEo)map.get(key);
            OverchargeResultBo fail = this.checkHangUp(wmsDetail, csLogicInventoryEo);
            map.put(key, csLogicInventoryEo);
            if (fail == null) continue;
            return fail;
        }
        return OverchargeResultBo.getSuccess();
    }

    @NotNull
    private String getMapKey(String skuCode, String inventoryProperty, String batch) {
        return StringUtils.isNotBlank((CharSequence)batch) ? skuCode + InventoryConfig.getCommonSeparate() + inventoryProperty + InventoryConfig.getCommonSeparate() + batch : skuCode + InventoryConfig.getCommonSeparate() + inventoryProperty;
    }

    @Nullable
    private OverchargeResultBo checkHangUp(BasicsDetailReqDto wmsDetail, LogicInventoryEo csLogicInventoryEo) {
        if (null == csLogicInventoryEo) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728: {}", (Object)JSON.toJSONString((Object)wmsDetail));
            return OverchargeResultBo.getFail("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728");
        }
        if (BigDecimalUtils.gt((BigDecimal)wmsDetail.getQuantity(), (BigDecimal)csLogicInventoryEo.getBalance()).booleanValue()) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u4e0d\u591f\u6263\u9664: \u5e93\u5b58\u5269\u4f59\u5e93\u5b58:{}, \u9700\u8981\u6263\u9664\u5e93\u5b58: {}", (Object)BigDecimalUtils.toStr((BigDecimal)csLogicInventoryEo.getBalance()), (Object)BigDecimalUtils.toStr((BigDecimal)wmsDetail.getQuantity()));
            return OverchargeResultBo.getFail(String.format("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u4e0d\u591f\u6263\u9664: \u5e93\u5b58\u5269\u4f59\u5e93\u5b58:%s, \u9700\u8981\u6263\u9664\u5e93\u5b58: %s", BigDecimalUtils.toStr((BigDecimal)csLogicInventoryEo.getBalance()), BigDecimalUtils.toStr((BigDecimal)wmsDetail.getQuantity())));
        }
        csLogicInventoryEo.setBalance(csLogicInventoryEo.getBalance().subtract(wmsDetail.getQuantity()));
        return null;
    }

    @NotNull
    private OverchargeResultBo checkPackage(OverchargeMetaBo overchargeMetaBo) {
        List<BasicsDetailReqDto> packageDetailDtos = overchargeMetaBo.getPackageDetailDtos();
        InOutNoticeOrderEo noticeOrderEo = overchargeMetaBo.getNoticeOrderEo();
        String warehouseCode = "in".equals(noticeOrderEo.getOrderType()) ? noticeOrderEo.getInLogicWarehouseCode() : noticeOrderEo.getOutLogicWarehouseCode();
        List skuCodes = packageDetailDtos.stream().map(BasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List inventoryPropertys = packageDetailDtos.stream().peek(r -> r.setInventoryProperty((String)DataExtractUtils.ifNullElse((Object)r.getInventoryProperty(), (Object)LogicWarehouseQualityEnum.QUALIFIED.getCode()))).map(BasicsDetailReqDto::getInventoryProperty).distinct().collect(Collectors.toList());
        ArrayList csLogicInventoryEos = new ArrayList();
        List logicInventoryTotalEos = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryTotalEo.class).eq(LogicInventoryTotalEo::getWarehouseCode, (Object)warehouseCode)).in(LogicInventoryTotalEo::getSkuCode, skuCodes)).in(LogicInventoryTotalEo::getInventoryProperty, inventoryPropertys)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        CubeBeanUtils.copyCollection(csLogicInventoryEos, (Collection)logicInventoryTotalEos, LogicInventoryEo.class);
        Map map = csLogicInventoryEos.stream().collect(Collectors.toMap(e -> this.getMapKey(e.getSkuCode(), e.getInventoryProperty(), null), Function.identity(), (k1, k2) -> k1));
        for (BasicsDetailReqDto wmsDetail : packageDetailDtos) {
            String key = this.getMapKey(wmsDetail.getSkuCode(), wmsDetail.getInventoryProperty(), null);
            LogicInventoryEo csLogicInventoryEo = (LogicInventoryEo)map.get(key);
            OverchargeResultBo fail = this.checkHangUp(wmsDetail, csLogicInventoryEo);
            map.put(key, csLogicInventoryEo);
            if (fail == null) continue;
            return fail;
        }
        return OverchargeResultBo.getSuccess();
    }

    protected abstract OverchargeResultBo doOverchargeCheck(OverchargeMetaBo var1, boolean var2, boolean var3, boolean var4);

    protected BigDecimal buildOverchargeProportion(InOutNoticeOrderEo inOutNoticeOrderEo) {
        BigDecimal overchargeProportion = BigDecimal.valueOf(1.1);
        log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,InOutNoticeOrderEo:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEo));
        String relevanceTableName = inOutNoticeOrderEo.getRelevanceTableName();
        if (!CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(relevanceTableName)) {
            return BigDecimal.ONE;
        }
        String orderType = inOutNoticeOrderEo.getOrderType();
        if (!"in".equals(orderType)) {
            return BigDecimal.ONE;
        }
        try {
            log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,GROUP_CODE:{},code:{}", (Object)DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), (Object)relevanceTableName);
            DictDto dictDto = this.pcpDictQueryApiProxy.queryByGroupCodeAndCode(DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), relevanceTableName);
            log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,dictDto:{}", (Object)JSON.toJSONString((Object)dictDto));
            AssertUtil.isTrue((null != dictDto ? 1 : 0) != 0, (String)"\u8ba1\u5212\u5165\u5355\u636e\u7c7b\u672a\u914d\u7f6e\u8d85\u6536\u6bd4\u4f8b\u4fe1\u606f");
            String value = dictDto.getValue();
            int intVal = Integer.parseInt(value);
            BigDecimal decimalVal = new BigDecimal(intVal).divide(new BigDecimal(100));
            overchargeProportion = decimalVal.add(BigDecimal.ONE);
            log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,\u57fa\u7840\u6570\u636e\u4e2d\u5fc3\u8ba1\u7b97\u4e4b\u540e\u7684,overchargeProportion:{}", (Object)overchargeProportion);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return overchargeProportion;
    }

    private boolean checkEqualBatch(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, OverchargeMetaBo overchargeMetaBo) {
        List<BasicsDetailReqDto> wmsDetailDtos = overchargeMetaBo.getWmsDetailDtos();
        boolean isEqualBatch = true;
        boolean multipleOut = InventoryConfig.isMultipleOut(overchargeMetaBo.getNoticeOrderEo().getJumpDocumentType(), overchargeMetaBo.getNoticeOrderEo().getDisplayBusinessType());
        Map<String, List<BasicsDetailReqDto>> batchWmsDetailsMap = wmsDetailDtos.stream().collect(Collectors.groupingBy(BasicsDetailReqDto::getSkuCode));
        if (multipleOut) {
            block0: for (Map.Entry<String, List<BasicsDetailReqDto>> wmsDetailDtoEntry : batchWmsDetailsMap.entrySet()) {
                String cargoCode = wmsDetailDtoEntry.getKey();
                List<BasicsDetailReqDto> wmsDetailDtoEntryValue = wmsDetailDtoEntry.getValue();
                List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos = batchNoticeDetailEosMap.get(cargoCode);
                if (CollectionUtils.isEmpty(inOutNoticeOrderDetailEos)) {
                    isEqualBatch = false;
                    break;
                }
                for (BasicsDetailReqDto wmsDetailDto : wmsDetailDtoEntryValue) {
                    InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo = inOutNoticeOrderDetailEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)wmsDetailDto.getBatch())).findFirst().orElse(null);
                    if (null != inOutNoticeOrderDetailEo) continue;
                    isEqualBatch = false;
                    continue block0;
                }
            }
        } else {
            block2: for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> cargoEntry : batchNoticeDetailEosMap.entrySet()) {
                String cargoCode = cargoEntry.getKey();
                List<InOutNoticeOrderDetailEo> batchList = cargoEntry.getValue();
                List<BasicsDetailReqDto> wmsBatchList = batchWmsDetailsMap.get(cargoCode);
                if (CollectionUtils.isEmpty(wmsBatchList)) {
                    isEqualBatch = false;
                    break;
                }
                if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)overchargeMetaBo.getCsRelevanceTableNameEnum()) && !InventoryConfig.isTransferInOrderBatch()) continue;
                for (InOutNoticeOrderDetailEo noticeDetailEo : batchList) {
                    BasicsDetailReqDto wmsDetailDto = wmsBatchList.stream().filter(o -> StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)noticeDetailEo.getBatch())).findFirst().orElse(null);
                    if (null != wmsDetailDto) continue;
                    isEqualBatch = false;
                    continue block2;
                }
            }
        }
        return isEqualBatch;
    }

    private boolean checkEqualSum(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<BasicsDetailReqDto> wmsDetailDtos) {
        String cargoCode;
        boolean isEqualSum = true;
        HashMap noticeNumMap = Maps.newHashMap();
        HashMap wmsNumMap = Maps.newHashMap();
        for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> entry : batchNoticeDetailEosMap.entrySet()) {
            for (InOutNoticeOrderDetailEo detailEo : entry.getValue()) {
                String key = this.keyGen(detailEo.getPreOrderItemId(), detailEo.getSkuCode());
                BigDecimal num = noticeNumMap.getOrDefault(key, BigDecimal.ZERO);
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)detailEo.getWaitQuantity());
                noticeNumMap.put(key, num);
            }
        }
        log.info("checkEqualSum-\u8ba1\u7b97\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4e0a\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)noticeNumMap));
        for (BasicsDetailReqDto basicsDetailReqDto : wmsDetailDtos) {
            cargoCode = this.keyGen(basicsDetailReqDto.getTradeOrderItemId(), basicsDetailReqDto.getSkuCode());
            BigDecimal num = (BigDecimal)wmsNumMap.get(cargoCode);
            num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)basicsDetailReqDto.getQuantity());
            wmsNumMap.put(cargoCode, num);
        }
        log.info("checkEqualSum-\u8ba1\u7b97wms\u51fa\u5165\u5e93\u4e0a\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)wmsNumMap));
        for (Map.Entry<String, List<Object>> entry : noticeNumMap.entrySet()) {
            cargoCode = entry.getKey();
            isEqualSum = BigDecimalUtils.equals((BigDecimal)((BigDecimal)((Object)entry.getValue())), (BigDecimal)((BigDecimal)wmsNumMap.get(cargoCode)));
            if (isEqualSum) continue;
            break;
        }
        return isEqualSum;
    }

    public String keyGen(Long preOrderItemId, String skuCode) {
        return preOrderItemId + ":" + skuCode;
    }

    public boolean checkGt(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<BasicsDetailReqDto> wmsDetailDtos) {
        String cargoCode;
        boolean hasGt = false;
        HashMap noticeNumMap = Maps.newHashMap();
        HashMap wmsNumMap = Maps.newHashMap();
        for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> entry : batchNoticeDetailEosMap.entrySet()) {
            for (InOutNoticeOrderDetailEo detailEo : entry.getValue()) {
                String key = this.keyGen(detailEo.getPreOrderItemId(), detailEo.getSkuCode());
                BigDecimal num = noticeNumMap.getOrDefault(key, BigDecimal.ZERO);
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)detailEo.getWaitQuantity());
                noticeNumMap.put(key, num);
            }
        }
        log.info("checkGt-\u8ba1\u7b97\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4e0a\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)noticeNumMap));
        for (BasicsDetailReqDto basicsDetailReqDto : wmsDetailDtos) {
            cargoCode = this.keyGen(basicsDetailReqDto.getTradeOrderItemId(), basicsDetailReqDto.getSkuCode());
            BigDecimal num = (BigDecimal)wmsNumMap.get(cargoCode);
            num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)basicsDetailReqDto.getQuantity());
            wmsNumMap.put(cargoCode, num);
        }
        log.info("checkGt-\u8ba1\u7b97wms\u51fa\u5165\u5e93\u4e0a\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)wmsNumMap));
        for (Map.Entry<String, List<Object>> entry : noticeNumMap.entrySet()) {
            cargoCode = entry.getKey();
            BigDecimal noticeSum = (BigDecimal)((Object)entry.getValue());
            BigDecimal wmsSum = (BigDecimal)wmsNumMap.get(cargoCode);
            if (!BigDecimalUtils.gt((BigDecimal)wmsSum, (BigDecimal)noticeSum).booleanValue()) continue;
            hasGt = true;
            break;
        }
        return hasGt;
    }

    public String checkInventory(InOutNoticeOrderEo inOutNoticeOrderEo, Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<BasicsDetailReqDto> wmsDetailDtos, boolean inFlag) {
        String overInventoryReason = "";
        String warehouseCode = inFlag ? inOutNoticeOrderEo.getInLogicWarehouseCode() : inOutNoticeOrderEo.getOutLogicWarehouseCode();
        List cargoCodes = wmsDetailDtos.stream().map(BasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List batches = wmsDetailDtos.stream().map(BasicsDetailReqDto::getBatch).distinct().collect(Collectors.toList());
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)warehouseCode);
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        if (CollectionUtils.isEmpty(cargoCodes)) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u8d27\u54c1\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)JSON.toJSONString(wmsDetailDtos));
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u8d27\u54c1\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        if (CollectionUtils.isEmpty(batches) && !InventoryConfig.isNoneBatch()) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)JSON.toJSONString(wmsDetailDtos));
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        List csLogicInventoryEos = new ArrayList();
        if (!InventoryConfig.isNoneBatch()) {
            csLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).eq(LogicInventoryEo::getWarehouseCode, (Object)warehouseCode)).in(LogicInventoryEo::getSkuCode, cargoCodes)).in(LogicInventoryEo::getBatch, batches)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        } else {
            List logicInventoryTotalEos = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryTotalEo.class).eq(LogicInventoryTotalEo::getWarehouseCode, (Object)warehouseCode)).in(LogicInventoryTotalEo::getSkuCode, cargoCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            CubeBeanUtils.copyCollection(csLogicInventoryEos, (Collection)logicInventoryTotalEos, LogicInventoryEo.class);
        }
        log.info("csLogicInventoryEos:{}", (Object)JSON.toJSONString(csLogicInventoryEos));
        if (CollectionUtils.isEmpty(csLogicInventoryEos)) {
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728: {}", (Object)JSON.toJSONString(wmsDetailDtos));
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728";
        }
        for (BasicsDetailReqDto wmsDetail : wmsDetailDtos) {
            LogicInventoryEo csLogicInventoryEo = csLogicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)wmsDetail.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)wmsDetail.getBatch())).findFirst().orElse(null);
            if (null == csLogicInventoryEo) {
                log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728: {}", (Object)JSON.toJSONString((Object)wmsDetail));
                overInventoryReason = "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728";
                break;
            }
            if (!BigDecimalUtils.gt((BigDecimal)wmsDetail.getQuantity(), (BigDecimal)csLogicInventoryEo.getBalance()).booleanValue()) continue;
            log.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u4e0d\u591f\u6263\u9664: \u5e93\u5b58\u5269\u4f59\u5e93\u5b58:{}, \u9700\u8981\u6263\u9664\u5e93\u5b58: {}", (Object)csLogicInventoryEo.getBalance(), (Object)wmsDetail.getQuantity());
            overInventoryReason = String.format("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u4e0d\u591f\u6263\u9664: \u5e93\u5b58\u5269\u4f59\u5e93\u5b58:%s, \u9700\u8981\u6263\u9664\u5e93\u5b58: %s", csLogicInventoryEo.getBalance(), wmsDetail.getQuantity());
            break;
        }
        return overInventoryReason;
    }
}

