/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.wh.center.order.api.dto.response.LogisticsInfoRespDto;
import com.wh.center.order.api.query.ILogisticsInfoQueryApi;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsLogicWarehouseStatusEnum;
import com.yunxi.dg.base.center.enums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsValidFlagEnum;
import com.yunxi.dg.base.center.enums.InventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.OutNoticePushStatusEnum;
import com.yunxi.dg.base.center.enums.PcpBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.constants.BizPrintTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.DocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.SourceSystemEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.mapper.DgThirdWarehouseMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsOrderCancelReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryBasicsQueryReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryOperateCargoReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryOrderSalesRefundDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryOrderSalesRefundReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.InventoryOrderShipmentCheckReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inventory.LogicPreemptInventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.inventory.InventoryBasicsCargoRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.inventory.InventoryBasicsQueryRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.inventory.InventoryBasicsRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.inventory.InventoryOperateCargoRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.commons.IDgOrderPreemptWrapperHelper;
import com.yunxi.dg.base.center.inventory.service.commonsendback.CommonSendBackAble;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.entity.inventory.ILogicInventoryExposedService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.pda.IDeliveryLogisticsService;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.service.utils.Consumer;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class LogicInventoryExposedServiceImpl
implements ILogicInventoryExposedService {
    private Logger logger = LoggerFactory.getLogger(LogicInventoryExposedServiceImpl.class);
    @Resource
    private ILogicInventoryDomain logicInventoryDomain;
    @Resource
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Resource
    private ILockService lockService;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IDgOrderPreemptWrapperHelper dgOrderPreemptWrapperHelper;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    protected IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    private RepeatFilter repeatFilter;
    @Value(value="${order.send.flag:false}")
    private boolean pushFlag;
    @Value(value="${inventory.order.valid.inventory:true}")
    private boolean validInventory;
    @Resource
    private DgThirdWarehouseMapper dgThirdWarehouseMapper;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private ICalcInventoryService calcInventoryService;
    @Autowired
    public ApplicationEventPublisher applicationEventPublisher;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private CommonSendBackAble commonSendBackAble;
    @Resource
    private IDeliveryLogisticsService deliveryLogisticsService;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private ILogisticsInfoQueryApi logisticsInfoQueryApi;

    @Override
    public List<InventoryBasicsQueryRespDto> queryCommonInventory(InventoryBasicsQueryReqDto basicsQueryReqDto) {
        this.logger.info("queryCommonInventory==>logic,\u57fa\u7840\u5e93\u5b58\u67e5\u8be2,basicsQueryReqDto:{}", (Object)JSON.toJSONString((Object)basicsQueryReqDto));
        List<Object> resultList = Lists.newArrayList();
        if (!this.checkQueryCommonParams(basicsQueryReqDto).booleanValue()) {
            return Lists.newArrayList();
        }
        Boolean totalQueryFlag = basicsQueryReqDto.getTotalQueryFlag();
        if (Boolean.TRUE.equals(totalQueryFlag)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            this.buildQueryCommonWrapper(basicsQueryReqDto, queryWrapper);
            List csLogicInventoryTotalEoList = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)queryWrapper);
            resultList = csLogicInventoryTotalEoList.stream().map(e -> {
                InventoryBasicsQueryRespDto respDto = new InventoryBasicsQueryRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
                respDto.setLongCode(e.getSkuCode());
                respDto.setCargoCode(e.getSkuCode());
                respDto.setCargoName(e.getSkuName());
                return respDto;
            }).collect(Collectors.toList());
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            this.buildQueryCommonWrapper(basicsQueryReqDto, queryWrapper);
            List csLogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)queryWrapper);
            resultList = csLogicInventoryEoList.stream().map(e -> {
                InventoryBasicsQueryRespDto respDto = new InventoryBasicsQueryRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
                respDto.setLongCode(e.getSkuCode());
                respDto.setCargoCode(e.getSkuCode());
                respDto.setCargoName(e.getSkuName());
                return respDto;
            }).collect(Collectors.toList());
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InventoryOperateRespDto preemptInventoryBackResult(LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        this.logger.info("preemptInventoryBackResult==>\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58,logicPreemptInventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        InventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        inventoryOperateReqDto.setNegativeValidate(this.validInventory ? Optional.ofNullable(inventoryOperateReqDto.getNegativeValidate()).orElse(1) : Integer.valueOf(0));
        List<Object> basicsCargoRespDtos = new ArrayList<InventoryBasicsCargoRespDto>();
        for (InventoryOperateCargoReqDto detailReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
            InventoryBasicsCargoRespDto basicsCargoRespDto = new InventoryBasicsCargoRespDto();
            basicsCargoRespDto.setCargoCode(StringUtils.isNotBlank((CharSequence)detailReqDto.getCargoCode()) ? detailReqDto.getCargoCode() : detailReqDto.getLongCode());
            basicsCargoRespDto.setLongCode(StringUtils.isNotBlank((CharSequence)detailReqDto.getCargoCode()) ? detailReqDto.getCargoCode() : detailReqDto.getLongCode());
            basicsCargoRespDto.setWarehouseCode(detailReqDto.getWarehouseCode());
            basicsCargoRespDto.setBatch(detailReqDto.getBatch());
            basicsCargoRespDtos.add(basicsCargoRespDto);
        }
        InventoryBasicsRespDto inventoryBasicsRespDto = new InventoryBasicsRespDto();
        CubeBeanUtils.copyProperties((Object)inventoryBasicsRespDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        Mutex mutex = this.lockService.lock("preemptInventoryBackResult", inventoryOperateReqDto.getSourceNo(), 20, 25, TimeUnit.SECONDS);
        try {
            this.releaseAndPreemptInventoryAddDeliveryNoticeOrder(logicPreemptInventoryOperateReqDto);
            basicsCargoRespDtos.forEach(e -> e.setOperateFlag(Boolean.valueOf(true)));
            inventoryBasicsRespDto.setSuccessList(basicsCargoRespDtos);
        }
        catch (Exception exception) {
            this.logger.info("Exception\u9884\u5360\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)exception.getLocalizedMessage());
            exception.printStackTrace();
            String[] split = StringUtils.isNotBlank((CharSequence)exception.getLocalizedMessage()) ? exception.getLocalizedMessage().split(";") : new String[]{};
            String flag = "\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u903b\u8f91\u4ed3\u7f16\u7801";
            if (split.length > 0 && split[0].startsWith(flag)) {
                Set<String> failList = LogicInventoryExposedServiceImpl.parse(split);
                this.logger.info("failList:{}", (Object)JSON.toJSONString(failList));
                basicsCargoRespDtos = basicsCargoRespDtos.stream().filter(e -> failList.contains(e.getWarehouseCode() + InventoryConfig.getCommonSeparate() + e.getLongCode())).peek(r -> r.setOperateFlag(Boolean.valueOf(false))).collect(Collectors.toList());
            } else {
                basicsCargoRespDtos.forEach(e -> e.setOperateFlag(Boolean.valueOf(false)));
            }
            inventoryBasicsRespDto.setFailList(basicsCargoRespDtos);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        InventoryOperateRespDto inventoryOperateRespDto = new InventoryOperateRespDto();
        this.buildRespInfo(inventoryOperateRespDto, inventoryBasicsRespDto, inventoryOperateReqDto.getOperateCargoReqDtoList());
        this.logger.info("preemptInventoryBackResult==>\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDto));
        return inventoryOperateRespDto;
    }

    private static Set<String> parse(String[] split) {
        Set<String> failList = Stream.of(split).map(r -> {
            int skuInx = r.indexOf("SKU\u7f16\u7801");
            String warehouseCode = r.substring(14, skuInx - 2);
            int endIndex = r.contains("\u6279\u6b21") ? r.indexOf("\u6279\u6b21") - 2 : r.indexOf("\u5e93\u5b58\u72b6\u6001") - 2;
            String skuCode = r.substring(skuInx + 7, endIndex);
            return warehouseCode + InventoryConfig.getCommonSeparate() + skuCode;
        }).collect(Collectors.toSet());
        return failList;
    }

    @Override
    public Boolean continueDelivery(String orderNo) {
        this.logger.info("continueDelivery==>\u6839\u636e\u8ba2\u5355\u53f7\u8fdb\u884c\u7ee7\u7eed\u53d1\u8d27,orderNo:{}", (Object)JSON.toJSONString((Object)orderNo));
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List inventoryUsageRecordEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryUsageRecordEo.class).select(new SFunction[]{BaseEo::getId}).eq(InventoryUsageRecordEo::getSourceNo, (Object)orderNo)).eq(InventoryUsageRecordEo::getValid, (Object)ValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty((Collection)inventoryUsageRecordEos, (String)"\u6ca1\u6709\u6709\u6548\u9884\u5360\u8bb0\u5f55", (Object[])new Object[0]);
        QueryWrapper receiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List receiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)receiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEoList), (String)"\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEoList.get(0);
        String logicWarehouseCode = receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode();
        QueryWrapper logicWarehouseEoQueryWrapper = new QueryWrapper();
        logicWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        logicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)ValidFlagEnum.ENABLE.getCode());
        logicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)logicWarehouseEoQueryWrapper);
        AssertUtil.isTrue((null != logicWarehouseEo && StringUtils.isNotBlank((CharSequence)logicWarehouseEo.getPhysicsWarehouseCode()) ? 1 : 0) != 0, (String)"\u903b\u8f91\u4ed3\u672a\u7ed1\u5b9a\u7269\u7406\u4ed3");
        QueryWrapper detailEoQueryWrapper = new QueryWrapper();
        detailEoQueryWrapper.eq((Object)"document_no", (Object)receiveDeliveryNoticeOrderEo.getDocumentNo());
        detailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List receiveDeliveryNoticeOrderDetailEoList = this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)detailEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderDetailEoList), (String)"\u53d1\u8d27\u901a\u77e5\u5355\u8be6\u60c5\u4fe1\u606f\u4e0d\u5b58\u5728");
        String refWarehouseCode = logicWarehouseEo.getPhysicsWarehouseCode();
        InventoryOperateReqDto csInventoryOperateReqDto = new InventoryOperateReqDto();
        csInventoryOperateReqDto.setSourceNo(orderNo);
        csInventoryOperateReqDto.setBusinessType(receiveDeliveryNoticeOrderEo.getBusinessType());
        csInventoryOperateReqDto.setSourceType(InventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode());
        csInventoryOperateReqDto.setNegativeValidate(YesNoEnum.YES.getValue());
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        for (ReceiveDeliveryNoticeOrderDetailEo deliveryNoticeOrderDetailEo : receiveDeliveryNoticeOrderDetailEoList) {
            InventoryOperateCargoReqDto cargoReqDto = new InventoryOperateCargoReqDto();
            cargoReqDto.setCargoCode(deliveryNoticeOrderDetailEo.getSkuCode());
            cargoReqDto.setLongCode(deliveryNoticeOrderDetailEo.getSkuCode());
            cargoReqDto.setCargoName(deliveryNoticeOrderDetailEo.getSkuName());
            cargoReqDto.setBatch(deliveryNoticeOrderDetailEo.getBatch());
            cargoReqDto.setWarehouseCode(refWarehouseCode);
            cargoReqDto.setChangeInventory(deliveryNoticeOrderDetailEo.getPlanQuantity());
            cargoReqDto.setTradeOrderItemId(deliveryNoticeOrderDetailEo.getPreOrderItemId());
            cargoReqDto.setLineNo(deliveryNoticeOrderDetailEo.getLineNo());
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)JSON.parseObject((String)deliveryNoticeOrderDetailEo.getExtension(), BasicOrderDtoExtension.class);
            if (Objects.nonNull(basicOrderDtoExtension)) {
                cargoReqDto.setWeight(basicOrderDtoExtension.getWeight());
                cargoReqDto.setVolume(basicOrderDtoExtension.getVolume());
                cargoReqDto.setSkuDisplayName(basicOrderDtoExtension.getSkuDisplayName());
            }
            operateCargoReqDtoList.add(cargoReqDto);
        }
        csInventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
        this.joinWarehouse(csInventoryOperateReqDto, logicWarehouseEo);
        csInventoryOperateReqDto.setExtension(receiveDeliveryNoticeOrderEo.getExtension());
        return this.preemptOrderInventory(csInventoryOperateReqDto);
    }

    @Override
    public Boolean orderShipmentCheck(InventoryOrderShipmentCheckReqDto inventoryOrderShipmentCheckReqDto) {
        this.logger.info("orderShipmentCheck==>\u67e5\u8be2\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u5355\u4e0e\u672c\u6b21\u7269\u6d41\u5355\u53f7\u662f\u5426\u4e00\u81f4,inventoryOrderShipmentCheckReqDto:{}", (Object)JSON.toJSONString((Object)inventoryOrderShipmentCheckReqDto));
        AssertUtil.isTrue((null != inventoryOrderShipmentCheckReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceNo = inventoryOrderShipmentCheckReqDto.getSourceNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)sourceNo), (String)"\u8ba2\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String shipmentEnterpriseCode = inventoryOrderShipmentCheckReqDto.getShipmentEnterpriseCode();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shipmentEnterpriseCode), (String)"\u7269\u6d41\u5546\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String shipmentEnterpriseName = inventoryOrderShipmentCheckReqDto.getShipmentEnterpriseName();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shipmentEnterpriseName), (String)"\u7269\u6d41\u5546\u540d\u79f0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper receiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List receiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)receiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEoList), (String)"\u67e5\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEoList.get(0);
        String deliveryOrderShipmentEnterpriseCode = receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode();
        if (!shipmentEnterpriseCode.equals(deliveryOrderShipmentEnterpriseCode)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Boolean preemptOrderInventory(InventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("preemptOrderInventory==>\u5e93\u5b58\u9884\u5360\uff0c\u5305\u542b\u5355\u636e\u64cd\u4f5c-\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,inventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        AssertUtil.assertNotNull((Object)inventoryOperateReqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String businessType = StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getBusinessType()) ? inventoryOperateReqDto.getBusinessType() : PcpBusinessTypeEnum.ORDER_SALES_OUT.getCode();
        inventoryOperateReqDto.setBusinessType(businessType);
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        ArrayList outNoticeOrderStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode()});
        List inOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"relevance_no", (Object)sourceNo)).in((Object)"order_status", (Collection)outNoticeOrderStatusList));
        if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList)) {
            return true;
        }
        QueryWrapper receiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
        List receiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)receiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.assertNotEmpty((Collection)receiveDeliveryNoticeOrderEoList, (String)"\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f", (Object[])new Object[0]);
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEoList.get(0);
        inventoryOperateReqDto.setRelevanceNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
        inventoryOperateReqDto.setPlatformOrderNo(receiveDeliveryNoticeOrderEo.getExternalOrderNo());
        Long outNoticeOrderId = this.createOutNoticeOrder(inventoryOperateReqDto, receiveDeliveryNoticeOrderEo);
        if (null == outNoticeOrderId) {
            throw new BizException("\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean releaseAndPreemptInventory(LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        this.logger.info("releaseAndpreemptInventory==>\u91ca\u653e\u5355\u636e\u539f\u5df2\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58\u5e76\u4e14\u6839\u636e\u4fe1\u606f\u91cd\u65b0\u9884\u5360,logicPreemptInventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        Mutex mutex = this.lockService.lock("releaseAndpreemptInventory", logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto().getSourceNo(), 20, 25, TimeUnit.SECONDS);
        try {
            this.releaseAndPreemptInventoryAddDeliveryNoticeOrder(logicPreemptInventoryOperateReqDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Boolean deductionInventoryOrder(final LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        this.logger.info("deductionInventoryOrder==>\u751f\u6210\u53d1\u3001\u6536\u8d27\u7ed3\u679c\u5355\uff0c\u51fa\u3001\u5165\u5e93\u7ed3\u679c\u5355\uff08\u51fa\u5e93\u76f4\u63a5\u6263\u51cf\u5e93\u5b58\uff09,logicPreemptInventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        this.checkDeductionInventoryOrder(logicPreemptInventoryOperateReqDto);
        InventoryConfig.lock(() -> {
            String sourceNo = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto().getSourceNo();
            List outResultOrderEos = this.inOutResultOrderDomain.queryByRelevanceNo(sourceNo);
            AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)outResultOrderEos), (String)"\u5df2\u5b58\u5728\u6709\u6548\u7ed3\u679c\u5355:{}", (String)JSONUtil.toJsonStr((Object)outResultOrderEos));
            final InventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
            ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = this.dgOrderPreemptWrapperHelper.getPreemptFacadeBo(inventoryOperateReqDto);
            receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(true);
            receiveDeliveryNoticeOrderFacadeBo.setValidNegative(false);
            receiveDeliveryNoticeOrderFacadeBo.setSourceType(InventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode());
            receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
            receiveDeliveryNoticeOrderFacadeBo.setOnlyGenResult(logicPreemptInventoryOperateReqDto.isOnlyGenResult());
            receiveDeliveryNoticeOrderFacadeBo.setShoutBatch(false);
            receiveDeliveryNoticeOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

                @Override
                public void beforeCallBack(BaseOrderBaseContext context) {
                    if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                        ReceiveDeliveryNoticeOrderContext deliveryNoticeOrderContext = (ReceiveDeliveryNoticeOrderContext)context;
                        deliveryNoticeOrderContext.setSendWms(false);
                        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
                        csWmsShippingInfoReqDto.setShippingNo(logicPreemptInventoryOperateReqDto.getShippingNo());
                        csWmsShippingInfoReqDto.setShippingType(logicPreemptInventoryOperateReqDto.getShippingType());
                        csWmsShippingInfoReqDto.setFirstShippingCompanyCode(logicPreemptInventoryOperateReqDto.getShippingCompanyCode());
                        csWmsShippingInfoReqDto.setShipmentEnterpriseName(logicPreemptInventoryOperateReqDto.getShipmentEnterpriseName());
                        csWmsShippingInfoReqDto.setShippingCompanyCode(logicPreemptInventoryOperateReqDto.getShippingCompanyCode());
                        csWmsShippingInfoReqDto.setShippingCompanyName(logicPreemptInventoryOperateReqDto.getShippingCompanyName());
                        deliveryNoticeOrderContext.setShippingInfoReqDtoList(Arrays.asList(csWmsShippingInfoReqDto));
                        LogicInventoryExposedServiceImpl.this.dgOrderPreemptWrapperHelper.wrapperOrderInfo(deliveryNoticeOrderContext, inventoryOperateReqDto, logicPreemptInventoryOperateReqDto);
                    }
                }

                @Override
                public void afterCallBack(BaseOrderBaseContext context) {
                    context.setTransparentCallback(true);
                    if (context instanceof ReceiveDeliveryResultOrderContext) {
                        ReceiveDeliveryResultOrderContext context1 = (ReceiveDeliveryResultOrderContext)context;
                        LogicInventoryExposedServiceImpl.this.logger.info("\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u63a8\u9001\u6807\u8bc6pushFlag:{}", (Object)LogicInventoryExposedServiceImpl.this.pushFlag);
                        String string = MDC.get((String)"yes.req.requestId");
                    }
                }
            });
            Optional.ofNullable(logicPreemptInventoryOperateReqDto.getReceivePersonAddressInfo()).ifPresent(re -> {
                BaseOrderAddressEo baseOrderAddressEo = (BaseOrderAddressEo)BeanUtil.copyProperties((Object)re, BaseOrderAddressEo.class, (String[])new String[0]);
                baseOrderAddressEo.setContactsType("consignee");
                receiveDeliveryNoticeOrderFacadeBo.setBaseOrderAddressEoList(Lists.newArrayList((Object[])new BaseOrderAddressEo[]{baseOrderAddressEo}));
            });
            if (BasicsOrderOperateTypeEnum.isOut((String)logicPreemptInventoryOperateReqDto.getInOutFlag())) {
                receiveDeliveryNoticeOrderFacadeBo.setValidNegative(logicPreemptInventoryOperateReqDto.isOnlyGenResult());
                this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
            } else {
                this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
            }
            return 1;
        }, "DEDUCTION_INVENTORY_ORDER:" + logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto().getSourceNo(), "deductionInventoryOrder");
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Boolean releaseInventoryByStrategy(InventoryOperateReqDto inventoryOperateReqDto) {
        Mutex lock;
        block10: {
            block9: {
                block7: {
                    block8: {
                        Boolean bl;
                        this.logger.info("releaseInventoryByStrategy==>inventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
                        lock = null;
                        String cacheKey = "releaseInventoryByStrategy";
                        try {
                            lock = this.lockService.lock(cacheKey, inventoryOperateReqDto.getSourceNo(), 10, 20, TimeUnit.SECONDS);
                            if (null == lock) {
                                throw new BizException(String.format("\u6839\u636e\u4f20\u5165\u7684\u5e93\u5b58\u7b56\u7565\u8fdb\u884c\u5bf9\u5e94\u5e93\u5b58\u91ca\u653e\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8ba2\u5355\u53f7\uff1a%s", inventoryOperateReqDto.getSourceNo()));
                            }
                            this.checkParam(inventoryOperateReqDto);
                            QueryWrapper queryWrapper = new QueryWrapper();
                            queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
                            queryWrapper.eq((Object)"valid", (Object)ValidFlagEnum.ENABLE.getCode());
                            queryWrapper.eq((Object)"source_no", (Object)inventoryOperateReqDto.getSourceNo());
                            List inventoryUsageRecordEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper);
                            if (!CollectionUtils.isEmpty((Collection)inventoryUsageRecordEoList)) break block7;
                            Boolean specialCheckFlag = this.specialCheck(inventoryOperateReqDto);
                            if (specialCheckFlag.booleanValue()) break block8;
                            bl = Boolean.FALSE;
                            if (lock == null) return bl;
                        }
                        catch (Throwable throwable) {
                            if (lock == null) throw throwable;
                            this.lockService.unlock(lock);
                            throw throwable;
                        }
                        this.lockService.unlock(lock);
                        return bl;
                    }
                    Boolean bl = Boolean.TRUE;
                    if (lock == null) return bl;
                    this.lockService.unlock(lock);
                    return bl;
                }
                if (this.checkLogisticStatus(inventoryOperateReqDto)) break block9;
                Boolean specialCheckFlag = Boolean.FALSE;
                if (lock == null) return specialCheckFlag;
                this.lockService.unlock(lock);
                return specialCheckFlag;
            }
            Boolean checkFlag = this.checkWms(inventoryOperateReqDto);
            if (checkFlag.booleanValue()) break block10;
            Boolean bl = Boolean.FALSE;
            if (lock == null) return bl;
            this.lockService.unlock(lock);
            return bl;
        }
        this.cancelOrderStrategy(inventoryOperateReqDto);
        if (lock == null) return true;
        this.lockService.unlock(lock);
        return true;
    }

    private boolean checkLogisticStatus(InventoryOperateReqDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getSourceNo()) || !dto.getSourceNo().startsWith("DD")) {
            return true;
        }
        RestResponse resp = this.logisticsInfoQueryApi.queryInfoByOrderNo(dto.getSourceNo());
        LogisticsInfoRespDto logistics = (LogisticsInfoRespDto)RestResponseHelper.extractData((RestResponse)resp);
        ArrayList notAllowCancelStatus = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        boolean enable = logistics == null || logistics.getStatus() == null || !notAllowCancelStatus.contains(logistics.getStatus());
        this.logger.info("checkLogisticStatus==>sourceNo:{},enable:{}", (Object)dto.getSourceNo(), (Object)enable);
        return enable;
    }

    @Override
    public Boolean checkHangUp(String sourceNo) {
        ArrayList effectiveState = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ORO_DONE_OUT.getCode(), BaseOrderStatusEnum.IRO_DONE_IN.getCode()});
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)sourceNo)).in((Object)"order_status", (Collection)effectiveState)).list();
        return CollectionUtils.isEmpty((Collection)eos);
    }

    @Override
    public Boolean checkCancelHangUp(String sourceNo) {
        return true;
    }

    @Override
    public void addInventory(InventoryOperateReqDto inventoryOperateReqDto) {
        FormInDto formInDto = new FormInDto();
        formInDto.setSourceNo("test");
        formInDto.setSourceType("11");
        formInDto.setNoneLineNo(Boolean.valueOf(true));
        formInDto.setIgnoreFutureIn(Boolean.valueOf(true));
        formInDto.setDetails(inventoryOperateReqDto.getOperateCargoReqDtoList().stream().map(r -> {
            CalcDetailDto dto = new CalcDetailDto();
            dto.setSkuCode(r.getLongCode());
            dto.setBatch(r.getBatch());
            dto.setNum(r.getChangeInventory());
            dto.setExpireDate(r.getExpireTime());
            dto.setProduceDate(r.getProduceTime());
            dto.setLogicWarehouseCode(inventoryOperateReqDto.getLogicWarehouseCode());
            return dto;
        }).collect(Collectors.toList()));
        this.calcInventoryService.formIn(formInDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public List<String> orderSalesRefundConfirm(final InventoryOrderSalesRefundReqDto outDeliveryReqDto) {
        this.logger.info("orderSalesRefundConfirm==>\u9500\u552e\u9000\u786e\u8ba4\u64cd\u4f5c,outDeliveryReqDto:{}", (Object)LogUtils.buildLogContent((Object)outDeliveryReqDto));
        this.checkParams(outDeliveryReqDto);
        List<InventoryOrderSalesRefundReqDto> groupingList = this.groupingByWarehouseCode(outDeliveryReqDto);
        Iterator<InventoryOrderSalesRefundReqDto> var3 = groupingList.iterator();
        ArrayList<String> list = new ArrayList<String>();
        boolean auto = YesNoHelper.isNo((Integer)outDeliveryReqDto.getUnshippedReturn());
        while (var3.hasNext()) {
            InventoryOrderSalesRefundReqDto orderSalesRefundReqDto = var3.next();
            List operateCargoReqDtoList = orderSalesRefundReqDto.getOperateCargoReqDtoList();
            InventoryOrderSalesRefundDetailReqDto refundDetailReqDto = (InventoryOrderSalesRefundDetailReqDto)operateCargoReqDtoList.get(0);
            ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
            receiveDeliveryNoticeOrderFacadeBo.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_REFUND.getCode());
            receiveDeliveryNoticeOrderFacadeBo.setDisplayBusinessType(orderSalesRefundReqDto.getReturnBizType().toString());
            receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(null);
            receiveDeliveryNoticeOrderFacadeBo.setBizDate(outDeliveryReqDto.getBizDate());
            receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(orderSalesRefundReqDto.getSourceNo());
            receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE_REFUND);
            receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(refundDetailReqDto.getWarehouseCode());
            receiveDeliveryNoticeOrderFacadeBo.setSendWms((Boolean)ObjectUtils.defaultIfNull((Object)outDeliveryReqDto.getSendWmsFlag(), (Object)(!auto ? 1 : 0)));
            receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(auto);
            receiveDeliveryNoticeOrderFacadeBo.setBaseOrderAddressEoList(this.buildBaseOrderAddress(orderSalesRefundReqDto.getContactDto()));
            receiveDeliveryNoticeOrderFacadeBo.setSubWarehouseCode(outDeliveryReqDto.getSubWarehouseCode());
            receiveDeliveryNoticeOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

                @Override
                public void beforeCallBack(BaseOrderBaseContext context) {
                    if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                        ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                        receiveDeliveryNoticeOrderEo.setOaidOrderSourceCode(outDeliveryReqDto.getOaidOrderSourceCode());
                        context1.setOaidOrderSourceCode(outDeliveryReqDto.getOaidOrderSourceCode());
                    }
                }

                @Override
                public void afterCallBack(BaseOrderBaseContext context) {
                    context.setTransparentCallback(true);
                }
            });
            ArrayList deliveryNoticeOrderDetails = Lists.newArrayList();
            for (InventoryOrderSalesRefundDetailReqDto detail : operateCargoReqDtoList) {
                BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
                detailReqDto.setBatch("0");
                detailReqDto.setQuantity(BigDecimalUtils.abs((BigDecimal)detail.getChangeInventory()));
                detailReqDto.setSkuCode(detail.getLongCode());
                detailReqDto.setSkuName(detail.getCargoName());
                detailReqDto.setExpireTime(detail.getExpireTime());
                detailReqDto.setProduceTime(detail.getProduceTime());
                detailReqDto.setPreOrderItemId(detail.getPreOrderItemId());
                detailReqDto.setUnit(detail.getUnitCode());
                deliveryNoticeOrderDetails.add(detailReqDto);
            }
            receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(deliveryNoticeOrderDetails);
            this.buildUnit(deliveryNoticeOrderDetails, receiveDeliveryNoticeOrderFacadeBo);
            this.orderUnitConversionRecordService.baseVolumeAndWeightProcess(outDeliveryReqDto.getSourceNo(), deliveryNoticeOrderDetails, false);
            this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
            List eos = ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderSalesRefundReqDto.getSourceNo())).list();
            InOutNoticeOrderEo csOutNoticeOrderEo = CollectionUtils.isNotEmpty((Collection)eos) ? (InOutNoticeOrderEo)eos.get(0) : new InOutNoticeOrderEo();
            List documentNoList = ((List)Optional.ofNullable(eos).orElse(new ArrayList())).stream().map(InOutNoticeOrderEo::getDocumentNo).distinct().collect(Collectors.toList());
            list.addAll(documentNoList);
        }
        return list;
    }

    private List<BaseOrderAddressEo> buildBaseOrderAddress(ContactDto contactDto) {
        return Optional.ofNullable(contactDto).map(c -> {
            BaseOrderAddressEo baseOrderAddressEo = (BaseOrderAddressEo)BeanUtil.copyProperties((Object)c, BaseOrderAddressEo.class, (String[])new String[0]);
            baseOrderAddressEo.setContacts(c.getReciveName());
            baseOrderAddressEo.setPhone(c.getRecivePhone());
            baseOrderAddressEo.setContactsType("consignee");
            return Lists.newArrayList((Object[])new BaseOrderAddressEo[]{baseOrderAddressEo});
        }).orElse(new ArrayList());
    }

    private void buildUnit(List<BaseOrderDetailReqDto> deliveryNoticeOrderDetails, ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo) {
        ArrayList unitConversionDetails = new ArrayList();
        deliveryNoticeOrderDetails.forEach(detailReqDto -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(detailReqDto.getUnit());
            unitConversionDetail.setSkuCode(detailReqDto.getSkuCode());
            unitConversionDetail.setCurNum(detailReqDto.getQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(receiveDeliveryNoticeOrderFacadeBo.getRelevanceNo());
        orderUnitConversionReqDto.setType(CsPcpBusinessTypeEnum.ORDER_SALES_REFUND.getCode());
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
    }

    private void wmsInSendBack(InOutNoticeOrderEo csOutNoticeOrderEo, InventoryOrderSalesRefundReqDto orderSalesRefundReqDto) {
        List operateCargoReqDtoList = orderSalesRefundReqDto.getOperateCargoReqDtoList();
        InventoryOrderSalesRefundDetailReqDto refundDetailReqDto = (InventoryOrderSalesRefundDetailReqDto)operateCargoReqDtoList.get(0);
        String logicWarehouseCode = refundDetailReqDto.getWarehouseCode();
        BasicsReceiveReqDto csBasicsReceiveReqDto = new BasicsReceiveReqDto();
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(csOutNoticeOrderEo.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtil.getSnowflake().nextIdStr());
        csBasicsReceiveReqDto.setWarehouseCode(logicWarehouseCode);
        QueryWrapper logicWarehouseEoQueryWrapper = new QueryWrapper();
        logicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        logicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)CsValidFlagEnum.ENABLE.getCode());
        logicWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
        List logicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList((Wrapper)logicWarehouseEoQueryWrapper);
        AssertUtil.isTrue((CollectionUtils.isNotEmpty((Collection)logicWarehouseEos) && StringUtils.isNotBlank((CharSequence)((LogicWarehouseEo)logicWarehouseEos.get(0)).getPhysicsWarehouseCode()) ? 1 : 0) != 0, (String)"\u903b\u8f91\u4ed3\u672a\u5173\u8054\u7269\u7406\u4ed3\u4fe1\u606f");
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (InventoryOrderSalesRefundDetailReqDto detailReqDto : operateCargoReqDtoList) {
            BasicsDetailReqDto inSendBackDetailReqDto = LogicInventoryExposedServiceImpl.getBasicsDetailReqDto(detailReqDto);
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        this.commonSendBackAble.receiveIn(csBasicsReceiveReqDto);
    }

    @NotNull
    private static BasicsDetailReqDto getBasicsDetailReqDto(InventoryOrderSalesRefundDetailReqDto detailReqDto) {
        BasicsDetailReqDto inSendBackDetailReqDto = new BasicsDetailReqDto();
        inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
        inSendBackDetailReqDto.setQuantity(detailReqDto.getChangeInventory());
        inSendBackDetailReqDto.setSkuCode(detailReqDto.getLongCode());
        inSendBackDetailReqDto.setPreOrderItemId(detailReqDto.getPreOrderItemId());
        inSendBackDetailReqDto.setTradeOrderItemId(detailReqDto.getPreOrderItemId());
        return inSendBackDetailReqDto;
    }

    private void sendWms(InOutNoticeOrderEo outNoticeOrderEo) {
        InOutNoticeOrderContext inOutNoticeOrderContext = new InOutNoticeOrderContext();
        inOutNoticeOrderContext.setDocumentNo(outNoticeOrderEo.getDocumentNo());
        inOutNoticeOrderContext.setInOutNoticeOrderEo(outNoticeOrderEo);
        InventoryConfig.getPushWms().pushWms(inOutNoticeOrderContext);
    }

    private List<InventoryOrderSalesRefundReqDto> groupingByWarehouseCode(InventoryOrderSalesRefundReqDto csOutDeliveryReqDto) {
        Boolean sendWmsFlag = csOutDeliveryReqDto.getSendWmsFlag();
        sendWmsFlag = null == sendWmsFlag ? false : sendWmsFlag;
        ArrayList resultList = Lists.newArrayList();
        List operateCargoReqDtoList = csOutDeliveryReqDto.getOperateCargoReqDtoList();
        Map<String, List<InventoryOrderSalesRefundDetailReqDto>> groupMap = operateCargoReqDtoList.stream().collect(Collectors.groupingBy(InventoryOrderSalesRefundDetailReqDto::getWarehouseCode));
        Set<Map.Entry<String, List<InventoryOrderSalesRefundDetailReqDto>>> entrySet = groupMap.entrySet();
        for (Map.Entry<String, List<InventoryOrderSalesRefundDetailReqDto>> entry : entrySet) {
            InventoryOrderSalesRefundReqDto targetReqDto = new InventoryOrderSalesRefundReqDto();
            CubeBeanUtils.copyProperties((Object)targetReqDto, (Object)csOutDeliveryReqDto, (String[])new String[]{"operateCargoReqDtoList"});
            List<InventoryOrderSalesRefundDetailReqDto> detailReqDtoList = entry.getValue();
            ArrayList targetList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)targetList, detailReqDtoList, InventoryOrderSalesRefundDetailReqDto.class);
            targetReqDto.setOperateCargoReqDtoList((List)targetList);
            resultList.add(targetReqDto);
            targetReqDto.setSendWmsFlag(sendWmsFlag);
        }
        return resultList;
    }

    private void checkParams(InventoryOrderSalesRefundReqDto csOutDeliveryReqDto) {
        String sourceNo = csOutDeliveryReqDto.getSourceNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)sourceNo), (String)"\u6765\u6e90\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal totalInventory = csOutDeliveryReqDto.getTotalInventory();
        AssertUtil.isTrue((null != totalInventory && totalInventory.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u603b\u6570\u91cf\u53c2\u6570\u6709\u8bef");
        List operateCargoReqDtoList = csOutDeliveryReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)operateCargoReqDtoList), (String)"\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u53c2\u6570\u6709\u8bef");
        for (InventoryOrderSalesRefundDetailReqDto refundDetailReqDto : operateCargoReqDtoList) {
            String warehouseCode = refundDetailReqDto.getWarehouseCode();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseCode), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            if (InventoryConfig.isNoneBatch()) {
                refundDetailReqDto.setBatch((String)DataExtractUtils.ifNullElse((Object)refundDetailReqDto.getBatch(), (Object)InventoryConfig.getDefaultBatch()));
            }
            String batch = refundDetailReqDto.getBatch();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)batch), (String)"\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            String longCode = refundDetailReqDto.getLongCode();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)longCode), (String)"\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal changeInventory = refundDetailReqDto.getChangeInventory();
            AssertUtil.isTrue((null != changeInventory && changeInventory.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5e93\u5b58\u53d8\u52a8\u53c2\u6570\u6709\u8bef");
        }
        List warehouseCodeList = operateCargoReqDtoList.stream().map(InventoryOrderSalesRefundDetailReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        QueryWrapper csLogicWarehouseEoQueryWrapper = new QueryWrapper();
        csLogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csLogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)CsLogicWarehouseStatusEnum.ENABLE.getCode());
        csLogicWarehouseEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        List csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)csLogicWarehouseEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)csLogicWarehouseEoList), (String)"\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map logicWarehouseEoMap = csLogicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        List<String> longCodeList = operateCargoReqDtoList.stream().map(InventoryOrderSalesRefundDetailReqDto::getLongCode).distinct().collect(Collectors.toList());
        List itemList = this.itemDataQueryHelper.getByCodes(longCodeList);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(itemList), (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map csItemEoMap = itemList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        for (InventoryOrderSalesRefundDetailReqDto refundDetailReqDto : operateCargoReqDtoList) {
            ItemSkuDto csItemEo;
            String warehouseCode = refundDetailReqDto.getWarehouseCode();
            String longCode = refundDetailReqDto.getLongCode();
            LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(warehouseCode);
            if (null != csLogicWarehouseEo) {
                refundDetailReqDto.setWarehouseId(csLogicWarehouseEo.getId());
                refundDetailReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
            }
            if (null == (csItemEo = (ItemSkuDto)csItemEoMap.get(longCode))) continue;
            refundDetailReqDto.setCargoName(csItemEo.getSkuName());
            refundDetailReqDto.setCargoCode(csItemEo.getSkuCode());
            refundDetailReqDto.setLongCode(csItemEo.getSkuCode());
        }
        BigDecimal calculateTotalInventory = operateCargoReqDtoList.stream().map(InventoryOrderSalesRefundDetailReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
        int compare = calculateTotalInventory.compareTo(totalInventory);
        AssertUtil.isTrue((compare == 0 ? 1 : 0) != 0, (String)"\u603b\u6570\u91cf\u5fc5\u987b\u7b49\u4e8e\u660e\u7ec6\u52a0\u8d77\u6765\u7684\u603b\u6570\u91cf");
        QueryWrapper csDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)csOutDeliveryReqDto.getSourceNo());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"receive");
        ArrayList<String> notInStatusList = new ArrayList<String>(2);
        notInStatusList.add(BaseOrderStatusEnum.RNO_CANCEL.getCode());
        notInStatusList.add(BaseOrderStatusEnum.RNO_HANG_UP.getCode());
        csDeliveryNoticeOrderEoQueryWrapper.notIn((Object)"order_status", notInStatusList);
        List csDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)csDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)csDeliveryNoticeOrderEoList), (String)String.format("\u3010%s\u3011\u4e0d\u5141\u8bb8\u91cd\u590d\u64cd\u4f5c", csOutDeliveryReqDto.getSourceNo()));
    }

    private void checkDeductionInventoryOrder(LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        AssertUtil.isTrue((null != logicPreemptInventoryOperateReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        AssertUtil.isTrue((null != inventoryOperateReqDto ? 1 : 0) != 0, (String)"\u5e93\u5b58\u64cd\u4f5c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)sourceNo), (String)"\u6765\u6e90\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String basicDataBusinessType = inventoryOperateReqDto.getBasicDataBusinessType();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)basicDataBusinessType), (String)"\u4e1a\u52a1\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List operateCargoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)operateCargoList), (String)"\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (InventoryOperateCargoReqDto cargoReqDto : operateCargoList) {
            String warehouseCode = cargoReqDto.getWarehouseCode();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseCode), (String)"\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            String longCode = cargoReqDto.getLongCode();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)longCode), (String)"\u5546\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal changeInventory = cargoReqDto.getChangeInventory();
            AssertUtil.isTrue((null != changeInventory ? 1 : 0) != 0, (String)"\u53d8\u52a8\u5e93\u5b58\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Long createOutNoticeOrder(final InventoryOperateReqDto inventoryOperateReqDto, final ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo) {
        LogicWarehouseEo warehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inventoryOperateReqDto.getLogicWarehouseCode())).one();
        AssertUtil.isTrue((boolean)Objects.nonNull(warehouse), (String)"\u4ed3\u5e93\u4e0d\u5b58\u5728:{}", (String)inventoryOperateReqDto.getLogicWarehouseCode());
        this.logger.info("preemptOrderInventory==>\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355,orderNo:{}", (Object)inventoryOperateReqDto.getSourceNo());
        InOutNoticeOrderFacadeBo inOutNoticeOrderFacadeBo = new InOutNoticeOrderFacadeBo();
        CubeBeanUtils.copyProperties((Object)inOutNoticeOrderFacadeBo, (Object)inventoryOperateReqDto, (String[])new String[0]);
        inOutNoticeOrderFacadeBo.setReceiveDeliveryNoticeOrderEo(receiveDeliveryNoticeOrderEo);
        boolean isComplete = ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)warehouse.getIsVirtual());
        inOutNoticeOrderFacadeBo.setAutoComplete(isComplete);
        inOutNoticeOrderFacadeBo.setSendWms(!isComplete);
        inOutNoticeOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    InOutNoticeOrderContext context1 = (InOutNoticeOrderContext)context;
                    InOutNoticeOrderEo inOutNoticeOrderEo = context1.getInOutNoticeOrderEo();
                    inOutNoticeOrderEo.setDisplayBusinessName(receiveDeliveryNoticeOrderEo.getDisplayBusinessName());
                    inOutNoticeOrderEo.setDisplayBusinessType(receiveDeliveryNoticeOrderEo.getDisplayBusinessType());
                    inOutNoticeOrderEo.setJumpDocumentType(receiveDeliveryNoticeOrderEo.getJumpDocumentType());
                    inOutNoticeOrderEo.setJumpDocumentName(receiveDeliveryNoticeOrderEo.getJumpDocumentName());
                    inOutNoticeOrderEo.setShipmentEnterpriseCode(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseCode());
                    inOutNoticeOrderEo.setShipmentEnterpriseName(receiveDeliveryNoticeOrderEo.getShipmentEnterpriseName());
                    inOutNoticeOrderEo.setShippingType(receiveDeliveryNoticeOrderEo.getShippingType());
                    inOutNoticeOrderEo.setOaidOrderSourceCode(receiveDeliveryNoticeOrderEo.getOaidOrderSourceCode());
                    inOutNoticeOrderEo.setSourcePlatformCode(receiveDeliveryNoticeOrderEo.getSourcePlatformCode());
                    inOutNoticeOrderEo.setPayTime(receiveDeliveryNoticeOrderEo.getPayTime());
                    inOutNoticeOrderEo.setTradeOrderCreateTime(receiveDeliveryNoticeOrderEo.getTradeOrderCreateTime());
                    inOutNoticeOrderEo.setYfRepairOrderNo(receiveDeliveryNoticeOrderEo.getYfRepairOrderNo());
                    inOutNoticeOrderEo.setPushStatus(OutNoticePushStatusEnum.WAITING.getCode());
                    inOutNoticeOrderEo.setExtension(inventoryOperateReqDto.getExtension());
                    inOutNoticeOrderEo.setExchangePlatformAfterSaleOrderNo(receiveDeliveryNoticeOrderEo.getExchangePlatformAfterSaleOrderNo());
                    inOutNoticeOrderEo.setShopId(receiveDeliveryNoticeOrderEo.getShopId());
                    inOutNoticeOrderEo.setShopCode(receiveDeliveryNoticeOrderEo.getShopCode());
                    inOutNoticeOrderEo.setShopName(receiveDeliveryNoticeOrderEo.getShopName());
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(true);
            }
        });
        InOutNoticeOrderContext inOutNoticeOrderContext = this.baseOrderFacade.outNoticeOrderGen(inOutNoticeOrderFacadeBo);
        return inOutNoticeOrderContext.getInOutNoticeOrderEo().getId();
    }

    private void queryFailAvailableInventory(InventoryOperateRespDto inventoryOperateRespDto) {
        List failList = inventoryOperateRespDto.getFailList();
        if (CollectionUtils.isEmpty((Collection)failList)) {
            return;
        }
        this.logger.info("queryAvailableInventory==>\u67e5\u8be2\u5931\u8d25\u7684sku\u96c6\u5408\u7684\u53ef\u7528\u5e93\u5b58\u4fe1\u606f,failList:{}", (Object)JSON.toJSONString((Object)failList));
        List longCodeList = failList.stream().map(InventoryOperateCargoRespDto::getLongCode).collect(Collectors.toList());
        List warehouseCodeList = failList.stream().map(InventoryOperateCargoRespDto::getWarehouseCode).collect(Collectors.toList());
        QueryWrapper csLogicInventoryEoQueryWrapper = new QueryWrapper();
        csLogicInventoryEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csLogicInventoryEoQueryWrapper.in((Object)"sku_code", longCodeList);
        csLogicInventoryEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        csLogicInventoryEoQueryWrapper.eq((Object)"inventory_property", (Object)LogicWarehouseQualityEnum.QUALIFIED.getCode());
        List logicInventoryEoList = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)csLogicInventoryEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)logicInventoryEoList)) {
            return;
        }
        Map csLogicInventoryEoMap = logicInventoryEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + InventoryConfig.getCommonSeparate() + eo.getWarehouseCode(), Function.identity(), (o, o1) -> o));
        for (InventoryOperateCargoRespDto cargoRespDto : failList) {
            String key = cargoRespDto.getLongCode() + InventoryConfig.getCommonSeparate() + cargoRespDto.getWarehouseCode();
            cargoRespDto.setAvailable(BigDecimal.ZERO);
            LogicInventoryTotalEo csLogicInventoryEo = (LogicInventoryTotalEo)csLogicInventoryEoMap.get(key);
            if (null == csLogicInventoryEo) continue;
            cargoRespDto.setAvailable(csLogicInventoryEo.getAvailable());
        }
        this.logger.info("queryAvailableInventory==>\u67e5\u8be2\u5931\u8d25\u7684sku\u96c6\u5408\u7684\u53ef\u7528\u5e93\u5b58\u4fe1\u606f,\u5904\u7406\u5b8c\u6210\u53ef\u7528\u4fe1\u606f\u540e,failList:{}", (Object)JSON.toJSONString((Object)failList));
    }

    private void buildRespInfo(InventoryOperateRespDto inventoryOperateRespDto, InventoryBasicsRespDto inventoryBasicsRespDto, List<InventoryOperateCargoReqDto> operateCargoList) {
        List failList;
        this.logger.info("buildRespInfo-inventoryBasicsRespDto:{}", (Object)JSON.toJSONString((Object)inventoryBasicsRespDto));
        inventoryOperateRespDto.setInventoryStrategy(inventoryBasicsRespDto.getInventoryStrategy());
        inventoryOperateRespDto.setBusinessType(inventoryBasicsRespDto.getBusinessType());
        inventoryOperateRespDto.setSourceNo(inventoryBasicsRespDto.getSourceNo());
        inventoryOperateRespDto.setSourceType(inventoryBasicsRespDto.getSourceType());
        inventoryOperateRespDto.setPlatformOrderNo(inventoryBasicsRespDto.getPlatformOrderNo());
        inventoryOperateRespDto.setPortionSuccessFlag(Boolean.valueOf(CollectionUtils.isNotEmpty((Collection)inventoryBasicsRespDto.getFailList())));
        inventoryOperateRespDto.setOperateCargoReqDtoList(operateCargoList);
        List successList = inventoryBasicsRespDto.getSuccessList();
        if (CollectionUtils.isNotEmpty((Collection)successList)) {
            ArrayList successRespList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)successRespList, (Collection)successList, InventoryOperateCargoRespDto.class);
            inventoryOperateRespDto.setSuccessList((List)successRespList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(failList = inventoryBasicsRespDto.getFailList()))) {
            ArrayList failRespList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)failRespList, (Collection)failList, InventoryOperateCargoRespDto.class);
            inventoryOperateRespDto.setFailList((List)failRespList);
            this.queryFailAvailableInventory(inventoryOperateRespDto);
        }
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void releaseAndPreemptInventoryAddDeliveryNoticeOrder(final LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto) {
        final InventoryOperateReqDto inventoryOperateReqDto = logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto();
        LogicWarehouseEo warehouse = (LogicWarehouseEo)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)((InventoryOperateCargoReqDto)logicPreemptInventoryOperateReqDto.getInventoryOperateReqDto().getOperateCargoReqDtoList().get(0)).getWarehouseCode())).one();
        AssertUtil.isTrue((boolean)Objects.nonNull(warehouse), (String)"\u4ed3\u5e93\u4e0d\u5b58\u5728:{}", (String)inventoryOperateReqDto.getLogicWarehouseCode());
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNo(inventoryOperateReqDto.getSourceNo());
        this.logger.info("deliveryNoticeOrderEoList:{}", (Object)JSON.toJSONString((Object)deliveryNoticeOrderEoList));
        if (CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList)) {
            for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
                if (BaseOrderStatusEnum.DNO_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus())) continue;
                String sourceType = StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getSourceType()) ? inventoryOperateReqDto.getSourceType() : InventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode();
                BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(deliveryNoticeOrderEo.getDocumentNo()).sourceType(sourceType).build();
                this.logger.info("\u8c03\u7528\u57fa\u7ebf\u53d6\u6d88\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)commonCancelBo));
                this.baseOrderFacade.deliveryNoticeOrderCancel(commonCancelBo);
            }
        }
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = this.dgOrderPreemptWrapperHelper.getPreemptFacadeBo(inventoryOperateReqDto);
        receiveDeliveryNoticeOrderFacadeBo.setSourceType(InventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
        receiveDeliveryNoticeOrderFacadeBo.setShoutBatch(StringUtils.isNotBlank((CharSequence)((InventoryOperateCargoReqDto)inventoryOperateReqDto.getOperateCargoReqDtoList().get(0)).getBatch()));
        final boolean generateOutNoticeOrde = Objects.equals(logicPreemptInventoryOperateReqDto.getGenerateOutNoticeOrder(), 1);
        receiveDeliveryNoticeOrderFacadeBo.setGenerateInOut(generateOutNoticeOrde);
        receiveDeliveryNoticeOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                context1.setGenerateInOut(generateOutNoticeOrde);
                context1.setSourceSystem(SourceSystemEnum.O2O.getCode());
                LogicInventoryExposedServiceImpl.this.dgOrderPreemptWrapperHelper.wrapperOrderInfo(context1, inventoryOperateReqDto, logicPreemptInventoryOperateReqDto);
                LogicInventoryExposedServiceImpl.this.logger.info("releaseAndPreemptInventoryAddDeliveryNoticeOrder\u8bbe\u7f6eReceiveDeliveryNoticeOrderContext\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)context1));
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        if (InventoryConfig.isCanSupplyInventory() && InventoryConfig.getPushShareDispatchAble().canPush(PushAble.CanPushBo.builder().logicWarehouseCode(receiveDeliveryNoticeOrderFacadeBo.getLogicWarehouseCode()).relevanceTableNameEnum(CsRelevanceTableNameEnum.CS_ORDER_SALE).businessType(receiveDeliveryNoticeOrderFacadeBo.getBusinessType()).build())) {
            BaseOrderBaseContext baseOrderBaseContext = new BaseOrderBaseContext();
            baseOrderBaseContext.setRelevanceNo(receiveDeliveryNoticeOrderFacadeBo.getRelevanceNo());
            baseOrderBaseContext.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
            baseOrderBaseContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
            baseOrderBaseContext.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
            InventoryConfig.getPushShareDispatchAble().push(baseOrderBaseContext);
        }
        this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
    }

    private Boolean checkQueryCommonParams(InventoryBasicsQueryReqDto query) {
        boolean flag = CollectionUtils.isEmpty((Collection)query.getWarehouseCodeList()) && CollectionUtils.isEmpty((Collection)query.getCargoCodeList()) && CollectionUtils.isEmpty((Collection)query.getBatchList());
        return !flag;
    }

    private <T> void buildQueryCommonWrapper(InventoryBasicsQueryReqDto query, QueryWrapper<T> queryWrapper) {
        this.logger.info("buildQueryCommonWrapper==>\u5e93\u5b58\u901a\u7528\u67e5\u8be2\uff0c\u6784\u5efa\u67e5\u8be2\u53c2\u6570,query:{},queryWrapper:{}", (Object)JSON.toJSONString((Object)query), (Object)JSON.toJSONString(queryWrapper));
        if (CollectionUtils.isNotEmpty((Collection)query.getWarehouseCodeList())) {
            queryWrapper.in((Object)"warehouse_code", (Collection)query.getWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)query.getCargoCodeList())) {
            queryWrapper.in((Object)"sku_code", (Collection)query.getCargoCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)query.getBatchList())) {
            queryWrapper.in((Object)"batch", (Collection)query.getBatchList());
        }
        if (CollectionUtils.isNotEmpty((Collection)query.getLongCodeList())) {
            queryWrapper.in((Object)"sku_code", (Collection)query.getLongCodeList());
        }
        queryWrapper.eq((Object)"dr", (Object)0);
    }

    private void joinWarehouse(InventoryOperateReqDto inventoryOperateReqDto, LogicWarehouseEo logicWarehouseEo) {
        inventoryOperateReqDto.setLogicWarehouseCode(logicWarehouseEo.getWarehouseCode());
        inventoryOperateReqDto.setLogicWarehouseName(logicWarehouseEo.getWarehouseName());
        inventoryOperateReqDto.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
        inventoryOperateReqDto.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
    }

    private void checkParam(InventoryOperateReqDto inventoryOperateReqDto) {
        AssertUtil.isTrue((null != inventoryOperateReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)sourceNo), (String)"\u6765\u6e90\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)inventoryOperateReqDto.getCancelOrderStrategyList())) {
            ArrayList cancelOrderStrategyList = Lists.newArrayList();
            cancelOrderStrategyList.add(DocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode());
            cancelOrderStrategyList.add(DocumentTypeEnum.OUT_NOTICE_ORDER.getCode());
            inventoryOperateReqDto.setCancelOrderStrategyList((List)cancelOrderStrategyList);
        }
    }

    private Boolean checkWms(InventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("checkWms==>\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636e,inventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        ArrayList<String> cancelStatusList = new ArrayList<String>(1);
        cancelStatusList.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        inOutNoticeOrderEoQueryWrapper.notIn((Object)"order_status", cancelStatusList);
        List inOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
        this.logger.info("releaseInventoryByStrategy#checkWms==>\u67e5\u8be2\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f,inOutNoticeOrderEoList:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEoList));
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEoList)) {
            return Boolean.TRUE;
        }
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        if (OutNoticePushStatusEnum.PUSHING.getCode().equals(inOutNoticeOrderEo.getPushStatus())) {
            return Boolean.FALSE;
        }
        if (OutNoticePushStatusEnum.WITHOUT_PUSH.getCode().equals(inOutNoticeOrderEo.getPushStatus())) {
            return Boolean.TRUE;
        }
        if (BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(inOutNoticeOrderEo.getPushStatus())) {
            return Boolean.TRUE;
        }
        this.logger.info("checkWms==>\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636e,\u67e5\u8be2\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606fInOutNoticeOrderEo:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEo));
        String outLogicWarehouseCode = inOutNoticeOrderEo.getOutLogicWarehouseCode();
        QueryWrapper logicWarehouseEoQueryWrapper = new QueryWrapper();
        logicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        logicWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)outLogicWarehouseCode);
        List logicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)logicWarehouseEoQueryWrapper);
        this.logger.info("checkWms==>\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636e,\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606fLogicWarehouseEoList:{}", (Object)JSON.toJSONString((Object)logicWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)logicWarehouseEoList)) {
            return Boolean.FALSE;
        }
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)logicWarehouseEoList.get(0);
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).last(" limit 1 ")).one();
        if (Objects.isNull(physicsWarehouseEo)) {
            return Boolean.TRUE;
        }
        String warehouseCorrespondingSystem = physicsWarehouseEo.getThirdCode();
        QueryWrapper thirdWarehouseEoQueryWrapper = new QueryWrapper();
        thirdWarehouseEoQueryWrapper.eq((Object)"warehouse_code", (Object)warehouseCorrespondingSystem);
        thirdWarehouseEoQueryWrapper.eq((Object)"dr", (Object)0);
        List dgThirdWarehouseEos = this.dgThirdWarehouseMapper.selectList((Wrapper)thirdWarehouseEoQueryWrapper);
        this.logger.info("checkWms==>\u8c03\u7528\u5947\u95e8\u63a5\u53e3\u53d6\u6d88\u5355\u636e,\u67e5\u8be2thirdWarehouseEos:{}", (Object)JSON.toJSONString((Object)dgThirdWarehouseEos));
        if (CollectionUtils.isEmpty((Collection)dgThirdWarehouseEos)) {
            this.logger.info("\u6ca1\u6709\u5bf9\u5e94customerId\uff0c\u4e0d\u7528\u8c03WMS\u53d6\u6d88\u5355\u636e");
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    private Boolean specialCheck(InventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("specialCheck==>inventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        ArrayList<String> cancelStatusList = new ArrayList<String>(1);
        cancelStatusList.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        inOutNoticeOrderEoQueryWrapper.notIn((Object)"order_status", cancelStatusList);
        List inOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
        this.logger.info("specialCheck==>inOutNoticeOrderEoList:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEoList));
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEoList)) {
            return Boolean.TRUE;
        }
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        String pushStatus = outNoticeOrderEo.getPushStatus();
        ArrayList<String> cacelOutResultStatusList = new ArrayList<String>(2);
        cacelOutResultStatusList.add(BaseOrderStatusEnum.ORO_HANG_UP.getCode());
        cacelOutResultStatusList.add(BaseOrderStatusEnum.ORO_ERROR.getCode());
        QueryWrapper inOutResultOrderEoQueryWrapper = new QueryWrapper();
        inOutResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutResultOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        inOutResultOrderEoQueryWrapper.eq((Object)"order_type", (Object)"out");
        inOutResultOrderEoQueryWrapper.notIn((Object)"order_status", cacelOutResultStatusList);
        List inOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)inOutResultOrderEoQueryWrapper);
        this.logger.info("specialCheck==>inOutResultOrderEoList:{}", (Object)JSON.toJSONString((Object)inOutResultOrderEoList));
        if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderEoList)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void cancelOrderStrategy(InventoryOperateReqDto inventoryOperateReqDto) {
        List cancelOrderStrategyList = inventoryOperateReqDto.getCancelOrderStrategyList();
        if (CollectionUtils.isEmpty((Collection)cancelOrderStrategyList)) {
            return;
        }
        if (cancelOrderStrategyList.contains(DocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode())) {
            QueryWrapper receiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
            receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"delivery");
            receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)inventoryOperateReqDto.getSourceNo());
            List receiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)receiveDeliveryNoticeOrderEoQueryWrapper);
            QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
            inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            inOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"out");
            inOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)inventoryOperateReqDto.getSourceNo());
            List inOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEoList)) {
                for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : receiveDeliveryNoticeOrderEoList) {
                    if (BaseOrderStatusEnum.DNO_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus())) {
                        this.logger.info("\u53d1\u8d27\u901a\u77e5\u5355\uff1a{}\u662f\u53d6\u6d88\u72b6\u6001\uff0c\u4e0d\u5904\u7406", (Object)deliveryNoticeOrderEo.getDocumentNo());
                        continue;
                    }
                    List receiveDeliveryNoticeOrderDetailEos = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)deliveryNoticeOrderEo.getDocumentNo())).list();
                    List skuCodeList = receiveDeliveryNoticeOrderDetailEos.stream().sorted(Comparator.comparing(ReceiveDeliveryNoticeOrderDetailEo::getSkuCode)).map(e -> e.getSkuCode()).distinct().collect(Collectors.toList());
                    this.logger.info("\u6839\u636e\u4ea7\u54c1\u7f16\u7801\u6392\u5e8fskuCodeList:{}", (Object)JSON.toJSONString(skuCodeList));
                    BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(deliveryNoticeOrderEo.getDocumentNo()).sourceType(InventorySourceTypeEnum.PCP_OUT_SALE_RELEASE.getCode()).pushEvent(true).build();
                    this.baseOrderFacade.deliveryNoticeOrderCancel(commonCancelBo);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList)) {
                this.cancelShippingCode(inOutNoticeOrderEoList.stream().filter(r -> !BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(r.getOrderStatus())).collect(Collectors.toList()));
            }
        }
        if (cancelOrderStrategyList.contains(DocumentTypeEnum.OUT_NOTICE_ORDER.getCode())) {
            QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
            inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            inOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"out");
            inOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)inventoryOperateReqDto.getSourceNo());
            List inOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList)) {
                for (InOutNoticeOrderEo inOutNoticeOrderEo : inOutNoticeOrderEoList) {
                    if (BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(inOutNoticeOrderEo.getOrderStatus())) {
                        this.logger.info("\u51fa\u5e93\u901a\u77e5\u5355\uff1a{}\u662f\u53d6\u6d88\u72b6\u6001\uff0c\u4e0d\u5904\u7406", (Object)inOutNoticeOrderEo.getDocumentNo());
                        continue;
                    }
                    BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(inOutNoticeOrderEo.getDocumentNo()).sourceType(InventorySourceTypeEnum.PCP_OUT_SALE_RELEASE.getCode()).pushEvent(true).build();
                    this.baseOrderFacade.outNoticeOrderCancel(commonCancelBo);
                }
                this.cancelShippingCode(inOutNoticeOrderEoList.stream().filter(r -> !BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(r.getOrderStatus())).collect(Collectors.toList()));
            }
        }
    }

    private void cancelShippingCode(List<InOutNoticeOrderEo> inOutNoticeOrderEoList) {
        InventoryConfig.registerSynchronizationAfterCommit(() -> {
            for (InOutNoticeOrderEo inOutNoticeOrderEo : inOutNoticeOrderEoList) {
                if (!StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getShippingCode())) continue;
                LogisticsOrderCancelReqDto cancelReqDto = LogisticsOrderCancelReqDto.builder().bizOrderNo(inOutNoticeOrderEo.getDocumentNo()).bizPrintType(BizPrintTypeEnum.DELIVERY.getCode()).build();
                try {
                    this.deliveryLogisticsService.cancel(cancelReqDto);
                }
                catch (Exception e) {
                    this.logger.info("\u64a4\u9500\u53d6\u53f7\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
        });
    }

    public static void registerSynchronizationAfterCommit(final Consumer consumer) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    consumer.accept();
                }
            });
        } else {
            consumer.accept();
        }
    }

    public static void registerSynchronizationAfterCompulete(final Consumer consumer) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    consumer.accept();
                }
            });
        } else {
            consumer.accept();
        }
    }
}

