/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.convert.entity.LogicWarehouseCrossOrgConfigConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseCrossOrgConfigDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseCrossOrgConfigDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseCrossOrgConfigPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseCrossOrgConfigEo;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicWarehouseCrossOrgConfigService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogicWarehouseCrossOrgConfigServiceImpl
extends BaseServiceImpl<LogicWarehouseCrossOrgConfigDto, LogicWarehouseCrossOrgConfigEo, ILogicWarehouseCrossOrgConfigDomain>
implements ILogicWarehouseCrossOrgConfigService {
    @Resource
    private IContext context;

    public LogicWarehouseCrossOrgConfigServiceImpl(ILogicWarehouseCrossOrgConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogicWarehouseCrossOrgConfigDto, LogicWarehouseCrossOrgConfigEo> converter() {
        return LogicWarehouseCrossOrgConfigConverter.INSTANCE;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> insert(LogicWarehouseCrossOrgConfigDto dto) {
        AssertUtils.notNull((Object)dto.getBusinessType(), (String)"\u8de8\u7ec4\u7ec7\u4ea4\u6613\u7c7b\u578b\u4e0d\u80fd\u8fd9\u7a7a");
        AssertUtils.isTrue((Objects.equals(dto.getBusinessType(), 1) || Objects.equals(dto.getBusinessType(), 2) ? 1 : 0) != 0, (String)"\u8de8\u7ec4\u7ec7\u4ea4\u6613\u7c7b\u578b\u9519\u8bef");
        ArrayList configEoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getOutLogicWarehouseIds())) {
            this.dealWithDataEo(dto.getOutLogicWarehouseIds(), dto.getBusinessType(), 1, configEoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getInLogicWarehouseIds())) {
            this.dealWithDataEo(dto.getInLogicWarehouseIds(), dto.getBusinessType(), 2, configEoList);
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(BaseEo::getDr, (Object)0);
        lqw.eq(LogicWarehouseCrossOrgConfigEo::getBusinessType, (Object)dto.getBusinessType());
        LogicWarehouseCrossOrgConfigEo updateEo = new LogicWarehouseCrossOrgConfigEo();
        updateEo.setDr(1);
        ((ILogicWarehouseCrossOrgConfigDomain)this.domain).getMapper().update((Object)updateEo, (Wrapper)lqw);
        int count = 0;
        if (CollectionUtils.isNotEmpty((Collection)configEoList)) {
            count = ((ILogicWarehouseCrossOrgConfigDomain)this.domain).insertBatch((List)configEoList);
        }
        return new RestResponse((Object)count);
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Integer> insertBatch(List<LogicWarehouseCrossOrgConfigDto> dtos) {
        AssertUtils.notEmpty(dtos, (String)"\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u8fd9\u7a7a");
        Integer count = 0;
        for (LogicWarehouseCrossOrgConfigDto dto : dtos) {
            count = count + ((Long)this.insert(dto).getData()).intValue();
        }
        return new RestResponse((Object)count);
    }

    private void dealWithDataEo(List<Long> ids, Integer businessType, Integer type, List<LogicWarehouseCrossOrgConfigEo> configEoList) {
        for (Long id : ids) {
            LogicWarehouseCrossOrgConfigEo eo = new LogicWarehouseCrossOrgConfigEo();
            eo.setLogicWarehouseId(id);
            eo.setBusinessType(businessType);
            eo.setType(type);
            eo.setCreatePerson(this.context.userName());
            eo.setCreateTime(new Date());
            eo.setUpdatePerson(eo.getCreatePerson());
            eo.setUpdateTime(eo.getCreateTime());
            configEoList.add(eo);
        }
    }

    @Override
    public PageInfo<LogicWarehouseRespDto> queryAll(LogicWarehouseCrossOrgConfigPageReqDto reqDto) {
        return ((ILogicWarehouseCrossOrgConfigDomain)this.domain).queryAll(reqDto);
    }

    @Override
    public List<LogicWarehouseRespDto> query(LogicWarehouseCrossOrgConfigPageReqDto reqDto) {
        return ((ILogicWarehouseCrossOrgConfigDomain)this.domain).query(reqDto);
    }
}

