/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsPhysicsWarehouseStatusEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.PhysicsWarehouseConverter;
import com.yunxi.dg.base.center.inventory.dao.mapper.DgThirdWarehouseMapper;
import com.yunxi.dg.base.center.inventory.dao.mapper.RelPhysicsWarehouseStorageConditionMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.CsPhysicsWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseDropdownDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseQueryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseUpdateReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.RelPhysicsWarehouseStorageConditionDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseSearchReqDto;
import com.yunxi.dg.base.center.inventory.eo.DgThirdWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelPhysicsWarehouseStorageConditionEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicWarehouseService;
import com.yunxi.dg.base.center.inventory.service.entity.IPhysicsWarehouseService;
import com.yunxi.dg.base.center.inventory.service.entity.IRelPhysicsWarehouseStorageConditionService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PhysicsWarehouseServiceImpl
extends BaseServiceImpl<PhysicsWarehouseDto, PhysicsWarehouseEo, IPhysicsWarehouseDomain>
implements IPhysicsWarehouseService {
    private static final Logger log = LoggerFactory.getLogger(PhysicsWarehouseServiceImpl.class);
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private IPhysicsWarehouseService physicsWarehouseService;
    @Resource
    private ILogicWarehouseService logicWarehouseService;
    @Resource
    private IRelPhysicsWarehouseStorageConditionService relPhysicsWarehouseStorageConditionService;
    @Resource
    private RelPhysicsWarehouseStorageConditionMapper relPhysicsWarehouseStorageConditionMapper;
    @Resource
    private DgThirdWarehouseMapper dgThirdWarehouseMapper;
    @Resource
    private ILogicWarehouseDomain iLogicWarehouseDomain;

    public PhysicsWarehouseServiceImpl(IPhysicsWarehouseDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PhysicsWarehouseDto, PhysicsWarehouseEo> converter() {
        return PhysicsWarehouseConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<PhysicsWarehouseDto>> queryData(PhysicsWarehousePageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        PageInfo pageInfo = new PageInfo(((IPhysicsWarehouseDomain)this.domain).queryDataByParams(dto));
        this.setPhysicsWarehouseEntitySystemName((PageInfo<PhysicsWarehouseDto>)pageInfo);
        this.setRelPhysicsWarehouseStorageConditionList((PageInfo<PhysicsWarehouseDto>)pageInfo);
        return new RestResponse((Object)pageInfo);
    }

    private void setPhysicsWarehouseEntitySystemName(PageInfo<PhysicsWarehouseDto> pageInfo) {
        if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return;
        }
        List entitySystemCodes = pageInfo.getList().stream().map(o -> o.getEntitySystemCode()).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", entitySystemCodes);
        List thirdWarehouseEos = this.dgThirdWarehouseMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)thirdWarehouseEos)) {
            return;
        }
        Map<String, String> map = thirdWarehouseEos.stream().collect(Collectors.toMap(DgThirdWarehouseEo::getWarehouseCode, DgThirdWarehouseEo::getWarehouseName, (o1, o2) -> o1));
        for (PhysicsWarehouseDto physicsWarehouseDto : pageInfo.getList()) {
            physicsWarehouseDto.setEntitySystemName(map.get(physicsWarehouseDto.getEntitySystemCode()));
        }
    }

    private void setPhysicsWarehouseEntitySystemName(List<PhysicsWarehouseDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List entitySystemCodes = list.stream().map(o -> o.getEntitySystemCode()).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", entitySystemCodes);
        List thirdWarehouseEos = this.dgThirdWarehouseMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)thirdWarehouseEos)) {
            return;
        }
        Map<String, String> map = thirdWarehouseEos.stream().collect(Collectors.toMap(DgThirdWarehouseEo::getWarehouseCode, DgThirdWarehouseEo::getWarehouseName, (o1, o2) -> o1));
        for (PhysicsWarehouseDto physicsWarehouseDto : list) {
            physicsWarehouseDto.setEntitySystemName(map.get(physicsWarehouseDto.getEntitySystemCode()));
        }
    }

    private void setRelPhysicsWarehouseStorageConditionList(PageInfo<PhysicsWarehouseDto> pageInfo) {
        if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return;
        }
        List warehouseCodes = pageInfo.getList().stream().map(e -> e.getWarehouseCode()).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"physics_warehouse_code", warehouseCodes);
        List eos = this.relPhysicsWarehouseStorageConditionMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return;
        }
        Map<String, List<RelPhysicsWarehouseStorageConditionEo>> map = eos.stream().collect(Collectors.groupingBy(RelPhysicsWarehouseStorageConditionEo::getPhysicsWarehouseCode));
        for (PhysicsWarehouseDto physicsWarehouseDto : pageInfo.getList()) {
            List<RelPhysicsWarehouseStorageConditionEo> list = map.get(physicsWarehouseDto.getWarehouseCode());
            if (CollectionUtils.isEmpty(list)) continue;
            List storageConditionList = list.stream().map(e -> e.getStorageConditionCode()).distinct().collect(Collectors.toList());
            physicsWarehouseDto.setStorageConditionList(storageConditionList);
        }
    }

    private void setRelPhysicsWarehouseStorageConditionList(List<PhysicsWarehouseDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List warehouseCodes = list.stream().map(e -> e.getWarehouseCode()).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"physics_warehouse_code", warehouseCodes);
        List eos = this.relPhysicsWarehouseStorageConditionMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return;
        }
        Map<String, List<RelPhysicsWarehouseStorageConditionEo>> map = eos.stream().collect(Collectors.groupingBy(RelPhysicsWarehouseStorageConditionEo::getPhysicsWarehouseCode));
        for (PhysicsWarehouseDto physicsWarehouseDto : list) {
            List<RelPhysicsWarehouseStorageConditionEo> physicsWarehouseStorageConditionEos = map.get(physicsWarehouseDto.getWarehouseCode());
            if (CollectionUtils.isEmpty(physicsWarehouseStorageConditionEos)) continue;
            List storageConditionList = physicsWarehouseStorageConditionEos.stream().filter(e -> e.getStorageConditionCode() != null).map(e -> e.getStorageConditionCode()).distinct().collect(Collectors.toList());
            physicsWarehouseDto.setStorageConditionList(storageConditionList);
        }
    }

    @Override
    public RestResponse<List<PhysicsWarehouseDto>> selectPhysicsWarehouse(PhysicsWarehousePageReqDto dto) {
        List physicsWarehouseDtos = ((IPhysicsWarehouseDomain)this.domain).queryDataByParams(dto);
        this.setPhysicsWarehouseEntitySystemName(physicsWarehouseDtos);
        this.setRelPhysicsWarehouseStorageConditionList(physicsWarehouseDtos);
        return new RestResponse((Object)physicsWarehouseDtos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Long> addPhysicsWarehouse(PhysicsWarehouseDto warehouseDto) {
        this.validParams(warehouseDto);
        PhysicsWarehouseEo csPhysicsWarehouseEo = new PhysicsWarehouseEo();
        CubeBeanUtils.copyProperties((Object)csPhysicsWarehouseEo, (Object)warehouseDto, (String[])new String[0]);
        csPhysicsWarehouseEo.setId(null);
        csPhysicsWarehouseEo.setInterconnectionFlag(warehouseDto.getInterconnectionFlag());
        csPhysicsWarehouseEo.setThirdCode(warehouseDto.getEntityWarehouseId());
        ((IPhysicsWarehouseDomain)this.domain).insert((BaseEo)csPhysicsWarehouseEo);
        WarehouseAddressEo warehouseAddressEo = new WarehouseAddressEo();
        CubeBeanUtils.copyProperties((Object)warehouseAddressEo, (Object)warehouseDto, (String[])new String[0]);
        warehouseAddressEo.setWarehouseId(csPhysicsWarehouseEo.getId());
        warehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        warehouseAddressEo.setValidFlag(ValidFlagEnum.ENABLE.getCode());
        warehouseAddressEo.setContacts(warehouseDto.getContact());
        warehouseAddressEo.setId(null);
        this.warehouseAddressDomain.insert((BaseEo)warehouseAddressEo);
        this.batchInsertRelPhysicsWarehouseStorageCondition(warehouseDto);
        return new RestResponse((Object)csPhysicsWarehouseEo.getId());
    }

    private void batchInsertRelPhysicsWarehouseStorageCondition(PhysicsWarehouseDto warehouseDto) {
        if (CollectionUtils.isNotEmpty((Collection)warehouseDto.getStorageConditionList())) {
            List<RelPhysicsWarehouseStorageConditionDto> addReqDtoList = warehouseDto.getStorageConditionList().stream().map(e -> {
                RelPhysicsWarehouseStorageConditionDto dto = new RelPhysicsWarehouseStorageConditionDto();
                dto.setPhysicsWarehouseCode(warehouseDto.getWarehouseCode());
                dto.setStorageConditionCode(e);
                return dto;
            }).collect(Collectors.toList());
            this.relPhysicsWarehouseStorageConditionService.batchInsert(addReqDtoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Long> updatePhysicsWarehouse(PhysicsWarehouseDto warehouseDto) {
        AssertUtils.isTrue((null != warehouseDto.getId() ? 1 : 0) != 0, (String)"\u7269\u7406\u4ed3ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.validParams(warehouseDto);
        PhysicsWarehouseEo csPhysicsWarehouseEo = new PhysicsWarehouseEo();
        CubeBeanUtils.copyProperties((Object)csPhysicsWarehouseEo, (Object)warehouseDto, (String[])new String[0]);
        csPhysicsWarehouseEo.setInterconnectionFlag(warehouseDto.getInterconnectionFlag());
        csPhysicsWarehouseEo.setThirdCode(warehouseDto.getEntityWarehouseId());
        ((IPhysicsWarehouseDomain)this.domain).update((BaseEo)csPhysicsWarehouseEo);
        List physicsWarehouseEoList = ((ExtQueryChainWrapper)this.iLogicWarehouseDomain.filter().eq((Object)"physics_warehouse_code", (Object)warehouseDto.getWarehouseCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)physicsWarehouseEoList)) {
            for (LogicWarehouseEo logicWarehouseEo : physicsWarehouseEoList) {
                logicWarehouseEo.setPhysicsWarehouseName(warehouseDto.getWarehouseName());
                this.iLogicWarehouseDomain.updateSelective((BaseEo)logicWarehouseEo);
            }
        }
        QueryWrapper updateAddressEoWrapper = new QueryWrapper();
        updateAddressEoWrapper.eq((Object)"warehouse_id", (Object)csPhysicsWarehouseEo.getId());
        updateAddressEoWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        WarehouseAddressEo addressEo = (WarehouseAddressEo)this.warehouseAddressDomain.getMapper().selectOne((Wrapper)updateAddressEoWrapper);
        if (null != addressEo && null != addressEo.getId()) {
            WarehouseAddressEo updateAddressEo = new WarehouseAddressEo();
            CubeBeanUtils.copyProperties((Object)updateAddressEo, (Object)warehouseDto, (String[])new String[0]);
            if (StringUtils.isNotEmpty((CharSequence)warehouseDto.getContact())) {
                updateAddressEo.setContacts(warehouseDto.getContact());
            }
            updateAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
            updateAddressEo.setValidFlag(ValidFlagEnum.ENABLE.getCode());
            updateAddressEo.setId(addressEo.getId());
            updateAddressEo.setWarehouseId(csPhysicsWarehouseEo.getId());
            this.warehouseAddressDomain.update((BaseEo)updateAddressEo);
        } else {
            WarehouseAddressEo warehouseAddressEo = new WarehouseAddressEo();
            CubeBeanUtils.copyProperties((Object)warehouseAddressEo, (Object)warehouseDto, (String[])new String[0]);
            warehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
            warehouseAddressEo.setWarehouseId(csPhysicsWarehouseEo.getId());
            warehouseAddressEo.setValidFlag(ValidFlagEnum.ENABLE.getCode());
            warehouseAddressEo.setId(null);
            this.warehouseAddressDomain.insert((BaseEo)warehouseAddressEo);
        }
        this.batchInsertRelPhysicsWarehouseStorageCondition(warehouseDto);
        return new RestResponse((Object)csPhysicsWarehouseEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Void> updatePhysicsWarehouseStatusById(PhysicsWarehouseReqDto reqDto) {
        List<PhysicsWarehouseEo> warehouseEoList;
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reqDto.getIdList()), (String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u7269\u7406\u4ed3");
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)reqDto.getWarehouseStatus()), (String)"\u7269\u7406\u4ed3\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        List physicsWarehouseEoList = ((IPhysicsWarehouseDomain)this.domain).selectByIds(reqDto.getIdList());
        if (CollectionUtils.isNotEmpty((Collection)physicsWarehouseEoList) && CollectionUtils.isNotEmpty(warehouseEoList = physicsWarehouseEoList.stream().filter(p -> !p.getWarehouseStatus().equals(reqDto.getWarehouseStatus())).collect(Collectors.toList()))) {
            warehouseEoList.forEach(physicsWarehouseEo -> physicsWarehouseEo.setWarehouseStatus(reqDto.getWarehouseStatus()));
            ((IPhysicsWarehouseDomain)this.domain).updateStatusByIdList(warehouseEoList);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Long> initPhysicsWarehouse(PhysicsWarehouseAddReqDto dto) {
        this.validAddParam(dto);
        dto.setWarehouseStatus(CsPhysicsWarehouseStatusEnum.ENABLE.getCode());
        PhysicsWarehouseDto physicsWarehouseDto = new PhysicsWarehouseDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)physicsWarehouseDto, (String[])new String[0]);
        RestResponse<Long> physicsWarehouse = this.physicsWarehouseService.addPhysicsWarehouse(physicsWarehouseDto);
        return new RestResponse(physicsWarehouse.getData());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Void> updatePhysicsWarehouse(Long id, PhysicsWarehouseUpdateReqDto reqDto) {
        this.validUpdateParam(reqDto);
        RelWarehouseEo csRelWarehouseEo = new RelWarehouseEo();
        csRelWarehouseEo.setRefWarehouseId(id);
        Iterable relWarehouseEoList = null;
        AssertUtils.isTrue((boolean)CollectionUtil.isNotEmpty(relWarehouseEoList), (String)"\u4ed3\u5e93\u5173\u8054\u5173\u7cfb\u4e0d\u5b58\u5728");
        relWarehouseEoList.forEach(eo -> {});
        return null;
    }

    @Override
    public RestResponse<PhysicsWarehouseDto> selectDataById(Long id) {
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((IPhysicsWarehouseDomain)this.domain).selectByPrimaryKey(id);
        PhysicsWarehouseDto physicsWarehouseDto = new PhysicsWarehouseDto();
        if (null != physicsWarehouseEo && null != physicsWarehouseEo.getId()) {
            physicsWarehouseDto = (PhysicsWarehouseDto)this.converter().toDto((BaseEo)physicsWarehouseEo);
            QueryWrapper updateAddressEoWrapper = new QueryWrapper();
            updateAddressEoWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
            updateAddressEoWrapper.eq((Object)"warehouse_id", (Object)physicsWarehouseEo.getId());
            WarehouseAddressEo addressEo = (WarehouseAddressEo)this.warehouseAddressDomain.getMapper().selectOne((Wrapper)updateAddressEoWrapper);
            if (null != addressEo && null != addressEo.getId()) {
                BeanUtils.copyProperties((Object)addressEo, (Object)physicsWarehouseDto);
            }
            physicsWarehouseDto.setId(physicsWarehouseEo.getId());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"physics_warehouse_code", (Object)physicsWarehouseDto.getWarehouseCode());
            List eos = this.relPhysicsWarehouseStorageConditionMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)eos)) {
                return new RestResponse((Object)physicsWarehouseDto);
            }
            Map<String, List<RelPhysicsWarehouseStorageConditionEo>> map = eos.stream().collect(Collectors.groupingBy(RelPhysicsWarehouseStorageConditionEo::getPhysicsWarehouseCode));
            List<RelPhysicsWarehouseStorageConditionEo> list = map.get(physicsWarehouseDto.getWarehouseCode());
            List storageConditionList = list.stream().map(e -> e.getStorageConditionCode()).distinct().collect(Collectors.toList());
            physicsWarehouseDto.setStorageConditionList(storageConditionList);
        }
        return new RestResponse((Object)physicsWarehouseDto);
    }

    @Override
    public RestResponse<List<PhysicsWarehouseDropdownDto>> dropdown(WarehouseSearchReqDto searchReqDto) {
        return new RestResponse((Object)((IPhysicsWarehouseDomain)this.domain).dropdown(searchReqDto));
    }

    private List<PhysicsWarehouseEo> selectDataByParams(String warehouseCode, String warehouseName, String entityWarehouseId) {
        PhysicsWarehouseEo physicsWarehouseEo = new PhysicsWarehouseEo();
        if (StringUtils.isNotEmpty((CharSequence)warehouseCode)) {
            physicsWarehouseEo.setWarehouseCode(warehouseCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseName)) {
            physicsWarehouseEo.setWarehouseName(warehouseName);
        }
        if (StringUtils.isNotEmpty((CharSequence)entityWarehouseId)) {
            physicsWarehouseEo.setEntityWarehouseId(entityWarehouseId);
        }
        return ((IPhysicsWarehouseDomain)this.domain).selectList((BaseEo)physicsWarehouseEo);
    }

    private void validParams(PhysicsWarehouseDto warehouseDto) {
        AssertUtils.isTrue((null != warehouseDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseDto.getWarehouseCode()), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseDto.getWarehouseName()), (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseStatus = warehouseDto.getWarehouseStatus();
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseStatus), (String)"\u4ed3\u5e93\u72b6\u6001\u53c2\u6570\u6709\u8bef");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseDto.getContact()), (String)"\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseDto.getPhone()), (String)"\u8054\u7cfb\u7535\u8bdd\u6709\u8bef");
        AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)warehouseDto.getProvince()) && StringUtils.isNotBlank((CharSequence)warehouseDto.getProvinceCode()) ? 1 : 0) != 0, (String)"\u7701\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)warehouseDto.getCity()) && StringUtils.isNotBlank((CharSequence)warehouseDto.getCityCode()) ? 1 : 0) != 0, (String)"\u5e02\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)warehouseDto.getDetailAddress()), (String)"\u8be6\u7ec6\u5730\u5740\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (null == warehouseDto.getId()) {
            List<PhysicsWarehouseEo> warehouseEos = this.selectDataByParams(warehouseDto.getWarehouseCode(), null, null);
            AssertUtils.isFalse((boolean)CollectionUtils.isNotEmpty(warehouseEos), (String)("\u4ed3\u5e93\u7f16\u7801(" + warehouseDto.getWarehouseCode() + ")\u5df2\u7ecf\u5b58\u5728"));
            List<PhysicsWarehouseEo> warehouseEoList = this.selectDataByParams(null, warehouseDto.getWarehouseName(), null);
            AssertUtils.isFalse((boolean)CollectionUtils.isNotEmpty(warehouseEoList), (String)("\u4ed3\u5e93\u540d\u79f0(" + warehouseDto.getWarehouseName() + ")\u5df2\u7ecf\u5b58\u5728"));
        } else {
            PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((IPhysicsWarehouseDomain)this.domain).getMapper().selectById((Serializable)warehouseDto.getId());
            AssertUtils.isTrue((null != physicsWarehouseEo ? 1 : 0) != 0, (String)"\u8be5\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
        }
    }

    private void validAddParam(PhysicsWarehouseAddReqDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getWarehouseName()) || StringUtils.isEmpty((CharSequence)dto.getWarehouseCode()) || null == dto.getOrganizationId() || StringUtils.isEmpty((CharSequence)dto.getWarehouseStatus()) || StringUtils.isEmpty((CharSequence)dto.getWarehouseType())) {
            AssertUtils.isTrue((boolean)false, (String)"\u53c2\u6570\u672a\u8865\u5168");
        }
        dto.setMainWarehouse(null == dto.getMainWarehouse() ? YesNoEnum.YES.getValue() : dto.getMainWarehouse());
        List physicsWarehouseEos = ((IPhysicsWarehouseDomain)this.domain).queryByWarehouseCode(dto.getWarehouseCode());
        AssertUtils.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isEmpty((Collection)physicsWarehouseEos), (String)("\u4ed3\u5e93\u7f16\u7801\u5df2\u7ecf\u521d\u59cb\u5316" + dto.getWarehouseCode()));
    }

    private void validUpdateParam(PhysicsWarehouseUpdateReqDto reqDto) {
        if (StringUtils.isEmpty((CharSequence)reqDto.getWarehouseName()) || null == reqDto.getOrganizationId() || StringUtils.isEmpty((CharSequence)reqDto.getWarehouseCode()) || StringUtils.isEmpty((CharSequence)reqDto.getWarehouseStatus()) || StringUtils.isEmpty((CharSequence)reqDto.getWarehouseType())) {
            AssertUtils.isTrue((boolean)false, (String)"\u53c2\u6570\u672a\u8865\u5168");
        }
        reqDto.setMainWarehouse(null == reqDto.getMainWarehouse() ? YesNoEnum.YES.getValue() : reqDto.getMainWarehouse());
    }

    @Override
    public RestResponse<List<CsPhysicsWarehouseRespDto>> queryByParam(PhysicsWarehouseQueryDto queryDto) {
        log.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        ExtQueryChainWrapper wrapper = (ExtQueryChainWrapper)((IPhysicsWarehouseDomain)this.domain).filter().orderByDesc((Object)"id");
        if (Objects.nonNull(queryDto.getOrganizationId())) {
            wrapper.eq((Object)"organization_id", (Object)queryDto.getOrganizationId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode())) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)queryDto.getWarehouseCodeList())) {
            wrapper.in((Object)"warehouse_code", (Collection)queryDto.getWarehouseCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseStatus())) {
            wrapper.eq((Object)"warehouse_status", (Object)queryDto.getWarehouseStatus());
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"create_time");
        List selectList = wrapper.list();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)selectList, CsPhysicsWarehouseRespDto.class);
        log.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)list));
        return new RestResponse((Object)list);
    }
}

