/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.helper;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.exceptions.BizException;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualInventoryDto;
import com.yunxi.dg.base.center.share.dto.entity.LogicVirtualInventoryDto;
import com.yunxi.dg.base.center.share.dto.entity.LogicWarehouseReqDto;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgVirtualInventoryApiProxy;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class InventoryCheckHelper {
    @Resource
    private IDgVirtualInventoryApiProxy iDgVirtualInventoryApiProxy;

    public void inventoryCheck(Map<String, BigDecimal> skuCodeMap, String logicWarehouseCode, String assignSupplyWarehouseCode) {
        if (InventoryConfig.isCanSupplyInventory()) {
            HashMap<String, Consumer<Map>> skuMap = new HashMap<String, Consumer<Map>>();
            for (Map.Entry<String, BigDecimal> entry : skuCodeMap.entrySet()) {
                skuMap.put(entry.getKey(), skuCodeAvailableMap -> {
                    BigDecimal virtualAvailable = (BigDecimal)skuCodeAvailableMap.get(entry.getKey());
                    if (!skuCodeAvailableMap.containsKey(entry.getKey())) {
                        throw new BizException("\u903b\u8f91\u4ed3\u672a\u5173\u8054\u4f9b\u8d27\u7b56\u7565");
                    }
                    if (BigDecimalUtils.lt((BigDecimal)virtualAvailable, (BigDecimal)((BigDecimal)entry.getValue())).booleanValue()) {
                        throw new BizException("\u5546\u54c1\u7f16\u7801" + (String)entry.getKey() + "\u4f9b\u8d27\u4ed3\u5e93\u5b58\u4e0d\u8db3");
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(skuMap)) {
                LogicWarehouseReqDto logicWarehouseReqDto = new LogicWarehouseReqDto();
                logicWarehouseReqDto.setLogicWarehouseCode(logicWarehouseCode);
                logicWarehouseReqDto.setSkuCodeList(new ArrayList(skuMap.keySet()));
                List logicVirtualInventoryDtoList = (List)this.iDgVirtualInventoryApiProxy.logicByVirtualInventory(Collections.singletonList(logicWarehouseReqDto)).getData();
                if (CollectionUtils.isEmpty((Collection)logicVirtualInventoryDtoList)) {
                    return;
                }
                Map<String, BigDecimal> skuCodeAvailableMap2 = ((LogicVirtualInventoryDto)logicVirtualInventoryDtoList.get(0)).getDgVirtualInventoryDtoList().stream().filter(r -> StringUtils.isBlank((CharSequence)assignSupplyWarehouseCode) || ObjectUtil.equals((Object)r.getWarehouseCode(), (Object)assignSupplyWarehouseCode)).collect(Collectors.groupingBy(DgVirtualInventoryDto::getSkuCode, Collectors.mapping(DgVirtualInventoryDto::getAvailable, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
                skuMap.values().forEach(x -> x.accept(skuCodeAvailableMap2));
            }
        }
    }
}

