/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.pda.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum LinkSuitTypeEnum {
    SHOP("SHOP", "\u5e97\u94fa"),
    WAREHOUSE("WAREHOUSE", "\u4ed3\u5e93"),
    LOGISTICS("LOGISTICS", "\u7269\u6d41\u5546");

    public final String code;
    public final String desc;
    public static final Map<String, LinkSuitTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private LinkSuitTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LinkSuitTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(LinkSuitTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(LinkSuitTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

