/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.dto.response;

import com.dtyunxi.cube.commons.dto.TreeNode;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemDgRespDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="DirectoryItemTreeDto", description="\u76ee\u5f55\u54cd\u5e94Dto")
public class DirectoryItemTreeDto
extends BaseDto {
    private static Logger logger = LoggerFactory.getLogger(DirectoryItemTreeDto.class);
    @ApiModelProperty(name="node", value="\u76ee\u5f55\u8282\u70b9")
    private DirectoryItemDgRespDto node;
    @ApiModelProperty(name="children", value="\u76ee\u5f55\u5b50\u8282\u70b9\u96c6\u5408")
    private List<DirectoryItemTreeDto> children;

    public DirectoryItemTreeDto() {
    }

    public DirectoryItemTreeDto(DirectoryItemDgRespDto node) {
        this.node = node;
    }

    public static List<DirectoryItemTreeDto> createTreeDto(List<DirectoryItemDgRespDto> listT) {
        ArrayList<DirectoryItemTreeDto> treeDtos = new ArrayList<DirectoryItemTreeDto>();
        Long topId = DirectoryItemTreeDto.findTopId(listT);
        if (!CollectionUtils.isEmpty(listT)) {
            TreeMap<String, List<DirectoryItemTreeDto>> subTreeMap = new TreeMap<String, List<DirectoryItemTreeDto>>();
            for (DirectoryItemDgRespDto t : listT) {
                DirectoryItemTreeDto treeDto = new DirectoryItemTreeDto(t);
                if (topId.equals(t.getParentId())) {
                    treeDtos.add(treeDto);
                    continue;
                }
                String parentIdString = String.valueOf(t.getParentId());
                ArrayList<DirectoryItemTreeDto> subList = (ArrayList<DirectoryItemTreeDto>)subTreeMap.get(parentIdString);
                if (CollectionUtils.isEmpty((Collection)subList)) {
                    subList = new ArrayList<DirectoryItemTreeDto>();
                }
                subList.add(treeDto);
                subTreeMap.put(parentIdString, subList);
            }
            for (DirectoryItemTreeDto tree : treeDtos) {
                DirectoryItemTreeDto.getSubTree(tree, subTreeMap);
            }
        }
        return treeDtos;
    }

    private static <T extends TreeNode> void getSubTree(DirectoryItemTreeDto tree, Map<String, List<DirectoryItemTreeDto>> map) {
        String parentIdString = String.valueOf(tree.getNode().getId());
        List<DirectoryItemTreeDto> childList = map.get(parentIdString);
        if (!CollectionUtils.isEmpty(childList)) {
            tree.setChildren(childList);
            for (DirectoryItemTreeDto child : childList) {
                DirectoryItemTreeDto.getSubTree(child, map);
            }
        }
    }

    private static Long findTopId(List<DirectoryItemDgRespDto> list) {
        Long topId = null;
        for (DirectoryItemDgRespDto t : list) {
            if (t == null || t.getParentId() == null) continue;
            if (topId == null) {
                topId = t.getParentId();
                continue;
            }
            if (t.getParentId().equals(TreeNode.TOP_ID)) {
                topId = t.getParentId();
                return topId;
            }
            if (!topId.equals(t.getId())) continue;
            topId = t.getParentId();
        }
        if (topId == null) {
            topId = 0L;
        }
        return topId;
    }

    public DirectoryItemDgRespDto getNode() {
        return this.node;
    }

    public List<DirectoryItemTreeDto> getChildren() {
        return this.children;
    }

    public void setNode(DirectoryItemDgRespDto node) {
        this.node = node;
    }

    public void setChildren(List<DirectoryItemTreeDto> children) {
        this.children = children;
    }
}

