/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.service.component.collect;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.yunxi.dg.base.center.pulldata.dao.common.select.MultipartJoinSelectGeneric;
import com.yunxi.dg.base.center.pulldata.dao.common.select.SelectGeneric;
import com.yunxi.dg.base.center.pulldata.dao.das.common.ISelectGenericDas;
import com.yunxi.dg.base.center.pulldata.domain.entity.IPmsInventoryPostDetailDomain;
import com.yunxi.dg.base.center.pulldata.dto.entity.PmsInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.service.component.collect.ICollectDocumentDataService;
import com.yunxi.dg.base.center.pulldata.service.component.context.CollectDataInitContext;
import com.yunxi.dg.base.center.pulldata.service.component.refresher.DataInserter;
import com.yunxi.dg.base.center.pulldata.service.component.runner.BizRunnerAfterGetLockRunner;
import com.yunxi.dg.base.center.pulldata.service.entity.IPmsInventoryPostDetailService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReceiveDeliveryResultOrderCollectDataServiceImpl
implements ICollectDocumentDataService {
    private static final Logger log = LoggerFactory.getLogger(ReceiveDeliveryResultOrderCollectDataServiceImpl.class);
    @Resource
    private ISelectGenericDas das;
    @Resource
    private IPmsInventoryPostDetailService service;
    @Resource
    private IPmsInventoryPostDetailDomain domain;
    @Resource
    private DataInserter inserter;
    @Resource
    private BizRunnerAfterGetLockRunner runner;

    @Override
    public void collectAndSaveDataToSnapshot(CollectDataInitContext context) {
        List eos;
        if (context.getDeleteOldData().booleanValue() && CollectionUtils.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)this.domain.filter().eq((Object)"reconciliation_time", (Object)context.getInventoryReconciliationTime())).list()))) {
            List ids = eos.stream().map(e -> e.getId()).collect(Collectors.toList());
            this.domain.getMapper().deleteBatchIds(ids);
        }
        this.doCollectAndSaveDataToSnapshot(context);
    }

    public void doCollectAndSaveDataToSnapshot(CollectDataInitContext context) {
        log.info("doCollectAndSaveDataToSnapshot-context:{}", (Object)JSON.toJSONString((Object)context));
        MultipartJoinSelectGeneric generic = context.getGeneric();
        generic.end();
        PageHelper.startPage((int)1, (int)100);
        Page page = this.das.queryPage((SelectGeneric)generic);
        this.buildAndSaveDataToSnapshot(context, (Page<Map<String, Object>>)page);
        int pages = page.getPages();
        int cur = 1;
        while (cur++ < pages) {
            PageHelper.startPage((int)cur, (int)100);
            page = this.das.queryPage((SelectGeneric)generic);
            this.buildAndSaveDataToSnapshot(context, (Page<Map<String, Object>>)page);
        }
    }

    public void buildAndSaveDataToSnapshot(CollectDataInitContext context, Page<Map<String, Object>> page) {
        if (CollectionUtils.isEmpty(page)) {
            return;
        }
        Date inventoryReconciliationTime = context.getInventoryReconciliationTime();
        Function<Map<String, Object>, JSONObject> function = context.getExtensionAssemblyFunction();
        ArrayList<String> documentNos = new ArrayList<String>();
        HashMap<String, Map> document2recordMap = new HashMap<String, Map>();
        for (Map record : page) {
            String documentNo = (String)record.get("document_no");
            documentNos.add(documentNo);
            document2recordMap.put(documentNo, record);
        }
        SelectGeneric generic = new SelectGeneric("cs_delivery_result_order_detail", "il");
        generic.addField("document_no");
        generic.addField("sku_code");
        generic.addField("sku_name");
        generic.addField("batch");
        generic.addField("inventory_property");
        generic.addField("done_quantity");
        generic.equalsWhere("dr", (Object)0);
        generic.in("document_no", documentNos);
        List detailMaps = this.das.queryList(generic);
        if (CollectionUtils.isEmpty((Collection)detailMaps)) {
            return;
        }
        ArrayList<PmsInventoryPostDetailDto> insertList = new ArrayList<PmsInventoryPostDetailDto>();
        for (Map detailMap : detailMaps) {
            String documentNo = (String)detailMap.get("document_no");
            Map record = (Map)document2recordMap.get(documentNo);
            if (CollUtil.isEmpty((Map)record)) continue;
            String orderType = (String)record.get("order_type");
            String warehouseCode = "delivery".equals(record.get("order_type")) ? (String)record.get("delivery_logic_warehouse_code") : (String)record.get("receive_logic_warehouse_code");
            String warehouseName = "delivery".equals(record.get("order_type")) ? (String)record.get("delivery_logic_warehouse_name") : (String)record.get("receive_logic_warehouse_name");
            PmsInventoryPostDetailDto insertDto = new PmsInventoryPostDetailDto();
            insertDto.setReconciliationTime(inventoryReconciliationTime);
            insertDto.setResultOrderNo((String)detailMap.get("document_no"));
            insertDto.setOrderType(orderType);
            insertDto.setRelevanceBizNo((String)record.get("relevance_no"));
            insertDto.setRelevanceOrderStatus((String)record.get("order_status"));
            insertDto.setRelevanceOrderType((String)record.get("business_type"));
            insertDto.setRelevanceBizType((String)record.get("display_business_type"));
            insertDto.setLogicWarehouseCode(warehouseCode);
            insertDto.setLogicWarehouseName(warehouseName);
            insertDto.setSkuCode((String)detailMap.get("sku_code"));
            insertDto.setSkuName((String)detailMap.get("sku_name"));
            insertDto.setBatch((String)detailMap.get("batch"));
            insertDto.setInventoryProperty((String)detailMap.get("inventory_property"));
            BigDecimal doneQuantity = new BigDecimal(String.valueOf(detailMap.getOrDefault("done_quantity", 0.0)));
            insertDto.setQuantity(doneQuantity);
            JSONObject extension = null;
            if (function != null && Objects.nonNull(extension = function.apply(record))) {
                insertDto.setExtension(extension.toJSONString());
            }
            insertList.add(insertDto);
        }
        if (CollectionUtils.isNotEmpty(insertList)) {
            this.inserter.doBatchInsert(this.service, insertList);
        }
    }
}

