/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.service.component.fetch.impl;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.yunxi.dg.base.center.pulldata.dto.entity.ThreeInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchBo;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchStrategy;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchTypeEnum;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.impl.AbstractDataFetchStrategy;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.wdt.AbstractWdtDataQueryService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WdtDataFetchStrategy
extends AbstractDataFetchStrategy
implements DataFetchStrategy {
    private static final Logger log = LoggerFactory.getLogger(WdtDataFetchStrategy.class);
    @Autowired
    private Map<String, AbstractWdtDataQueryService> wdtDataQueryServiceMap;

    @Override
    public String type() {
        return DataFetchTypeEnum.WDT.getCode();
    }

    public static String getDateString(int day) {
        DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate yesterday = LocalDate.now().plusDays(day);
        return yesterday.format(DATE_FORMATTER);
    }

    @Override
    public void doFetchAndSaveData(DataFetchBo dataFetchBo) {
        String warehouseCode = dataFetchBo.getWarehouseCode();
        String reconciliationDateStr = null;
        reconciliationDateStr = dataFetchBo.getReconciliationDate() == null ? WdtDataFetchStrategy.getDateString(-1) : DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)dataFetchBo.getReconciliationDate());
        Date reconciliationDate = DateUtil.parseDate((String)reconciliationDateStr, (String)"yyyy-MM-dd");
        dataFetchBo.setReconciliationDate(reconciliationDate);
        this.doDelete(ThreeInventoryPostDetailDto.builder().reconciliationTime(reconciliationDate).warehouseCode(warehouseCode).source(DataFetchTypeEnum.WDT.getCode()).build());
        this.wdtDataQueryServiceMap.values().forEach(v -> v.queryData(dataFetchBo));
    }
}

