/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.service.component.fetch.wdt;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.rest.RestResponse;
import com.google.common.base.Throwables;
import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockinOtherQuerywithdetailResponse;
import com.yunxi.dg.base.center.connector.dto.request.WdtWmsStockinOtherQuerywithdetailRequestDto;
import com.yunxi.dg.base.center.pulldata.dto.entity.ThreeInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchBo;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchTypeEnum;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.wdt.AbstractWdtDataQueryService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WdtInOtherDataQueryService
extends AbstractWdtDataQueryService {
    private static final Logger log = LoggerFactory.getLogger(WdtInOtherDataQueryService.class);

    @Override
    public void queryData(DataFetchBo dataFetchBo) {
        Date reconciliationDate = dataFetchBo.getReconciliationDate();
        String warehouseCode = dataFetchBo.getWarehouseCode();
        String startTime = DateUtil.getDateToString((Date)DateUtil.getDayBegin((Date)reconciliationDate));
        String endTime = DateUtil.getDateToString((Date)DateUtil.getDayEnd((Date)reconciliationDate));
        WdtWmsStockinOtherQuerywithdetailRequestDto request = new WdtWmsStockinOtherQuerywithdetailRequestDto();
        request.setStartTime(startTime);
        request.setEndTime(endTime);
        request.setStatus("80");
        request.setWarehouseNo(warehouseCode);
        request.setPageSize(Long.valueOf(this.pageSize));
        boolean hasMore = true;
        try {
            Long pageNo = 1L;
            while (hasMore) {
                List orderList;
                request.setPageNo(pageNo);
                log.info("\u83b7\u53d6\u65fa\u5e97\u901a\u5176\u4ed6\u5165\u5e93\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
                WdtWmsStockinOtherQuerywithdetailResponse response = (WdtWmsStockinOtherQuerywithdetailResponse)RestResponseHelper.extractData((RestResponse)this.wdtSdkApi.stockinQueryWithDetail(request));
                WdtWmsStockinOtherQuerywithdetailResponse.Data data = response.getData();
                if (Objects.isNull(data)) {
                    log.info("\u65f6\u95f4\u6bb5\uff1a{},{}\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a", (Object)request.getStartTime(), (Object)request.getEndTime());
                    hasMore = false;
                }
                if (CollectionUtils.isEmpty((Collection)(orderList = data.getOrder()))) {
                    log.info("\u65f6\u95f4\u6bb5\uff1a{},{}\u67e5\u8be2\u5355\u636e\u5217\u8868\u6570\u636e\u4e3a\u7a7a", (Object)request.getStartTime(), (Object)request.getEndTime());
                    hasMore = false;
                    continue;
                }
                List<ThreeInventoryPostDetailDto> detailDtoList = this.convertInOtherToDto(reconciliationDate, orderList);
                this.service.insertBatch(detailDtoList);
                Long l = pageNo;
                Long l2 = pageNo = Long.valueOf(pageNo + 1L);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u65fa\u5e97\u901a\u5176\u4ed6\u5165\u5e93\u5f02\u5e38\uff1a{},{},{}", new Object[]{request.getStartTime(), request.getEndTime(), Throwables.getStackTraceAsString((Throwable)e)});
        }
    }

    private List<ThreeInventoryPostDetailDto> convertInOtherToDto(Date reconciliationDate, List<WdtWmsStockinOtherQuerywithdetailResponse.Order> orderList) {
        ArrayList<ThreeInventoryPostDetailDto> detailDtoList = new ArrayList<ThreeInventoryPostDetailDto>();
        orderList.forEach(v -> v.getDetailList().forEach(i -> {
            ThreeInventoryPostDetailDto detailDto = new ThreeInventoryPostDetailDto();
            detailDto.setSource(DataFetchTypeEnum.WDT.getCode());
            detailDto.setReconciliationTime(reconciliationDate);
            detailDto.setOrderNo(v.getOrderNo());
            detailDto.setOrderType("receive");
            detailDto.setOsBizNo(v.getSrcOrderNo());
            detailDto.setOsOrderType("otherIn");
            detailDto.setOsBizType("default");
            detailDto.setOsBizTypeStr("\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b");
            detailDto.setWarehouseCode(v.getWarehouseNo());
            detailDto.setWarehouseName("");
            if (i.getDefect().booleanValue()) {
                detailDto.setInventoryProperty("un_qualified");
            } else {
                detailDto.setInventoryProperty("qualified");
            }
            detailDto.setQuantity(new BigDecimal(i.getGoodsCount()));
            detailDto.setSkuCode(i.getSpecNo());
            detailDto.setSkuName(i.getSpecName());
            detailDto.setOsBizType("default");
            detailDto.setOsBizTypeStr("\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b");
            detailDto.setExtension(JSONObject.toJSONString((Object)v, (SerializeFilter[])this.filters, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            detailDtoList.add(detailDto);
        }));
        return detailDtoList;
    }
}

