/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.service.component.fetch.wdt;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.google.common.base.Throwables;
import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockoutSalesQuerywithdetailResponse;
import com.yunxi.dg.base.center.connector.dto.request.WdtWmsStockoutSalesQuerywithdetailRequestDto;
import com.yunxi.dg.base.center.pulldata.dto.entity.ThreeInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchBo;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchTypeEnum;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.wdt.AbstractWdtDataQueryService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WdtOutSaleDataQueryService
extends AbstractWdtDataQueryService {
    private static final Logger log = LoggerFactory.getLogger(WdtOutSaleDataQueryService.class);

    @Override
    public void queryData(DataFetchBo dataFetchBo) {
        Date reconciliationDate = dataFetchBo.getReconciliationDate();
        String warehouseCode = dataFetchBo.getWarehouseCode();
        String reconciliationDateStr = DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)reconciliationDate);
        List<String> timeList = WdtOutSaleDataQueryService.splitTimeList(reconciliationDateStr);
        for (String s : timeList) {
            WdtWmsStockoutSalesQuerywithdetailRequestDto request = new WdtWmsStockoutSalesQuerywithdetailRequestDto();
            request.setStartTime(s.concat(":00:00"));
            request.setEndTime(s.concat(":59:59"));
            request.setStatusType(Long.valueOf(3L));
            request.setStatus("110");
            request.setWarehouseNo(warehouseCode);
            request.setPageSize(Long.valueOf(200L));
            boolean hasMore = true;
            try {
                Long pageNo = 1L;
                while (hasMore) {
                    request.setPageNo(pageNo);
                    log.info("\u83b7\u53d6\u65fa\u5e97\u901a\u9500\u552e\u51fa\u5e93\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
                    WdtWmsStockoutSalesQuerywithdetailResponse response = (WdtWmsStockoutSalesQuerywithdetailResponse)RestResponseHelper.extractData((RestResponse)this.wdtSdkApi.stockOutSalesQueryWithDetail(request));
                    WdtWmsStockoutSalesQuerywithdetailResponse.Data data = response.getData();
                    if (Objects.isNull(data)) {
                        log.info("\u65f6\u95f4\u6bb5\uff1a{},{}\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a", (Object)request.getStartTime(), (Object)request.getEndTime());
                        hasMore = false;
                        continue;
                    }
                    List orderList = data.getOrder();
                    if (CollectionUtils.isEmpty((Collection)orderList)) {
                        log.info("\u65f6\u95f4\u6bb5\uff1a{},{}\u67e5\u8be2\u5355\u636e\u5217\u8868\u6570\u636e\u4e3a\u7a7a", (Object)request.getStartTime(), (Object)request.getEndTime());
                        hasMore = false;
                        continue;
                    }
                    List<ThreeInventoryPostDetailDto> detailDtoList = this.convertOutSaleToDto(reconciliationDate, orderList);
                    this.doSave(detailDtoList);
                    Long l = pageNo;
                    Long l2 = pageNo = Long.valueOf(pageNo + 1L);
                }
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u65fa\u5e97\u901a\u9500\u552e\u51fa\u5e93\u5f02\u5e38\uff1a{},{},{}", new Object[]{request.getStartTime(), request.getEndTime(), Throwables.getStackTraceAsString((Throwable)e)});
            }
        }
    }

    private List<ThreeInventoryPostDetailDto> convertOutSaleToDto(Date reconciliationTime, List<WdtWmsStockoutSalesQuerywithdetailResponse.Order> orderList) {
        ArrayList<ThreeInventoryPostDetailDto> detailDtoList = new ArrayList<ThreeInventoryPostDetailDto>();
        orderList.forEach(v -> v.getDetailsList().forEach(i -> {
            ThreeInventoryPostDetailDto detailDto = new ThreeInventoryPostDetailDto();
            detailDto.setSource(DataFetchTypeEnum.WDT.getCode());
            detailDto.setReconciliationTime(reconciliationTime);
            detailDto.setOrderNo(v.getOrderNo());
            detailDto.setOrderType("delivery");
            detailDto.setOsBizNo(v.getSrcOrderNo());
            detailDto.setOsOrderType("saleOut");
            detailDto.setWarehouseCode(v.getWarehouseNo());
            detailDto.setWarehouseName(v.getWarehouseName());
            detailDto.setInventoryProperty("qualified");
            detailDto.setQuantity(new BigDecimal(i.getNum()));
            detailDto.setSkuCode(i.getSpecNo());
            detailDto.setSkuName(i.getSpecName());
            detailDto.setOsBizType("default");
            detailDto.setOsBizTypeStr("\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b");
            detailDto.setExtension(JSONObject.toJSONString((Object)v, (SerializeFilter[])this.filters, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            detailDtoList.add(detailDto);
        }));
        return detailDtoList;
    }

    public static List<String> splitTimeList(String time) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
            String startDate = time.concat(" 00");
            String endDate = time.concat(" 24");
            Date dBegin = sdf.parse(startDate);
            Date dEnd = sdf.parse(endDate);
            List<String> timeList = WdtOutSaleDataQueryService.findDates("H", dBegin, dEnd, 1);
            return timeList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e5\u671f\u8f6c\u6362\u683c\u5f0f\u9519\u8bef");
        }
    }

    public static List<String> findDates(String dateType, Date dBegin, Date dEnd, int time) throws Exception {
        ArrayList<String> listDate = new ArrayList<String>();
        listDate.add(new SimpleDateFormat("yyyy-MM-dd HH").format(dBegin));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (calEnd.after(calBegin)) {
            if ("H".equals(dateType)) {
                calBegin.add(10, time);
            }
            if ("M".equals(dateType)) {
                calBegin.add(2, time);
            }
            if ("D".equals(dateType)) {
                calBegin.add(5, time);
            }
            if ("N".equals(dateType)) {
                calBegin.add(12, time);
            }
            if ("S".equals(dateType)) {
                calBegin.add(13, time);
            }
            if (!calEnd.after(calBegin)) continue;
            listDate.add(new SimpleDateFormat("yyyy-MM-dd HH").format(calBegin.getTime()));
        }
        return listDate;
    }
}

