/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.service.component.refresher;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.BaseService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataInserter {
    private static final Logger log = LoggerFactory.getLogger(DataInserter.class);

    public <T extends BaseDto, E extends BaseEo, D extends IBaseDomain<E>> boolean doBatchInsert(BaseService<T, E, D> baseService, List<T> list) {
        int size = list.size();
        log.info("\u51c6\u5907\u6279\u91cf\u63d2\u5165{}\u8868\u6570\u636e\uff1a{}\u6761", (Object)baseService.getClass().getSimpleName(), (Object)size);
        if (size == 0) {
            return true;
        }
        long bt = System.currentTimeMillis();
        int BATCH_SIZE = 1000;
        if (size > 1000) {
            int loop = size / 1000;
            int fromIndex = 0;
            int toIndex = 1000;
            for (int i = 0; i < loop; ++i) {
                log.debug("\u7b2c" + fromIndex + "~" + toIndex + "\u6761");
                baseService.insertBatch(list.subList(fromIndex, toIndex));
                fromIndex += 1000;
                toIndex += 1000;
            }
            if (fromIndex < size) {
                log.debug("\u7b2c" + fromIndex + "~" + size + "\u6761");
                baseService.insertBatch(list.subList(fromIndex, size));
            }
        } else {
            baseService.insertBatch(list);
        }
        long et = System.currentTimeMillis();
        log.info("{}\u8868{}\u6761\u6570\u636e\u63d2\u5165\u6210\u529f\uff0c\u8017\u65f6\uff1a{} ms", new Object[]{baseService.getClass().getSimpleName(), size, et - bt});
        return true;
    }
}

