/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.pulldata.service.component.selector;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelector<TYPE, SERVICE> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSelector.class);
    protected Map<TYPE, SERVICE> registry = new HashMap<TYPE, SERVICE>();

    public Map<TYPE, SERVICE> registry() {
        return this.registry;
    }

    public String selectorType() {
        return this.getClass().getSimpleName();
    }

    public SERVICE defaultOne() {
        return null;
    }

    public void register(TYPE type, SERVICE nodeService) {
        if (type == null) {
            log.info("{}\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object)this.selectorType());
            return;
        }
        this.registry().put(type, nodeService);
        log.info("\u6ce8\u518c\u7c7b\u578b\u4e3a{}\u7684{}{}\u5b9e\u4f8b", new Object[]{type, nodeService.getClass().getCanonicalName(), this.selectorType()});
    }

    public SERVICE select(TYPE type) {
        if (type == null || type.equals("")) {
            throw new BizException(String.format("\u7c7b\u578b%s\u4e0d\u80fd\u4e3a\u7a7a", type));
        }
        SERVICE nodeService = this.registry().get(type);
        if (nodeService == null && this.defaultOne() != null) {
            return this.defaultOne();
        }
        if (nodeService == null) {
            throw new BizException(String.format("\u4e0d\u5b58\u5728\u8be5\u8282\u70b9\u7c7b\u578b[%s]", type));
        }
        return nodeService;
    }
}

