/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.entity.impl;

import com.yunxi.dg.base.center.report.constants.CostAllocRuleAllocTypeEnum;
import com.yunxi.dg.base.center.report.dao.das.IBudgetCostAllocRuleDas;
import com.yunxi.dg.base.center.report.dao.das.IBudgetCostAllocRuleShopDas;
import com.yunxi.dg.base.center.report.domain.entity.IBudgetCostAllocRuleDomain;
import com.yunxi.dg.base.center.report.dto.entity.CostAllocRuleDto;
import com.yunxi.dg.base.center.report.eo.BudgetCostAllocRuleEo;
import com.yunxi.dg.base.center.report.eo.BudgetCostAllocRuleShopEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BudgetCostAllocRuleDomainImpl
extends BaseDomainImpl<BudgetCostAllocRuleEo>
implements IBudgetCostAllocRuleDomain {
    @Resource
    private IBudgetCostAllocRuleDas das;
    @Resource
    private IBudgetCostAllocRuleShopDas budgetCostAllocRuleShopDas;

    public ICommonDas<BudgetCostAllocRuleEo> commonDas() {
        return this.das;
    }

    @Override
    public List<CostAllocRuleDto> getRules(List<String> statusList) {
        List rules = this.das.getRules(statusList);
        if (rules.isEmpty()) {
            return rules;
        }
        Set ruleIds = rules.stream().map(CostAllocRuleDto::getRuleId).collect(Collectors.toSet());
        List fixedList = this.budgetCostAllocRuleShopDas.findByRuleIds(ruleIds);
        Map<Long, Map<String, BigDecimal>> fixedMapGroup = fixedList.stream().collect(Collectors.groupingBy(BudgetCostAllocRuleShopEo::getRuleId, Collectors.toMap(BudgetCostAllocRuleShopEo::getShopCode, BudgetCostAllocRuleShopEo::getBudgetAmount)));
        rules.forEach(rule -> {
            Map<String, BigDecimal> map = fixedMapGroup.getOrDefault(rule.getRuleId(), Collections.emptyMap());
            CostAllocRuleAllocTypeEnum alloc = CostAllocRuleAllocTypeEnum.fromCode((Integer)rule.getRuleType(), (String)rule.getAllocType());
            switch (alloc) {
                case BY_RATIO: {
                    HashMap rt = new HashMap();
                    map.forEach((k, v) -> rt.put(k, v.divide(new BigDecimal("100"), 6, RoundingMode.UP)));
                    rule.setBudgetProportionCostMap(rt);
                    break;
                }
                case BY_FIXED: {
                    rule.setBudgetFixedCostMap(map);
                    break;
                }
            }
        });
        return rules;
    }
}

