/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.EnterpriceCrossTradeRelationConverter;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossPurchaseRelationDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossSupplierRelationDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossTradeRelationDomain;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPurchaseRelationDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossPurchaseRelationPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossSupplierRelationDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossSupplierRelationPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationInsertBatchDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationRespDto;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossTradeRelationEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossTradeRelationService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnterpriceCrossTradeRelationServiceImpl
extends BaseServiceImpl<EnterpriceCrossTradeRelationDto, EnterpriceCrossTradeRelationEo, IEnterpriceCrossTradeRelationDomain>
implements IEnterpriceCrossTradeRelationService {
    @Resource
    private IEnterpriceCrossPurchaseRelationDomain purchaseRelationDomain;
    @Resource
    private IEnterpriceCrossSupplierRelationDomain supplierRelationDomain;
    @Resource
    private IContext context;

    public EnterpriceCrossTradeRelationServiceImpl(IEnterpriceCrossTradeRelationDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<EnterpriceCrossTradeRelationDto, EnterpriceCrossTradeRelationEo> converter() {
        return EnterpriceCrossTradeRelationConverter.INSTANCE;
    }

    @Override
    public PageInfo<EnterpriceCrossTradeRelationRespDto> queryPage(EnterpriceCrossTradeRelationPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IEnterpriceCrossTradeRelationDomain)this.domain).list(dto));
    }

    @Override
    public RestResponse<Long> insertRelation(EnterpriceCrossTradeRelationDto dto) {
        Integer count = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IEnterpriceCrossTradeRelationDomain)this.domain).filter().eq((Object)"supplier_relation_id", (Object)dto.getSupplierRelationId())).eq((Object)"purchase_relation_id", (Object)dto.getPurchaseRelationId())).count();
        AssertUtils.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u516c\u53f8\u95f4\u4ea4\u6613\u5173\u7cfb\u5df2\u5b58\u5728");
        EnterpriceCrossTradeRelationEo eo = (EnterpriceCrossTradeRelationEo)this.converter().toEo((BaseDto)dto);
        eo.setExtPurchaseRatio(eo.getExtPurchaseRatio() == null || eo.getExtPurchaseRatio().compareTo(BigDecimal.ONE) < 0 ? BigDecimal.ONE : eo.getExtPurchaseRatio());
        eo.setFactoryRatio(eo.getFactoryRatio() == null || eo.getFactoryRatio().compareTo(BigDecimal.ONE) < 0 ? BigDecimal.ONE : eo.getFactoryRatio());
        ((IEnterpriceCrossTradeRelationDomain)this.domain).insert((BaseEo)eo);
        return new RestResponse((Object)eo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertBatchRelation(EnterpriceCrossTradeRelationInsertBatchDto dto) {
        List purchaseRelationDtoList = this.purchaseRelationDomain.queryList(new EnterpriceCrossPurchaseRelationPageReqDto());
        List supplierRelationDtoList = this.supplierRelationDomain.queryList(new EnterpriceCrossSupplierRelationPageReqDto());
        Map<String, Long> purchaseCodeMap = purchaseRelationDtoList.stream().collect(Collectors.toMap(EnterpriceCrossPurchaseRelationDto::getPurchaseEnterpriseCode, BaseDto::getId));
        Map<String, Long> purchaseNameMap = purchaseRelationDtoList.stream().collect(Collectors.toMap(EnterpriceCrossPurchaseRelationDto::getPurchaseEnterpriseName, BaseDto::getId));
        Map<String, Long> supplierCodeMap = supplierRelationDtoList.stream().collect(Collectors.toMap(EnterpriceCrossSupplierRelationDto::getSupplierCode, BaseDto::getId));
        Map<String, Long> supplierNameMap = supplierRelationDtoList.stream().collect(Collectors.toMap(EnterpriceCrossSupplierRelationDto::getSupplierName, BaseDto::getId));
        ArrayList<EnterpriceCrossTradeRelationEo> insertList = new ArrayList<EnterpriceCrossTradeRelationEo>();
        List list = dto.getList();
        HashSet<String> set = new HashSet<String>();
        Iterator<EnterpriceCrossTradeRelationInsertBatchDto.InsertBatchRelation> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.checkAndAddToInsertList(iterator, purchaseCodeMap, purchaseNameMap, supplierCodeMap, supplierNameMap, insertList, set);
        }
        if (!insertList.isEmpty()) {
            ((IEnterpriceCrossTradeRelationDomain)this.domain).insertBatch(insertList);
        }
    }

    @Override
    public EnterpriceCrossTradeRelationRespDto getByPurchaseEnterpriseCodeAndEnterpriseCode(String purchaseEnterpriseCode, String enterpriseCode) {
        return ((IEnterpriceCrossTradeRelationDomain)this.domain).getByPurchaseEnterpriseCodeAndEnterpriseCode(purchaseEnterpriseCode, enterpriseCode);
    }

    @Override
    public EnterpriceCrossTradeRelationRespDto getBySaleEnterpriseByPurchaseEnterpriseCodeAndSupplierCode(String purchaseEnterpriseCode, String supplierCode) {
        return ((IEnterpriceCrossTradeRelationDomain)this.domain).getBySaleEnterpriseByPurchaseEnterpriseCodeAndSupplierCode(purchaseEnterpriseCode, supplierCode);
    }

    @Override
    public RestResponse<Void> updateRelation(EnterpriceCrossTradeRelationDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"\u7f3a\u5c11id");
        Integer count = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IEnterpriceCrossTradeRelationDomain)this.domain).filter().ne((Object)"id", (Object)dto.getId())).eq((Object)"supplier_relation_id", (Object)dto.getSupplierRelationId())).eq((Object)"purchase_relation_id", (Object)dto.getPurchaseRelationId())).count();
        AssertUtils.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u516c\u53f8\u95f4\u4ea4\u6613\u5173\u7cfb\u5df2\u5b58\u5728");
        EnterpriceCrossTradeRelationEo eo = (EnterpriceCrossTradeRelationEo)this.converter().toEo((BaseDto)dto);
        eo.setExtPurchaseRatio(eo.getExtPurchaseRatio() == null || eo.getExtPurchaseRatio().compareTo(BigDecimal.ONE) < 0 ? BigDecimal.ONE : eo.getExtPurchaseRatio());
        eo.setFactoryRatio(eo.getFactoryRatio() == null || eo.getFactoryRatio().compareTo(BigDecimal.ONE) < 0 ? BigDecimal.ONE : eo.getFactoryRatio());
        ((IEnterpriceCrossTradeRelationDomain)this.domain).updateSelective((BaseEo)eo);
        return new RestResponse();
    }

    private void checkAndAddToInsertList(Iterator<EnterpriceCrossTradeRelationInsertBatchDto.InsertBatchRelation> iterator, Map<String, Long> purchaseCodeMap, Map<String, Long> purchaseNameMap, Map<String, Long> supplierCodeMap, Map<String, Long> supplierNameMap, List<EnterpriceCrossTradeRelationEo> insertList, Set<String> set) {
        Long sId;
        EnterpriceCrossTradeRelationInsertBatchDto.InsertBatchRelation next = iterator.next();
        Long pId = purchaseCodeMap.get(next.getPurchaseEnterpriseCode());
        if (pId == null) {
            pId = purchaseNameMap.get(next.getPurchaseEnterpriseName());
            AssertUtils.isTrue((pId != null ? 1 : 0) != 0, (String)("\u91c7\u8d2d\u5546" + next.getPurchaseEnterpriseCode() + "\u548c" + next.getPurchaseEnterpriseName() + "\u627e\u4e0d\u5230"));
        }
        if ((sId = supplierCodeMap.get(next.getSupplierCode())) == null) {
            sId = supplierNameMap.get(next.getSupplierName());
            AssertUtils.isTrue((sId != null ? 1 : 0) != 0, (String)("\u4f9b\u5e94\u5546" + next.getSupplierCode() + "\u548c" + next.getSupplierName() + "\u627e\u4e0d\u5230"));
        }
        AssertUtils.isTrue((!set.contains(sId + "@" + pId) ? 1 : 0) != 0, (String)("\u91c7\u8d2d\u65b9" + next.getPurchaseEnterpriseCode() + "\uff0c\u4f9b\u5e94\u5546" + next.getSupplierCode() + "\u5173\u7cfb\u5df2\u5b58\u5728"));
        set.add(sId + "@" + pId);
        Integer count = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IEnterpriceCrossTradeRelationDomain)this.domain).filter().eq((Object)"supplier_relation_id", (Object)sId)).eq((Object)"purchase_relation_id", (Object)pId)).count();
        AssertUtils.isTrue((count == 0 ? 1 : 0) != 0, (String)("\u91c7\u8d2d\u65b9" + next.getPurchaseEnterpriseCode() + "\uff0c\u4f9b\u5e94\u5546" + next.getSupplierCode() + "\u5173\u7cfb\u5df2\u5b58\u5728"));
        EnterpriceCrossTradeRelationEo inserEo = new EnterpriceCrossTradeRelationEo();
        inserEo.setTenantId(this.context.tenantId());
        inserEo.setInstanceId(this.context.instanceId());
        inserEo.setCreatePerson(this.context.userName());
        inserEo.setCreateTime(new Date());
        inserEo.setUpdatePerson(this.context.userName());
        inserEo.setUpdateTime(new Date());
        inserEo.setSupplierRelationId(sId);
        inserEo.setPurchaseRelationId(pId);
        inserEo.setRemark(next.getRemark());
        inserEo.setExtPurchaseRatio(next.getExtPurchaseRatio() == null || next.getExtPurchaseRatio().compareTo(BigDecimal.ONE) < 0 ? BigDecimal.ONE : next.getExtPurchaseRatio());
        inserEo.setFactoryRatio(next.getFactoryRatio() == null || next.getFactoryRatio().compareTo(BigDecimal.ONE) < 0 ? BigDecimal.ONE : next.getFactoryRatio());
        insertList.add(inserEo);
    }
}

