/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.dtyunxi.util.IdGenrator;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.CustomerRebateCollectReportConverter;
import com.yunxi.dg.base.center.report.convert.entity.CustomerRebateCountConverter;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsCompanyInfoDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICustomerRebateCollectReportDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICustomerRebateCountDomain;
import com.yunxi.dg.base.center.report.domain.entity.ICustomerRebateDetailReportDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.entity.IFlowTypeDomain;
import com.yunxi.dg.base.center.report.dto.entity.CodeAndNameDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateCollectReportDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateCollectReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateCollectTypeDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateCountDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateDetailReportDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebatePeriodDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.eo.CustomerRebateCollectReportEo;
import com.yunxi.dg.base.center.report.eo.CustomerRebateCountEo;
import com.yunxi.dg.base.center.report.service.entity.ICustomerRebateCollectReportService;
import com.yunxi.dg.base.center.report.utils.PageQueryUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import com.yunxi.dg.base.poi.dto.ExportFileParams;
import com.yunxi.dg.base.poi.dto.ExportSolFileParams;
import com.yunxi.dg.base.poi.service.FileOperationCommonService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerRebateCollectReportServiceImpl
extends BaseServiceImpl<CustomerRebateCollectReportDto, CustomerRebateCollectReportEo, ICustomerRebateCollectReportDomain>
implements ICustomerRebateCollectReportService {
    private static final Logger log = LoggerFactory.getLogger(CustomerRebateCollectReportServiceImpl.class);
    @Resource
    private ICustomerRebateDetailReportDomain customerRebateDetailReportDomain;
    @Resource
    private IDgCustomerDomain customerDomain;
    @Resource
    private IDgCsCompanyInfoDomain dgCsCompanyInfoDomain;
    @Resource
    private ICustomerRebateCountDomain customerRebateCountDomain;
    @Resource
    private IDgShopDomain dgShopDomain;
    @Resource
    private IFlowTypeDomain flowTypeDomain;
    @Resource
    private FileOperationCommonService fileOperationCommonService;

    public CustomerRebateCollectReportServiceImpl(ICustomerRebateCollectReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CustomerRebateCollectReportDto, CustomerRebateCollectReportEo> converter() {
        return CustomerRebateCollectReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> this.customerRebateDetailReportDomain.getMinChangeTime());
        dto.syncByStep("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u6c47\u603b\u62a5\u8868", this::doSyncInternal);
    }

    private void doSyncInternal(LocalDateTime startTime, LocalDateTime endTime) {
        LocalDate businessDate = startTime.toLocalDate();
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u6c47\u603b\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e {}", (Object)businessDate);
        ((ICustomerRebateCollectReportDomain)this.domain).physicsDeleteByBusinessDate(businessDate);
        this.customerRebateCountDomain.physicsDeleteByBusinessDate(businessDate);
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u6c47\u603b\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e\u5b8c\u6210");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List detailCountList = PageQueryUtils.queryAll(() -> this.customerRebateDetailReportDomain.queryListByBusinessDate(startTime, endTime));
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u6c47\u603b\u62a5\u8868\u540c\u6b65: {} - {} \u67e5\u8be2\u5230 {} \u6761\u6570\u636e", new Object[]{startTime.format(formatter), endTime.format(formatter), detailCountList.size()});
        if (detailCountList.isEmpty()) {
            return;
        }
        Map typeMap = this.flowTypeDomain.getTypeNewNameMap();
        ArrayList primaryList = new ArrayList();
        HashMap primaryMap = new HashMap();
        ArrayList countList = new ArrayList();
        Map<String, List<CustomerRebateDetailReportDto>> primaryGroup = detailCountList.stream().collect(Collectors.groupingBy(k -> k.getCompanyId() + "___" + k.getCustomerCode() + "___" + k.getShopCode()));
        primaryGroup.forEach((k, values) -> {
            CustomerRebateDetailReportDto first = (CustomerRebateDetailReportDto)values.get(0);
            CustomerRebateCollectReportEo primary = CustomerRebateCollectReportConverter.INSTANCE.detailToEo(first);
            primary.setId(Long.valueOf(IdGenrator.getDistributedId()));
            primary.setBusinessDate((Date)DateUtil.date((TemporalAccessor)startTime.toLocalDate()));
            Map<String, List<CustomerRebateDetailReportDto>> countGroup = values.stream().collect(Collectors.groupingBy(c -> c.getSpecialProject() + "___" + c.getType() + "___" + c.getChangeType() + "___" + c.getRebateBusinessTypeCode()));
            CustomerRebatePeriodDto normalPeriod = new CustomerRebatePeriodDto();
            CustomerRebatePeriodDto specialPeriod = new CustomerRebatePeriodDto();
            countGroup.forEach((c, cs) -> {
                CustomerRebateDetailReportDto fir = (CustomerRebateDetailReportDto)cs.get(0);
                CustomerRebateCountEo eo = CustomerRebateCountConverter.INSTANCE.detailToEo(fir);
                eo.setCollectId(primary.getId());
                eo.setBusinessDate(primary.getBusinessDate());
                if (fir.getRebateBusinessTypeCode() == null) {
                    CodeAndNameDto dto = (CodeAndNameDto)typeMap.get(fir.getChangeType());
                    eo.setRebateBusinessTypeCode(fir.getChangeType());
                    if (dto != null) {
                        eo.setRebateBusinessTypeCode(dto.getCode());
                        eo.setRebateBusinessTypeName(dto.getName());
                    }
                }
                BigDecimal tradeAmount = BigDecimal.ZERO;
                for (CustomerRebateDetailReportDto value : cs) {
                    tradeAmount = tradeAmount.add(value.getTradeAmount());
                    if (value.getSpecialProject().equals(0)) {
                        normalPeriod.compare(value);
                    }
                    if (!value.getSpecialProject().equals(1)) continue;
                    specialPeriod.compare(value);
                }
                eo.setTradeAmount(tradeAmount);
                countList.add(eo);
            });
            BigDecimal changeInAmount = normalPeriod.getChangeInAmount().add(specialPeriod.getChangeInAmount());
            BigDecimal changeOutAmount = normalPeriod.getChangeOutAmount().add(specialPeriod.getChangeOutAmount());
            BigDecimal periodBeginBalance = normalPeriod.getBeginBalance().add(specialPeriod.getBeginBalance());
            BigDecimal periodEndBalance = normalPeriod.getEndBalance().add(specialPeriod.getEndBalance());
            primary.setBusinessDate((Date)DateUtil.date((TemporalAccessor)startTime.toLocalDate()));
            primary.setPeriodBeginBalance(periodBeginBalance);
            primary.setChangeInAmount(changeInAmount);
            primary.setChangeOutAmount(changeOutAmount);
            primary.setPeriodEndBalance(periodEndBalance);
            primary.setNormalPeriodBeginBalance(normalPeriod.getBeginBalance());
            primary.setNormalPeriodEndBalance(normalPeriod.getEndBalance());
            primary.setSpecialPeriodBeginBalance(specialPeriod.getBeginBalance());
            primary.setSpecialPeriodEndBalance(specialPeriod.getEndBalance());
            primaryList.add(primary);
            primaryMap.put(primary.getId(), primary);
        });
        countList.forEach(count -> {
            CustomerRebateCollectReportEo report = (CustomerRebateCollectReportEo)primaryMap.get(count.getCollectId());
            count.setBusinessDate(report.getBusinessDate());
            count.setShopName(report.getShopName());
            count.setCompanyId(report.getCompanyId());
            count.setCompanyName(report.getCompanyName());
        });
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u6c47\u603b\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} - {} \u6761\u6570\u636e", (Object)primaryList.size(), (Object)countList.size());
        ((ICustomerRebateCollectReportDomain)this.domain).insertBatch(primaryList);
        this.customerRebateCountDomain.insertBatch(countList);
        log.info("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u6c47\u603b\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} - {} \u6761\u6570\u636e\u5b8c\u6210", (Object)primaryList.size(), (Object)countList.size());
    }

    @Override
    public PageInfo<CustomerRebateCollectReportDto> page(CustomerRebateCollectReportPageReqDto dto) {
        PageInfo<CustomerRebateCollectReportDto> page = this.pageWithoutAlign(dto);
        this.align(page.getList());
        return page;
    }

    @Override
    public PageInfo<CustomerRebateCollectReportDto> pageWithoutAlign(CustomerRebateCollectReportPageReqDto dto) {
        if (dto.getBusinessDateFrom() == null) {
            dto.setBusinessDateFrom(LocalDate.now().plusDays(-1L).plusMonths(-1L));
            dto.setBusinessDateTo(LocalDate.now().plusDays(-1L));
        }
        PageInfo page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((ICustomerRebateCollectReportDomain)this.domain).queryList(dto));
        List reportIds = page.getList().stream().map(BaseDto::getId).collect(Collectors.toList());
        List countList = this.customerRebateCountDomain.getByCollectIds(reportIds);
        Map<Long, Map<Integer, Map<Integer, List<CustomerRebateCountDto>>>> group = countList.stream().collect(Collectors.groupingBy(CustomerRebateCountDto::getCollectId, Collectors.groupingBy(CustomerRebateCountDto::getSpecialProject, Collectors.groupingBy(CustomerRebateCountDto::getType))));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String businessDateRange = formatter.format(dto.getBusinessDateFrom()) + "-" + formatter.format(dto.getBusinessDateTo());
        page.getList().forEach(r -> {
            r.setBusinessDateRange(businessDateRange);
            Map specialGroup = group.getOrDefault(r.getId(), Collections.emptyMap());
            r.setNormalRebate(CustomerRebateCollectTypeDto.parse((BigDecimal)BigDecimal.ZERO, specialGroup.getOrDefault(0, Collections.emptyMap())));
            r.setSpecialRebate(CustomerRebateCollectTypeDto.parse((BigDecimal)BigDecimal.ZERO, specialGroup.getOrDefault(1, Collections.emptyMap())));
        });
        return page;
    }

    @Override
    public void align(List<CustomerRebateCollectReportDto> list) {
        LinkedHashMap normalInMap = new LinkedHashMap();
        LinkedHashMap normalOutMap = new LinkedHashMap();
        LinkedHashMap specialInMap = new LinkedHashMap();
        LinkedHashMap specialOutMap = new LinkedHashMap();
        list.forEach(dto -> {
            this.addAlignInfo(dto.getNormalRebate(), normalInMap, normalOutMap);
            this.addAlignInfo(dto.getSpecialRebate(), specialInMap, specialOutMap);
        });
        list.forEach(dto -> {
            this.align((CustomerRebateCollectReportDto)dto, dto.getNormalRebate(), normalInMap, normalOutMap);
            this.align((CustomerRebateCollectReportDto)dto, dto.getSpecialRebate(), specialInMap, specialOutMap);
        });
    }

    private void align(CustomerRebateCollectReportDto report, CustomerRebateCollectTypeDto dto, Map<String, CustomerRebateCountDto> inMap, Map<String, CustomerRebateCountDto> outMap) {
        List<CustomerRebateCountDto> inList = this.align(report, dto.getInList(), inMap);
        dto.setInList(inList);
        List<CustomerRebateCountDto> outList = this.align(report, dto.getOutList(), outMap);
        dto.setOutList(outList);
    }

    private List<CustomerRebateCountDto> align(CustomerRebateCollectReportDto report, List<CustomerRebateCountDto> list, Map<String, CustomerRebateCountDto> map) {
        Map<String, CustomerRebateCountDto> dtoMap = list.stream().collect(Collectors.toMap(this::getKey, v -> v, (a, b) -> {
            log.warn("\u91cd\u590d\u7684rebateBusinessTypeCode\u7f16\u7801: code={}, a={}, b={}", new Object[]{a.getRebateBusinessTypeCode(), JSONUtil.toJsonStr((Object)a), JSONUtil.toJsonStr((Object)b)});
            return b;
        }));
        ArrayList<CustomerRebateCountDto> result = new ArrayList<CustomerRebateCountDto>();
        map.forEach((code, v) -> {
            CustomerRebateCountDto dto = (CustomerRebateCountDto)dtoMap.get(code);
            if (dto != null) {
                result.add(dto);
                return;
            }
            dto = new CustomerRebateCountDto();
            dto.setCollectId(report.getId());
            dto.setBusinessDate(report.getBusinessDate());
            dto.setCompanyId(report.getCompanyId());
            dto.setCompanyName(report.getCompanyName());
            dto.setCustomerCode(report.getCustomerCode());
            dto.setCustomerName(report.getCustomerName());
            dto.setShopCode(report.getShopCode());
            dto.setShopName(report.getShopName());
            dto.setType(v.getType());
            dto.setRebateBusinessTypeCode(v.getRebateBusinessTypeCode());
            dto.setRebateBusinessTypeName(v.getRebateBusinessTypeName());
            dto.setTradeAmount(BigDecimal.ZERO);
            result.add(dto);
        });
        return result;
    }

    private void addAlignInfo(CustomerRebateCollectTypeDto dto, Map<String, CustomerRebateCountDto> inMap, Map<String, CustomerRebateCountDto> outMap) {
        this.addAlignInfo(dto.getInList(), inMap);
        this.addAlignInfo(dto.getOutList(), outMap);
    }

    private void addAlignInfo(List<CustomerRebateCountDto> list, Map<String, CustomerRebateCountDto> map) {
        list.forEach(r -> {
            String key = this.getKey((CustomerRebateCountDto)r);
            if (!map.containsKey(key)) {
                CustomerRebateCountDto dto = new CustomerRebateCountDto();
                dto.setSpecialProject(r.getSpecialProject());
                dto.setType(r.getType());
                dto.setRebateBusinessTypeCode(r.getRebateBusinessTypeCode());
                dto.setRebateBusinessTypeName(r.getRebateBusinessTypeName());
                map.put(key, dto);
            }
        });
    }

    private String getKey(CustomerRebateCountDto r) {
        return r.getSpecialProject() + "_" + r.getType() + "_" + r.getRebateBusinessTypeCode();
    }

    @Override
    public LocalDate getLastBusinessDate() {
        return ((ICustomerRebateCollectReportDomain)this.domain).getLastBusinessDate();
    }

    @Override
    public void export(CustomerRebateCollectReportPageReqDto dto) {
        ExportSolFileParams params = new ExportSolFileParams();
        params.setKey("customer_rebate_collect_report");
        params.setFilter(JSONUtil.toJsonStr((Object)dto));
        params.setMenuModuleName("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u6c47\u603b\u62a5\u8868");
        params.setExportFunctionName("\u5ba2\u6237\u8fd4\u5229\u51fa\u5165\u6c60\u6c47\u603b\u62a5\u8868\u5bfc\u51fa");
        this.fileOperationCommonService.exportFileOperationCommonAsync((ExportFileParams)params);
    }
}

