/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.api.constant.AfterSaleOrderSourceEnum;
import com.yunxi.dg.base.center.report.api.constant.DgB2BAfterSaleStatus;
import com.yunxi.dg.base.center.report.api.constant.DgF2BAfterStatus;
import com.yunxi.dg.base.center.report.constants.OaAuditStatusEnum;
import com.yunxi.dg.base.center.report.convert.entity.DgAfterSaleOrderConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgRefundDetailDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutNoticeOrderDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.report.dto.account.constant.VoucherTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.BizTagDto;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.center.report.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.report.dto.entity.DgRefundDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordRespDto;
import com.yunxi.dg.base.center.report.dto.trade.req.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.report.dto.trade.req.DgAfterSaleOrderValidReqDto;
import com.yunxi.dg.base.center.report.dto.trade.req.DgOrderLabelRecordReqDto;
import com.yunxi.dg.base.center.report.dto.trade.req.DgOrderLabelReqDto;
import com.yunxi.dg.base.center.report.dto.trade.req.RebateOrderReqDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgAfterSaleItemRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgAfterSaleOrderItemExportRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgAfterSaleOrderReceiveResultDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgAfterSaleOrderStatusCountRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgB2BAfterSaleOrderStatusCountRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgOrderLabelRecordRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgOrderLabelRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgOrderReceiveResultDetailDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgReceiveDeliverResultRecordDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgReceiveDeliverResultRecordItemDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.RebateOrderRespDto;
import com.yunxi.dg.base.center.report.eo.DgShopEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.report.service.entity.IBizTagRecordService;
import com.yunxi.dg.base.center.report.service.entity.IBizTagService;
import com.yunxi.dg.base.center.report.service.entity.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.report.service.entity.IDgAfterSaleOrderTagRecordService;
import com.yunxi.dg.base.center.report.service.entity.IDgOrderLabelService;
import com.yunxi.dg.base.center.report.service.entity.IDgOrderTagService;
import com.yunxi.dg.base.center.report.service.finance.IKeepAccountingService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgAfterSaleOrderServiceImpl
extends BaseServiceImpl<DgAfterSaleOrderDto, DgAfterSaleOrderEo, IDgAfterSaleOrderDomain>
implements IDgAfterSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(DgAfterSaleOrderServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(DgAfterSaleOrderServiceImpl.class);
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private IDgRefundDetailDomain refundDetailDomain;
    @Resource
    private IDgAfterSaleOrderTagRecordService afterSaleOrderTagRecordService;
    @Resource
    private IBizTagRecordService tagRecordService;
    @Resource
    private IBizTagService tagService;
    @Resource
    private IDgOrderTagService orderTagService;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgOrderLabelService orderLabelService;
    @Resource
    private IDgOutNoticeOrderDomain outNoticeOrderDomain;
    @Resource
    private IKeepAccountingService accountingService;
    @Value(value="${mysql.in.limit:500}")
    private Integer sizeLimit;
    @Resource(name="statisticsExecutor")
    private Executor executor;
    @Resource
    private IDgShopDomain shopDomain;

    public DgAfterSaleOrderServiceImpl(IDgAfterSaleOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgAfterSaleOrderDto, DgAfterSaleOrderEo> converter() {
        return DgAfterSaleOrderConverter.INSTANCE;
    }

    @Override
    public DgAfterSaleOrderRespDto queryById(Long id) {
        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)this.afterSaleOrderDomain.selectByPrimaryKey(id);
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)afterSaleOrderEo, (BaseVo)afterSaleOrderRespDto);
        return afterSaleOrderRespDto;
    }

    @Override
    public PageInfo<DgAfterSaleOrderRespDto> queryByPage(DgAfterSaleOrderValidReqDto afterSaleOrderReqDto, Integer pageNum, Integer pageSize) {
        log.info("\u552e\u540e\u5217\u8868\u67e5\u8be2\u5165\u53c2 {} {} {}", new Object[]{JSON.toJSONString((Object)afterSaleOrderReqDto), pageNum, pageSize});
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dgAfterSaleOrderRespDtos = ((IDgAfterSaleOrderDomain)this.domain).queryAfterSaleOrderDetail(afterSaleOrderReqDto);
        PageInfo dtoPageInfo = new PageInfo(dgAfterSaleOrderRespDtos);
        Map<String, Long> statusCounts = this.queryAfterSaleOrderStatusCountMap(afterSaleOrderReqDto);
        List<DgAfterSaleOrderRespDto> respDtoList = this.completableFutureDtoHelper(dgAfterSaleOrderRespDtos, afterSaleOrderReqDto, afterSaleOrderReqDto.getQueryItem(), afterSaleOrderReqDto.getQueryTag());
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            respDtoList.get(0).setStatusCountMap(statusCounts);
            respDtoList.forEach(v -> {
                v.setAfterDeliveryAccounting(Objects.nonNull(v.getAfterDeliveryAccounting()) && "ACCOUNTED".equals(v.getAfterDeliveryAccounting()) ? "ACCOUNTED" : "UNACCOUNTED");
                v.setAfterBillingAccounting(Objects.nonNull(v.getAfterBillingAccounting()) && "ACCOUNTED".equals(v.getAfterBillingAccounting()) ? "ACCOUNTED" : "UNACCOUNTED");
            });
        }
        dtoPageInfo.setList(respDtoList);
        respDtoList.forEach(dto -> {
            if (!"3".equals(dto.getRefundStatus())) {
                log.info("{} \u9000\u6b3e\u72b6\u6001\u4e0d\u4e3a\u6210\u529f\u5219\u4e0d\u9700\u8981\u8fd4\u56de\u9000\u6b3e\u5b8c\u6210\u65f6\u95f4", (Object)dto.getId());
                dto.setLastChanged(null);
            }
        });
        return dtoPageInfo;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryBySaleOrderNo(List<String> saleOrderNo) {
        return ((IDgAfterSaleOrderDomain)this.domain).queryBySaleOrderNo(saleOrderNo);
    }

    @Override
    public DgB2BAfterSaleOrderStatusCountRespDto querySaleReturnByPageCount(DgAfterSaleOrderValidReqDto afterSaleOrderReqDto) {
        return this.queryAfterSaleOrderStatusCount(afterSaleOrderReqDto);
    }

    @NotNull
    private ExtQueryChainWrapper<DgAfterSaleOrderEo> getDgAfterSaleOrderExtQueryChainWrapper(DgAfterSaleOrderValidReqDto afterSaleOrderReqDto) {
        List warehouseCodes;
        List applyWarehouseCodes;
        List itemCodeList;
        List saleOutWarehouseCodeList;
        ExtQueryChainWrapper filter = this.afterSaleOrderDomain.filter();
        List orderTagCodeArr = afterSaleOrderReqDto.getOrderTagCodeArr();
        if (afterSaleOrderReqDto.getNeedTag() != null) {
            StringBuilder sb = new StringBuilder("SELECT 1 FROM tg_biz_tag_record r WHERE r.record_link_id = tr_dg_after_sale_order.id and r.dr=0");
            if (CollectionUtils.isNotEmpty((Collection)orderTagCodeArr)) {
                StringJoiner codeSb = new StringJoiner(",");
                for (String code2 : orderTagCodeArr) {
                    codeSb.add("'" + code2 + "'");
                }
                String codes = codeSb.toString();
                sb.append(" and r.tag_code in (").append(codes).append(")");
            }
            if (afterSaleOrderReqDto.getNeedTag() == 1) {
                filter.exists(true, sb.toString());
            } else if (afterSaleOrderReqDto.getNeedTag() == 0) {
                filter.notExists(true, sb.toString());
            }
        }
        filter.eq(StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getAfterBusinessTypeCode()), (Object)"after_business_type_code", (Object)afterSaleOrderReqDto.getAfterBusinessTypeCode());
        filter.eq(ObjectUtil.isNotEmpty((Object)afterSaleOrderReqDto.getIfInvoice()), (Object)"if_invoice", (Object)afterSaleOrderReqDto.getIfInvoice());
        filter.eq(ObjectUtil.isNotEmpty((Object)afterSaleOrderReqDto.getIfRecord()), (Object)"if_record", (Object)afterSaleOrderReqDto.getIfRecord());
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getStatusList())) {
            filter.in((Object)"status", (Collection)afterSaleOrderReqDto.getStatusList());
        }
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderReqDto.getReason())) {
            filter.like((Object)"reason", (Object)afterSaleOrderReqDto.getReason());
        }
        if (afterSaleOrderReqDto.getStartPlatformCreated() != null) {
            filter.ge((Object)"platform_created", (Object)afterSaleOrderReqDto.getStartPlatformCreated());
        }
        if (afterSaleOrderReqDto.getEndPlatformCreated() != null) {
            filter.le((Object)"platform_created", (Object)afterSaleOrderReqDto.getEndPlatformCreated());
        }
        if (afterSaleOrderReqDto.getCreateTimeStart() != null) {
            filter.ge((Object)"create_time", (Object)afterSaleOrderReqDto.getCreateTimeStart());
        }
        if (afterSaleOrderReqDto.getCreateTimeEnd() != null) {
            filter.le((Object)"create_time", (Object)afterSaleOrderReqDto.getCreateTimeEnd());
        }
        if (afterSaleOrderReqDto.getChannelAfterSaleCreatedStart() != null) {
            filter.ge((Object)"channel_after_sale_created", (Object)afterSaleOrderReqDto.getChannelAfterSaleCreatedStart());
        }
        if (afterSaleOrderReqDto.getChannelAfterSaleCreatedEnd() != null) {
            filter.le((Object)"channel_after_sale_created", (Object)afterSaleOrderReqDto.getChannelAfterSaleCreatedEnd());
        }
        if (afterSaleOrderReqDto.getLastChangedStart() != null) {
            filter.ge((Object)"last_changed", (Object)afterSaleOrderReqDto.getLastChangedStart());
        }
        if (afterSaleOrderReqDto.getLastChangedEnd() != null) {
            filter.le((Object)"last_changed", (Object)afterSaleOrderReqDto.getLastChangedEnd());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getOrderNo())) {
            filter.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"after_sale_order_no", (Collection)afterSaleOrderReqDto.getOrderNo())).or()).in((Object)"sale_order_no", (Collection)afterSaleOrderReqDto.getOrderNo())).or()).in((Object)"platform_refund_order_sn", (Collection)afterSaleOrderReqDto.getOrderNo())).or()).in((Object)"platform_order_no", (Collection)afterSaleOrderReqDto.getOrderNo());
            });
        }
        if (afterSaleOrderReqDto.getInWarehouseDateStart() != null) {
            filter.ge((Object)"in_warehouse_date", (Object)afterSaleOrderReqDto.getInWarehouseDateStart());
        }
        if (afterSaleOrderReqDto.getInWarehouseDateEnd() != null) {
            filter.le((Object)"in_warehouse_date", (Object)afterSaleOrderReqDto.getInWarehouseDateEnd());
        }
        if (afterSaleOrderReqDto.getStartPlatformCreated() != null) {
            filter.ge((Object)"platform_created", (Object)afterSaleOrderReqDto.getStartPlatformCreated());
        }
        if (afterSaleOrderReqDto.getEndPlatformCreated() != null) {
            filter.le((Object)"platform_created", (Object)afterSaleOrderReqDto.getEndPlatformCreated());
        }
        if (afterSaleOrderReqDto.getCompleteDateStart() != null) {
            filter.ge((Object)"complete_date", (Object)afterSaleOrderReqDto.getCompleteDateStart());
        }
        if (afterSaleOrderReqDto.getCompleteDateEnd() != null) {
            filter.le((Object)"complete_date", (Object)afterSaleOrderReqDto.getCompleteDateEnd());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getReturnWarehouseCodeList())) {
            filter.in((Object)"return_warehouse_code", (Collection)afterSaleOrderReqDto.getReturnWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getEnterpriseCodeList())) {
            filter.in((Object)"enterprise_code", (Collection)afterSaleOrderReqDto.getEnterpriseCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getStatus())) {
            filter.eq((Object)"status", (Object)afterSaleOrderReqDto.getStatus());
        }
        if (Objects.nonNull(afterSaleOrderReqDto.getSubsidiesType())) {
            filter.eq((Object)"subsidies_type", (Object)afterSaleOrderReqDto.getSubsidiesType());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getRefundStatusList())) {
            filter.in((Object)"refund_status", (Collection)afterSaleOrderReqDto.getRefundStatusList());
        }
        if (afterSaleOrderReqDto.getShopId() != null) {
            filter.eq((Object)"shop_id", (Object)afterSaleOrderReqDto.getShopId());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getShopIdList())) {
            filter.in((Object)"shop_id", (Collection)afterSaleOrderReqDto.getShopIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getShopCodeList())) {
            filter.in((Object)"shop_code", (Collection)afterSaleOrderReqDto.getShopCodeList());
        }
        if (afterSaleOrderReqDto.getReturnType() != null) {
            filter.eq((Object)"return_type", (Object)afterSaleOrderReqDto.getReturnType());
        }
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderReqDto.getAfterSaleOrderType())) {
            filter.eq((Object)"after_sale_order_type", (Object)afterSaleOrderReqDto.getAfterSaleOrderType());
        }
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderReqDto.getChannelCode())) {
            filter.eq((Object)"channel_code", (Object)afterSaleOrderReqDto.getChannelCode());
        }
        if (afterSaleOrderReqDto.getDeliveryStatus() != null) {
            filter.eq((Object)"delivery_status", (Object)afterSaleOrderReqDto.getDeliveryStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getAfterSaleOrderNo())) {
            filter.eq((Object)"after_sale_order_no", (Object)afterSaleOrderReqDto.getAfterSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getBizModel())) {
            filter.eq((Object)"biz_model", (Object)afterSaleOrderReqDto.getBizModel());
        }
        if (Objects.nonNull(afterSaleOrderReqDto.getReturnBizType())) {
            filter.eq((Object)"return_biz_type", (Object)afterSaleOrderReqDto.getReturnBizType());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getReturnBizTypeList())) {
            filter.in((Object)"return_biz_type", (Collection)afterSaleOrderReqDto.getReturnBizTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getExcludeReturnBizTypeList())) {
            filter.notIn((Object)"return_biz_type", (Collection)afterSaleOrderReqDto.getExcludeReturnBizTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getCustomerCodeList())) {
            filter.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"customer_name", (Collection)afterSaleOrderReqDto.getCustomerCodeList())).or()).in((Object)"customer_code", (Collection)afterSaleOrderReqDto.getCustomerCodeList());
            });
        }
        String applyRefundWarehouseCode = afterSaleOrderReqDto.getApplyRefundWarehouseCode();
        String refundWarehouseCode = afterSaleOrderReqDto.getRefundWarehouseCode();
        String skuNames = afterSaleOrderReqDto.getSkuNames();
        if (StringUtils.isNotBlank((CharSequence)applyRefundWarehouseCode) || StringUtils.isNotBlank((CharSequence)refundWarehouseCode)) {
            StringBuilder sb = new StringBuilder("SELECT 1 FROM tr_dg_after_sale_order_item asoi WHERE asoi.after_sale_order_id = tr_dg_after_sale_order.id");
            Optional.ofNullable(applyRefundWarehouseCode).ifPresent(code -> {
                sb.append(" and asoi.apply_refund_warehouse_code=");
                sb.append("'").append(applyRefundWarehouseCode).append("'");
            });
            Optional.ofNullable(refundWarehouseCode).ifPresent(code -> {
                sb.append(" and asoi.refund_warehouse_code=");
                sb.append("'").append(refundWarehouseCode).append("'");
            });
            filter.exists(true, sb.toString());
        }
        if (afterSaleOrderReqDto.getRelateToPlatformOrder() != null) {
            if (afterSaleOrderReqDto.getRelateToPlatformOrder() == 1) {
                filter.eq((Object)"relate_to_platform_order", (Object)afterSaleOrderReqDto.getRelateToPlatformOrder());
            } else {
                filter.and(wrapper -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"relate_to_platform_order", (Object)afterSaleOrderReqDto.getRelateToPlatformOrder())).or()).eq((Object)"relate_to_platform_order", (Object)"")).or()).isNull((Object)"relate_to_platform_order");
                });
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getOrderSourceList())) {
            filter.in((Object)"order_source", (Collection)afterSaleOrderReqDto.getOrderSourceList());
        }
        if (CollectionUtils.isNotEmpty((Collection)(saleOutWarehouseCodeList = afterSaleOrderReqDto.getSaleOutWarehouseCodeList()))) {
            StringBuilder sb = new StringBuilder("SELECT 1 FROM tr_dg_perform_order_info s WHERE s.id = tr_dg_after_sale_order.sale_order_id and s.delivery_logical_warehouse_code in");
            StringJoiner codeSb = new StringJoiner(",");
            for (Object code3 : saleOutWarehouseCodeList) {
                codeSb.add("'" + (String)code3 + "'");
            }
            String codes = codeSb.toString();
            sb.append("(").append(codes).append(")");
            filter.exists(true, sb.toString());
        }
        if (CollectionUtils.isNotEmpty((Collection)(itemCodeList = afterSaleOrderReqDto.getItemCodeList()))) {
            StringBuilder sb = new StringBuilder("SELECT 1 FROM tr_dg_after_sale_order_item s WHERE s.after_sale_order_id = tr_dg_after_sale_order.id and s.sku_code in");
            StringJoiner codeSb = new StringJoiner(",");
            for (Object code4 : itemCodeList) {
                codeSb.add("'" + (String)code4 + "'");
            }
            String codes = codeSb.toString();
            sb.append("(").append(codes).append(")");
            filter.exists(true, sb.toString());
        }
        if (CollectionUtils.isNotEmpty((Collection)(applyWarehouseCodes = afterSaleOrderReqDto.getApplyReFundWarehouseCodeList()))) {
            StringBuilder sb = new StringBuilder("SELECT 1 FROM tr_dg_after_sale_order_item s WHERE s.after_sale_order_id = tr_dg_after_sale_order.id and s.apply_refund_warehouse_code in");
            StringJoiner codeSb = new StringJoiner(",");
            for (Object code5 : applyWarehouseCodes) {
                codeSb.add("'" + (String)code5 + "'");
            }
            String codes = codeSb.toString();
            sb.append("(").append(codes).append(")");
            filter.exists(true, sb.toString());
        }
        if (CollectionUtils.isNotEmpty((Collection)(warehouseCodes = afterSaleOrderReqDto.getReFundWarehouseCodeList()))) {
            StringBuilder sb = new StringBuilder("SELECT 1 FROM tr_dg_after_sale_order_item s WHERE s.after_sale_order_id = tr_dg_after_sale_order.id and s.refund_warehouse_code in ");
            StringJoiner codeSb = new StringJoiner(",");
            for (String code6 : warehouseCodes) {
                codeSb.add("'" + code6 + "'");
            }
            String codes = codeSb.toString();
            sb.append("(").append(codes).append(")");
            filter.exists(true, sb.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getRemark())) {
            filter.like((Object)"remark", (Object)afterSaleOrderReqDto.getRemark());
        }
        filter.like(StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getReturnShippingSn()), (Object)"return_shipping_sn", (Object)("%" + afterSaleOrderReqDto.getReturnShippingSn() + "%"));
        filter.eq((Object)"dr", (Object)0);
        filter.in(CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getOrderIds()), (Object)"id", (Collection)afterSaleOrderReqDto.getOrderIds());
        filter.orderByDesc((Object)"create_time");
        return filter;
    }

    private Map<String, Long> queryAfterSaleOrderStatusCountMap(DgAfterSaleOrderValidReqDto afterSaleOrderReqDto) {
        afterSaleOrderReqDto.setStatus(null);
        afterSaleOrderReqDto.setStatusList(null);
        ExtQueryChainWrapper<DgAfterSaleOrderEo> filter = this.getDgAfterSaleOrderExtQueryChainWrapper(afterSaleOrderReqDto);
        filter.select(new String[]{"status"});
        List afterSaleOrderEoList = filter.list();
        Map<String, Long> statusCounts = afterSaleOrderEoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderEo::getStatus, Collectors.counting()));
        return statusCounts;
    }

    private DgB2BAfterSaleOrderStatusCountRespDto queryAfterSaleOrderStatusCount(DgAfterSaleOrderValidReqDto afterSaleOrderReqDto) {
        ExtQueryChainWrapper<DgAfterSaleOrderEo> filter = this.getDgAfterSaleOrderExtQueryChainWrapper(afterSaleOrderReqDto);
        filter.select(new String[]{"status"});
        List afterSaleOrderEoList = filter.list();
        Map<String, Long> statusCounts = afterSaleOrderEoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderEo::getStatus, Collectors.counting()));
        DgB2BAfterSaleOrderStatusCountRespDto dgB2BAfterSaleOrderStatusCountRespDto = new DgB2BAfterSaleOrderStatusCountRespDto();
        int allCount = 0;
        for (Map.Entry<String, Long> stringLongEntry : statusCounts.entrySet()) {
            String status = stringLongEntry.getKey();
            int value = stringLongEntry.getValue().intValue();
            allCount += value;
            DgB2BAfterSaleStatus dgB2BAfterSaleStatus = DgB2BAfterSaleStatus.forCode((String)status);
            if (ObjectUtil.isEmpty((Object)dgB2BAfterSaleStatus)) continue;
            switch (dgB2BAfterSaleStatus) {
                case WAIT_CHECK: {
                    dgB2BAfterSaleOrderStatusCountRespDto.setWaitCheckCount(Integer.valueOf(value));
                    break;
                }
                case WAIT_AUDIT: {
                    dgB2BAfterSaleOrderStatusCountRespDto.setWaitAuditCount(Integer.valueOf(value));
                    break;
                }
                case WAIT_IN_WAREHOUSE: {
                    dgB2BAfterSaleOrderStatusCountRespDto.setWaitInWarehouseCount(Integer.valueOf(value));
                    break;
                }
                case PART_IN_WAREHOUSE: {
                    dgB2BAfterSaleOrderStatusCountRespDto.setPartInWarehouseCount(Integer.valueOf(value));
                    break;
                }
                case COMPLETE: {
                    dgB2BAfterSaleOrderStatusCountRespDto.setCompleteCount(Integer.valueOf(value));
                    break;
                }
                case FINISH: {
                    dgB2BAfterSaleOrderStatusCountRespDto.setFinishCount(Integer.valueOf(value));
                    break;
                }
                case INVALID: {
                    dgB2BAfterSaleOrderStatusCountRespDto.setInvalidCount(Integer.valueOf(value));
                    break;
                }
                case CLOSE: {
                    dgB2BAfterSaleOrderStatusCountRespDto.setCloseCount(Integer.valueOf(value));
                    break;
                }
            }
        }
        dgB2BAfterSaleOrderStatusCountRespDto.setAllCount(Integer.valueOf(allCount));
        return dgB2BAfterSaleOrderStatusCountRespDto;
    }

    private List<DgAfterSaleOrderRespDto> completableFutureDtoHelper(List<DgAfterSaleOrderRespDto> respDtos, DgAfterSaleOrderValidReqDto afterSaleOrderReqDto, Boolean queryItem, Boolean queryTag) {
        LinkedList<DgAfterSaleOrderRespDto> respDtoList = new LinkedList<DgAfterSaleOrderRespDto>();
        int pageSize = this.sizeLimit;
        int limit = (respDtos.size() + pageSize - 1) / pageSize;
        List pageList = ((Stream)Stream.iterate(0, n -> n + 1).limit(limit).parallel()).map(n -> ((Stream)respDtos.stream().skip(n * pageSize).limit(pageSize).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        LinkedList<CompletionStage> futures = new LinkedList<CompletionStage>();
        for (List list : pageList) {
            CompletionStage future = CompletableFuture.supplyAsync(() -> this.dtoHelper(afterSaleOrderRespDtos, afterSaleOrderReqDto, queryItem, queryTag), this.executor).whenComplete((result, throwable) -> {
                if (CollectionUtils.isNotEmpty((Collection)result)) {
                    log.info("\u5f53\u524d\u7ebf\u7a0b\u6267\u884c\u6210\u529f");
                }
                if (throwable != null) {
                    log.error("completableFuture  error:{}", throwable);
                }
            });
            futures.add(future);
        }
        for (CompletableFuture completableFuture : futures) {
            List afterSaleOrderRespDtos = null;
            try {
                afterSaleOrderRespDtos = (List)completableFuture.get();
            }
            catch (InterruptedException e) {
                log.error("\u5b50\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("\u5b50\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38", (Throwable)e);
            }
            if (!CollectionUtils.isNotEmpty((Collection)afterSaleOrderRespDtos)) continue;
            respDtoList.addAll(afterSaleOrderRespDtos);
        }
        return respDtoList;
    }

    private List<DgAfterSaleOrderRespDto> dtoHelper(List<DgAfterSaleOrderRespDto> respDtos, DgAfterSaleOrderValidReqDto afterSaleOrderReqDto, Boolean queryItem, Boolean queryTag) {
        HashSet<Long> orderIdSet = new HashSet<Long>();
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<Long> shopIds = new ArrayList<Long>();
        for (DgAfterSaleOrderRespDto dto2 : respDtos) {
            Long id = dto2.getId();
            orderIdSet.add(id);
            ids.add(id);
            shopIds.add(dto2.getShopId());
        }
        ArrayList orderIds = new ArrayList(orderIdSet);
        ArrayList<ReBizTagRecordRespDto> tagRecordRespDtos = new ArrayList<ReBizTagRecordRespDto>();
        ReBizTagRecordPageReqDto orderTagRecordReqDto = new ReBizTagRecordPageReqDto();
        orderTagRecordReqDto.setRecordLinkIds(ids);
        tagRecordRespDtos.addAll(this.tagRecordService.findAll(orderTagRecordReqDto));
        if (queryTag != null && queryTag.booleanValue() && CollectionUtils.isNotEmpty(tagRecordRespDtos)) {
            List tagCodes = tagRecordRespDtos.stream().map(BizTagRecordDto::getTagCode).collect(Collectors.toList());
            ReBizTagPageReqDto reBizTagPageReqDto = new ReBizTagPageReqDto();
            reBizTagPageReqDto.setTagCodes(tagCodes);
            List<BizTagDto> tagEoList = this.tagService.findAll(reBizTagPageReqDto);
            Map orderTagEoMap = tagEoList.stream().collect(Collectors.toMap(BizTagDto::getTagCode, Function.identity()));
            Map<Long, List<ReBizTagRecordRespDto>> tagRecordMap = tagRecordRespDtos.stream().collect(Collectors.groupingBy(BizTagRecordDto::getRecordLinkId));
            respDtos.forEach(dto -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)tagRecordMap.get(dto.getId())))) {
                    dto.setTagRecordCodes(((List)tagRecordMap.get(dto.getId())).stream().map(e -> (BizTagDto)orderTagEoMap.get(e.getTagCode())).collect(Collectors.toList()));
                    dto.setTagRecordNames(((List)tagRecordMap.get(dto.getId())).stream().map(e -> ((BizTagDto)orderTagEoMap.get(e.getTagCode())).getTagName()).collect(Collectors.toList()));
                }
            });
        }
        DgOrderLabelRecordReqDto dgOrderLabelRecordReqDto = new DgOrderLabelRecordReqDto();
        dgOrderLabelRecordReqDto.setOrderIds(orderIds);
        List dgOrderLabelRecordRespDtos = this.orderLabelRecordDomain.queryByParam(dgOrderLabelRecordReqDto);
        if (CollectionUtils.isNotEmpty((Collection)dgOrderLabelRecordRespDtos)) {
            List tagCodes = dgOrderLabelRecordRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
            DgOrderLabelReqDto dgOrderLabelReqDto = new DgOrderLabelReqDto();
            dgOrderLabelReqDto.setLabelCodes(tagCodes);
            List<DgOrderLabelRespDto> labelEoList = this.orderLabelService.queryByList(dgOrderLabelReqDto);
            Map orderLabelEoMap = labelEoList.stream().collect(Collectors.toMap(DgOrderLabelRespDto::getLabelCode, Function.identity()));
            Map<Long, List<DgOrderLabelRecordRespDto>> labelRecordMap = dgOrderLabelRecordRespDtos.stream().collect(Collectors.groupingBy(DgOrderLabelBaseRespDto::getOrderId));
            respDtos.forEach(dto -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)labelRecordMap.get(dto.getId())))) {
                    dto.setLabelRecordCodes(((List)labelRecordMap.get(dto.getId())).stream().map(e -> (DgOrderLabelRespDto)orderLabelEoMap.get(e.getLabelCode())).collect(Collectors.toList()));
                }
            });
        }
        List outNoticeOrderNoList = respDtos.stream().map(DgAfterSaleOrderRespDto::getInputWarehouseOrderNo).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        Map<Object, Object> outNoticeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(outNoticeOrderNoList)) {
            DgOutNoticeOrderPageReqDto queryDto = new DgOutNoticeOrderPageReqDto();
            queryDto.setDocumentNoList(outNoticeOrderNoList);
            List dgOutNoticeOrderDtos = this.outNoticeOrderDomain.queryList(queryDto);
            outNoticeMap = ((List)Optional.ofNullable(dgOutNoticeOrderDtos).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgOutNoticeOrderDto::getDocumentNo, Function.identity(), (v1, v2) -> v1));
        }
        List shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().select(new String[]{"id, manage_type"}).in((Object)"id", shopIds)).list();
        Map shopIdMap = shopEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
        HashMap finalOutNoticeMap = outNoticeMap;
        respDtos.forEach(dto -> {
            DgOutNoticeOrderDto outNoticeOrderRespDto;
            DgShopEo dgShopEo = (DgShopEo)shopIdMap.get(dto.getShopId());
            Optional.ofNullable(dgShopEo).ifPresent(a -> dto.setShopType(a.getManageType()));
            dto.setPushWmsStatus("notPushed");
            if (StringUtils.isNotEmpty((CharSequence)dto.getInputWarehouseOrderNo()) && finalOutNoticeMap.containsKey(dto.getInputWarehouseOrderNo()) && !"ino_cancel".equals((outNoticeOrderRespDto = (DgOutNoticeOrderDto)finalOutNoticeMap.get(dto.getInputWarehouseOrderNo())).getOrderStatus())) {
                if ("success".equals(outNoticeOrderRespDto.getPushStatus())) {
                    dto.setPushWmsStatus("pushed");
                } else {
                    dto.setPushWmsStatus("notPushed");
                    dto.setPushWmsMsg(outNoticeOrderRespDto.getPushMsg());
                }
            }
        });
        DgAfterSaleOrderItemEo query = new DgAfterSaleOrderItemEo();
        query.setDr(0);
        ExtQueryChainWrapper filter = this.afterSaleOrderItemDomain.filter();
        filter.in((Object)"after_sale_order_id", orderIds);
        List afterSaleOrderItemEos = filter.list();
        Map<Long, List<DgAfterSaleOrderItemEo>> listMap = this.getAfterSaleOrderItemMap(afterSaleOrderItemEos);
        respDtos.forEach(e -> {
            List itemEos = (List)listMap.get(e.getId());
            if (CollectionUtils.isNotEmpty((Collection)itemEos)) {
                ArrayList items = new ArrayList();
                itemEos.forEach(ld -> {
                    DgAfterSaleItemRespDto respDto = new DgAfterSaleItemRespDto();
                    CubeBeanUtils.copyProperties((Object)respDto, (Object)ld, (String[])new String[0]);
                    respDto.setItemNum(Optional.ofNullable(ld.getItemNum()).map(BigDecimal::intValue).orElse(0));
                    items.add(respDto);
                });
                e.setItems(items);
                BigDecimal origPayAmount = itemEos.stream().filter(p -> p.getOrigPayAmount() != null && Objects.equals(p.getAfterSaleOrderItemType(), 0)).map(DgAfterSaleOrderItemEo::getOrigPayAmount).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
                this.logger.info("origPayAmount:{}", (Object)origPayAmount);
                BigDecimal origRealPayAmount = itemEos.stream().map(DgAfterSaleOrderItemEo::getOrigRealPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                e.setOrigPayAmount(origPayAmount);
                e.setOrigRealPayAmount(origRealPayAmount);
                BigDecimal realPayAmount = itemEos.stream().filter(p -> p.getRealPayAmount() != null && p.getAfterSaleOrderItemType() == 0).map(DgAfterSaleOrderItemEo::getRealPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal payAmount = itemEos.stream().filter(p -> p.getRealPayAmount() != null && p.getAfterSaleOrderItemType() == 1).map(DgAfterSaleOrderItemEo::getRealPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundAmount = itemEos.stream().map(DgAfterSaleOrderItemEo::getActualRefundAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                e.setRealPayAmount(realPayAmount);
                e.setPayAmount(payAmount);
                e.setRefundAmount(refundAmount);
                List refundWarehouseNameList = itemEos.stream().map(DgAfterSaleOrderItemEo::getRefundWarehouseName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                String applyRefundWarehouseName = itemEos.stream().map(DgAfterSaleOrderItemEo::getApplyRefundWarehouseName).filter(Objects::nonNull).findFirst().orElse(null);
                e.setRefundWarehouseNameList(refundWarehouseNameList);
                e.setApplyRefundWarehouseName(applyRefundWarehouseName);
                BigDecimal itemTotalNum = itemEos.stream().map(DgAfterSaleOrderItemEo::getActualReturnNum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                e.setItemTotalNum(itemTotalNum.compareTo(BigDecimal.ZERO) <= 0 ? null : Integer.valueOf(itemTotalNum.intValue()));
                e.setRefundAmount(e.getRefundAmount().compareTo(BigDecimal.ZERO) <= 0 ? null : e.getRefundAmount());
                if (StringUtils.isNotBlank((CharSequence)e.getExtension())) {
                    JSONObject extension = JSONObject.parseObject((String)e.getExtension());
                    e.setPhoneNum(extension.getString("phoneNum"));
                }
            }
        });
        return respDtos;
    }

    private Map<Long, List<DgAfterSaleOrderItemEo>> getAfterSaleOrderItemMap(List<DgAfterSaleOrderItemEo> DgAfterSaleOrderItemEos) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(DgAfterSaleOrderItemEos)) {
            return map;
        }
        return DgAfterSaleOrderItemEos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getAfterSaleOrderId));
    }

    @Override
    public List<DgAfterSaleOrderItemExportRespDto> queryByExport(String filter, Integer pageNum, Integer pageSize) {
        DgAfterSaleOrderValidReqDto afterSaleOrderReqDto = (DgAfterSaleOrderValidReqDto)JSON.parseObject((String)filter, DgAfterSaleOrderValidReqDto.class);
        log.info("\u5546\u54c1\u5bfc\u51fa\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)afterSaleOrderReqDto));
        List respDtoPageInfo = this.afterSaleOrderDomain.selectByExport(afterSaleOrderReqDto);
        return respDtoPageInfo;
    }

    @Override
    public PageInfo<DgAfterSaleOrderRespDto> queryPostReturnByPage(DgAfterSaleOrderValidReqDto reqDto) {
        this.queryPostReturnByPageParamsHandle((DgAfterSaleOrderReqDto)reqDto);
        this.logger.info("\u9000\u8d27\u5355\u5217\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo pageInfo = this.afterSaleOrderDomain.queryPostReturnByPage(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List refundDetailEoList;
            List ids = pageInfo.getList().stream().map(DgAfterSaleOrderRespDto::getId).collect(Collectors.toList());
            List itemEoList = this.afterSaleOrderItemDomain.selectByAfterOrderIds(ids);
            Map<Object, Object> itemMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)itemEoList)) {
                itemMap = itemEoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getAfterSaleOrderId));
            }
            List completeAfterOrderNoList = pageInfo.getList().stream().filter(e -> e.getStatus().equals("COMPLETE")).map(DgAfterSaleOrderRespDto::getAfterSaleOrderNo).collect(Collectors.toList());
            HashMap accountTypeMap = new HashMap();
            Map<Object, Object> refundDetailMap = new HashMap();
            if (CollectionUtils.isNotEmpty(completeAfterOrderNoList) && CollectionUtils.isNotEmpty((Collection)(refundDetailEoList = ((ExtQueryChainWrapper)this.refundDetailDomain.filter().in((Object)"biz_order_no", completeAfterOrderNoList)).list()))) {
                List refundDetailDtos = BeanCopyUtil.copyPropertiesForList((List)refundDetailEoList, DgRefundDetailDto.class);
                refundDetailMap = refundDetailDtos.stream().collect(Collectors.groupingBy(DgRefundDetailDto::getBizOrderId));
            }
            List dgOrderLabelRecordRespDtoList = this.orderLabelRecordDomain.queryByOrderId(ids);
            Map dgOrderLabelRecordRespDtoMap = Optional.ofNullable(dgOrderLabelRecordRespDtoList).map(m -> m.stream().collect(Collectors.groupingBy(DgOrderLabelBaseRespDto::getOrderId))).orElse(new HashMap());
            HashMap finalRefundDetailMap = refundDetailMap;
            Map<Object, Object> finalItemMap = itemMap;
            pageInfo.getList().forEach(dto -> {
                List afterSaleOrderItemEos;
                if (StringUtils.isNotBlank((CharSequence)dto.getStatus()) && ObjectUtil.isNotEmpty((Object)DgF2BAfterStatus.forCode((String)dto.getStatus()))) {
                    dto.setStatusStr(DgF2BAfterStatus.forCode((String)dto.getStatus()).getDesc());
                }
                if (ObjectUtil.isNotEmpty((Object)dto.getOrderSource()) && ObjectUtil.isNotEmpty((Object)AfterSaleOrderSourceEnum.enumOf((Integer)dto.getOrderSource()))) {
                    dto.setOrderSourceStr(AfterSaleOrderSourceEnum.enumOf((Integer)dto.getOrderSource()).getDesc());
                }
                if (CollectionUtils.isNotEmpty((Collection)(afterSaleOrderItemEos = (List)finalItemMap.get(dto.getId())))) {
                    List imgList = afterSaleOrderItemEos.stream().map(DgAfterSaleOrderItemEo::getImgUrl).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                    dto.setAfterItemImgList(imgList);
                    dto.setItemCount(Integer.valueOf(afterSaleOrderItemEos.size()));
                    BigDecimal orderActualRefundAmount = afterSaleOrderItemEos.stream().map(item -> Optional.ofNullable(item.getActualRefundAmount()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    dto.setOrderActualRefundAmount(orderActualRefundAmount);
                    BigDecimal refundAmount = afterSaleOrderItemEos.stream().map(item -> Optional.ofNullable(item.getRefundAmount()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    dto.setRefundAmount(refundAmount);
                    BigDecimal applyReturnQty = afterSaleOrderItemEos.stream().map(DgAfterSaleOrderItemEo::getActualReturnNum).filter(ObjectUtil::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add);
                    dto.setApplyReturnQty(applyReturnQty.compareTo(BigDecimal.ZERO) <= 0 ? null : Long.valueOf(applyReturnQty.longValue()));
                }
                if (dto.getStatus().equals("COMPLETE")) {
                    List dgRefundDetailDtos = (List)finalRefundDetailMap.get(dto.getId());
                    dto.setRefundDetailDtoList(dgRefundDetailDtos);
                }
                dto.setLocation(String.format("%s%s%s", Optional.ofNullable(dto.getReturnProvinceName()).orElse(""), Optional.ofNullable(dto.getReturnCityName()).orElse(""), Optional.ofNullable(dto.getReturnCountyName()).orElse("")));
                List dgOrderLabelRecordRespDtos = (List)dgOrderLabelRecordRespDtoMap.get(dto.getId());
                if (CollectionUtils.isNotEmpty((Collection)dgOrderLabelRecordRespDtos)) {
                    List lableCodes = dgOrderLabelRecordRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
                    DgOrderLabelReqDto dgOrderLabelReqDto = new DgOrderLabelReqDto();
                    dgOrderLabelReqDto.setLabelCodes(lableCodes);
                    List<DgOrderLabelRespDto> labelEoList = this.orderLabelService.queryByList(dgOrderLabelReqDto);
                    dto.setLabelRecordCodes(labelEoList);
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getOaAuditStatus())) {
                    dto.setOaAuditStatusName(OaAuditStatusEnum.getDescByCode((String)dto.getOaAuditStatus()));
                }
            });
        }
        return pageInfo;
    }

    private void queryPostReturnByPageParamsHandle(DgAfterSaleOrderReqDto reqDto) {
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAfterSaleOrderNo())) {
            String[] strings = reqDto.getAfterSaleOrderNo().replace(" ", ",").split(",");
            reqDto.setAfterSaleOrderNoList(Arrays.asList(strings));
            reqDto.setAfterSaleOrderNo(null);
        }
    }

    @Override
    public DgAfterSaleOrderStatusCountRespDto queryPostReturnByPageCount(DgAfterSaleOrderValidReqDto reqDto) {
        this.logger.info("\u9000\u8ba2\u5355\u5217\u8868\u7edf\u8ba1\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.afterSaleOrderDomain.queryPostReturnByPageCount((DgAfterSaleOrderReqDto)reqDto);
    }

    @Override
    public Integer queryPostReturnCountByCustomer(String customerCode, String bizType) {
        this.logger.info("\u6839\u636e\u5ba2\u6237\u67e5\u8be2\u9000\u8d27\u5355\u636e\u6570\u91cf\uff1a{}", (Object)customerCode);
        ArrayList statusList = Lists.newArrayList((Object[])new String[]{DgF2BAfterStatus.WAIT_AUDIT.getCode(), DgF2BAfterStatus.WAIT_IN_STORAGE.getCode(), DgF2BAfterStatus.RETURNED_WAIT_CONFIRM.getCode(), DgF2BAfterStatus.WAIT_QUALITY_TEST.getCode(), DgF2BAfterStatus.QUALITY_TEST_WAIT_CONFIRM.getCode(), DgF2BAfterStatus.WAIT_REFUND.getCode(), DgF2BAfterStatus.COMPLETE.getCode(), DgF2BAfterStatus.CANCEL.getCode(), DgF2BAfterStatus.CLOSE.getCode()});
        return ((IDgAfterSaleOrderDomain)this.domain).queryPostReturnCountByCustomer(customerCode, (List)statusList, bizType);
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List dgAfterSaleOrderEos = ((IDgAfterSaleOrderDomain)this.domain).selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)dgAfterSaleOrderEos)) {
            return null;
        }
        ArrayList<DgAfterSaleOrderRespDto> dtoList = new ArrayList<DgAfterSaleOrderRespDto>();
        DtoHelper.eoList2DtoList((Collection)dgAfterSaleOrderEos, dtoList, DgAfterSaleOrderRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<RebateOrderRespDto> queryRebateAfterOrderByPage(RebateOrderReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List respDtoList = this.afterSaleOrderDomain.queryRebateAfterOrderByPage(reqDto);
        return new PageInfo(respDtoList);
    }

    @Override
    public DgAfterSaleOrderReceiveResultDto queryAfterSaleOrderReceiveResult(DgAfterSaleOrderDto orderDto) {
        this.logger.info("\u67e5\u8be2\u552e\u540e\u5355\u6536\u8d27\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderDto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)orderDto.getAfterSaleOrderNo()), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List detailDtoList = this.afterSaleOrderDomain.queryAfterSaleOrderReceiveResult(orderDto);
        if (CollectionUtils.isEmpty((Collection)detailDtoList)) {
            return null;
        }
        DgOrderReceiveResultDetailDto detailDto = (DgOrderReceiveResultDetailDto)detailDtoList.get(0);
        DgAfterSaleOrderReceiveResultDto resultDto = (DgAfterSaleOrderReceiveResultDto)BeanCopyUtil.copy((Object)detailDto, DgAfterSaleOrderReceiveResultDto.class);
        ArrayList recordDtoList = new ArrayList();
        Map<String, List<DgOrderReceiveResultDetailDto>> resultCollect = detailDtoList.stream().collect(Collectors.groupingBy(DgOrderReceiveResultDetailDto::getDocumentNo));
        resultCollect.forEach((k, v) -> {
            DgReceiveDeliverResultRecordDto recordDto = (DgReceiveDeliverResultRecordDto)BeanCopyUtil.copy(v.get(0), DgReceiveDeliverResultRecordDto.class);
            List resultRecordItemDtoList = BeanCopyUtil.copyPropertiesForList((List)v, DgReceiveDeliverResultRecordItemDto.class);
            recordDto.setItemDtoList(resultRecordItemDtoList);
            recordDtoList.add(recordDto);
        });
        resultDto.setRecordDtoList(recordDtoList);
        return resultDto;
    }

    private void dealKeepAccounting(List<DgAfterSaleOrderRespDto> respDtoList) {
        if (CollectionUtils.isEmpty(respDtoList)) {
            return;
        }
        List<String> orderNos = respDtoList.stream().map(DgAfterSaleOrderRespDto::getAfterSaleOrderNo).distinct().collect(Collectors.toList());
        Map<String, String> accountingMap = this.accountingService.getAccountingOrderNos(orderNos);
        respDtoList.forEach(v -> {
            if (accountingMap.containsKey(v.getAfterSaleOrderNo() + "-" + VoucherTypeEnum.DELIVERY.getCode())) {
                v.setAfterDeliveryAccounting(null != accountingMap.get(v.getAfterSaleOrderNo() + "-" + VoucherTypeEnum.DELIVERY.getCode()) ? "ACCOUNTED" : "UNACCOUNTED");
            }
            if (accountingMap.containsKey(v.getAfterSaleOrderNo() + "-" + VoucherTypeEnum.INVOICE.getCode())) {
                v.setAfterBillingAccounting(null != accountingMap.get(v.getAfterSaleOrderNo() + "-" + VoucherTypeEnum.INVOICE.getCode()) ? "ACCOUNTED" : "UNACCOUNTED");
            }
        });
    }
}

