/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.DomesticInventoryReportConverter;
import com.yunxi.dg.base.center.report.convert.entity.DomesticInventoryWarehouseConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDomesticInventoryReportDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDomesticInventoryWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.item.ISerialCodeDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgVirtualWarehouseDomain;
import com.yunxi.dg.base.center.report.dto.entity.CodeAndNameDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticInventoryReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticInventoryReportJoinDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticInventoryReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticInventoryReportStorageDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticInventoryWarehouseDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuRelevantInfoDto;
import com.yunxi.dg.base.center.report.dto.entity.WarehouseCodeAndNameDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualWarehouseDto;
import com.yunxi.dg.base.center.report.eo.DomesticInventoryReportEo;
import com.yunxi.dg.base.center.report.eo.item.SerialCodeEo;
import com.yunxi.dg.base.center.report.service.entity.IDomesticInventoryReportService;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import com.yunxi.dg.base.poi.dto.ExportFileParams;
import com.yunxi.dg.base.poi.dto.ExportSolFileParams;
import com.yunxi.dg.base.poi.service.FileOperationCommonService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DomesticInventoryReportServiceImpl
extends BaseServiceImpl<DomesticInventoryReportDto, DomesticInventoryReportEo, IDomesticInventoryReportDomain>
implements IDomesticInventoryReportService {
    private static final Logger log = LoggerFactory.getLogger(DomesticInventoryReportServiceImpl.class);
    @Resource
    private IDgVirtualWarehouseDomain virtualWarehouseDomain;
    @Resource
    private IDomesticInventoryWarehouseDomain domesticInventoryWarehouseDomain;
    @Resource
    private FileOperationCommonService fileOperationCommonService;
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private ISerialCodeDomain serialCodeDomain;

    public DomesticInventoryReportServiceImpl(IDomesticInventoryReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DomesticInventoryReportDto, DomesticInventoryReportEo> converter() {
        return DomesticInventoryReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> ((IDomesticInventoryReportDomain)this.domain).getSourceMinUpdateTime());
        dto.setStartTime(dto.getStartTime().withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0));
        dto.setEndTime(dto.getEndTime().toLocalDate().withDayOfMonth(1).plusMonths(1L).atStartOfDay());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        log.info("\u65f6\u95f4\u8303\u56f4\u53c2\u6570\u8c03\u6574\u4e3a: {} - {}", (Object)dto.getStartTime().format(formatter), (Object)dto.getEndTime().format(formatter));
        dto.syncByMonth("\u56fd\u5185\u5e93\u5b58\u62a5\u8868", this::doSyncInternal);
    }

    private void doSyncInternal(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate periodStartDate = startTime.toLocalDate();
        LocalDate periodEndDate = periodStartDate.plusMonths(1L).plusDays(-1L);
        periodEndDate = periodEndDate.isAfter(LocalDate.now()) ? LocalDate.now() : periodEndDate;
        int pageNum = 1;
        int pageSize = 1000;
        ArrayList<DomesticInventoryReportJoinDto> all = new ArrayList<DomesticInventoryReportJoinDto>();
        do {
            endTime = endTime.isBefore(periodEndDate.atStartOfDay()) ? endTime : periodEndDate.atStartOfDay();
            PageInfo page = ((IDomesticInventoryReportDomain)this.domain).pageSourceByChangeTime(startTime, endTime, periodStartDate, periodEndDate, pageNum, pageSize);
            log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u540c\u6b65: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(formatter), endTime.format(formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            if (list == null || list.isEmpty()) continue;
            all.addAll(list);
        } while (hasNextPage);
        this.process_sh_virtual_inventory_snapshot(all, periodStartDate, periodEndDate);
        this.process_sh_dg_virtual_warehouse(all);
        this.process_it_item_sku_dg(all);
        this.process_it_serial_code(all);
        Map<String, List<DomesticInventoryReportJoinDto>> group = all.stream().collect(Collectors.groupingBy(item -> item.getBizMonth() + "__" + item.getSkuCode()));
        ArrayList<DomesticInventoryReportDto> result = new ArrayList<DomesticInventoryReportDto>();
        group.forEach((key, values) -> {
            DomesticInventoryReportJoinDto one = (DomesticInventoryReportJoinDto)values.get(0);
            DomesticInventoryReportDto report = new DomesticInventoryReportDto();
            BeanUtils.copyProperties((Object)one, (Object)report);
            List warehouses = values.stream().map(w -> {
                DomesticInventoryWarehouseDto warehouse = new DomesticInventoryWarehouseDto();
                BeanUtils.copyProperties((Object)w, (Object)warehouse);
                BigDecimal storageAmt = Optional.ofNullable(w.getRetailPrice()).orElse(BigDecimal.ZERO).multiply(w.getEndStorageQty());
                warehouse.setStorageAmt(storageAmt);
                return warehouse;
            }).collect(Collectors.toList());
            report.setWarehouses(warehouses);
            result.add(report);
        });
        this.saveAll(result);
    }

    private void process_sh_virtual_inventory_snapshot(List<DomesticInventoryReportJoinDto> all, LocalDate periodStartDate, LocalDate periodEndDate) {
        HashSet warehouseCodes = new HashSet();
        HashSet skuCodes = new HashSet();
        all.forEach(join -> {
            warehouseCodes.add(join.getWarehouseCode());
            skuCodes.add(join.getSkuCode());
        });
        List storages = ((IDomesticInventoryReportDomain)this.domain).getByPeriods(warehouseCodes, skuCodes, periodStartDate, periodEndDate);
        Map<String, List<DomesticInventoryReportStorageDto>> group = storages.stream().collect(Collectors.groupingBy(k -> k.getWarehouseCode() + "___" + k.getSkuCode()));
        HashMap map = new HashMap();
        group.forEach((key, values) -> {
            BigDecimal openingStorageQty = values.stream().filter(k -> k.getDate().equals(periodStartDate)).findFirst().map(DomesticInventoryReportStorageDto::getBalance).orElse(BigDecimal.ZERO);
            DomesticInventoryReportStorageDto s = values.stream().filter(k -> k.getDate().equals(periodEndDate)).max(Comparator.comparing(DomesticInventoryReportStorageDto::getId)).orElse(null);
            BigDecimal readyOutStorageQty = s == null ? BigDecimal.ZERO : s.getPreempt();
            BigDecimal endStorageQty = s == null ? BigDecimal.ZERO : s.getBalance();
            map.put(key, DomesticInventoryReportStorageDto.builder().openingStorageQty(openingStorageQty).readyOutStorageQty(readyOutStorageQty).endStorageQty(endStorageQty).build());
        });
        all.forEach(join -> {
            DomesticInventoryReportStorageDto storage = (DomesticInventoryReportStorageDto)map.get(join.getWarehouseCode() + "___" + join.getSkuCode());
            if (storage == null) {
                return;
            }
            join.setOpeningStorageQty(storage.getOpeningStorageQty());
            join.setReadyOutStorageQty(storage.getReadyOutStorageQty());
            join.setEndStorageQty(storage.getEndStorageQty());
        });
    }

    private void process_sh_dg_virtual_warehouse(List<DomesticInventoryReportJoinDto> list) {
        List warehouseCodes = list.stream().map(DomesticInventoryReportJoinDto::getWarehouseCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List ws = this.virtualWarehouseDomain.selectByCodes(warehouseCodes);
        List<String> orgCodes = ws.stream().map(DgVirtualWarehouseDto::getOrganizationCode).distinct().collect(Collectors.toList());
        Map<String, CodeAndNameDto> orgCodeNameMap = this.getOrgCodeNameMap(orgCodes);
        Map<String, DgVirtualWarehouseDto> map = ws.stream().collect(Collectors.toMap(DgVirtualWarehouseDto::getWarehouseCode, v -> v));
        list.forEach(join -> {
            DgVirtualWarehouseDto eo = (DgVirtualWarehouseDto)map.get(join.getWarehouseCode());
            if (eo == null) {
                return;
            }
            join.setWarehouseName(eo.getWarehouseName());
            CodeAndNameDto dto = (CodeAndNameDto)orgCodeNameMap.get(eo.getOrganizationCode());
            if (dto != null) {
                join.setSalesChannelCode(dto.getCode());
                join.setSalesChannelName(dto.getName());
            }
        });
    }

    private Map<String, CodeAndNameDto> getOrgCodeNameMap(List<String> orgCodes) {
        List list = ((IDomesticInventoryReportDomain)this.domain).getSalesChannelCodeName(orgCodes);
        return list.stream().collect(Collectors.toMap(CodeAndNameDto::getOtherKey, v -> v, (a, b) -> b));
    }

    private void process_it_item_sku_dg(List<DomesticInventoryReportJoinDto> list) {
        Set<String> skuCodes = list.stream().map(DomesticInventoryReportDto::getSkuCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (skuCodes.isEmpty()) {
            return;
        }
        Map<String, SkuRelevantInfoDto> skuMap = this.itemSkuDgService.querySkuRelevantInfoMap(skuCodes);
        list.forEach(join -> {
            SkuRelevantInfoDto sku = (SkuRelevantInfoDto)skuMap.get(join.getSkuCode());
            if (sku == null) {
                return;
            }
            join.setSkuName(sku.getSkuName());
            join.setEliminate(sku.getEliminate());
            join.setSerialCode(sku.getSerialCode());
            join.setDepartmentCode(sku.getDepartmentCode());
            join.setDepartmentName(sku.getDepartmentName());
            join.setSkuIpCode(sku.getItemIpCode());
            join.setSkuIpName(sku.getItemIpName());
            join.setItemClassCode(sku.getItemClassCode());
            join.setItemClassName(sku.getItemClassName());
            join.setPackageNum(sku.getPackageNum());
            join.setRetailPrice(sku.getFactoryPrice());
            join.setSerialId(sku.getSerialId());
        });
    }

    private void process_it_serial_code(List<DomesticInventoryReportJoinDto> list) {
        List serialIds = list.stream().map(DomesticInventoryReportJoinDto::getSerialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (serialIds.isEmpty()) {
            return;
        }
        List serials = this.serialCodeDomain.selectByIds(serialIds);
        Map<Long, SerialCodeEo> skuMap = serials.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        list.forEach(join -> {
            SerialCodeEo serial = (SerialCodeEo)skuMap.get(join.getSerialId());
            if (serial == null) {
                return;
            }
            join.setSerialName(serial.getName());
        });
    }

    private void saveAll(List<DomesticInventoryReportDto> list) {
        List bizMonths = list.stream().map(DomesticInventoryReportDto::getBizMonth).distinct().collect(Collectors.toList());
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e {}", bizMonths);
        ((IDomesticInventoryReportDomain)this.domain).physicsDeleteByBizMonth(bizMonths);
        this.domesticInventoryWarehouseDomain.physicsDeleteByBizMonths(bizMonths);
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e\u5b8c\u6210");
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e", (Object)list.size());
        ArrayList<BaseEo> reports = new ArrayList<BaseEo>();
        ArrayList<BaseEo> warehouses = new ArrayList<BaseEo>();
        for (DomesticInventoryReportDto dto : list) {
            reports.add(this.converter().toEo((BaseDto)dto));
            for (DomesticInventoryWarehouseDto warehouse : dto.getWarehouses()) {
                warehouses.add(DomesticInventoryWarehouseConverter.INSTANCE.toEo((BaseDto)warehouse));
            }
        }
        ((IDomesticInventoryReportDomain)this.domain).insertBatch(reports);
        this.domesticInventoryWarehouseDomain.insertBatch(warehouses);
        log.info("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
    }

    @Override
    public PageInfo<DomesticInventoryReportDto> page(DomesticInventoryReportPageReqDto dto) {
        PageInfo<DomesticInventoryReportDto> page = this.pageWithoutAlign(dto);
        this.alignWarehouses(dto.getWarehouseCodes(), page.getList());
        return page;
    }

    @Override
    public PageInfo<DomesticInventoryReportDto> pageWithoutAlign(DomesticInventoryReportPageReqDto dto) {
        PageInfo page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((IDomesticInventoryReportDomain)this.domain).queryList(dto));
        List list = page.getList();
        List bizMonths = list.stream().map(DomesticInventoryReportDto::getBizMonth).distinct().collect(Collectors.toList());
        List warehouses = DomesticInventoryWarehouseConverter.INSTANCE.toDtoList(this.domesticInventoryWarehouseDomain.queryByBizMonths(bizMonths));
        Map<String, List<DomesticInventoryWarehouseDto>> group = warehouses.stream().collect(Collectors.groupingBy(k -> k.getBizMonth() + "__" + k.getSkuCode()));
        list.forEach(report -> {
            List reportWarehouses = group.getOrDefault(report.getBizMonth() + "__" + report.getSkuCode(), new ArrayList(0));
            report.setWarehouses(reportWarehouses);
        });
        return page;
    }

    @Override
    public void alignWarehouses(Set<String> warehouseCodes, List<DomesticInventoryReportDto> list) {
        List<WarehouseCodeAndNameDto> warehouses = this.processWarehouses(warehouseCodes, list);
        list.forEach(report -> {
            List ws = Optional.ofNullable(report.getWarehouses()).orElse(Collections.emptyList());
            Map<String, DomesticInventoryWarehouseDto> map = ws.stream().collect(Collectors.toMap(DomesticInventoryWarehouseDto::getWarehouseCode, v -> v));
            ArrayList salesChannelCodes = new ArrayList();
            ArrayList salesChannelNames = new ArrayList();
            List rs = warehouses.stream().map(k -> {
                DomesticInventoryWarehouseDto w = (DomesticInventoryWarehouseDto)map.get(k.getWarehouseCode());
                if (w != null) {
                    return w;
                }
                w = new DomesticInventoryWarehouseDto();
                w.setBizMonth(report.getBizMonth());
                w.setSkuCode(report.getSkuCode());
                w.setSkuName(report.getSkuName());
                w.setWarehouseCode(k.getWarehouseCode());
                w.setWarehouseName(k.getWarehouseName());
                w.setSalesChannelCode(k.getSalesChannelCode());
                w.setSalesChannelName(k.getSalesChannelName());
                return w;
            }).peek(k -> {
                if (k.getSalesChannelCode() != null && !salesChannelCodes.contains(k.getSalesChannelCode())) {
                    salesChannelCodes.add(k.getSalesChannelCode());
                }
                if (k.getSalesChannelName() != null && !salesChannelNames.contains(k.getSalesChannelName())) {
                    salesChannelNames.add(k.getSalesChannelName());
                }
            }).collect(Collectors.toList());
            report.setSalesChannelCode(String.join((CharSequence)",", salesChannelCodes));
            report.setSalesChannelName(String.join((CharSequence)",", salesChannelNames));
            report.setWarehouses(rs);
        });
    }

    private List<WarehouseCodeAndNameDto> processWarehouses(Set<String> warehouseCodes, List<DomesticInventoryReportDto> list) {
        if (warehouseCodes != null && !warehouseCodes.isEmpty()) {
            List ws = this.virtualWarehouseDomain.selectByCodes(new ArrayList<String>(warehouseCodes));
            List<String> orgCodes = ws.stream().map(DgVirtualWarehouseDto::getOrganizationCode).distinct().collect(Collectors.toList());
            Map<String, CodeAndNameDto> orgCodeNameMap = this.getOrgCodeNameMap(orgCodes);
            return ws.stream().map(k -> {
                CodeAndNameDto dto = (CodeAndNameDto)orgCodeNameMap.get(k.getOrganizationCode());
                return WarehouseCodeAndNameDto.builder().warehouseCode(k.getWarehouseCode()).warehouseName(k.getWarehouseName()).salesChannelCode(dto != null ? dto.getCode() : null).salesChannelName(dto != null ? dto.getName() : null).build();
            }).distinct().sorted(Comparator.comparing(WarehouseCodeAndNameDto::getWarehouseCode)).collect(Collectors.toList());
        }
        return list.stream().flatMap(k -> Optional.ofNullable(k.getWarehouses()).orElse(Collections.emptyList()).stream()).map(k -> WarehouseCodeAndNameDto.builder().warehouseCode(k.getWarehouseCode()).warehouseName(k.getWarehouseName()).salesChannelCode(k.getSalesChannelCode()).salesChannelName(k.getSalesChannelName()).build()).distinct().sorted(Comparator.comparing(WarehouseCodeAndNameDto::getWarehouseCode)).collect(Collectors.toList());
    }

    @Override
    public void export(DomesticInventoryReportPageReqDto dto) {
        ExportSolFileParams params = new ExportSolFileParams();
        params.setKey("domestic_inventory_report");
        params.setFilter(JacksonUtil.toJson((Object)dto));
        params.setMenuModuleName("\u56fd\u5185\u5e93\u5b58\u62a5\u8868");
        params.setExportFunctionName("\u56fd\u5185\u5e93\u5b58\u62a5\u8868\u5bfc\u51fa");
        this.fileOperationCommonService.exportFileOperationCommonAsync((ExportFileParams)params);
    }

    @Override
    public String getLastBizMonth() {
        return ((IDomesticInventoryReportDomain)this.domain).getLastBizMonth();
    }
}

