/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.expense.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.expense.IBudgetAdjustDomain;
import com.yunxi.dg.base.center.report.domain.item.IBrandDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IDirDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemDgDomain;
import com.yunxi.dg.base.center.report.domain.user.IUsOrganizationDomain;
import com.yunxi.dg.base.center.report.dto.expense.BudgetAdjustPageReqDto;
import com.yunxi.dg.base.center.report.dto.expense.BudgetAdjustRespDto;
import com.yunxi.dg.base.center.report.dto.expense.constant.AdjustmentTypeEnum;
import com.yunxi.dg.base.center.report.dto.expense.constant.BudgetAdjustStatusEnum;
import com.yunxi.dg.base.center.report.dto.expense.constant.BudgetTypeEnum;
import com.yunxi.dg.base.center.report.dto.expense.constant.FiscalPeriodEnum;
import com.yunxi.dg.base.center.report.eo.ItemDgEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.center.report.eo.item.BrandDgEo;
import com.yunxi.dg.base.center.report.eo.item.DirDgEo;
import com.yunxi.dg.base.center.report.eo.user.OrganizationEo;
import com.yunxi.dg.base.center.report.service.expense.BudgetUtils;
import com.yunxi.dg.base.center.report.service.expense.IBudgetAdjustService;
import com.yunxi.dg.base.center.report.utils.MyDateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BudgetAdjustServiceImpl
implements IBudgetAdjustService {
    private static final Logger log = LoggerFactory.getLogger(BudgetAdjustServiceImpl.class);
    @Resource
    private IBudgetAdjustDomain budgetAdjustDomain;
    @Resource
    private IUsOrganizationDomain organizationDomain;
    @Resource
    private IDgCustomerDomain dgCustomerDomain;
    @Resource
    private IBrandDgDomain brandDgDomain;
    @Resource
    private IDirDgDomain dirDgDomain;
    @Resource
    private IItemDgDomain itemDgDomain;

    @Override
    public PageInfo<BudgetAdjustRespDto> page(BudgetAdjustPageReqDto dto) {
        PageInfo pageInfo;
        List list;
        if (Objects.nonNull(dto.getToDt())) {
            dto.setToDt(MyDateUtil.getLastTimeOfDate(dto.getToDt()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = (pageInfo = this.budgetAdjustDomain.queryPage(dto)).getList()))) {
            this.dealAdjustListInfo(list);
        }
        return pageInfo;
    }

    @Override
    public BudgetAdjustRespDto get(Long id) {
        List refBudgetAdjustRespDtos;
        List budgetAdjustRespDtos = this.budgetAdjustDomain.queryDtoByIds((List)Lists.newArrayList((Object[])new Long[]{id}));
        if (CollectionUtils.isEmpty((Collection)budgetAdjustRespDtos)) {
            throw new BizException("\u9884\u7b97\u8c03\u6574ID\u4e0d\u6b63\u786e\uff0c\u627e\u4e0d\u5230\u8bb0\u5f55");
        }
        BudgetAdjustRespDto budgetAdjustRespDto = (BudgetAdjustRespDto)budgetAdjustRespDtos.get(0);
        ArrayList budgetAdjustRespDtoList = Lists.newArrayList((Object[])new BudgetAdjustRespDto[]{budgetAdjustRespDto});
        if ((Objects.equals(budgetAdjustRespDto.getTypeId(), AdjustmentTypeEnum.ENTRY.getCode()) || Objects.equals(budgetAdjustRespDto.getTypeId(), AdjustmentTypeEnum.LAY_OFF.getCode())) && CollectionUtils.isNotEmpty((Collection)(refBudgetAdjustRespDtos = this.budgetAdjustDomain.queryDtoByReferenceId(budgetAdjustRespDto.getId())))) {
            budgetAdjustRespDtoList.addAll(refBudgetAdjustRespDtos);
            budgetAdjustRespDto.setReferenceAdjustBudgets(refBudgetAdjustRespDtos);
        }
        this.dealAdjustListInfo(budgetAdjustRespDtoList);
        return budgetAdjustRespDto;
    }

    private void dealAdjustListInfo(List<BudgetAdjustRespDto> list) {
        Map<Integer, List<BudgetAdjustRespDto>> map = list.stream().collect(Collectors.groupingBy(BudgetAdjustRespDto::getBudgetType));
        for (Map.Entry<Integer, List<BudgetAdjustRespDto>> entry : map.entrySet()) {
            Integer budgetType = entry.getKey();
            List<BudgetAdjustRespDto> budgetRespDtos = entry.getValue();
            List<Long> objectIds = budgetRespDtos.stream().map(BudgetAdjustRespDto::getObjectId).distinct().collect(Collectors.toList());
            this.setObjectInfo(budgetRespDtos, objectIds, budgetType);
        }
        list.forEach(adjustRespDto -> {
            adjustRespDto.setBudgetTypeName(BudgetTypeEnum.getDesc((Integer)adjustRespDto.getBudgetType()));
            adjustRespDto.setTypeIdName(AdjustmentTypeEnum.getDesc((Long)adjustRespDto.getTypeId()));
            adjustRespDto.setStatusName(BudgetAdjustStatusEnum.getDesc((Integer)adjustRespDto.getStatus()));
            if (Objects.nonNull(adjustRespDto.getFiscalYear())) {
                StringBuilder sb = new StringBuilder();
                sb.append(adjustRespDto.getFiscalYear());
                if (Objects.equals(FiscalPeriodEnum.QUARTER.getCode(), adjustRespDto.getPeriod())) {
                    sb.append("/").append(BudgetUtils.getQuarterStrByQuarter(adjustRespDto.getPeriodNo()));
                }
                if (Objects.equals(FiscalPeriodEnum.MONTH.getCode(), adjustRespDto.getPeriod())) {
                    sb.append("/").append(BudgetUtils.getQuarterStrByMonth(adjustRespDto.getPeriodNo()));
                    sb.append("/").append(adjustRespDto.getPeriodNo()).append("\u6708");
                }
                adjustRespDto.setPeriodName(sb.toString());
            }
        });
    }

    private void setObjectInfo(List<BudgetAdjustRespDto> budgetAdjustRespDtos, List<Long> objectIds, Integer budgetType) {
        if (Objects.equals(BudgetTypeEnum.SEAL_ORG.getCode(), budgetType)) {
            List organizationEos = ((ExtQueryChainWrapper)this.organizationDomain.filter().in((Object)"id", objectIds)).list();
            Map eoMap = organizationEos.stream().collect(Collectors.toMap(OrganizationEo::getId, Function.identity()));
            budgetAdjustRespDtos.forEach(adjustRespDto -> {
                OrganizationEo organizationEo = (OrganizationEo)eoMap.get(adjustRespDto.getObjectId());
                if (Objects.nonNull(organizationEo)) {
                    adjustRespDto.setObjectCode(organizationEo.getCode());
                    adjustRespDto.setObjectName(organizationEo.getName());
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.CUSTOMER.getCode(), budgetType)) {
            List customerEos = ((ExtQueryChainWrapper)this.dgCustomerDomain.filter().in((Object)"id", objectIds)).list();
            Map eoMap = customerEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            budgetAdjustRespDtos.forEach(adjustRespDto -> {
                DgCustomerEo customerEo = (DgCustomerEo)eoMap.get(adjustRespDto.getObjectId());
                if (Objects.nonNull(customerEo)) {
                    adjustRespDto.setObjectCode(customerEo.getCode());
                    adjustRespDto.setObjectName(customerEo.getName());
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.BRAND.getCode(), budgetType)) {
            List brandEos = ((ExtQueryChainWrapper)this.brandDgDomain.filter().in((Object)"id", objectIds)).list();
            Map eoMap = brandEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            budgetAdjustRespDtos.forEach(adjustRespDto -> {
                BrandDgEo brandDgEo = (BrandDgEo)eoMap.get(adjustRespDto.getObjectId());
                if (Objects.nonNull(brandDgEo)) {
                    adjustRespDto.setObjectCode(brandDgEo.getCode());
                    adjustRespDto.setObjectName(brandDgEo.getName());
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.DIR.getCode(), budgetType)) {
            List dirEos = ((ExtQueryChainWrapper)this.dirDgDomain.filter().in((Object)"id", objectIds)).list();
            Map eoMap = dirEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            budgetAdjustRespDtos.forEach(adjustRespDto -> {
                DirDgEo dirDgEo = (DirDgEo)eoMap.get(adjustRespDto.getObjectId());
                if (Objects.nonNull(dirDgEo)) {
                    adjustRespDto.setObjectCode(dirDgEo.getCode());
                    adjustRespDto.setObjectName(dirDgEo.getName());
                }
            });
        } else if (Objects.equals(BudgetTypeEnum.ITEM.getCode(), budgetType)) {
            List itemEos = ((ExtQueryChainWrapper)this.itemDgDomain.filter().in((Object)"id", objectIds)).list();
            Map eoMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            budgetAdjustRespDtos.forEach(adjustRespDto -> {
                ItemDgEo itemDgEo = (ItemDgEo)eoMap.get(adjustRespDto.getObjectId());
                if (Objects.nonNull(itemDgEo)) {
                    adjustRespDto.setObjectCode(itemDgEo.getCode());
                    adjustRespDto.setObjectName(itemDgEo.getName());
                }
            });
        }
    }
}

