/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.expense.impl;

import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.expense.IBudgetDomain;
import com.yunxi.dg.base.center.report.dto.expense.BudgetPageReqDto;
import com.yunxi.dg.base.center.report.dto.expense.BudgetRelationNameDto;
import com.yunxi.dg.base.center.report.dto.expense.BudgetRespDto;
import com.yunxi.dg.base.center.report.dto.expense.constant.BudgetTypeEnum;
import com.yunxi.dg.base.center.report.dto.expense.constant.FiscalPeriodEnum;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerAreaEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.center.report.service.expense.BudgetUtils;
import com.yunxi.dg.base.center.report.service.expense.IBudgetService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class BudgetServiceImpl
implements IBudgetService {
    @Resource
    private IBudgetDomain budgetDomain;
    @Resource
    private BudgetUtils budgetUtils;
    @Resource
    private IContext context;
    @Resource
    private IDgCustomerDomain customerDomain;
    @Resource
    private IDgCustomerAreaDomain dgCustomerAreaDomain;

    @Override
    public PageInfo<BudgetRespDto> page(BudgetPageReqDto dto) {
        PageInfo pageInfo;
        List budgetRespDtoList;
        if (Objects.equals(dto.getSelfCreate(), 1)) {
            dto.setCreatePerson(this.context.userName());
        }
        if (CollectionUtils.isNotEmpty((Collection)(budgetRespDtoList = (pageInfo = this.budgetDomain.queryPage(dto)).getList()))) {
            budgetRespDtoList.forEach(adjustRespDto -> {
                adjustRespDto.setBudgetTypeName(BudgetTypeEnum.getDesc((Integer)adjustRespDto.getBudgetType()));
                if (Objects.nonNull(adjustRespDto.getFiscalYear())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(adjustRespDto.getFiscalYear());
                    if (Objects.equals(FiscalPeriodEnum.QUARTER.getCode(), adjustRespDto.getPeriod())) {
                        sb.append("/").append(BudgetUtils.getQuarterStrByQuarter(adjustRespDto.getPeriodNo()));
                    }
                    if (Objects.equals(FiscalPeriodEnum.MONTH.getCode(), adjustRespDto.getPeriod())) {
                        sb.append("/").append(BudgetUtils.getQuarterStrByMonth(adjustRespDto.getPeriodNo()));
                        sb.append("/").append(adjustRespDto.getPeriodNo()).append("\u6708");
                    }
                    adjustRespDto.setPeriodName(sb.toString());
                }
            });
            ArrayList list = Lists.newArrayList();
            list.addAll(budgetRespDtoList);
            this.budgetUtils.dealObjectName(list);
        }
        return pageInfo;
    }

    @Override
    public BudgetRelationNameDto queryRelationName(BudgetRelationNameDto dto) {
        DgCustomerAreaEo areaEo;
        dto.setFiscalYearName(this.budgetDomain.queryFiscalYearNameById(dto.getFiscalYearId()));
        dto.setBudgetSubjectName(this.budgetDomain.querySubjectNameById(dto.getBudgetSubjectId()));
        dto.setBudgetTypeName(BudgetTypeEnum.getDesc((Integer)dto.getBudgetTypeId()));
        String objectName = "";
        if (Objects.equals(dto.getBudgetTypeId(), BudgetTypeEnum.CUSTOMER.getCode())) {
            DgCustomerEo customerEo = (DgCustomerEo)this.customerDomain.selectByPrimaryKey(dto.getBudgetObjectId());
            if (customerEo != null) {
                objectName = customerEo.getName();
            }
        } else if (Objects.equals(dto.getBudgetTypeId(), BudgetTypeEnum.CUSTOMER_CATEGORY.getCode()) && (areaEo = (DgCustomerAreaEo)this.dgCustomerAreaDomain.selectByPrimaryKey(dto.getBudgetObjectId())) != null) {
            objectName = areaEo.getName();
        }
        dto.setBudgetObjectName(objectName);
        return dto;
    }
}

