/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.agg;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.report.dao.mapper.DgInDeliveryNoticeOrderSnapshotMapper;
import com.yunxi.dg.base.center.report.dao.mapper.agg.DgHomePageMapper;
import com.yunxi.dg.base.center.report.domain.es.IEsPerformOrderDomain;
import com.yunxi.dg.base.center.report.dto.agg.DgHomeInventoryStatusReqDto;
import com.yunxi.dg.base.center.report.dto.agg.DgHomeInventoryStatusRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgHomePageDataCountRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgHomePageWarehouseThresholdReqDto;
import com.yunxi.dg.base.center.report.dto.agg.DgHomePageWarehouseThresholdRespDto;
import com.yunxi.dg.base.center.report.dto.trade.req.DgEsPerformOrderReqDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgEsPerformOrderStatusCountRespDto;
import com.yunxi.dg.base.center.report.service.agg.IDgHomePageService;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DgHomePageServiceImpl
implements IDgHomePageService {
    @Resource
    private DgHomePageMapper mapper;
    @Resource
    private IEsPerformOrderDomain esPerformOrderDomain;
    @Resource
    DgInDeliveryNoticeOrderSnapshotMapper dgInDeliveryNoticeOrderSnapshotMapper;

    @Override
    public RestResponse<DgHomePageDataCountRespDto> getPreviewDataCount() {
        DgHomePageDataCountRespDto respDto = Optional.ofNullable(this.mapper.getAfterSaleOrderCount()).orElse(new DgHomePageDataCountRespDto());
        respDto.setRefundAndWaitReturnTotal(this.mapper.getRefundAndWaitReturnCount());
        respDto.setExchangeAndWaitReturnTotal(this.mapper.getExchangeAndWaitReturnCount());
        DgEsPerformOrderReqDto filter = new DgEsPerformOrderReqDto();
        DgEsPerformOrderStatusCountRespDto countRespDto = this.esPerformOrderDomain.queryCount(filter);
        if (countRespDto == null) {
            return new RestResponse((Object)respDto);
        }
        respDto.setWaitAuditOrderTotal(countRespDto.getWaitAuditCount());
        respDto.setWaitPickOrderTotal(countRespDto.getWaitPickCount());
        respDto.setLackOrderTotal(countRespDto.getLackCount());
        respDto.setWaitDeliveryOrderTotal(countRespDto.getWaitDeliveryCount());
        respDto.setUnusualOrderTotal(countRespDto.getAbnormalCount());
        respDto.setInterceptBeforeDeliveryTotal(countRespDto.getInterceptBeforeDeliveryCount());
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<List<DgHomeInventoryStatusRespDto>> getInventoryStatusByWarehouseCodes(DgHomeInventoryStatusReqDto dto) {
        List initList = this.mapper.getInventoryStatusByWarehouseCodes(dto);
        if (CollectionUtils.isEmpty((Collection)initList)) {
            return new RestResponse(new ArrayList());
        }
        List tags = Optional.ofNullable(this.mapper.getAllTags()).orElse(new ArrayList());
        ArrayList<DgHomeInventoryStatusRespDto> dataList = new ArrayList<DgHomeInventoryStatusRespDto>();
        Map<String, List<DgHomeInventoryStatusRespDto>> warehouseMap = initList.stream().collect(Collectors.groupingBy(o -> o.getWarehouseCode() + "@" + o.getWarehouseName()));
        for (String mapKey : warehouseMap.keySet()) {
            String[] warehouseCodeAndName = mapKey.split("@");
            DgHomeInventoryStatusRespDto item = new DgHomeInventoryStatusRespDto();
            item.setWarehouseCode(warehouseCodeAndName[0]);
            item.setWarehouseName(warehouseCodeAndName[1]);
            List listOfTtem = tags;
            List<DgHomeInventoryStatusRespDto> tagInventoryCountList = warehouseMap.get(mapKey);
            Map<String, List<DgHomeInventoryStatusRespDto>> tagMap = tagInventoryCountList.stream().collect(Collectors.groupingBy(DgHomeInventoryStatusRespDto::getTagCode));
            listOfTtem.forEach(tag -> {
                if (tagMap.containsKey(tag.getTagCode())) {
                    tag.setInventoryTotal(((DgHomeInventoryStatusRespDto)((List)tagMap.get(tag.getTagCode())).get(0)).getInventoryTotal());
                }
            });
            item.setInventoryStatusTags(listOfTtem);
            dataList.add(item);
        }
        return new RestResponse(dataList);
    }

    @Override
    public RestResponse<List<DgHomePageWarehouseThresholdRespDto>> getDeliveryThresholdValueByWarehouseCodes(DgHomePageWarehouseThresholdReqDto dto) {
        List respDtos = this.mapper.queryWarehouseOutCountOnToDay(dto);
        if (CollectionUtils.isEmpty((Collection)respDtos)) {
            return new RestResponse(new ArrayList());
        }
        respDtos.forEach(o -> {
            o.setSurplusQuantity(o.getThreshold().subtract(o.getOutQuantityOnDay()));
            o.setThresholdPercentage(o.getSurplusQuantity().divide(o.getThreshold(), 2, RoundingMode.HALF_UP));
        });
        return new RestResponse((Object)respDtos);
    }
}

