/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.agg;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.constants.IsFlagEnum;
import com.yunxi.dg.base.center.report.dao.mapper.OrderUnitConversionRecordMapper;
import com.yunxi.dg.base.center.report.dao.mapper.agg.DgBasisOrderRelOrderInfoMapper;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderLogisticsWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.report.domain.entity.IOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutNoticeOrderDomain;
import com.yunxi.dg.base.center.report.dto.agg.DgDeliveryOutPageDto;
import com.yunxi.dg.base.center.report.dto.agg.DgDeliveryOutRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgInventoryBillGoodsDto;
import com.yunxi.dg.base.center.report.dto.agg.DgInventoryBillGoodsReqDto;
import com.yunxi.dg.base.center.report.dto.agg.DgReceiveInPageDto;
import com.yunxi.dg.base.center.report.dto.agg.DgReceiveInRespDto;
import com.yunxi.dg.base.center.report.enums.DgDocumentTypeEnum;
import com.yunxi.dg.base.center.report.enums.DgLogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.report.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.report.eo.OutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderLogisticsWarehouseEo;
import com.yunxi.dg.base.center.report.service.agg.IDgWarehouseOperationService;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.impl.inventory.utils.UnitConverUtils;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.dataLimit.annotations.DataLimitSelector;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgWarehouseOperationServiceImpl
implements IDgWarehouseOperationService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgWarehouseOperationServiceImpl.class);
    String deliveryOutTableName = "delivery_out_order";
    String receiveInTableName = "receive_in_order";
    private static final String[] ORDER_NOS = new String[]{"documentNo", "relevanceNo", "externalOrderNo"};
    @Resource
    private IDgOutNoticeOrderDomain iDgOutNoticeOrderDomain;
    @Resource
    private DgBasisOrderRelOrderInfoMapper dgBasisOrderRelOrderInfoMapper;
    @Resource
    private OrderUnitConversionRecordMapper orderUnitConversionRecordMapper;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Value(value="${yunxi.dg.base.inventory.hidden.batch.enable:false}")
    private Boolean preemptHiddenBatch;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Autowired
    private IDgAfterSaleOrderLogisticsWarehouseDomain dgAfterSaleOrderLogisticsWarehouseDomain;
    @Autowired
    private IOutNoticeOrderDetailDomain outNoticeOrderDetailDomain;

    @Override
    @DataLimitSelector(tableName="cs_out_notice_order")
    public RestResponse<PageInfo<DgDeliveryOutRespDto>> deliveryOutPage(DgDeliveryOutPageDto deliveryOutPageDto) {
        PageInfo deliveryOutRespDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            deliveryOutRespDtoPageInfo = this.getDeliveryOutOrderEsList(deliveryOutPageDto);
        } else {
            PageHelper.startPage((int)deliveryOutPageDto.getPageNum(), (int)deliveryOutPageDto.getPageSize());
            deliveryOutRespDtoPageInfo = new PageInfo(this.dgBasisOrderRelOrderInfoMapper.queryDeliveryOut(deliveryOutPageDto));
        }
        return new RestResponse(deliveryOutRespDtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<DgReceiveInRespDto>> receiveInPage(DgReceiveInPageDto dgReceiveInPageDto) {
        PageInfo receiveInRespDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            this.decideTab(dgReceiveInPageDto);
            receiveInRespDtoPageInfo = this.getReceiveInOrderEsList(dgReceiveInPageDto);
        } else {
            List outNoticeOrderDetails;
            List dgAfterSaleOrderLogisticsWarehouseEoList;
            List afterSaleOrderNoList;
            List returnShippingSn = dgReceiveInPageDto.getCompoundOrderNoList();
            if (CollectionUtils.isNotEmpty((Collection)returnShippingSn) && CollectionUtils.isNotEmpty(afterSaleOrderNoList = (dgAfterSaleOrderLogisticsWarehouseEoList = ((ExtQueryChainWrapper)this.dgAfterSaleOrderLogisticsWarehouseDomain.filter().in((Object)"return_shipping_sn", (Collection)returnShippingSn)).list()).stream().map(DgAfterSaleOrderLogisticsWarehouseEo::getAfterSaleOrderNo).collect(Collectors.toList()))) {
                dgReceiveInPageDto.getCompoundOrderNoList().addAll(afterSaleOrderNoList);
            }
            PageHelper.startPage((int)dgReceiveInPageDto.getPageNum(), (int)dgReceiveInPageDto.getPageSize());
            List dgReceiveInRespDtoList = this.dgBasisOrderRelOrderInfoMapper.queryReceiveIn(dgReceiveInPageDto);
            List filterList = dgReceiveInRespDtoList.stream().filter(dgReceiveInRespDto -> "cs_order_after_sale".equals(dgReceiveInRespDto.getRelevanceTableName())).collect(Collectors.toList());
            List documentNos = dgReceiveInRespDtoList.stream().map(DgReceiveInRespDto::getDocumentNo).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(documentNos) && CollectionUtils.isNotEmpty((Collection)(outNoticeOrderDetails = ((ExtQueryChainWrapper)this.outNoticeOrderDetailDomain.filter().in((Object)"document_no", documentNos)).list()))) {
                Map<String, Map<String, BigDecimal>> orderSkuQuantityMap = outNoticeOrderDetails.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailEo::getDocumentNo, Collectors.groupingBy(OutNoticeOrderDetailEo::getSkuCode, Collectors.mapping(OutNoticeOrderDetailEo::getPlanQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))));
                Map orderSkuNameMap = outNoticeOrderDetails.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailEo::getDocumentNo, Collectors.mapping(OutNoticeOrderDetailEo::getSkuName, Collectors.toSet())));
                dgReceiveInRespDtoList.forEach(dgReceiveInRespDto -> {
                    Map skuQuantityMap = (Map)orderSkuQuantityMap.get(dgReceiveInRespDto.getDocumentNo());
                    Set skuNameSet = (Set)orderSkuNameMap.get(dgReceiveInRespDto.getDocumentNo());
                    if (MapUtils.isNotEmpty((Map)skuQuantityMap)) {
                        List skuQuantityStr = skuQuantityMap.entrySet().stream().map(entry -> {
                            BigDecimal value = ((BigDecimal)entry.getValue()).setScale(0, 1);
                            return (String)entry.getKey() + "*" + value.toString();
                        }).collect(Collectors.toList());
                        dgReceiveInRespDto.setItemExtInfo(StringUtils.join(skuQuantityStr, (String)";"));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)skuNameSet)) {
                        dgReceiveInRespDto.setItemInfo(StringUtils.join((Iterable)skuNameSet, (String)";"));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(filterList)) {
                List filterEos = ((ExtQueryChainWrapper)this.dgAfterSaleOrderLogisticsWarehouseDomain.filter().in((Object)"after_sale_order_no", (Collection)filterList.stream().map(DgReceiveInRespDto::getRelevanceNo).distinct().collect(Collectors.toList()))).list();
                Map filterMap = filterEos.stream().collect(Collectors.toMap(DgAfterSaleOrderLogisticsWarehouseEo::getAfterSaleOrderNo, Function.identity()));
                dgReceiveInRespDtoList.forEach(dgReceiveInRespDto -> {
                    DgAfterSaleOrderLogisticsWarehouseEo filterEo = (DgAfterSaleOrderLogisticsWarehouseEo)filterMap.get(dgReceiveInRespDto.getRelevanceNo());
                    if (filterEo != null) {
                        dgReceiveInRespDto.setReturnShippingCode(filterEo.getShippingCode());
                        dgReceiveInRespDto.setReturnShippingName(filterEo.getShippingName());
                        dgReceiveInRespDto.setReturnShippingSn(filterEo.getReturnShippingSn());
                    }
                });
            }
            receiveInRespDtoPageInfo = new PageInfo(dgReceiveInRespDtoList);
        }
        return new RestResponse(receiveInRespDtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<DgInventoryBillGoodsDto>> deliveryOutGoodsPage(DgInventoryBillGoodsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        dto.setTableName(DgDocumentTypeEnum.OUT_NOTICE_ORDER.getTableName());
        List inventoryBillGoodsDtoList = this.dgBasisOrderRelOrderInfoMapper.queryGoodByDocumentNo(dto);
        List relevanceNoList = inventoryBillGoodsDtoList.stream().map(DgInventoryBillGoodsDto::getRelevanceNo).collect(Collectors.toList());
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(relevanceNoList), (Object)"document_code", relevanceNoList)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode() + o.getToUnit(), Function.identity(), (o2, o1) -> o2));
        inventoryBillGoodsDtoList.forEach(o -> {
            o.setInventoryProperty(Optional.ofNullable(o.getInventoryProperty()).orElse(DgLogicWarehouseQualityEnum.QUALIFIED.getCode()));
            o.setPreemptHiddenBatch(this.preemptHiddenBatch);
        });
        inventoryBillGoodsDtoList.forEach(r -> r.setDocumentCode(r.getRelevanceNo()));
        UnitConverUtils.unitConvertBatch(inventoryBillGoodsDtoList);
        PageInfo dgInventoryBillGoodsDtoPageInfo = new PageInfo(inventoryBillGoodsDtoList);
        return new RestResponse((Object)dgInventoryBillGoodsDtoPageInfo);
    }

    private void unitConversion(DgInventoryBillGoodsDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        dto.setUnit(unitConversionEo.getUnit());
        BigDecimal rate = unitConversionEo.getNum().divide(unitConversionEo.getToNum(), 6, RoundingMode.HALF_UP);
        BigDecimal planQuantity = null != dto.getPlanQuantity() ? dto.getPlanQuantity().multiply(rate) : null;
        BigDecimal doneQuantity = null != dto.getDoneQuantity() ? dto.getDoneQuantity().multiply(rate) : null;
        BigDecimal waitQuantity = null != dto.getWaitQuantity() ? dto.getWaitQuantity().multiply(rate) : null;
        dto.setPlanQuantity(planQuantity);
        dto.setDoneQuantity(doneQuantity);
        dto.setWaitQuantity(waitQuantity);
    }

    private PageInfo<DgDeliveryOutRespDto> getDeliveryOutOrderEsList(DgDeliveryOutPageDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.deliveryOutTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgDeliveryOutRespDto orderItemPageDto = (DgDeliveryOutRespDto)BeanUtil.copyProperties((Object)docValue, DgDeliveryOutRespDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgDeliveryOutPageDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u53d1\u8d27\u51fa\u5e93\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        this.decideTab(reqDto, queryVo);
        if (CollectionUtils.isEmpty((Collection)reqDto.getCompoundOrderNoList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)o, (List)reqDto.getCompoundOrderNoList(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompoundOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getCompoundOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getWhetherRemark())) {
            if (IsFlagEnum.YES.getCode().equals(reqDto.getWhetherRemark().toString())) {
                queryVo.addExistsFilter("remark");
            } else {
                FilterFieldVo nonExistsFilter = FilterFieldVo.exists((String)"remark");
                nonExistsFilter.setNon(Boolean.valueOf(true));
                queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
            }
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u53d1\u8d27\u51fa\u5e93\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    private void decideTab(DgDeliveryOutPageDto reqDto, OSSearchVo queryVo) {
        if (ObjectUtil.isNotEmpty((Object)reqDto.getTypeStatus())) {
            if (ObjectUtil.equals((Object)1, (Object)reqDto.getTypeStatus())) {
                FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"sendStatus", (String)"dispense_with_send")});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"interconnectionFlag", (String)"0")});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"status", Arrays.asList("", "ono_wait_out", "ono_portion_out"))});
                FilterFieldVo filterOr = queryVo.createCompoundFilter(LogicalSymbol.OR);
                filterOr.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"sendStatus", (String)"send")});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"interconnectionFlag", (String)"0")});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"status", Arrays.asList("", "ono_wait_out", "ono_portion_out"))});
                queryVo.addFilters(new FilterFieldVo[]{filter, filterOr});
            } else if (ObjectUtil.equals((Object)2, (Object)reqDto.getTypeStatus())) {
                FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"sendStatus", Arrays.asList("dispense_with_send", "send"))});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"interconnectionFlag", (String)"0")});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"status", (String)"ono_wait_out")});
                queryVo.addFilters(new FilterFieldVo[]{filter});
            } else if (ObjectUtil.equals((Object)3, (Object)reqDto.getTypeStatus())) {
                FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"sendStatus", Arrays.asList("dispense_with_send", "send"))});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"interconnectionFlag", (String)"0")});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"status", (String)"ono_portion_out")});
                queryVo.addFilters(new FilterFieldVo[]{filter});
            } else if (ObjectUtil.equals((Object)4, (Object)reqDto.getTypeStatus())) {
                FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"sendStatus", Arrays.asList("dispense_with_send", "send"))});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)"interconnectionFlag", (String)"0")});
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"status", Arrays.asList("ono_total_out", "finish_over"))});
                queryVo.addFilters(new FilterFieldVo[]{filter});
            }
        }
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }

    private PageInfo<DgReceiveInRespDto> getReceiveInOrderEsList(DgReceiveInPageDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.receiveInTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initInSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgReceiveInRespDto orderItemPageDto = (DgReceiveInRespDto)BeanUtil.copyProperties((Object)docValue, DgReceiveInRespDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initInSearchVo(DgReceiveInPageDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u6536\u8d27\u5165\u5e93\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (CollectionUtils.isEmpty((Collection)reqDto.getCompoundOrderNoList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)o, (List)reqDto.getCompoundOrderNoList(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompoundOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getCompoundOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getWhetherRemark())) {
            if (IsFlagEnum.YES.getCode().equals(reqDto.getWhetherRemark().toString())) {
                queryVo.addExistsFilter("remark");
            } else {
                FilterFieldVo nonExistsFilter = FilterFieldVo.exists((String)"remark");
                nonExistsFilter.setNon(Boolean.valueOf(true));
                queryVo.addFilters(new FilterFieldVo[]{nonExistsFilter});
            }
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u6536\u8d27\u5165\u5e93\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    private void decideTab(DgReceiveInPageDto dgReceiveInPageDto) {
        if (ObjectUtil.equals((Object)1, (Object)dgReceiveInPageDto.getTypeStatus())) {
            dgReceiveInPageDto.setInterconnectionFlag("0");
            dgReceiveInPageDto.setOrderStatusList(Arrays.asList("ino_wait_in"));
        } else if (ObjectUtil.equals((Object)2, (Object)dgReceiveInPageDto.getTypeStatus())) {
            dgReceiveInPageDto.setInterconnectionFlag("0");
            dgReceiveInPageDto.setOrderStatusList(Arrays.asList("ino_portion_in"));
        } else if (ObjectUtil.equals((Object)3, (Object)dgReceiveInPageDto.getTypeStatus())) {
            dgReceiveInPageDto.setInterconnectionFlag("0");
            dgReceiveInPageDto.setOrderStatusList(Arrays.asList("ino_total_in", "finish_over"));
        }
    }
}

