/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.inventory.DgDeliveryNoticeOrderConverter;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.report.service.agg.IDgBasisOrderRelOrderInfoService;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.IDgDeliveryNoticeOrderService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgDeliveryNoticeOrderServiceImpl
extends BaseServiceImpl<DgDeliveryNoticeOrderDto, DgDeliveryNoticeOrderEo, IDgDeliveryNoticeOrderDomain>
implements IDgDeliveryNoticeOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgDeliveryNoticeOrderServiceImpl.class);
    String tableName = "cs_delivery_notice_order";
    private static final String[] ORDER_NOS = new String[]{"platformOrderNo", "saleOrderNo", "inventoryLogisticsNo", "deliveryNoticeNo"};
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Resource
    private IDgBasisOrderRelOrderInfoService dgBasisOrderRelOrderInfoService;

    public DgDeliveryNoticeOrderServiceImpl(IDgDeliveryNoticeOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgDeliveryNoticeOrderDto, DgDeliveryNoticeOrderEo> converter() {
        return DgDeliveryNoticeOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgDeliveryNoticeOrderDto>> queryList(DgDeliveryNoticeOrderPageReqDto dto) {
        return new RestResponse((Object)((IDgDeliveryNoticeOrderDomain)this.domain).queryListExt(dto));
    }

    @Override
    public RestResponse<PageInfo<DgDeliveryNoticeOrderDto>> queryPage(DgDeliveryNoticeOrderPageReqDto dto) {
        PageInfo dgDeliveryNoticeOrderDtoPageInfo;
        if (this.esQuery.booleanValue()) {
            dgDeliveryNoticeOrderDtoPageInfo = this.getDeliveryNoticeOrderEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            List relevanceNoList = dto.getRelevanceNoList();
            if (CollectionUtils.isNotEmpty((Collection)relevanceNoList)) {
                relevanceNoList.add(StringUtils.join((Iterable)relevanceNoList, (String)","));
                dto.setRelevanceNoList(relevanceNoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(dgDeliveryNoticeOrderDtoPageInfo = new PageInfo(((IDgDeliveryNoticeOrderDomain)this.domain).queryList(dto))).getList())) {
                this.setExtension(dgDeliveryNoticeOrderDtoPageInfo.getList());
            }
        }
        return new RestResponse(dgDeliveryNoticeOrderDtoPageInfo);
    }

    private void setExtension(List<DgDeliveryNoticeOrderDto> list) {
        List ids = list.stream().map(p -> p.getId()).collect(Collectors.toList());
        List eoList = ((ExtQueryChainWrapper)((IDgDeliveryNoticeOrderDomain)this.domain).filter().select(new String[]{"id", "extension"}).in((Object)"id", ids)).list();
        Map<Long, String> extensionMap = this.getExtensionMap(eoList);
        for (DgDeliveryNoticeOrderDto noticeOrderDto : list) {
            noticeOrderDto.setExtension(extensionMap.get(noticeOrderDto.getId()));
        }
    }

    private Map<Long, String> getExtensionMap(List<DgDeliveryNoticeOrderEo> eoList) {
        if (CollectionUtils.isEmpty(eoList)) {
            return Maps.newHashMap();
        }
        return eoList.stream().collect(Collectors.toMap(BaseEo::getId, CubeBaseEo::getExtension, (k1, k2) -> k2));
    }

    @Override
    public RestResponse<DgDeliveryNoticeOrderDto> queryByDocumentNo(String documentNo) {
        DgDeliveryNoticeOrderDto DgDeliveryNoticeOrderDto2 = ((IDgDeliveryNoticeOrderDomain)this.domain).queryDocumentNoDetail(documentNo);
        return new RestResponse((Object)DgDeliveryNoticeOrderDto2);
    }

    private PageInfo<DgDeliveryNoticeOrderDto> getDeliveryNoticeOrderEsList(DgDeliveryNoticeOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgDeliveryNoticeOrderDto orderItemPageDto = (DgDeliveryNoticeOrderDto)BeanUtil.copyProperties((Object)docValue, DgDeliveryNoticeOrderDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgDeliveryNoticeOrderPageReqDto reqDto) throws Exception {
        log.info("ES\u6536\u53d1\u8d27\u901a\u77e5\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u6536\u53d1\u8d27\u901a\u77e5\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

