/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.constants.tag.TagGroupEnum;
import com.yunxi.dg.base.center.report.convert.entity.PlanOrderConverter;
import com.yunxi.dg.base.center.report.domain.entity.IRelInventoryBatchTagDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgPlanOrderDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgPlanOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPlanOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPlanOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.RelInventoryBatchTagDto;
import com.yunxi.dg.base.center.report.dto.item.ItDirDto;
import com.yunxi.dg.base.center.report.enums.DgOrderTypeEnum;
import com.yunxi.dg.base.center.report.eo.inventory.DgPlanOrderEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.IReportDataSearchService;
import com.yunxi.dg.base.center.report.service.inventory.IDgPlanOrderService;
import com.yunxi.dg.base.center.report.service.item.IItDirService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgPlanOrderServiceImpl
extends BaseServiceImpl<DgPlanOrderDto, DgPlanOrderEo, IDgPlanOrderDomain>
implements IDgPlanOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgPlanOrderServiceImpl.class);
    String tableName = "in_plan_order";
    String tableNameWithDetail = "in_plan_order_detail";
    private static final String[] ORDER_NOS = new String[]{"orderNo", "externalOrderNo"};
    @Resource
    private IRelInventoryBatchTagDomain iRelInventoryBatchTagDomain;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource(name="purchaseReportDataSearchService")
    private IReportDataSearchService<DgPlanOrderPageReqDto, DgPlanOrderDetailDto> reportDataSearchService;
    @Resource
    private IDgDeliveryResultOrderDetailDomain dgDeliveryResultOrderDetailDomain;
    @Resource
    private IItDirService dirService;

    public DgPlanOrderServiceImpl(IDgPlanOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPlanOrderDto, DgPlanOrderEo> converter() {
        return PlanOrderConverter.INSTANCE;
    }

    @Override
    public PageInfo<DgPlanOrderDetailDto> queryDetailPage(DgPlanOrderPageReqDto reqDto) {
        if (Objects.isNull(reqDto) || StringUtils.isBlank((CharSequence)reqDto.getOrderType())) {
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getLastDirIdList())) {
            List<String> skuCodes = this.dirService.querySkuCodeListByDirList(reqDto.getLastDirIdList());
            if (CollectionUtils.isEmpty(skuCodes)) {
                return null;
            }
            List skuCodeList = Optional.ofNullable(reqDto.getSkuCodeList()).orElse(new ArrayList());
            skuCodeList.addAll(skuCodes);
            reqDto.setSkuCodeList(skuCodeList);
        }
        PageInfo<DgPlanOrderDetailDto> planOrderDetailDtoPageInfo = new PageInfo<DgPlanOrderDetailDto>();
        if (this.esQuery.booleanValue()) {
            planOrderDetailDtoPageInfo = this.getPlanOrderDetailDtoPageEsList(reqDto);
        } else {
            PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
            planOrderDetailDtoPageInfo = this.reportDataSearchService.queryList(reqDto);
        }
        this.planOrderDetailSetDfaultParam(planOrderDetailDtoPageInfo);
        return planOrderDetailDtoPageInfo;
    }

    private PageInfo<DgPlanOrderDetailDto> getPlanOrderDetailDtoPageEsList(DgPlanOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableNameWithDetail;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initDetailSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, RoundingMode.UP);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgPlanOrderDetailDtoList = searchResultVo.getDocValues(docValue -> (DgPlanOrderDetailDto)BeanUtil.copyProperties((Object)docValue, DgPlanOrderDetailDto.class, (String[])new String[0]));
            pageInfo.setList(dgPlanOrderDetailDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initDetailSearchVo(DgPlanOrderPageReqDto dto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u67e5\u91c7\u8d2d\u5355\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)LogUtils.buildLogContent((Object)dto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)dto);
        if (Objects.nonNull(dto.getCompoundOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)orderNo, (String)dto.getCompoundOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSkuCodeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCode", (List)dto.getSkuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSpuCodeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCode", (List)dto.getSpuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getInventoryPropertyList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"inventoryProperty", (List)dto.getInventoryPropertyList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getBatchList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batch", (List)dto.getBatchList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayName", (String)("*" + dto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u53c2\u6570\u5c01\u88c5\u540e\uff1a{}", (Object)LogUtils.buildLogContent((Object)queryVo));
        return queryVo;
    }

    @Override
    public void planOrderDetailSetDfaultParam(PageInfo<DgPlanOrderDetailDto> planOrderDetailDtoPageInfo) {
        List dtoList = Optional.ofNullable(planOrderDetailDtoPageInfo.getList()).orElse(Collections.emptyList());
        List inventoryBatchIdList = dtoList.stream().map(DgPlanOrderDetailDto::getInventoryBatchId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List relInventoryBatchTagEoList = new ArrayList();
        if (CollectionUtils.isNotEmpty(inventoryBatchIdList)) {
            relInventoryBatchTagEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iRelInventoryBatchTagDomain.filter().in(CollectionUtils.isNotEmpty(inventoryBatchIdList), (Object)"inventory_batch_id", inventoryBatchIdList)).lt((Object)"effective_time", (Object)new Date())).ge((Object)"failure_time", (Object)new Date())).list();
        }
        List<String> skuCodes = dtoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSkuCode())).map(e -> e.getSkuCode()).distinct().collect(Collectors.toList());
        Map lastDirMap = Optional.ofNullable(this.dirService.queryLastDirBySkuCodes(skuCodes)).orElse(new HashMap());
        List relInventoryBatchTagDtoList = BeanUtil.copyToList(relInventoryBatchTagEoList, RelInventoryBatchTagDto.class);
        Map<Long, List<RelInventoryBatchTagDto>> relInventoryBatchTagEoMap = relInventoryBatchTagDtoList.stream().collect(Collectors.groupingBy(RelInventoryBatchTagDto::getInventoryBatchId));
        if (CollectionUtils.isNotEmpty((Collection)planOrderDetailDtoPageInfo.getList())) {
            planOrderDetailDtoPageInfo.getList().forEach(o -> {
                ItDirDto itDirDto;
                List list;
                if (DgOrderTypeEnum.PURCHASE.getCode().equals(o.getOrderType()) || DgOrderTypeEnum.PURCHASE_RETURN.getCode().equals(o.getOrderType())) {
                    o.setUpdatePerson(o.getCreatePerson());
                }
                if (CollectionUtils.isNotEmpty((Collection)(list = (List)relInventoryBatchTagEoMap.get(o.getInventoryBatchId())))) {
                    Map<String, List<RelInventoryBatchTagDto>> tagTypeMap = list.stream().collect(Collectors.groupingBy(RelInventoryBatchTagDto::getTagType));
                    o.setExpiryDateTagList(tagTypeMap.get(TagGroupEnum.EXPIRY_DATE.getCode()));
                    o.setQualityInspectionTagList(tagTypeMap.get(TagGroupEnum.QUALITY.getCode()));
                }
                if (Objects.nonNull(itDirDto = (ItDirDto)lastDirMap.get(o.getSkuCode()))) {
                    o.setLastDirId(itDirDto.getId());
                    o.setLastDirName(itDirDto.getName());
                }
            });
        }
    }

    @Override
    public PageInfo<DgPlanOrderDto> queryPage(DgPlanOrderPageReqDto dto) {
        PageInfo dgPlanOrderDtoPageInfo;
        if (this.esQuery.booleanValue()) {
            log.info("\u91c7\u8d2d\u5355es\u67e5\u8be2");
            dgPlanOrderDtoPageInfo = this.getdgPlanOrderDtoPageEsList(dto);
        } else {
            log.info("\u91c7\u8d2d\u5355\u62a5\u8868\u67e5\u8be2");
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            dgPlanOrderDtoPageInfo = new PageInfo(((IDgPlanOrderDomain)this.domain).queryList(dto));
        }
        return dgPlanOrderDtoPageInfo;
    }

    private PageInfo<DgPlanOrderDto> getdgPlanOrderDtoPageEsList(DgPlanOrderPageReqDto dto) {
        PageInfo pageInfo;
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, RoundingMode.UP);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgPlanOrderDtoList = searchResultVo.getDocValues(docValue -> (DgPlanOrderDto)BeanUtil.copyProperties((Object)docValue, DgPlanOrderDto.class, (String[])new String[0]));
            pageInfo.setList(dgPlanOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgPlanOrderPageReqDto dto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u67e5\u91c7\u8d2d\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)LogUtils.buildLogContent((Object)dto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)dto);
        if (Objects.nonNull(dto.getCompoundOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)orderNo, (String)dto.getCompoundOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSkuCodeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"skuCodeList", (List)dto.getSkuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSpuCodeList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"spuCodeList", (List)dto.getSpuCodeList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getInventoryPropertyList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"inventoryPropertyList", (List)dto.getInventoryPropertyList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getBatchList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"batchList", (List)dto.getBatchList())});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (Objects.nonNull(dto.getSkuDisplayName())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.wildcard((String)"skuDisplayNameList", (String)("*" + dto.getSkuDisplayName() + "*"))});
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u67e5\u8be2\u8ba2\u5355\u53c2\u6570\u5c01\u88c5\u540e\uff1a{}", (Object)LogUtils.buildLogContent((Object)queryVo));
        return queryVo;
    }

    @Override
    public List<DgPlanOrderDto> queryList(DgPlanOrderPageReqDto reqDto) {
        return ((IDgPlanOrderDomain)this.domain).queryList(reqDto);
    }

    @Override
    public DgPlanOrderDetailDto queryDetail(String orderNo) {
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return null;
        }
        DgPlanOrderEo planOrderEo = (DgPlanOrderEo)((ExtQueryChainWrapper)((IDgPlanOrderDomain)this.domain).filter().eq((Object)"order_no", (Object)orderNo)).one();
        if (Objects.isNull(planOrderEo)) {
            return null;
        }
        DgPlanOrderPageReqDto planOrderPageReqDto = new DgPlanOrderPageReqDto();
        planOrderPageReqDto.setOrderNo(orderNo);
        planOrderPageReqDto.setOrderType(planOrderEo.getOrderType());
        planOrderPageReqDto.setPageSize(Integer.valueOf(1000));
        PageInfo<DgPlanOrderDetailDto> pageInfo = this.queryDetailPage(planOrderPageReqDto);
        return this.getDgPlanOrderDetailDto(planOrderEo, pageInfo);
    }

    @Override
    public DgPlanOrderDetailDto getDgPlanOrderDetailDto(DgPlanOrderEo planOrderEo, PageInfo<DgPlanOrderDetailDto> pageInfo) {
        if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        BigDecimal doneQuantity = BigDecimal.ZERO;
        BigDecimal planQuantity = BigDecimal.ZERO;
        BigDecimal waitQuantity = BigDecimal.ZERO;
        BigDecimal volume = BigDecimal.ZERO;
        BigDecimal weight = BigDecimal.ZERO;
        for (DgPlanOrderDetailDto dto : pageInfo.getList()) {
            doneQuantity = BigDecimalUtils.add((BigDecimal)doneQuantity, (BigDecimal)dto.getDoneQuantity());
            planQuantity = BigDecimalUtils.add((BigDecimal)planQuantity, (BigDecimal)dto.getPlanQuantity());
            waitQuantity = BigDecimalUtils.add((BigDecimal)waitQuantity, (BigDecimal)dto.getWaitQuantity());
            volume = BigDecimalUtils.add((BigDecimal)volume, (BigDecimal)dto.getVolume());
            weight = BigDecimalUtils.add((BigDecimal)weight, (BigDecimal)dto.getWeight());
        }
        DgPlanOrderDetailDto detailDto = (DgPlanOrderDetailDto)pageInfo.getList().get(0);
        detailDto.setId(planOrderEo.getId());
        detailDto.setDoneQuantity(doneQuantity);
        detailDto.setPlanQuantity(planQuantity);
        detailDto.setWaitQuantity(waitQuantity);
        detailDto.setVolume(volume);
        detailDto.setWeight(weight);
        detailDto.setSaleOrganizationCode(planOrderEo.getSaleOrganizationCode());
        detailDto.setSaleOrganizationName(planOrderEo.getSaleOrganizationName());
        detailDto.setDocumentType(planOrderEo.getDocumentType());
        detailDto.setErpPurchaseOrderNo(planOrderEo.getErpPurchaseOrderNo());
        detailDto.setErpType(planOrderEo.getErpType());
        detailDto.setExtension(planOrderEo.getExtension());
        return detailDto;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

