/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory.query.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DefaultConstants;
import com.yunxi.dg.base.center.report.dao.common.select.MultipartSelectGeneric;
import com.yunxi.dg.base.center.report.dto.agg.DgBusinessGoodsRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.BaseQueryPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryStatisticsRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.utils.OrderUnitConverterDto;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.AbstractReportDataSearchServiceImpl;
import com.yunxi.dg.base.center.report.service.impl.inventory.utils.UnitConverUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="otherInOutReportDataSearchService")
public class OtherInOutReportDataSearchServiceImpl
extends AbstractReportDataSearchServiceImpl<DgInOtherStorageOrderPageReqDto, DgInOtherStorageOrderDetailDto> {
    private String[] overStatus = new String[]{"completed", "finish"};

    public OtherInOutReportDataSearchServiceImpl() {
        this("in_other_storage_order", "m");
    }

    public OtherInOutReportDataSearchServiceImpl(String tableName, String alias) {
        super(tableName, alias);
    }

    @Override
    public void wrap(List<DgInOtherStorageOrderDetailDto> resultList) {
        super.wrap(resultList);
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        Set<String> orderNos = resultList.stream().filter(x -> !StrUtil.equalsAny((CharSequence)x.getOrderStatus(), (CharSequence[])this.overStatus)).map(DgInOtherStorageOrderDetailDto::getStorageOrderNo).collect(Collectors.toSet());
        Map<Long, InventoryStatisticsRespDto> processingQuantityOfTheDocumentMap = this.getOutQuantityOfTheDocument(orderNos, "out", "in");
        ArrayList convertList = new ArrayList();
        resultList.forEach(o -> {
            String extension = o.getExtension();
            JSONObject jsonObject = null;
            if (StringUtils.isNotEmpty((CharSequence)extension) && Objects.nonNull(jsonObject = JSONObject.parseObject((String)extension))) {
                o.setAuditRemark(jsonObject.getString("auditRemark"));
            }
            if (DefaultConstants.STATIC_STATUS_LIST.contains(o.getOrderStatus())) {
                o.setWaitQuantity(o.getQuantity());
            } else if (!StrUtil.equalsAny((CharSequence)o.getOrderStatus(), (CharSequence[])this.overStatus)) {
                InventoryStatisticsRespDto detailEo = processingQuantityOfTheDocumentMap.getOrDefault(o.getId(), new InventoryStatisticsRespDto());
                OrderUnitConverterDto converDto = new OrderUnitConverterDto();
                BeanUtil.copyProperties((Object)o, (Object)converDto, (String[])new String[0]);
                converDto.setConvedUnit(true);
                converDto.setDocumentCode(o.getStorageOrderNo());
                converDto.setPlanQuantity(detailEo.getPlanQuantity());
                converDto.setDoneQuantity(detailEo.getDoneQuantity());
                converDto.setWaitQuantity(BigDecimalUtils.subtract((BigDecimal)detailEo.getPlanQuantity(), (BigDecimal)detailEo.getDoneQuantity()));
                converDto.setConsumer(ver -> {
                    o.setDoneQuantity(ver.getDoneQuantity());
                    o.setWaitQuantity(ver.getWaitQuantity());
                });
                convertList.add(converDto);
            }
            if (StringUtils.isNotEmpty((CharSequence)o.getExtension())) {
                JSONObject param = JSONObject.parseObject((String)o.getExtension());
                o.setTransportTypeCode(param.getString("transportTypeCode"));
                o.setTransportTypeName(param.getString("transportTypeName"));
                o.setLineCode(param.getString("lineCode"));
                o.setLineName(param.getString("lineName"));
            }
        });
        UnitConverUtils.unitConvertBatch(new ArrayList(convertList));
    }

    @Override
    public void setLeftJoinOn(MultipartSelectGeneric generic) {
        generic.addLeftJoin("in_other_storage_order_detail", "md", "m.storage_order_no = md.storage_order_no");
        generic.addLeftJoin("cs_delivery_notice_order", "cdno", "cdno.relevance_no= m.storage_order_no and cdno.dr=0");
        generic.addLeftJoin("cs_delivery_result_order", "cdro", "cdro.relevance_no= m.storage_order_no and cdro.dr=0");
        super.setLeftJoinOn(generic);
    }

    @Override
    public void setWhere(MultipartSelectGeneric generic, DgInOtherStorageOrderPageReqDto reqDto) {
        ArrayList<String> fields;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getType())) {
            generic.equalsWhere("m.type", (Object)reqDto.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompoundOrderNo())) {
            HashMap<String, String> orMap = new HashMap<String, String>();
            orMap.put("m.storage_order_no", reqDto.getCompoundOrderNo());
            orMap.put("m.external_order_no", reqDto.getCompoundOrderNo());
            generic.or(orMap);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderNoList())) {
            fields = new ArrayList<String>();
            fields.add("m.storage_order_no");
            fields.add("m.external_order_no");
            generic.inOr(fields, reqDto.getOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCompoundOrderNoList())) {
            fields = new ArrayList();
            fields.add("m.storage_order_no");
            fields.add("m.external_order_no");
            generic.inOr(fields, reqDto.getCompoundOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getReceivingSceneCodeList())) {
            generic.in("m.receiving_scene_code", reqDto.getReceivingSceneCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getInventoryPropertyList())) {
            generic.in("md.inventory_property", reqDto.getInventoryPropertyList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderStatusList())) {
            generic.in("m.order_status", reqDto.getOrderStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getExternalProcessStateList())) {
            generic.in("m.external_process_state", reqDto.getExternalProcessStateList());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getExternalProcessState())) {
            generic.equalsWhere("m.external_process_state", (Object)reqDto.getExternalProcessState());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSubWarehouseCodeList())) {
            generic.in("m.sub_warehouse_code", reqDto.getSubWarehouseCodeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSubWarehouseCode())) {
            generic.equalsWhere("m.sub_warehouse_code", (Object)reqDto.getSubWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getConsignee())) {
            generic.equalsWhere("m.consignee", (Object)reqDto.getConsignee());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getPhone())) {
            generic.equalsWhere("m.phone", (Object)reqDto.getPhone());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getPushFinance())) {
            generic.in("m.push_finance", reqDto.getPushFinance());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderStatusList())) {
            generic.in("m.order_status", reqDto.getOrderStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getExternalWarehouseCodeList())) {
            generic.in("m.external_warehouse_code", reqDto.getExternalWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBusinessTypeGroupList())) {
            generic.in("m.business_type_group", reqDto.getBusinessTypeGroupList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBusinessTypeList())) {
            generic.in("m.business_type", reqDto.getBusinessTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getWarehouseCodeList())) {
            generic.in("m.warehouse_code", reqDto.getWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getPhysicsWarehouseCodeList())) {
            generic.in("m.physics_warehouse_code", reqDto.getPhysicsWarehouseCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBatchList())) {
            generic.in("md.batch", reqDto.getBatchList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            generic.in("md.sku_code", reqDto.getSkuCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSpuCodeList())) {
            generic.in("iig.code", reqDto.getSpuCodeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSkuDisplayName())) {
            generic.like("iisd.display_name", reqDto.getSkuDisplayName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSpecModel())) {
            generic.like("iisd.spec_model", reqDto.getSpecModel());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSaleOrganizationCodeList())) {
            generic.in("m.sale_organization_code", reqDto.getSaleOrganizationCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCostCenterCodeList())) {
            generic.in("m.cost_center_code", reqDto.getCostCenterCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCustomerCodeList())) {
            generic.in("m.customer_code", reqDto.getCustomerCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCargoOrganizationCodeList())) {
            generic.in("m.cargo_organization_code", reqDto.getCargoOrganizationCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getLogisticsCompanyCodeList())) {
            generic.in("m.logistics_company_code", reqDto.getLogisticsCompanyCodeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getStorageOrderNo())) {
            generic.equalsWhere("m.storage_order_no", (Object)reqDto.getStorageOrderNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCreatePerson())) {
            generic.like("m.create_person", reqDto.getCreatePerson());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getUpdatePerson())) {
            generic.like("m.update_person", reqDto.getUpdatePerson());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCreatePersonList())) {
            generic.in("m.create_person", reqDto.getCreatePersonList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getUpdatePersonList())) {
            generic.in("m.update_person", reqDto.getCreatePersonList());
        }
        if (reqDto.getStartBizDate() != null) {
            generic.greaterThanEqualWhere("m.biz_date", (Object)reqDto.getStartBizDate());
        }
        if (reqDto.getEndBizDate() != null) {
            generic.lessThanEqualWhere("m.biz_date", (Object)reqDto.getEndBizDate());
        }
        if (reqDto.getStartCreateTime() != null) {
            generic.greaterThanEqualWhere("m.create_time", (Object)reqDto.getStartCreateTime());
        }
        if (reqDto.getEndCreateTime() != null) {
            generic.lessThanEqualWhere("m.create_time", (Object)reqDto.getEndCreateTime());
        }
        if (reqDto.getStartUpdateTime() != null) {
            generic.greaterThanEqualWhere("m.update_time", (Object)reqDto.getStartUpdateTime());
        }
        if (reqDto.getEndUpdateTime() != null) {
            generic.lessThanEqualWhere("m.update_time", (Object)reqDto.getEndUpdateTime());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getLogisticsOrderNo())) {
            generic.like("cdno.pre_order_no", reqDto.getLogisticsOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getU9No())) {
            generic.like("cdro.u9_no", reqDto.getU9No());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getProjectCode())) {
            generic.like("md.project_code", reqDto.getProjectCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getProjectName())) {
            generic.like("md.project_name", reqDto.getProjectName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getMessage())) {
            generic.like("m.message", reqDto.getMessage());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getMessageList())) {
            generic.in("m.message", reqDto.getMessageList());
        }
        super.setWhere(generic, reqDto);
    }

    @Override
    public List<String> getExtFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("md.id AS id");
        fields.add("m.storage_order_no");
        fields.add("m.external_order_no");
        fields.add("m.external_process_state");
        fields.add("m.sub_warehouse_code");
        fields.add("m.sub_warehouse_name");
        fields.add("m.receiving_scene_code");
        fields.add("m.receiving_scene_name");
        fields.add("m.pre_order_no");
        fields.add("m.order_src");
        fields.add("m.type");
        fields.add("md.inventory_property AS inventoryProperty");
        fields.add("m.business_type_group");
        fields.add("m.business_type_group_name");
        fields.add("m.business_type");
        fields.add("m.business_type_name");
        fields.add("m.organization_code");
        fields.add("m.organization_name");
        fields.add("m.organization_id");
        fields.add("m.warehouse_id");
        fields.add("m.warehouse_code");
        fields.add("m.warehouse_name");
        fields.add("m.customer_code");
        fields.add("m.customer_name");
        fields.add("m.order_status");
        fields.add("m.consignee");
        fields.add("m.phone");
        fields.add("m.total_quantity");
        fields.add("m.total_volume");
        fields.add("m.province_code");
        fields.add("m.province_name");
        fields.add("m.city_code");
        fields.add("m.city_name");
        fields.add("m.area_code");
        fields.add("m.area_name");
        fields.add("m.address");
        fields.add("m.message");
        fields.add("m.remark");
        fields.add("m.create_time");
        fields.add("m.create_person");
        fields.add("m.update_time");
        fields.add("m.update_person");
        fields.add("m.tenant_id");
        fields.add("m.instance_id");
        fields.add("m.extension");
        fields.add("m.source_system");
        fields.add("m.is_send_eas");
        fields.add("m.cost_center_code");
        fields.add("m.cost_center_name");
        fields.add("m.no_batch");
        fields.add("m.biz_date");
        fields.add("m.string_code_result");
        fields.add("m.string_code_time");
        fields.add("m.physics_warehouse_id");
        fields.add("m.physics_warehouse_code");
        fields.add("m.physics_warehouse_name");
        fields.add("m.external_warehouse_code");
        fields.add("m.external_warehouse_name");
        fields.add("m.push_finance");
        fields.add("m.sale_organization_code");
        fields.add("m.sale_organization_name");
        fields.add("m.cargo_organization_code");
        fields.add("m.cargo_organization_name");
        fields.add("m.logistics_company_code");
        fields.add("m.logistics_company_name");
        fields.add("m.customer_id as customerId");
        fields.add("m.operator_team_code as operatorTeamCode");
        fields.add("m.operator_team_name as operatorTeamName");
        fields.add("m.u9_cus_code as u9CusCode");
        fields.add("md.sku_code");
        fields.add("md.sku_name");
        fields.add("md.batch");
        fields.add("md.line_no");
        fields.add("md.quantity");
        fields.add("md.volume");
        fields.add("md.weight");
        fields.add("md.specification");
        fields.add("md.unit");
        fields.add("md.unit_price");
        fields.add("md.wait_quantity");
        fields.add("md.done_quantity");
        fields.add("md.project_id");
        fields.add("md.project_code");
        fields.add("md.project_name");
        fields.add("cdno.pre_order_no AS logisticsOrderNo");
        fields.add("cdro.u9_no AS u9No");
        return fields;
    }

    @Override
    protected DgInOtherStorageOrderPageReqDto convert2ReqDto(BaseQueryPageReqDto queryPageReqDto) {
        DgInOtherStorageOrderPageReqDto detailDto = new DgInOtherStorageOrderPageReqDto();
        detailDto.setStorageOrderNo(queryPageReqDto.getOrderNo());
        return detailDto;
    }

    @Override
    protected PageInfo<DgBusinessGoodsRespDto> convert2RespDto(PageInfo<DgInOtherStorageOrderDetailDto> pageInfo) {
        ArrayList<DgBusinessGoodsRespDto> results = new ArrayList<DgBusinessGoodsRespDto>();
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo(new ArrayList());
        }
        for (DgInOtherStorageOrderDetailDto dto : pageInfo.getList()) {
            DgBusinessGoodsRespDto dgBusinessGoodsRespDto = (DgBusinessGoodsRespDto)BeanUtil.copyProperties((Object)dto, DgBusinessGoodsRespDto.class, (String[])new String[0]);
            dgBusinessGoodsRespDto.setPlanQuantity(dto.getQuantity());
            results.add(dgBusinessGoodsRespDto);
        }
        return new PageInfo(results);
    }
}

