/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.item;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.es.base.BaseEsPageDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemEsRespDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemPageSearchReqDto;
import com.yunxi.dg.base.center.report.service.es.RestSearchExtService;
import com.yunxi.dg.base.center.report.service.item.DgShopItemService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgShopItemServiceImpl
implements DgShopItemService {
    private static Logger logger = LoggerFactory.getLogger(DgShopItemServiceImpl.class);
    @Resource
    private IOpenSearchService openSearchService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    public static final String INDEX_ITEM_SHOP = "shop_item_info";
    @Resource
    private RestSearchExtService restSearchService;

    @Override
    public PageInfo<ShopItemEsRespDto> queryPage(ShopItemPageSearchReqDto reqDto) {
        PageInfo pageInfo = new PageInfo();
        reqDto.setIndexName("shop_item_info_" + this.globalProfile);
        Boolean offShelf = Objects.nonNull(reqDto) && Objects.nonNull(reqDto.getOffShelf()) ? reqDto.getOffShelf() : true;
        if (offShelf.booleanValue()) {
            reqDto.setSpuShelfStatus(Integer.valueOf(1));
            reqDto.setSkuShelfStatus(Integer.valueOf(1));
        } else {
            reqDto.setSpuShelfStatus(Integer.valueOf(2));
        }
        logger.info("<<<<<<<<<<<<<-----\u5f00\u59cb\u6267\u884c\u67e5\u8be2ES-->>>>>>{}", (Object)JSON.toJSONString((Object)reqDto));
        SearchResultVo searchResultVo = this.restSearchService.esSearch((BaseEsPageDto)reqDto);
        logger.info("<<<<<<<<<<<<<-----\u6267\u884c\u7ed3\u675fES-->>>>>>");
        List shopItemEsRespDtoList = ((List)Optional.ofNullable(searchResultVo.getDocValues()).orElse(new ArrayList())).stream().map(doc -> (ShopItemEsRespDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), ShopItemEsRespDto.class)).collect(Collectors.toList());
        pageInfo.setPageNum(reqDto.getPageNum().intValue());
        pageInfo.setPageSize(reqDto.getPageSize().intValue());
        pageInfo.setSize(shopItemEsRespDtoList.size());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setList(shopItemEsRespDtoList);
        return pageInfo;
    }

    private OSSearchVo buildSearchVo(ShopItemPageSearchReqDto reqDto) {
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName("shop_item_info_" + this.globalProfile);
        if (Objects.nonNull(reqDto.getPageNum())) {
            osSearchVo.setPage(reqDto.getPageNum().intValue());
        }
        if (Objects.nonNull(reqDto.getPageSize())) {
            osSearchVo.setPageSize(reqDto.getPageSize().intValue());
        } else {
            osSearchVo.setPageSize(10000);
        }
        if (Objects.isNull(reqDto)) {
            return osSearchVo;
        }
        boolean isFlagFilter = false;
        return osSearchVo;
    }

    private void addKeywordSearch(OSSearchVo osSearchVo, String keyWord) {
        if (StringUtils.isBlank((CharSequence)keyWord)) {
            return;
        }
        String searchKeyword = "*" + keyWord + "*";
        osSearchVo.addWildcardFilter(Lists.newArrayList((Object[])new String[]{"name.keyword", "bran.keyword", "code.keyword"}).toArray(new String[0]), searchKeyword, LogicalSymbol.OR);
    }

    private void addBaseSearchOrder(OSSearchVo osSearchVo, ShopItemPageSearchReqDto reqDto) {
        if (StringUtils.isEmpty((CharSequence)reqDto.getOrderByDesc())) {
            osSearchVo.addSort("itemSkuList.shelfDgDto.shelfTime", SortOrder.DESC);
        } else {
            osSearchVo.addSort("itemSkuList.shelfDgDto.shelfTime", SortOrder.DESC);
        }
    }
}

