/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.share;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DgWarehouseClassifyEnum;
import com.yunxi.dg.base.center.report.convert.share.DgChannelInventoryConverter;
import com.yunxi.dg.base.center.report.domain.share.IDgChannelInventoryDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgInventorySupplyStrategyDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgInventorySupplyStrategyWarehouseDomain;
import com.yunxi.dg.base.center.report.dto.share.DgChannelAvailableInventoryDto;
import com.yunxi.dg.base.center.report.dto.share.DgChannelInventoryCountReDto;
import com.yunxi.dg.base.center.report.dto.share.DgChannelInventoryCountRespDto;
import com.yunxi.dg.base.center.report.dto.share.DgChannelInventoryDto;
import com.yunxi.dg.base.center.report.dto.share.DgChannelInventoryPageReqDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualInventoryDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualInventoryPageReqDto;
import com.yunxi.dg.base.center.report.eo.share.DgChannelInventoryEo;
import com.yunxi.dg.base.center.report.eo.share.DgInventorySupplyStrategyEo;
import com.yunxi.dg.base.center.report.eo.share.DgInventorySupplyStrategyWarehouseEo;
import com.yunxi.dg.base.center.report.service.impl.share.RedisFormulaManager;
import com.yunxi.dg.base.center.report.service.impl.share.RelWarehouseUtils;
import com.yunxi.dg.base.center.report.service.share.IDgChannelInventoryService;
import com.yunxi.dg.base.center.report.service.share.IDgVirtualInventoryService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgChannelInventoryServiceImpl
extends BaseServiceImpl<DgChannelInventoryDto, DgChannelInventoryEo, IDgChannelInventoryDomain>
implements IDgChannelInventoryService {
    @Resource
    private RelWarehouseUtils relWarehouseUtils;
    @Resource
    private IDgVirtualInventoryService virtualInventoryService;
    @Resource
    private IDgInventorySupplyStrategyDomain iDgInventorySupplyStrategyDomain;
    @Resource
    private IDgInventorySupplyStrategyWarehouseDomain iDgInventorySupplyStrategyWarehouseDomain;

    public DgChannelInventoryServiceImpl(IDgChannelInventoryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgChannelInventoryDto, DgChannelInventoryEo> converter() {
        return DgChannelInventoryConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<DgChannelInventoryDto>> queryPage(DgChannelInventoryPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        dto.setInventoryType((Integer)ObjectUtils.defaultIfNull((Object)dto.getInventoryType(), (Object)0));
        PageInfo pageInfo = new PageInfo(((IDgChannelInventoryDomain)this.domain).queryList(dto));
        this.wrapperInventory(dto, pageInfo.getList());
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<DgChannelInventoryDto>> queryList(DgChannelInventoryPageReqDto dto) {
        dto.setInventoryType((Integer)ObjectUtils.defaultIfNull((Object)dto.getInventoryType(), (Object)0));
        List dgChannelInventoryDtos = ((IDgChannelInventoryDomain)this.domain).queryList(dto);
        this.wrapperInventory(dto, dgChannelInventoryDtos);
        return new RestResponse((Object)dgChannelInventoryDtos);
    }

    private void wrapperInventory(DgChannelInventoryPageReqDto dto, List<DgChannelInventoryDto> dgChannelInventoryDtos) {
        if (CollectionUtils.isNotEmpty(dgChannelInventoryDtos) && CollectionUtils.isNotEmpty((Collection)dto.getSupplyWarehouseCodeList())) {
            DgVirtualInventoryPageReqDto virtualInventoryPageReqDto = (DgVirtualInventoryPageReqDto)BeanUtil.copyProperties((Object)dto, DgVirtualInventoryPageReqDto.class, (String[])new String[0]);
            virtualInventoryPageReqDto.setWarehouseCode(null);
            virtualInventoryPageReqDto.setWarehouseId(null);
            virtualInventoryPageReqDto.setWarehouseCodeList(dto.getSupplyWarehouseCodeList());
            virtualInventoryPageReqDto.setShareKeyList((List)Lists.newArrayList((Object[])new String[]{"DEFAULT"}));
            virtualInventoryPageReqDto.setInventoryType(Integer.valueOf(0));
            RestResponse<List<DgVirtualInventoryDto>> response = this.virtualInventoryService.queryList(virtualInventoryPageReqDto);
            List data = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                dgChannelInventoryDtos.forEach(r -> {
                    r.setAvailable(BigDecimal.ZERO);
                    r.setBalance(BigDecimal.ZERO);
                    r.setPreempt(BigDecimal.ZERO);
                    List<String> downRelWarehouseCodes = this.relWarehouseUtils.getDownRelWarehouseCodes(Lists.newArrayList((Object[])new String[]{r.getWarehouseCode()}), RedisFormulaManager.FormulaCalcEnum.SUPPLY_TO_CHANNEL);
                    data.stream().filter(v -> downRelWarehouseCodes.contains(v.getWarehouseCode()) && Objects.equals(r.getSkuCode(), v.getSkuCode())).forEach(v -> {
                        r.setAvailable(BigDecimalUtils.add((BigDecimal)r.getAvailable(), (BigDecimal)v.getAvailable()));
                        r.setBalance(BigDecimalUtils.add((BigDecimal)r.getBalance(), (BigDecimal)v.getBalance()));
                        r.setPreempt(BigDecimalUtils.add((BigDecimal)r.getPreempt(), (BigDecimal)v.getPreempt()));
                    });
                });
            } else {
                dgChannelInventoryDtos.forEach(r -> {
                    r.setAvailable(BigDecimal.ZERO);
                    r.setBalance(BigDecimal.ZERO);
                    r.setPreempt(BigDecimal.ZERO);
                });
            }
        }
    }

    @Override
    public DgChannelInventoryCountRespDto queryChannelInventoryByCount(DgChannelInventoryCountReDto channelInventoryCountReDto) {
        return ((IDgChannelInventoryDomain)this.domain).queryChannelInventoryByCount(channelInventoryCountReDto);
    }

    @Override
    public PageInfo<DgVirtualInventoryDto> queryAvailableInventoryPage(DgChannelInventoryPageReqDto dto) {
        AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode()) && StringUtils.isNotBlank((CharSequence)dto.getSkuCode()) ? 1 : 0) != 0, (String)"SKU\u7f16\u7801\u548c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        dto.setInventoryType((Integer)ObjectUtils.defaultIfNull((Object)dto.getInventoryType(), (Object)0));
        DgChannelAvailableInventoryDto channelAvailableInventoryDto = ((IDgChannelInventoryDomain)this.domain).queryAvailableInventoryDetail(dto);
        if (ObjectUtil.isNull((Object)channelAvailableInventoryDto)) {
            return new PageInfo();
        }
        DgInventorySupplyStrategyEo inventorySupplyStrategyEo = (DgInventorySupplyStrategyEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgInventorySupplyStrategyDomain.filter().eq((Object)"ref_entity_code", (Object)channelAvailableInventoryDto.getChannelWarehouseCode())).eq((Object)"status", (Object)"ENABLE")).eq((Object)"function_module", (Object)"CHANNEL")).one();
        if (ObjectUtil.isNull((Object)inventorySupplyStrategyEo)) {
            return new PageInfo();
        }
        List supplyStrategyWarehouseEos = ((ExtQueryChainWrapper)this.iDgInventorySupplyStrategyWarehouseDomain.filter().eq((Object)"supply_strategy_code", (Object)inventorySupplyStrategyEo.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)supplyStrategyWarehouseEos)) {
            return new PageInfo();
        }
        Map<String, BigDecimal> ratioMap = supplyStrategyWarehouseEos.stream().collect(Collectors.toMap(DgInventorySupplyStrategyWarehouseEo::getWarehouseCode, DgInventorySupplyStrategyWarehouseEo::getDistributionUmerical, (o1, o2) -> o1));
        ArrayList<String> warehouseCodeList = new ArrayList<String>(ratioMap.keySet());
        if (CollectionUtils.isEmpty(ratioMap.keySet())) {
            return new PageInfo();
        }
        DgVirtualInventoryPageReqDto reqDto = new DgVirtualInventoryPageReqDto();
        reqDto.setWarehouseCodeList(warehouseCodeList);
        reqDto.setSkuCodeList(Arrays.asList(channelAvailableInventoryDto.getSkuCode()));
        reqDto.setPageNum(dto.getPageNum());
        reqDto.setPageSize(dto.getPageSize());
        PageInfo pageInfo = (PageInfo)Optional.ofNullable(RestResponseHelper.extractData(this.virtualInventoryService.queryPage(reqDto))).orElse(new PageInfo());
        List list = pageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> {
                if (ratioMap.containsKey(o.getWarehouseCode())) {
                    BigDecimal ratio = (BigDecimal)ratioMap.get(o.getWarehouseCode());
                    o.setRatio(ratio);
                }
                o.setWarehouseClassify(DgWarehouseClassifyEnum.VIRTUAL.getCode());
            });
            BigDecimal available = list.stream().map(o -> BigDecimalUtils.multiply((BigDecimal)o.getAvailable(), (BigDecimal)o.getRatio())).reduce(BigDecimal.ZERO, BigDecimal::add);
            channelAvailableInventoryDto.setAvailable(available);
        }
        return pageInfo;
    }

    @Override
    public DgChannelAvailableInventoryDto queryAvailableInventoryList(DgChannelInventoryPageReqDto dto) {
        return null;
    }

    private static Integer expiredDay(Date expireTime) {
        if (Objects.isNull(expireTime)) {
            return null;
        }
        int day = DateUtil.getDifferDay((String)DateUtil.format((Date)expireTime), (String)DateUtil.format((Date)new Date()));
        if (day > 0) {
            return 1;
        }
        return 0;
    }
}

