/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.item.impl;

import cn.hutool.json.JSONUtil;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.price.dto.dto.PriceTypeDto;
import com.yunxi.dg.base.center.price.dto.item.ItemSkuBasePriceReqDto;
import com.yunxi.dg.base.center.price.dto.item.ItemSkuBasePriceRespDto;
import com.yunxi.dg.base.center.price.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgBasePriceItemQueryApiProxy;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceTypeQueryApiProxy;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.dto.entity.SkuInfoDto;
import com.yunxi.dg.base.center.report.dto.entity.SkuRelevantInfoDto;
import com.yunxi.dg.base.center.report.dto.item.ItemSkuDgDto;
import com.yunxi.dg.base.center.report.eo.item.ItemSkuDgEo;
import com.yunxi.dg.base.center.report.service.item.IItemSkuDgService;
import com.yunxi.dg.base.center.report.utils.PageQueryUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemSkuDgServiceImpl
extends BaseServiceImpl<ItemSkuDgDto, ItemSkuDgEo, IItemSkuDgDomain>
implements IItemSkuDgService {
    private static final Logger log = LoggerFactory.getLogger(ItemSkuDgServiceImpl.class);
    @Resource
    private IDgBasePriceItemQueryApiProxy basePriceItemQueryApiProxy;
    @Resource
    private IDgPriceTypeQueryApiProxy priceTypeQueryApiProxy;

    public ItemSkuDgServiceImpl(IItemSkuDgDomain iItemSkuDgDomain) {
        super((IBaseDomain)iItemSkuDgDomain);
    }

    @Override
    public Map<String, SkuRelevantInfoDto> querySkuRelevantInfoMap(Set<String> skuCodes) {
        List<PriceTypeDto> types = this.getTypes();
        Long typeId = ((List)Optional.ofNullable(types).orElse(new ArrayList(0))).stream().filter(s -> "Factory_price".equals(s.getTypeCode())).findFirst().map(PriceTypeDto::getTypeId).orElse(null);
        List<ItemSkuBasePriceRespDto> priceList = this.getPrices(skuCodes);
        BigDecimal empty = new BigDecimal(-9999);
        Map<String, BigDecimal> factoryPriceMap = priceList.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, v -> Optional.ofNullable(v.getSkuPriceMap()).map(s -> (BigDecimal)s.get(typeId)).orElse(empty)));
        List skus = ((IItemSkuDgDomain)this.domain).querySkuRelevantInfoList(skuCodes);
        return skus.stream().peek(sku -> {
            BigDecimal decimal = (BigDecimal)factoryPriceMap.get(sku.getSkuCode());
            if (decimal != null && !empty.equals(decimal)) {
                sku.setFactoryPrice(decimal);
            }
        }).collect(Collectors.toMap(SkuRelevantInfoDto::getSkuCode, s -> s, (a, b) -> {
            log.warn("\u91cd\u590d\u7684skuCode={}, a={}, b={}", new Object[]{a.getSkuCode(), JSONUtil.toJsonStr((Object)a), JSONUtil.toJsonStr((Object)b)});
            return b;
        }));
    }

    private List<ItemSkuBasePriceRespDto> getPrices(Set<String> skuCodes) {
        try {
            return PageQueryUtils.queryAll(1000, (pageNum, pageSize) -> {
                ItemSkuBasePriceReqDto req = new ItemSkuBasePriceReqDto();
                req.setSkuCodes(new ArrayList(skuCodes));
                req.setPageSize(pageSize);
                return (PageInfo)RestResponseHelper.extractData((RestResponse)this.basePriceItemQueryApiProxy.querySkuBasePriceByPage(req));
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return new ArrayList<ItemSkuBasePriceRespDto>(0);
        }
    }

    private List<PriceTypeDto> getTypes() {
        try {
            return (List)RestResponseHelper.extractData((RestResponse)this.priceTypeQueryApiProxy.queryPriceTypeDropDownListByCategoryCode(null, "0"));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return new ArrayList<PriceTypeDto>(0);
        }
    }

    @Override
    public Map<String, SkuInfoDto> getSkuInfoMap(Set<String> skuCodes) {
        List skus = ((IItemSkuDgDomain)this.domain).getSkuInfoList(skuCodes);
        return skus.stream().collect(Collectors.toMap(SkuInfoDto::getSkuCode, s -> s, (a, b) -> {
            log.warn("\u91cd\u590d\u7684skuCode={}, a={}, b={}", new Object[]{a.getSkuCode(), JSONUtil.toJsonStr((Object)a), JSONUtil.toJsonStr((Object)b)});
            return b;
        }));
    }
}

