/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.advice;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.report.api.constant.DgReportMqConstant;
import com.yunxi.dg.base.center.report.domain.entity.IBizTagDomain;
import com.yunxi.dg.base.center.report.eo.BizTagEo;
import com.yunxi.dg.base.center.report.service.anno.LabelTagSynchronizationAnnotation;
import com.yunxi.dg.base.center.report.service.anno.ReturnTypeEnums;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AfterLabelTagAdviceAspect {
    private static Logger logger = LoggerFactory.getLogger(AfterLabelTagAdviceAspect.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IBizTagDomain iBizTagDomain;

    @Pointcut(value="execution(* com.yunxi.dg.base.center.report.service.entity.impl.BizTagServiceImpl.*(..)) && @annotation(com.yunxi.dg.base.center.report.service.anno.LabelTagSynchronizationAnnotation)")
    public void serviceMethods() {
    }

    @Around(value="serviceMethods()")
    public Object modifyReturnValue(ProceedingJoinPoint joinPoint) throws Throwable {
        String processLogger;
        Object returnValue;
        ArrayList<Object> bizTypeCodeList = new ArrayList<Object>();
        try {
            returnValue = joinPoint.proceed();
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method targetMethod = methodSignature.getMethod();
            LabelTagSynchronizationAnnotation annotation = targetMethod.getAnnotation(LabelTagSynchronizationAnnotation.class);
            String desc = annotation.desc();
            StringBuilder stringBuilder = AfterLabelTagAdviceAspect.getStringBuilderLogger(targetMethod.getName());
            switch (ReturnTypeEnums.getEnumsByCode(annotation.returnType())) {
                case LIST_TYPE: {
                    if (!desc.equals("updateStatus")) break;
                    Object[] args = joinPoint.getArgs();
                    ArrayList longs = (ArrayList)args[1];
                    stringBuilder.append("[\u66f4\u65b0\u7684\u6807\u7b7eid] " + longs.toString() + "\n");
                    List bizTagEos = this.iBizTagDomain.selectByIds((List)longs);
                    List collect = bizTagEos.stream().map(BizTagEo::getTagCode).distinct().collect(Collectors.toList());
                    bizTypeCodeList.addAll(collect);
                    break;
                }
                case LONG_TYPE: {
                    if (desc.equals("edit")) {
                        Long id = (Long)returnValue;
                        stringBuilder.append("[\u66f4\u65b0\u7684\u6807\u7b7eid] " + id + "\n");
                        BizTagEo bizTagEo = (BizTagEo)this.iBizTagDomain.selectByPrimaryKey(id);
                        bizTypeCodeList.add(bizTagEo.getTagCode());
                        break;
                    }
                    if (!desc.equals("logicDel")) break;
                    Object[] args = joinPoint.getArgs();
                    Long id = (Long)args[0];
                    stringBuilder.append("[\u66f4\u65b0\u7684\u6807\u7b7eid] " + id + "\n");
                    BizTagEo bizTagEo = (BizTagEo)this.iBizTagDomain.selectByPrimaryKey(id);
                    bizTypeCodeList.add(bizTagEo.getTagCode());
                    break;
                }
            }
            processLogger = stringBuilder.toString();
        }
        catch (Exception e) {
            logger.info("Exception occurred: " + e.getMessage());
            throw e;
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString(bizTypeCodeList));
        logger.info("\u540c\u6b65\u6807\u7b7e\u66f4\u65b0\u4f1a\u8bdd:{}", (Object)processLogger);
        logger.info("mqService=>sendToChangeLabel: {}", (Object)LogUtils.buildLogContent((Object)messageVo));
        MessageResponse messageResponse = this.commonsMqService.publishMessageAsync(DgReportMqConstant.REPORT_PUBLISH_TOPIC.getCode(), DgReportMqConstant.ORDER_LABEL_CHANGE_TAG.getCode(), (Object)messageVo);
        return returnValue;
    }

    @NotNull
    private static StringBuilder getStringBuilderLogger(String methodName) {
        StringBuilder stringBuilder = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date());
        stringBuilder.append("[" + timestamp + "] ");
        stringBuilder.append("[\u64cd\u4f5c\u65b9\u6cd5]: " + methodName + "\n");
        return stringBuilder;
    }
}

