/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.credit.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.convert.entity.InstallmentApplyDgConverter;
import com.yunxi.dg.base.center.report.domain.credit.IInstallmentApplyDgDomain;
import com.yunxi.dg.base.center.report.dto.credit.InstallmentApplyDgDto;
import com.yunxi.dg.base.center.report.dto.credit.InstallmentApplyDgPageReqDto;
import com.yunxi.dg.base.center.report.dto.credit.InstallmentPlanFollowReqDto;
import com.yunxi.dg.base.center.report.dto.credit.InstallmentPlanFollowRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationExtDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.eo.credit.InstallmentApplyDgEo;
import com.yunxi.dg.base.center.report.service.credit.IInstallmentApplyDgService;
import com.yunxi.dg.base.center.report.service.credit.impl.CustomerRelationHelper;
import com.yunxi.dg.base.center.report.service.customer.tob.IDgOrgCustomerRelationService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class InstallmentApplyDgServiceImpl
extends BaseServiceImpl<InstallmentApplyDgDto, InstallmentApplyDgEo, IInstallmentApplyDgDomain>
implements IInstallmentApplyDgService {
    @Resource
    private IDgOrgCustomerRelationService dgOrgCustomerRelationService;
    @Resource
    private CustomerRelationHelper customerRelationHelper;

    public InstallmentApplyDgServiceImpl(IInstallmentApplyDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InstallmentApplyDgDto, InstallmentApplyDgEo> converter() {
        return InstallmentApplyDgConverter.INSTANCE;
    }

    @Override
    public PageInfo<InstallmentPlanFollowRespDto> installmentPlanFollowPage(InstallmentPlanFollowReqDto dto) {
        List list;
        HashSet customerIds;
        HashSet shopIds;
        List<CsOrgCustomerRelationExtDto> relationExtDtoList;
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (CollectionUtil.isNotEmpty((Collection)dto.getRegionIdList()) && CollectionUtil.isNotEmpty(relationExtDtoList = this.customerRelationHelper.getBusinessAreaList(dto.getRegionIdList()))) {
            shopIds = Sets.newHashSet();
            customerIds = Sets.newHashSet();
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList) {
                customerIds.add(csOrgCustomerRelationExtDto.getCustomerId());
                shopIds.add(csOrgCustomerRelationExtDto.getShopId());
            }
            dto.setCustomerIdList((List)Lists.newArrayList((Iterable)customerIds));
            if (CollectionUtil.isNotEmpty((Collection)dto.getShopIdList())) {
                dto.getShopIdList().addAll(shopIds);
            } else {
                dto.setShopIdList((List)Lists.newArrayList((Iterable)shopIds));
            }
        }
        if (CollectionUtil.isEmpty((Collection)(list = ((IInstallmentApplyDgDomain)this.domain).installmentPlanFollowPage(dto)))) {
            return new PageInfo();
        }
        shopIds = Sets.newHashSet();
        customerIds = Sets.newHashSet();
        for (InstallmentPlanFollowRespDto installmentPlanFollowRespDto : list) {
            shopIds.add(installmentPlanFollowRespDto.getShopId());
            customerIds.add(installmentPlanFollowRespDto.getCustomerId());
        }
        List<CsOrgCustomerRelationExtDto> relationExtDtoList2 = this.customerRelationHelper.getByCustomerIdAndShopId(shopIds, customerIds);
        if (CollectionUtil.isNotEmpty(relationExtDtoList2)) {
            Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel = this.customerRelationHelper.getMapAreaLevel(relationExtDtoList2);
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList2) {
                if (!mapAreaLevel.containsKey(csOrgCustomerRelationExtDto.getAreaId())) continue;
                List<DgBusinessAreaLevelDto> areaLevelDtoList = mapAreaLevel.get(csOrgCustomerRelationExtDto.getAreaId());
                String regionName = this.customerRelationHelper.getRegionName(areaLevelDtoList);
                for (InstallmentPlanFollowRespDto installmentPlanFollowRespDto : list) {
                    if (!csOrgCustomerRelationExtDto.getCustomerId().equals(installmentPlanFollowRespDto.getCustomerId()) || !csOrgCustomerRelationExtDto.getShopId().equals(installmentPlanFollowRespDto.getShopId())) continue;
                    installmentPlanFollowRespDto.setRegionName(regionName);
                }
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Override
    public <T> void fillAreaName(List<T> list, Function<T, Long> regionIdExtractor, BiConsumer<T, String> regionName) {
        if (CollectionUtil.isNotEmpty(list)) {
            Set regionIds = list.stream().map(regionIdExtractor).collect(Collectors.toSet());
            Map<Long, List<DgBusinessAreaLevelDto>> areaLevelMap = this.dgOrgCustomerRelationService.mapAreaLevel(Lists.newArrayList(regionIds));
            for (T item : list) {
                List<DgBusinessAreaLevelDto> areaLevelDtoList;
                List nameList;
                Long regionId = regionIdExtractor.apply(item);
                if (!areaLevelMap.containsKey(regionId) || !CollectionUtil.isNotEmpty((Collection)areaLevelMap.get(regionId)) || !CollectionUtil.isNotEmpty(nameList = (areaLevelDtoList = areaLevelMap.get(regionId)).stream().filter(Objects::nonNull).map(DgBusinessAreaLevelDto::getName).collect(Collectors.toList()))) continue;
                String join = String.join((CharSequence)"/", nameList);
                regionName.accept(item, join);
            }
        }
    }

    @Override
    public PageInfo<InstallmentApplyDgDto> pageQuery(InstallmentApplyDgPageReqDto dto) {
        List list;
        HashSet customerIds;
        HashSet shopIds;
        List<CsOrgCustomerRelationExtDto> relationExtDtoList;
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        if (CollectionUtil.isNotEmpty((Collection)dto.getRegionIdList()) && CollectionUtil.isNotEmpty(relationExtDtoList = this.customerRelationHelper.getBusinessAreaList(dto.getRegionIdList()))) {
            shopIds = Sets.newHashSet();
            customerIds = Sets.newHashSet();
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList) {
                customerIds.add(csOrgCustomerRelationExtDto.getCustomerId());
                shopIds.add(csOrgCustomerRelationExtDto.getShopId());
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getShopIdList())) {
                dto.getShopIdList().addAll(shopIds);
            } else {
                dto.setShopIdList((List)Lists.newArrayList((Iterable)shopIds));
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getCustomerIds())) {
                dto.getCustomerIds().addAll(customerIds);
            } else {
                dto.setCustomerIds((List)Lists.newArrayList((Iterable)customerIds));
            }
        }
        if (CollectionUtil.isEmpty((Collection)(list = ((IInstallmentApplyDgDomain)this.domain).pageQuery(dto)))) {
            return new PageInfo();
        }
        shopIds = Sets.newHashSet();
        customerIds = Sets.newHashSet();
        for (InstallmentApplyDgDto installmentApplyDgDto : list) {
            shopIds.add(installmentApplyDgDto.getShopId());
            customerIds.add(installmentApplyDgDto.getCustomerId());
        }
        List<CsOrgCustomerRelationExtDto> relationExtDtoList2 = this.customerRelationHelper.getByCustomerIdAndShopId(shopIds, customerIds);
        if (CollectionUtil.isNotEmpty(relationExtDtoList2)) {
            Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel = this.customerRelationHelper.getMapAreaLevel(relationExtDtoList2);
            for (CsOrgCustomerRelationExtDto csOrgCustomerRelationExtDto : relationExtDtoList2) {
                if (!mapAreaLevel.containsKey(csOrgCustomerRelationExtDto.getAreaId())) continue;
                List<DgBusinessAreaLevelDto> areaLevelDtoList = mapAreaLevel.get(csOrgCustomerRelationExtDto.getAreaId());
                String regionName = this.customerRelationHelper.getRegionName(areaLevelDtoList);
                for (InstallmentApplyDgDto installmentApplyDgDto : list) {
                    if (!csOrgCustomerRelationExtDto.getCustomerId().equals(installmentApplyDgDto.getCustomerId()) || !csOrgCustomerRelationExtDto.getShopId().equals(installmentApplyDgDto.getShopId())) continue;
                    installmentApplyDgDto.setRegionName(regionName);
                }
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }
}

