/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.constant.AfterSaleOrderSourceEnum;
import com.yunxi.dg.base.center.report.api.constant.ExchangeDeliveryStatus;
import com.yunxi.dg.base.center.report.api.constant.ExchangeOrderStatus;
import com.yunxi.dg.base.center.report.api.constant.ExchangeWarehousingStatus;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformExchangeOrderDomain;
import com.yunxi.dg.base.center.report.dto.trade.req.DgPerformExchangeOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgPerformExchangeOrderPageRespDto;
import com.yunxi.dg.base.center.report.service.entity.IDgExchangeOrderService;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgExchangeOrderServiceImpl
implements IDgExchangeOrderService {
    private static final Logger log = LoggerFactory.getLogger(DgExchangeOrderServiceImpl.class);
    @Resource
    private IDgPerformExchangeOrderDomain dgPerformExchangeOrderDomain;

    @Override
    public PageInfo<DgPerformExchangeOrderPageRespDto> queryPage(DgPerformExchangeOrderPageReqDto reqDto) {
        log.info("\u6362\u8d27\u5355\u5217\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo pageInfo = this.dgPerformExchangeOrderDomain.queryPage(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(dto -> {
                if (StringUtils.isNotBlank((CharSequence)dto.getOrderStatus()) && ObjectUtil.isNotEmpty((Object)ExchangeOrderStatus.forCode((String)dto.getOrderStatus()))) {
                    dto.setOrderStatusStr(ExchangeOrderStatus.forCode((String)dto.getOrderStatus()).getDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getWarehousingStatus()) && ObjectUtil.isNotEmpty((Object)ExchangeWarehousingStatus.forCode((String)dto.getWarehousingStatus()))) {
                    dto.setWarehousingStatusStr(ExchangeWarehousingStatus.forCode((String)dto.getWarehousingStatus()).getDesc());
                }
                if (ObjectUtil.isNotEmpty((Object)dto.getOrderSource()) && ObjectUtil.isNotEmpty((Object)AfterSaleOrderSourceEnum.enumOf((Integer)dto.getOrderSource()))) {
                    dto.setOrderSourceStr(AfterSaleOrderSourceEnum.enumOf((Integer)dto.getOrderSource()).getDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getDeliveryStatus()) && ObjectUtil.isNotEmpty((Object)ExchangeDeliveryStatus.forCode((String)dto.getDeliveryStatus()))) {
                    dto.setDeliveryStatusStr(ExchangeDeliveryStatus.forCode((String)dto.getDeliveryStatus()).getDesc());
                }
            });
        }
        return pageInfo;
    }
}

