/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.FinishProductWarehouseInventoryReportConverter;
import com.yunxi.dg.base.center.report.domain.entity.IFinishProductWarehouseInventoryReportDomain;
import com.yunxi.dg.base.center.report.dto.entity.FinishProductWarehouseInventoryReportDto;
import com.yunxi.dg.base.center.report.dto.entity.FinishProductWarehouseInventoryReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.eo.FinishProductWarehouseInventoryReportEo;
import com.yunxi.dg.base.center.report.service.entity.IFinishProductWarehouseInventoryReportService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinishProductWarehouseInventoryReportServiceImpl
extends BaseServiceImpl<FinishProductWarehouseInventoryReportDto, FinishProductWarehouseInventoryReportEo, IFinishProductWarehouseInventoryReportDomain>
implements IFinishProductWarehouseInventoryReportService {
    private static final Logger log = LoggerFactory.getLogger(FinishProductWarehouseInventoryReportServiceImpl.class);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public FinishProductWarehouseInventoryReportServiceImpl(IFinishProductWarehouseInventoryReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<FinishProductWarehouseInventoryReportDto, FinishProductWarehouseInventoryReportEo> converter() {
        return FinishProductWarehouseInventoryReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> ((IFinishProductWarehouseInventoryReportDomain)this.domain).getSourceMinUpdateTime());
        dto.syncByStep("\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS", this::doSyncInternal);
    }

    private void doSyncInternal(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        ((IFinishProductWarehouseInventoryReportDomain)this.domain).physicsDeleteBySourceUpdateTime(startTime, endTime);
        int pageNum = 1;
        int pageSize = 1000;
        do {
            PageInfo page = ((IFinishProductWarehouseInventoryReportDomain)this.domain).pageSourceByUpdateTime(startTime, endTime, pageNum, pageSize);
            log.info("\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS\u540c\u6b65: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            if (list == null || list.isEmpty()) continue;
            this.doSyncInternal(list);
        } while (hasNextPage);
    }

    private void doSyncInternal(List<FinishProductWarehouseInventoryReportEo> list) {
        List sourceIds = list.stream().map(FinishProductWarehouseInventoryReportEo::getSourceId).distinct().collect(Collectors.toList());
        list.removeIf(eo -> eo.getDr().equals(1));
        log.info("\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e {}", sourceIds);
        ((IFinishProductWarehouseInventoryReportDomain)this.domain).physicsDeleteBySourceIds(sourceIds);
        log.info("\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS\u540c\u6b65: \u5220\u9664\u76f8\u5173\u7684\u65e7\u6570\u636e\u5b8c\u6210");
        log.info("\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e", (Object)list.size());
        ((IFinishProductWarehouseInventoryReportDomain)this.domain).insertBatch(list);
        log.info("\u6210\u54c1\u4ed3\u5206\u5185\u5916\u4ed3\u76d8\u70b9\u62a5\u8868-WMS\u540c\u6b65: \u51c6\u5907\u4fdd\u5b58 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
    }

    @Override
    public PageInfo<FinishProductWarehouseInventoryReportDto> page(FinishProductWarehouseInventoryReportPageReqDto dto) {
        return PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> ((IFinishProductWarehouseInventoryReportDomain)this.domain).queryList(dto));
    }

    @Override
    public LocalDateTime getLastOrderUpdateTime() {
        return ((IFinishProductWarehouseInventoryReportDomain)this.domain).getLastOrderUpdateTime();
    }
}

