/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.price.dto.dto.PriceControlTableDto;
import com.yunxi.dg.base.center.price.dto.request.PriceControlTablePageReqDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceControlTableApiProxy;
import com.yunxi.dg.base.center.report.constants.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.report.constants.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.report.constants.StatisticalObjEnum;
import com.yunxi.dg.base.center.report.constants.TransportStyleEnum;
import com.yunxi.dg.base.center.report.convert.entity.ShipmentInfoConverter;
import com.yunxi.dg.base.center.report.dao.das.IOrderLabelItemDas;
import com.yunxi.dg.base.center.report.dao.das.IOrderLabelRecordDas;
import com.yunxi.dg.base.center.report.dao.das.IOrderTagRecordDas;
import com.yunxi.dg.base.center.report.dao.das.IShipmentAddrDas;
import com.yunxi.dg.base.center.report.domain.account.IAccountTypeDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgLogisticsInfoDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.report.domain.entity.IOrderLabelDomain;
import com.yunxi.dg.base.center.report.domain.entity.IOrderLabelItemDomain;
import com.yunxi.dg.base.center.report.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.report.domain.es.IEsPerformOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutNoticeOrderDomain;
import com.yunxi.dg.base.center.report.domain.rebate.IBillOrderDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgBusinessAuditDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformNoticeSyncRecordShippingDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.report.dto.account.constant.VoucherTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.BizTagDto;
import com.yunxi.dg.base.center.report.dto.entity.DgLogisticsInfoDto;
import com.yunxi.dg.base.center.report.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.report.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.report.dto.entity.SaleOrderBillRecordDto;
import com.yunxi.dg.base.center.report.dto.entity.ShipmentAddrDto;
import com.yunxi.dg.base.center.report.dto.entity.ShipmentInfoDto;
import com.yunxi.dg.base.center.report.dto.shipment.request.PerformOrderReportReqDto;
import com.yunxi.dg.base.center.report.dto.shipment.response.PerformOrderReportRespDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagPageReqDto;
import com.yunxi.dg.base.center.report.dto.trade.constant.DgSaleOrderItemRefundStatusEnum;
import com.yunxi.dg.base.center.report.dto.trade.req.DgEsPerformOrderReqDto;
import com.yunxi.dg.base.center.report.dto.trade.req.DgPerformOrderItemLatitudeReqDto;
import com.yunxi.dg.base.center.report.dto.trade.req.RebateOrderReqDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgEsAddressRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgEsPerformOrderRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgEsPerformOrderStatusCountRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgPerformOrderItemLatitudeRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgPerformOrderItemLineRespDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.RebateOrderRespDto;
import com.yunxi.dg.base.center.report.dto.trade.vo.OutNoticeResultJsonVo;
import com.yunxi.dg.base.center.report.enums.ItemLineReturnStatusEnum;
import com.yunxi.dg.base.center.report.eo.DgLogisticsInfoEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.report.eo.OrderLabelEo;
import com.yunxi.dg.base.center.report.eo.OrderLabelItemEo;
import com.yunxi.dg.base.center.report.eo.OrderLabelRecordEo;
import com.yunxi.dg.base.center.report.eo.OrderTagRecordEo;
import com.yunxi.dg.base.center.report.eo.ShipmentAddrEo;
import com.yunxi.dg.base.center.report.eo.ShipmentInfoEo;
import com.yunxi.dg.base.center.report.eo.account.AccountTypeEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgLogicWarehouseEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutNoticeOrderEo;
import com.yunxi.dg.base.center.report.eo.rebate.BillOrderEo;
import com.yunxi.dg.base.center.report.eo.trade.DgBusinessAuditEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformNoticeSyncRecordEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformNoticeSyncRecordShippingEo;
import com.yunxi.dg.base.center.report.eo.trade.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.report.service.entity.IBizTagService;
import com.yunxi.dg.base.center.report.service.entity.IDgLogisticsInfoService;
import com.yunxi.dg.base.center.report.service.entity.IPerformOrderInfoService;
import com.yunxi.dg.base.center.report.service.finance.IKeepAccountingService;
import com.yunxi.dg.base.center.report.utils.RequestUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PerformOrderInfoServiceImpl
extends BaseServiceImpl<ShipmentInfoDto, ShipmentInfoEo, IPerformOrderInfoDomain>
implements IPerformOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(PerformOrderInfoServiceImpl.class);
    @Resource
    private IShipmentAddrDas shipmentAddrDas;
    @Resource
    private IOrderTagRecordDas orderTagRecordDas;
    @Resource
    private IOrderLabelRecordDas orderLabelRecordDas;
    @Resource
    private IOrderLabelItemDas orderLabelItemDas;
    @Resource
    private IEsPerformOrderDomain esPerformOrderDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderItemDomain dgPerformOrderItemDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IAccountTypeDomain accountTypeDomain;
    @Resource
    private IBillOrderDomain billOrderDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain dgPerformOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgBusinessAuditDomain dgBusinessAuditDomain;
    @Resource
    private IDgPerformNoticeSyncRecordDomain performNoticeSyncRecordDomain;
    @Resource
    private IDgPerformNoticeSyncRecordShippingDomain performNoticeSyncRecordShippingDomain;
    @Resource
    private IDgLogisticsInfoDomain logisticsInfoDomain;
    @Resource
    private IDgOutNoticeOrderDomain noticeOrderDomain;
    @Resource
    private IKeepAccountingService accountingService;
    @Resource
    private IOrderLabelItemDomain orderLabelItemDomain;
    @Resource
    private IOrderLabelDomain orderLabelDomain;
    @Resource
    private IDgPriceControlTableApiProxy dgPriceControlTableApiProxy;
    @Resource
    private IDgLogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IBizTagService bizTagService;
    @Resource
    private IDgLogisticsInfoService dgLogisticsInfoService;

    public PerformOrderInfoServiceImpl(IPerformOrderInfoDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ShipmentInfoDto, ShipmentInfoEo> converter() {
        return ShipmentInfoConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<PerformOrderReportRespDto>> queryReportVoByPage(PerformOrderReportReqDto filter) {
        String[] orderNo;
        if (!StringUtils.isEmpty((CharSequence)filter.getSaleOrderStatus())) {
            filter.setSaleOrderStatusList(Arrays.asList(filter.getSaleOrderStatus().split(",")));
        }
        if (!StringUtils.isEmpty((CharSequence)filter.getOrderNo()) && (orderNo = filter.getOrderNo().split(",")).length != 1) {
            filter.setOrderNos(Arrays.asList(orderNo));
            filter.setOrderNo(null);
        }
        Page shipmentReportDtos = ((IPerformOrderInfoDomain)this.domain).queryEsVoByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)shipmentReportDtos, (String[])new String[]{"list", "navigatepageNums"});
        List saleOrderRespVoList = shipmentReportDtos.getResult();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)saleOrderRespVoList)) {
            List ids = saleOrderRespVoList.stream().map(PerformOrderReportRespDto::getId).collect(Collectors.toList());
            Map<Object, Object> saleOrderAddrEoMap = new HashMap();
            LambdaQueryWrapper addrWrapper = new LambdaQueryWrapper();
            addrWrapper.in(ShipmentAddrEo::getShipmentId, ids);
            addrWrapper.eq(BaseEo::getDr, (Object)0);
            List saleOrderAddrEos = this.shipmentAddrDas.getMapper().selectList((Wrapper)addrWrapper);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)saleOrderAddrEos)) {
                saleOrderAddrEoMap = saleOrderAddrEos.stream().collect(Collectors.toMap(ShipmentAddrEo::getShipmentId, Function.identity()));
            }
            Map<Object, Object> orderTagRecordEoMap = new HashMap();
            LambdaQueryWrapper tagRecordWrapper = new LambdaQueryWrapper();
            tagRecordWrapper.in(OrderTagRecordEo::getShipmentId, ids);
            tagRecordWrapper.eq(BaseEo::getDr, (Object)0);
            List orderTagRecordEos = this.orderTagRecordDas.getMapper().selectList((Wrapper)tagRecordWrapper);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderTagRecordEos)) {
                orderTagRecordEoMap = orderTagRecordEos.stream().collect(Collectors.groupingBy(OrderTagRecordEo::getShipmentId));
            }
            Map<Object, Object> orderLabelRecordEoMap = new HashMap();
            LambdaQueryWrapper labelRecordWrapper = new LambdaQueryWrapper();
            labelRecordWrapper.in(OrderLabelRecordEo::getOrderId, ids);
            labelRecordWrapper.eq(BaseEo::getDr, (Object)0);
            List orderLabelRecordEos = this.orderLabelRecordDas.getMapper().selectList((Wrapper)labelRecordWrapper);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderLabelRecordEos)) {
                orderLabelRecordEoMap = orderLabelRecordEos.stream().collect(Collectors.groupingBy(OrderLabelRecordEo::getOrderId));
            }
            Map<Object, Object> orderLabelItemEoMap = new HashMap();
            LambdaQueryWrapper labelItemWrapper = new LambdaQueryWrapper();
            labelItemWrapper.in(OrderLabelItemEo::getOrderId, ids);
            labelItemWrapper.eq(BaseEo::getDr, (Object)0);
            List orderLabelItemEos = this.orderLabelItemDas.getMapper().selectList((Wrapper)labelItemWrapper);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderLabelItemEos)) {
                orderLabelItemEoMap = orderLabelItemEos.stream().collect(Collectors.groupingBy(OrderLabelItemEo::getOrderId));
            }
            for (PerformOrderReportRespDto dto : saleOrderRespVoList) {
                List labelRecordEos;
                List tagRecordEos;
                ShipmentAddrEo saleOrderAddrEo = (ShipmentAddrEo)saleOrderAddrEoMap.get(dto.getId());
                if (Objects.nonNull(saleOrderAddrEo)) {
                    ShipmentAddrDto shipmentAddrDto = new ShipmentAddrDto();
                    CubeBeanUtils.copyProperties((Object)shipmentAddrDto, (Object)saleOrderAddrEo, (String[])new String[0]);
                    dto.setDeliveryName(saleOrderAddrEo.getReceiveName());
                    dto.setDeliveryPhone(saleOrderAddrEo.getReceivePhone());
                    dto.setShipmentAddrDto(shipmentAddrDto);
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(tagRecordEos = (List)orderTagRecordEoMap.get(dto.getId())))) {
                    dto.setOrderTagCodes(tagRecordEos.stream().map(OrderTagRecordEo::getTagCode).distinct().collect(Collectors.toList()));
                }
                ArrayList labelCodes = new ArrayList();
                List labelItemEos = (List)orderLabelItemEoMap.get(dto.getId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)labelItemEos)) {
                    labelCodes.addAll(labelItemEos.stream().map(OrderLabelItemEo::getLabelCode).distinct().collect(Collectors.toList()));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(labelRecordEos = (List)orderLabelRecordEoMap.get(dto.getId())))) {
                    labelCodes.addAll(labelRecordEos.stream().map(OrderLabelRecordEo::getLabelCode).distinct().collect(Collectors.toList()));
                }
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(labelCodes)) continue;
                dto.setOrderLabelCodes(labelCodes);
            }
            respDtoPageInfo.setList(saleOrderRespVoList);
        }
        return new RestResponse((Object)respDtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<DgEsPerformOrderRespDto>> queryEsByPage(DgEsPerformOrderReqDto filter) {
        String mallMode = RequestUtil.getHeader("mallMode");
        if ("B2B".equals(mallMode) && StringUtils.isBlank((CharSequence)filter.getCustomerCode())) {
            return new RestResponse((Object)new PageInfo());
        }
        PageInfo pageInfo = this.esPerformOrderDomain.queryEsByPage(filter);
        logger.info("\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)filter));
        List pageInfoList = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)pageInfoList)) {
            logger.info("\u67e5\u8be2ES\u8ba2\u8d27\u5355\u5217\u8868\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        if (CollUtil.isNotEmpty((Collection)pageInfoList)) {
            int pageSizeLog = 11;
            if (pageInfoList.size() < pageSizeLog) {
                logger.info("\u67e5\u8be2ES\u8ba2\u8d27\u5355\u5217\u8868\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pageInfoList));
            } else {
                logger.info("\u67e5\u8be2ES\u8ba2\u8d27\u5355\u5217\u8868\uff0c\u672c\u6b21\u8fd4\u56de\u6570\u636e\u91cf\uff1a{} \u6761", (Object)pageInfoList.size());
            }
            List<String> businessNos = pageInfo.getList().stream().map(DgEsPerformOrderRespDto::getSaleOrderNo).distinct().collect(Collectors.toList());
            Map<String, String> invoiceStatusMap = this.getInvoiceStatusBySaleOrderNo(businessNos);
            Map<String, Date> signTimeMap = this.dgLogisticsInfoService.getLogisticsSignTimeMap(businessNos);
            pageInfo.getList().forEach(v -> {
                if (StrUtil.isNotBlank((CharSequence)((CharSequence)invoiceStatusMap.get(v.getSaleOrderNo())))) {
                    v.setWhetherInvoice((String)invoiceStatusMap.get(v.getSaleOrderNo()));
                }
                v.setDeliveryAccounting(Objects.nonNull(v.getDeliveryKeepStatus()) ? "ACCOUNTED" : "UNACCOUNTED");
                v.setBillingAccounting(Objects.nonNull(v.getBillingKeepStatus()) ? "ACCOUNTED" : "UNACCOUNTED");
                if ("REACHABLE".equals(v.getDeliveryAddressCheck())) {
                    v.setUnreachableCause("");
                }
                Optional.ofNullable(v.getOrderLabelCodes()).ifPresent(codes -> {
                    if (codes.contains("LOCK")) {
                        v.setLockStatus(Integer.valueOf(1));
                    }
                });
                Date logisticsSignTime = (Date)signTimeMap.get(v.getSaleOrderNo());
                if (logisticsSignTime != null) {
                    v.setLogisticsSignTime(logisticsSignTime);
                }
            });
        }
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public PageInfo<DgPerformOrderItemLineRespDto> queryByDetailPage(DgEsPerformOrderReqDto filter) {
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.queryEsByPage(filter));
        if (pageInfo == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        PageInfo<DgPerformOrderItemLineRespDto> dtoPageInfo = this.queryDgPerformOrderItemLineRespDtoPageInfo(filter, (PageInfo<DgEsPerformOrderRespDto>)pageInfo);
        return dtoPageInfo;
    }

    private PageInfo<DgPerformOrderItemLineRespDto> queryDgPerformOrderItemLineRespDtoPageInfo(DgEsPerformOrderReqDto filter, PageInfo<DgEsPerformOrderRespDto> pageInfo) {
        logger.info("\u5f53\u524d\u67e5\u8be2es\u6570\u636e,pageNum:{},pageSize:{},\u8fd4\u56de\u6570\u91cf:{}", new Object[]{filter.getPageNum(), filter.getPageSize(), pageInfo.getList().size()});
        List orderIds = pageInfo.getList().stream().map(DgEsPerformOrderRespDto::getId).collect(Collectors.toList());
        LambdaQueryWrapper performOrderLineQuery = new LambdaQueryWrapper();
        performOrderLineQuery.in(DgPerformOrderLineEo::getOrderId, orderIds);
        performOrderLineQuery.eq(BaseEo::getDr, (Object)0);
        List performOrderLineEos = this.dgPerformOrderLineDomain.getMapper().selectList((Wrapper)performOrderLineQuery);
        Map<Long, List<DgPerformOrderLineEo>> orderLineMap = performOrderLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineEo::getOrderId));
        List orderLineIds = performOrderLineEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        Map<String, String> orderLabelMap = this.orderLabelDomain.filter().list().stream().collect(Collectors.toMap(OrderLabelEo::getLabelCode, OrderLabelEo::getLabelAbbr));
        ReBizTagPageReqDto pageReqDto = new ReBizTagPageReqDto();
        pageReqDto.setPageNum(Integer.valueOf(1));
        pageReqDto.setPageSize(Integer.valueOf(999));
        pageReqDto.setTagGroupCode("ORDER");
        Map<String, String> tagNameMap = this.bizTagService.queryByPage(pageReqDto).getList().stream().collect(Collectors.toMap(BizTagDto::getTagCode, BizTagDto::getTagName));
        HashMap<String, String> warehouseCode2NameMap = new HashMap<String, String>();
        Set warehouseCodes = pageInfo.getList().stream().map(DgEsPerformOrderRespDto::getDeliveryLogicalWarehouseCode).collect(Collectors.toSet());
        List warehouseCodeList = CollUtil.split(warehouseCodes, (int)500);
        for (List wcs : warehouseCodeList) {
            Map<String, String> warehouseMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", (Collection)wcs)).eq((Object)"dr", (Object)0)).list().stream().collect(Collectors.toMap(DgLogicWarehouseEo::getWarehouseCode, DgLogicWarehouseEo::getWarehouseName));
            warehouseCode2NameMap.putAll(warehouseMap);
        }
        ConcurrentHashMap orderLabelItemMap = new ConcurrentHashMap();
        ConcurrentHashMap orderLineAmountMap = new ConcurrentHashMap();
        ConcurrentHashMap afsOrderItemLineMap = new ConcurrentHashMap();
        ConcurrentHashMap priceMap = new ConcurrentHashMap();
        ConcurrentHashMap snMap = new ConcurrentHashMap();
        ConcurrentHashMap refundInterceptStatusMap = new ConcurrentHashMap();
        ServiceContext mainContext = ServiceContext.getContext();
        List orderLineIdList = CollUtil.split(orderLineIds, (int)500);
        List<CompletableFuture> futures = orderLineIdList.stream().map(batch -> CompletableFuture.runAsync(() -> {
            ServiceContext asyncContext = ServiceContext.getContext();
            mainContext.getKeys().forEach((arg_0, arg_1) -> ((ServiceContext)asyncContext).set(arg_0, arg_1));
            this.fetchData((List<Long>)batch, orderLabelMap, orderLabelItemMap, afsOrderItemLineMap, orderLineAmountMap, priceMap, snMap, refundInterceptStatusMap);
        })).collect(Collectors.toList());
        CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        allOf.join();
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<DgPerformOrderItemLineRespDto> resultList = new ArrayList<DgPerformOrderItemLineRespDto>();
        for (DgEsPerformOrderRespDto orderRespDto : pageInfo.getList()) {
            List<DgPerformOrderLineEo> dgPerformOrderLineEos = orderLineMap.get(orderRespDto.getId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(dgPerformOrderLineEos)) continue;
            String warehouseName = (String)warehouseCode2NameMap.get(orderRespDto.getDeliveryLogicalWarehouseCode());
            for (DgPerformOrderLineEo lineEo : dgPerformOrderLineEos) {
                PriceControlTableDto priceControlTableDto;
                DgPerformOrderItemLineRespDto respDto = (DgPerformOrderItemLineRespDto)BeanUtil.copyProperties((Object)orderRespDto, DgPerformOrderItemLineRespDto.class, (String[])new String[0]);
                respDto.setSaleOrderId(orderRespDto.getId());
                BeanUtil.copyProperties((Object)lineEo, (Object)respDto, (String[])new String[]{"platformOrderNo"});
                respDto.setLineId(lineEo.getId());
                if (lineEo.getBillingAccountingNum() != null) {
                    respDto.setBillingAccountingNum(lineEo.getBillingAccountingNum().setScale(0, 1).toPlainString());
                }
                if (lineEo.getDeliveryAccountingNum() != null) {
                    respDto.setDeliveryAccountingNum(lineEo.getDeliveryAccountingNum().setScale(0, 1).toPlainString());
                }
                respDto.setDeliveryLogicalWarehouseName(warehouseName);
                Optional.ofNullable(orderLabelItemMap.get(lineEo.getId())).ifPresent(arg_0 -> ((DgPerformOrderItemLineRespDto)respDto).setLabelName(arg_0));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderRespDto.getOrderTagCodes())) {
                    String tagName = orderRespDto.getOrderTagCodes().stream().map(tagNameMap::get).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.joining(","));
                    respDto.setOrderTagListString(tagName);
                }
                Optional.ofNullable(snMap.get(lineEo.getId())).ifPresent(arg_0 -> ((DgPerformOrderItemLineRespDto)respDto).setSnCode(arg_0));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderRespDto.getShipmentEnterpriseName())) {
                    respDto.setShipmentEnterpriseNameString(String.join((CharSequence)",", orderRespDto.getShipmentEnterpriseName()));
                }
                if (orderRespDto.getOrderAddress() != null) {
                    DgEsAddressRespDto orderAddress = orderRespDto.getOrderAddress();
                    respDto.setOrderAddressProvince(orderAddress.getProvince());
                    respDto.setOrderAddressCity(orderAddress.getCity());
                    respDto.setOrderAddressCounty(orderAddress.getCounty());
                    respDto.setOrderAddressDetail(orderAddress.getDetailAddress());
                }
                if ((priceControlTableDto = (PriceControlTableDto)priceMap.get(lineEo.getId())) != null) {
                    respDto.setControlPrice(priceControlTableDto.getControlPrice());
                    respDto.setCheckResult(priceControlTableDto.getCheckResult());
                }
                List dgPerformOrderItemLineEos = (List)orderLineAmountMap.get(lineEo.getId());
                this.bindAmount(respDto, dgPerformOrderItemLineEos);
                List lineEos = (List)afsOrderItemLineMap.get(lineEo.getId());
                this.buildAfsSummary(respDto, lineEos);
                respDto.setRefundedItemNum(respDto.getRefundedItemNumber().setScale(0, 1).toPlainString());
                respDto.setRefundInterceptStatus((String)refundInterceptStatusMap.get(lineEo.getId()));
                resultList.add(respDto);
            }
        }
        dtoPageInfo.setList(resultList);
        return dtoPageInfo;
    }

    private PageInfo<DgPerformOrderItemLineRespDto> queryDgPerformOrderItemLineSimpleRespDtoPageInfo(DgEsPerformOrderReqDto filter, PageInfo<DgEsPerformOrderRespDto> pageInfo) {
        logger.info("\u5f53\u524d\u67e5\u8be2es\u6570\u636e,pageNum:{},pageSize:{},\u8fd4\u56de\u6570\u91cf:{}", new Object[]{filter.getPageNum(), filter.getPageSize(), pageInfo.getList().size()});
        List<Long> orderIds = pageInfo.getList().stream().map(DgEsPerformOrderRespDto::getId).collect(Collectors.toList());
        Map<Long, String> orderNoMaps = pageInfo.getList().stream().collect(Collectors.toMap(DgEsPerformOrderRespDto::getId, DgEsPerformOrderRespDto::getSaleOrderNo));
        LambdaQueryWrapper performOrderLineQuery = new LambdaQueryWrapper();
        performOrderLineQuery.in(DgPerformOrderLineEo::getOrderId, orderIds);
        performOrderLineQuery.eq(BaseEo::getDr, (Object)0);
        List performOrderLineEos = this.dgPerformOrderLineDomain.getMapper().selectList((Wrapper)performOrderLineQuery);
        Map<Long, List<DgPerformOrderLineEo>> orderLineMap = performOrderLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineEo::getOrderId));
        List orderLineIds = performOrderLineEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        Map<String, String> orderLabelMap = this.orderLabelDomain.filter().list().stream().collect(Collectors.toMap(OrderLabelEo::getLabelCode, OrderLabelEo::getLabelAbbr));
        ReBizTagPageReqDto pageReqDto = new ReBizTagPageReqDto();
        pageReqDto.setPageNum(Integer.valueOf(1));
        pageReqDto.setPageSize(Integer.valueOf(999));
        pageReqDto.setTagGroupCode("ORDER");
        Map<String, String> tagNameMap = this.bizTagService.queryByPage(pageReqDto).getList().stream().collect(Collectors.toMap(BizTagDto::getTagCode, BizTagDto::getTagName));
        HashMap<String, String> warehouseCode2NameMap = new HashMap<String, String>();
        Set warehouseCodes = pageInfo.getList().stream().map(DgEsPerformOrderRespDto::getDeliveryLogicalWarehouseCode).collect(Collectors.toSet());
        List warehouseCodeList = CollUtil.split(warehouseCodes, (int)500);
        for (List wcs : warehouseCodeList) {
            Map<String, String> warehouseMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", (Collection)wcs)).eq((Object)"dr", (Object)0)).list().stream().collect(Collectors.toMap(DgLogicWarehouseEo::getWarehouseCode, DgLogicWarehouseEo::getWarehouseName));
            warehouseCode2NameMap.putAll(warehouseMap);
        }
        ConcurrentHashMap orderLabelItemMap = new ConcurrentHashMap();
        ConcurrentHashMap orderLineAmountMap = new ConcurrentHashMap();
        ConcurrentHashMap afsOrderItemLineMap = new ConcurrentHashMap();
        ConcurrentHashMap normalItemLineMap = new ConcurrentHashMap();
        ConcurrentHashMap<String, List<DgLogisticsInfoEo>> noticeShippingRecordMap = new ConcurrentHashMap<String, List<DgLogisticsInfoEo>>();
        ConcurrentHashMap priceMap = new ConcurrentHashMap();
        ConcurrentHashMap snMap = new ConcurrentHashMap();
        ConcurrentHashMap refundInterceptStatusMap = new ConcurrentHashMap();
        ServiceContext mainContext = ServiceContext.getContext();
        List orderLineIdList = CollUtil.split(orderLineIds, (int)500);
        List<CompletableFuture> futures = orderLineIdList.stream().map(batch -> CompletableFuture.runAsync(() -> {
            ServiceContext asyncContext = ServiceContext.getContext();
            mainContext.getKeys().forEach((arg_0, arg_1) -> ((ServiceContext)asyncContext).set(arg_0, arg_1));
            this.fetchSimpleLineData((List<Long>)batch, orderLabelMap, orderLabelItemMap, afsOrderItemLineMap, orderLineAmountMap, priceMap, snMap, refundInterceptStatusMap, normalItemLineMap);
        })).collect(Collectors.toList());
        CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        allOf.join();
        this.fetchSimpleLogisticsInfo(noticeShippingRecordMap, orderIds, orderNoMaps);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<DgPerformOrderItemLineRespDto> resultList = new ArrayList<DgPerformOrderItemLineRespDto>();
        for (DgEsPerformOrderRespDto orderRespDto : pageInfo.getList()) {
            List<DgPerformOrderLineEo> dgPerformOrderLineEos;
            List dgLogisticsInfoEos;
            if (noticeShippingRecordMap.containsKey(orderRespDto.getSaleOrderNo()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(dgLogisticsInfoEos = (List)noticeShippingRecordMap.get(orderRespDto.getSaleOrderNo())))) {
                ArrayList dgLogisticsInfoDtos = new ArrayList();
                CubeBeanUtils.copyCollection(dgLogisticsInfoDtos, (Collection)dgLogisticsInfoEos, DgLogisticsInfoDto.class);
                orderRespDto.setLogisticsInfoDtoList(dgLogisticsInfoDtos);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(dgPerformOrderLineEos = orderLineMap.get(orderRespDto.getId()))) continue;
            String warehouseName = (String)warehouseCode2NameMap.get(orderRespDto.getDeliveryLogicalWarehouseCode());
            for (DgPerformOrderLineEo lineEo : dgPerformOrderLineEos) {
                PriceControlTableDto priceControlTableDto;
                DgPerformOrderItemLineRespDto respDto = (DgPerformOrderItemLineRespDto)BeanUtil.copyProperties((Object)orderRespDto, DgPerformOrderItemLineRespDto.class, (String[])new String[0]);
                respDto.setSaleOrderId(orderRespDto.getId());
                BeanUtil.copyProperties((Object)lineEo, (Object)respDto, (String[])new String[]{"platformOrderNo"});
                respDto.setLineId(lineEo.getId());
                if (lineEo.getBillingAccountingNum() != null) {
                    respDto.setBillingAccountingNum(lineEo.getBillingAccountingNum().setScale(0, 1).toPlainString());
                }
                if (lineEo.getDeliveryAccountingNum() != null) {
                    respDto.setDeliveryAccountingNum(lineEo.getDeliveryAccountingNum().setScale(0, 1).toPlainString());
                }
                respDto.setDeliveryLogicalWarehouseName(warehouseName);
                Optional.ofNullable(orderLabelItemMap.get(lineEo.getId())).ifPresent(arg_0 -> ((DgPerformOrderItemLineRespDto)respDto).setLabelName(arg_0));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderRespDto.getOrderTagCodes())) {
                    String tagName = orderRespDto.getOrderTagCodes().stream().map(tagNameMap::get).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.joining(","));
                    respDto.setOrderTagListString(tagName);
                }
                Optional.ofNullable(snMap.get(lineEo.getId())).ifPresent(arg_0 -> ((DgPerformOrderItemLineRespDto)respDto).setSnCode(arg_0));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderRespDto.getShipmentEnterpriseName())) {
                    respDto.setShipmentEnterpriseNameString(String.join((CharSequence)",", orderRespDto.getShipmentEnterpriseName()));
                }
                if (orderRespDto.getOrderAddress() != null) {
                    DgEsAddressRespDto orderAddress = orderRespDto.getOrderAddress();
                    respDto.setOrderAddressProvince(orderAddress.getProvince());
                    respDto.setOrderAddressCity(orderAddress.getCity());
                    respDto.setOrderAddressCounty(orderAddress.getCounty());
                    respDto.setOrderAddressDetail(orderAddress.getDetailAddress());
                }
                if ((priceControlTableDto = (PriceControlTableDto)priceMap.get(lineEo.getId())) != null) {
                    respDto.setControlPrice(priceControlTableDto.getControlPrice());
                    respDto.setCheckResult(priceControlTableDto.getCheckResult());
                }
                List dgPerformOrderItemLineEos = (List)orderLineAmountMap.get(lineEo.getId());
                this.bindAmount(respDto, dgPerformOrderItemLineEos);
                List itemLineEos = (List)normalItemLineMap.get(lineEo.getId());
                this.buildDeliverySummary(respDto, itemLineEos);
                List lineEos = (List)afsOrderItemLineMap.get(lineEo.getId());
                this.buildAfsSummary(respDto, lineEos);
                respDto.setRefundedItemNum(respDto.getRefundedItemNumber().setScale(0, 1).toPlainString());
                respDto.setRefundInterceptStatus((String)refundInterceptStatusMap.get(lineEo.getId()));
                resultList.add(respDto);
            }
        }
        dtoPageInfo.setList(resultList);
        return dtoPageInfo;
    }

    private void buildDeliverySummary(DgPerformOrderItemLineRespDto orderLineDto, List<DgPerformOrderItemLineEo> lineEos) {
        BigDecimal outNum = null;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(lineEos)) {
            orderLineDto.setDeliveryTotalNum(BigDecimal.ZERO);
            outNum = BigDecimal.ZERO;
        } else {
            outNum = lineEos.stream().filter(ld -> Objects.equals("OUT", ld.getDistributionStatus())).map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            orderLineDto.setDeliveryTotalNum(outNum);
        }
        logger.info("\u8ba2\u5355\u884c {} \u5bf9\u5e94\u83b7\u53d6\u5230\u884c\u6570\u636e\u5927\u5c0f {} \u5df2\u51fa\u5e93\u6570\u91cf {}", new Object[]{orderLineDto.getLineId(), Optional.ofNullable(lineEos).map(List::size).orElse(0), outNum});
    }

    private void fetchSimpleLogisticsInfo(Map<String, List<DgLogisticsInfoEo>> noticeShippingRecordMap, List<Long> orderIds, Map<Long, String> orderNoMaps) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderIds)) {
            return;
        }
        List noticeSyncRecordShippingEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performNoticeSyncRecordShippingDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"order_id", orderIds)).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)noticeSyncRecordShippingEos)) {
            return;
        }
        Set consignmentNoSet = noticeSyncRecordShippingEos.stream().map(DgPerformNoticeSyncRecordShippingEo::getConsignmentNo).collect(Collectors.toSet());
        List dgLogisticsInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticsInfoDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"logistics_order_no", consignmentNoSet)).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dgLogisticsInfoEos)) {
            noticeShippingRecordMap.putAll(noticeSyncRecordShippingEos.stream().map(ld -> {
                DgLogisticsInfoEo eo = new DgLogisticsInfoEo();
                eo.setLogisticsOrderNo(ld.getConsignmentNo());
                eo.setBusinessOrderNo((String)orderNoMaps.get(ld.getOrderId()));
                eo.setLogisticsCompanyName(ld.getShippingCompany());
                eo.setLogisticsCompanyCode(ld.getShippingCompanyCode());
                return eo;
            }).collect(Collectors.groupingBy(DgLogisticsInfoEo::getBusinessOrderNo)));
        } else {
            noticeShippingRecordMap.putAll(noticeSyncRecordShippingEos.stream().map(ld -> {
                DgLogisticsInfoEo eo = new DgLogisticsInfoEo();
                eo.setLogisticsOrderNo(ld.getConsignmentNo());
                eo.setBusinessOrderNo((String)orderNoMaps.get(ld.getOrderId()));
                eo.setLogisticsCompanyName(ld.getShippingCompany());
                eo.setLogisticsCompanyCode(ld.getShippingCompanyCode());
                return eo;
            }).collect(Collectors.groupingBy(DgLogisticsInfoEo::getBusinessOrderNo)));
            Map<String, List<DgLogisticsInfoEo>> listMap = dgLogisticsInfoEos.stream().collect(Collectors.groupingBy(DgLogisticsInfoEo::getBusinessOrderNo));
            listMap.forEach((k, v) -> {
                if (noticeShippingRecordMap.containsKey(k)) {
                    List logisticsInfoEos = (List)noticeShippingRecordMap.get(k);
                    noticeShippingRecordMap.put((String)k, PerformOrderInfoServiceImpl.mergeLists(logisticsInfoEos, v));
                } else {
                    noticeShippingRecordMap.put((String)k, (List<DgLogisticsInfoEo>)v);
                }
            });
        }
    }

    private static List<DgLogisticsInfoEo> mergeLists(List<DgLogisticsInfoEo> a, List<DgLogisticsInfoEo> b) {
        ArrayList<DgLogisticsInfoEo> resultList = new ArrayList<DgLogisticsInfoEo>();
        resultList.addAll(b);
        Set codeSet = resultList.stream().map(DgLogisticsInfoEo::getLogisticsOrderNo).collect(Collectors.toSet());
        for (DgLogisticsInfoEo element : a) {
            if (codeSet.contains(element.getLogisticsOrderNo())) continue;
            resultList.add(element);
        }
        return resultList;
    }

    private void fetchSimpleLineData(List<Long> orderLineIds, Map<String, String> orderLabelMap, Map<Long, String> orderLabelItemMap, Map<Long, List<DgPerformOrderItemLineEo>> afsOrderItemLineMap, Map<Long, List<DgPerformOrderLineAmountEo>> orderLineAmountMap, Map<Long, PriceControlTableDto> priceMap, Map<Long, String> snMap, Map<Long, String> refundInterceptStatusMap, Map<Long, List<DgPerformOrderItemLineEo>> normalItemLineMap) {
        logger.info("\u5904\u7406\u8ba2\u5355\u884c {}", (Object)JSONObject.toJSONString(orderLineIds));
        List list = ((ExtQueryChainWrapper)this.dgPerformOrderLineAmountDomain.filter().in((Object)"order_line_id", orderLineIds)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            orderLineAmountMap.putAll(list.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId)));
        }
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"order_line_id", orderLineIds)).list();
        afsOrderItemLineMap.putAll(orderItemLineEos.stream().filter(x -> x.getShFlag() == 1).collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId)));
        normalItemLineMap.putAll(orderItemLineEos.stream().filter(x -> !Objects.equals(x.getShFlag(), 1)).collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId)));
        snMap.putAll(orderItemLineEos.stream().filter(x -> x.getShFlag() == 0).filter(a -> StringUtils.isNotBlank((CharSequence)a.getSnCode())).collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId, Collectors.mapping(DgPerformOrderItemLineEo::getSnCode, Collectors.joining(",")))));
        refundInterceptStatusMap.putAll(orderItemLineEos.stream().filter(x -> x.getShFlag() == 0 && StringUtils.isNotBlank((CharSequence)x.getRefundInterceptStatus())).collect(Collectors.toMap(DgPerformOrderItemLineEo::getOrderLineId, DgPerformOrderItemLineEo::getRefundInterceptStatus, (k1, k2) -> k1)));
    }

    @Override
    public PageInfo<DgEsPerformOrderRespDto> queryAllInfoByPage(DgEsPerformOrderReqDto filter) {
        PageInfo pageInfo;
        if (filter != null && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)filter.getOrderNos()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)filter.getPlatformOrderNoList())) {
            filter.setOrderNos(filter.getPlatformOrderNoList());
        }
        if ((pageInfo = (PageInfo)RestResponseHelper.extractData(this.queryEsByPage(filter))) == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        PageInfo<DgPerformOrderItemLineRespDto> dtoPageInfo = this.queryDgPerformOrderItemLineSimpleRespDtoPageInfo(filter, (PageInfo<DgEsPerformOrderRespDto>)pageInfo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
            Map<Long, List<DgPerformOrderItemLineRespDto>> orderLineGroupMap = dtoPageInfo.getList().stream().collect(Collectors.groupingBy(DgPerformOrderItemLineRespDto::getSaleOrderId));
            pageInfo.getList().forEach(ld -> {
                List dgPerformOrderItemLineRespDtos = (List)orderLineGroupMap.get(ld.getId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dgPerformOrderItemLineRespDtos)) {
                    ld.setOrderLineList(dgPerformOrderItemLineRespDtos);
                } else {
                    logger.info("{} \u67e5\u8be2\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f", (Object)ld.getId());
                }
            });
        } else {
            logger.info("\u67e5\u8be2\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
        }
        return pageInfo;
    }

    private void fetchData(List<Long> orderLineIds, Map<String, String> orderLabelMap, Map<Long, String> orderLabelItemMap, Map<Long, List<DgPerformOrderItemLineEo>> afsOrderItemLineMap, Map<Long, List<DgPerformOrderLineAmountEo>> orderLineAmountMap, Map<Long, PriceControlTableDto> priceMap, Map<Long, String> snMap, Map<Long, String> refundInterceptStatusMap) {
        logger.info("\u5904\u7406\u8ba2\u5355\uff1a{}", (Object)JSONObject.toJSONString(orderLineIds));
        LambdaQueryWrapper orderItemLabelWrapper = new LambdaQueryWrapper();
        orderItemLabelWrapper.in(OrderLabelItemEo::getOrderItemId, orderLineIds);
        orderItemLabelWrapper.eq(BaseEo::getDr, (Object)0);
        orderItemLabelWrapper.eq(OrderLabelItemEo::getDisplay, (Object)1);
        orderLabelItemMap.putAll(this.orderLabelItemDomain.getMapper().selectList((Wrapper)orderItemLabelWrapper).stream().filter(x -> orderLabelMap.containsKey(x.getLabelCode())).collect(Collectors.groupingBy(OrderLabelItemEo::getOrderItemId, Collectors.mapping(x -> (String)orderLabelMap.get(x.getLabelCode()), Collectors.joining(",")))));
        List list = ((ExtQueryChainWrapper)this.dgPerformOrderLineAmountDomain.filter().in((Object)"order_line_id", orderLineIds)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            orderLineAmountMap.putAll(list.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId)));
        }
        List afsOrderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"order_line_id", orderLineIds)).list();
        afsOrderItemLineMap.putAll(afsOrderItemLineEos.stream().filter(x -> x.getShFlag() == 1).collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId)));
        PriceControlTablePageReqDto queryParam = new PriceControlTablePageReqDto();
        queryParam.setRowIdList(orderLineIds);
        priceMap.putAll(((PageInfo)RestResponseHelper.extractData((RestResponse)this.dgPriceControlTableApiProxy.page(queryParam))).getList().stream().collect(Collectors.toMap(PriceControlTableDto::getRowId, Function.identity(), (k1, k2) -> k1)));
        snMap.putAll(afsOrderItemLineEos.stream().filter(x -> x.getShFlag() == 0).filter(a -> StringUtils.isNotBlank((CharSequence)a.getSnCode())).collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId, Collectors.mapping(DgPerformOrderItemLineEo::getSnCode, Collectors.joining(",")))));
        refundInterceptStatusMap.putAll(afsOrderItemLineEos.stream().filter(x -> x.getShFlag() == 0 && StringUtils.isNotBlank((CharSequence)x.getRefundInterceptStatus())).collect(Collectors.toMap(DgPerformOrderItemLineEo::getOrderLineId, DgPerformOrderItemLineEo::getRefundInterceptStatus, (k1, k2) -> k1)));
    }

    private void buildAfsSummary(DgPerformOrderItemLineRespDto orderLineDto, List<DgPerformOrderItemLineEo> afsOrderItemLineEos) {
        List refundingItemLineEos;
        List exchangeItemLineEos;
        List refundSuccessItemLineEos;
        logger.info("\u8ba2\u5355\u884c\uff1a{}\uff0c \u5bf9\u5e94\u552e\u540e\u6570\u636e\uff1a{}", (Object)orderLineDto.getLineId(), (Object)JSONObject.toJSONString(afsOrderItemLineEos));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(afsOrderItemLineEos)) {
            orderLineDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.NOT_REFUND.getCode());
            orderLineDto.setRefundedItemNumber(BigDecimal.ZERO);
            orderLineDto.setRefundedPayAmount(BigDecimal.ZERO);
            return;
        }
        BigDecimal refundingNumber = BigDecimal.ZERO;
        BigDecimal refundingAmount = BigDecimal.ZERO;
        BigDecimal refundNumber = BigDecimal.ZERO;
        BigDecimal refundAmount = BigDecimal.ZERO;
        BigDecimal exchangeNumber = BigDecimal.ZERO;
        BigDecimal exchangeAmount = BigDecimal.ZERO;
        orderLineDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.NOT_REFUND.getCode());
        List returnedSuccessItemLineEos = afsOrderItemLineEos.stream().filter(eo -> ItemLineReturnStatusEnum.YES.getType().equals(eo.getReturnStatus())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(returnedSuccessItemLineEos)) {
            refundNumber = returnedSuccessItemLineEos.stream().map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(refundSuccessItemLineEos = afsOrderItemLineEos.stream().filter(eo -> DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode().equals(eo.getRefundStatus()) && eo.getReturnStatus() > 0).collect(Collectors.toList()))) {
            refundAmount = refundSuccessItemLineEos.stream().map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            orderLineDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(exchangeItemLineEos = afsOrderItemLineEos.stream().filter(eo -> DgSaleOrderItemRefundStatusEnum.NORMAL.getCode().equals(eo.getRefundStatus())).collect(Collectors.toList()))) {
            exchangeNumber = exchangeItemLineEos.stream().map(DgPerformOrderItemLineEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            exchangeAmount = exchangeItemLineEos.stream().map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(refundingItemLineEos = afsOrderItemLineEos.stream().filter(eo -> DgSaleOrderItemRefundStatusEnum.REFUNDING.getCode().equals(eo.getRefundStatus())).collect(Collectors.toList()))) {
            refundingAmount = refundingItemLineEos.stream().map(DgPerformOrderItemLineEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(refundingItemLineEos)) {
            orderLineDto.setRefundStatus(DgSaleOrderItemRefundStatusEnum.REFUNDING.getCode());
        }
        orderLineDto.setRefundedItemNumber(refundNumber);
        orderLineDto.setRefundedPayAmount(refundAmount);
        orderLineDto.setRefundingNumber(refundingNumber);
        orderLineDto.setRefundingAmount(refundingAmount);
        orderLineDto.setSurplusCanReturnItemNum(orderLineDto.getItemNum().subtract(refundingNumber).subtract(refundNumber).subtract(exchangeNumber));
        orderLineDto.setSurplusCanRefundPayAmount(orderLineDto.getPayAmount().subtract(refundingAmount).subtract(refundAmount).subtract(exchangeAmount));
        logger.info("\u8ba2\u5355\u884cID:{},\u9000\u6b3e\u72b6\u6001:{},\u6362\u8d27\u9000\u56de\u7684\u6570\u91cf:{},\u9000\u6b3e\u4e2d\u6570\u91cf:{},\u9000\u6b3e\u4e2d\u91d1\u989d:{},\u5df2\u9000\u6570\u91cf:{},\u5df2\u9000\u91d1\u989d:{},\u53ef\u7533\u8bf7\u9000\u6b3e\u6570\u91cf:{},\u53ef\u7533\u8bf7\u9000\u6b3e\u91d1\u989d:{}", new Object[]{orderLineDto.getId(), orderLineDto.getRefundStatus(), exchangeNumber, orderLineDto.getRefundingNumber(), orderLineDto.getRefundingAmount(), orderLineDto.getRefundedItemNum(), orderLineDto.getRefundedPayAmount(), orderLineDto.getSurplusCanReturnItemNum(), orderLineDto.getSurplusCanRefundPayAmount()});
    }

    private void bindAmount(DgPerformOrderItemLineRespDto respDto, List<DgPerformOrderLineAmountEo> dgPerformOrderItemLineEos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dgPerformOrderItemLineEos)) {
            return;
        }
        Map amountDtoMap = dgPerformOrderItemLineEos.stream().filter(e -> e.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode())).collect(Collectors.toMap(DgPerformOrderLineAmountEo::getAccountType, Function.identity(), (a, b) -> a));
        DgPerformOrderLineAmountEo supplyAmountEo = (DgPerformOrderLineAmountEo)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_SUPPLY_PRICE.getCode());
        respDto.setOriginSupplyPrice(null != supplyAmountEo ? supplyAmountEo.getAmount().divide(Optional.ofNullable(respDto.getCalcItemNum()).orElse(respDto.getItemNum()), 2, 4) : BigDecimal.ZERO);
        respDto.setOriginSupplyAmount(null != supplyAmountEo ? supplyAmountEo.getAmount() : BigDecimal.ZERO);
        DgPerformOrderLineAmountEo priceAmountEo = (DgPerformOrderLineAmountEo)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode());
        respDto.setPrice(null != priceAmountEo ? priceAmountEo.getAmount().divide(Optional.ofNullable(respDto.getCalcItemNum()).orElse(respDto.getItemNum()), 2, 4) : BigDecimal.ZERO);
        respDto.setPayAmount(null != priceAmountEo ? priceAmountEo.getAmount() : BigDecimal.ZERO);
        DgPerformOrderLineAmountEo realPayAmountEo = (DgPerformOrderLineAmountEo)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
        respDto.setSkuRealPayAmount(null != realPayAmountEo ? realPayAmountEo.getAmount() : BigDecimal.ZERO);
        DgPerformOrderLineAmountEo discountAmountEo = (DgPerformOrderLineAmountEo)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode());
        respDto.setDiscountAmount(null != discountAmountEo ? discountAmountEo.getAmount() : BigDecimal.ZERO);
        DgPerformOrderLineAmountEo surplusCanRefundPayAmountEo = (DgPerformOrderLineAmountEo)amountDtoMap.get(DgOmsOrderAmountTypeEnum.LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode());
        respDto.setSurplusCanRefundPayAmount(null != surplusCanRefundPayAmountEo ? surplusCanRefundPayAmountEo.getAmount() : BigDecimal.ZERO);
    }

    private void F2bListDto(DgEsPerformOrderReqDto filter, PageInfo<DgEsPerformOrderRespDto> pageInfo) {
        if (Objects.isNull(pageInfo) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return;
        }
        List<String> businessNos = pageInfo.getList().stream().map(DgEsPerformOrderRespDto::getSaleOrderNo).distinct().collect(Collectors.toList());
        Pair<Map<String, String>, Map<String, String>> logisticsNoAndShipingNoMapPair = this.getLogisticsNosAndShippingNos(businessNos);
        Map logisticsNoMap = (Map)logisticsNoAndShipingNoMapPair.getKey();
        Map shippingNoMap = (Map)logisticsNoAndShipingNoMapPair.getValue();
        Map<String, String> invoiceStatusMap = this.getInvoiceStatusBySaleOrderNo(businessNos);
        Map<String, String> accountingMap = this.accountingService.getAccountingOrderNos(businessNos);
        pageInfo.getList().forEach(v -> {
            String result;
            if (shippingNoMap.containsKey(v.getSaleOrderNo())) {
                v.setShippingNos((String)shippingNoMap.get(v.getSaleOrderNo()));
            }
            if (StrUtil.isNotBlank((CharSequence)((CharSequence)invoiceStatusMap.get(v.getSaleOrderNo())))) {
                v.setWhetherInvoice((String)invoiceStatusMap.get(v.getSaleOrderNo()));
            }
            if (logisticsNoMap.containsKey(v.getSaleOrderNo())) {
                v.setShippingNos((String)logisticsNoMap.get(v.getSaleOrderNo()));
                v.setShippingNoList(Arrays.asList((String)logisticsNoMap.get(v.getSaleOrderNo())));
            }
            if (accountingMap.containsKey(v.getSaleOrderNo() + "-" + VoucherTypeEnum.DELIVERY.getCode())) {
                result = (String)accountingMap.get(v.getSaleOrderNo() + "-" + VoucherTypeEnum.DELIVERY.getCode());
                v.setDeliveryAccounting(Objects.nonNull(result) ? "ACCOUNTED" : "UNACCOUNTED");
            }
            if (accountingMap.containsKey(v.getSaleOrderNo() + "-" + VoucherTypeEnum.INVOICE.getCode())) {
                result = (String)accountingMap.get(v.getSaleOrderNo() + "-" + VoucherTypeEnum.INVOICE.getCode());
                v.setBillingAccounting(Objects.nonNull(result) ? "ACCOUNTED" : "UNACCOUNTED");
            }
        });
        if (Objects.equals(filter.getBizModel(), "F2B_ORDER")) {
            List list = pageInfo.getList();
            List performIdList = list.stream().map(DgEsPerformOrderRespDto::getId).collect(Collectors.toList());
            LambdaQueryWrapper performOrderQuery = new LambdaQueryWrapper();
            performOrderQuery.in(DgPerformOrderItemLineEo::getOrderId, performIdList);
            performOrderQuery.eq(BaseEo::getDr, (Object)0);
            List performOrderItemLineEos = this.dgPerformOrderItemLineDomain.getMapper().selectList((Wrapper)performOrderQuery);
            Map<Object, Object> deliveryNumMap = new HashMap();
            Map<Object, Object> returnedNumMap = new HashMap();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)performOrderItemLineEos)) {
                deliveryNumMap = performOrderItemLineEos.stream().collect(Collectors.toMap(DgPerformOrderItemLineEo::getOrderId, DgPerformOrderItemLineEo::getOutItemNum, (k1, k2) -> {
                    k1 = Objects.isNull(k1) ? BigDecimal.ZERO : k1;
                    k2 = Objects.isNull(k2) ? BigDecimal.ZERO : k2;
                    return k1.add((BigDecimal)k2);
                }));
                returnedNumMap = performOrderItemLineEos.stream().filter(eo -> !eo.getCancelStatus().equals(ItemLineReturnStatusEnum.YES.getType())).collect(Collectors.toMap(DgPerformOrderItemLineEo::getOrderId, eo -> Optional.ofNullable(eo.getReturnedNum()).orElse(BigDecimal.ZERO), (num1, num2) -> num1.add((BigDecimal)num2)));
            }
            LambdaQueryWrapper performOrderLineQuery = new LambdaQueryWrapper();
            performOrderLineQuery.in(DgPerformOrderLineEo::getOrderId, performIdList);
            performOrderLineQuery.eq(BaseEo::getDr, (Object)0);
            List performOrderLineEos = this.dgPerformOrderLineDomain.getMapper().selectList((Wrapper)performOrderLineQuery);
            Map<Long, List<DgPerformOrderLineEo>> orderLineMap = performOrderLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineEo::getOrderId));
            Map<Object, Object> accountTypeMap = new HashMap();
            List accountTypeEos = this.accountTypeDomain.selectAll();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountTypeEos)) {
                accountTypeMap = accountTypeEos.stream().collect(Collectors.toMap(AccountTypeEo::getAccountTypeCode, AccountTypeEo::getCustomName, (k1, k2) -> k1));
            }
            for (DgEsPerformOrderRespDto dto : list) {
                dto.setDeliverySchedule(BigDecimal.ZERO);
                dto.setDeliveryTotalNum(BigDecimal.ZERO);
                dto.setReturnedTotalNum(BigDecimal.ZERO);
                if (!deliveryNumMap.isEmpty() && deliveryNumMap.containsKey(dto.getId())) {
                    BigDecimal deliveryNum = Objects.nonNull(deliveryNumMap.get(dto.getId())) ? (BigDecimal)deliveryNumMap.get(dto.getId()) : BigDecimal.ZERO;
                    dto.setDeliveryTotalNum(deliveryNum);
                    BigDecimal deliveryNumS = Objects.nonNull(dto.getGoodsTotalNum()) ? deliveryNum.divide(dto.getGoodsTotalNum(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)) : BigDecimal.ZERO;
                    dto.setDeliverySchedule(deliveryNumS);
                }
                if (!returnedNumMap.isEmpty() && returnedNumMap.containsKey(dto.getId())) {
                    dto.setReturnedTotalNum((BigDecimal)returnedNumMap.get(dto.getId()));
                }
                dto.setReturnableTotalNum(dto.getDeliveryTotalNum().subtract(dto.getReturnedTotalNum()));
                if (!orderLineMap.isEmpty() && orderLineMap.containsKey(dto.getId())) {
                    List<DgPerformOrderLineEo> dgPerformOrderLineEos = orderLineMap.get(dto.getId());
                    ArrayList<String> itemPathUrlList = new ArrayList<String>();
                    HashSet<String> itemSet = new HashSet<String>();
                    for (DgPerformOrderLineEo item : dgPerformOrderLineEos) {
                        this.setLineExtInfo(item);
                        if (itemSet.contains(item.getSkuCode())) continue;
                        if (StringUtils.isNotEmpty((CharSequence)item.getImgUrl())) {
                            itemPathUrlList.add(item.getImgUrl());
                        }
                        itemSet.add(item.getSkuCode());
                    }
                    dto.setSkuCodeCount(new BigDecimal(itemSet.size()));
                    dto.setItemPathUrlList(itemPathUrlList);
                }
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getPayWayList()) || accountTypeMap.isEmpty()) continue;
                String payWayName = "";
                for (String payWay : dto.getPayWayList()) {
                    String payMethodName = (String)accountTypeMap.get(payWay);
                    if (StringUtils.isEmpty((CharSequence)payMethodName)) {
                        payMethodName = payWay;
                    }
                    if (StringUtils.isNotBlank((CharSequence)payWayName)) {
                        payWayName = payWayName + "\u3001" + payMethodName;
                        continue;
                    }
                    payWayName = payMethodName;
                }
                dto.setPayWayName(payWayName);
            }
            pageInfo.setList(list);
        }
    }

    private Pair<Map<String, String>, Map<String, String>> getLogisticsNosAndShippingNos(List<String> businessNos) {
        HashMap logisticsNoMap = Maps.newHashMap();
        HashMap shippingNoMap = Maps.newHashMap();
        Pair mapPair = new Pair((Object)logisticsNoMap, (Object)shippingNoMap);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(businessNos)) {
            return new Pair(new HashMap(), new HashMap());
        }
        try {
            List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.noticeOrderDomain.filter().in((Object)"relevance_no", businessNos)).ne((Object)"order_status", (Object)"ono_cancel")).list();
            Map noticeOrderEoListMap = noticeOrderEos.stream().filter(x -> TransportStyleEnum.LOGISTICS.getCode().equals(x.getTransportStyle())).collect(Collectors.toMap(DgOutNoticeOrderEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
            noticeOrderEoListMap.forEach((k, v) -> logisticsNoMap.put(k, v.getLogisticsOrderNo()));
            noticeOrderEoListMap.forEach((k, v) -> shippingNoMap.put(k, v.getShippingCode() + Optional.ofNullable(v.getSubShippingCode()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(r -> "," + r).orElse("")));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7269\u6d41\u5355\u53f7\u5f02\u5e38\uff1a{},{}", (Object)e, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        logger.info("\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)logisticsNoMap));
        logger.info("\u63d0\u8d27\u5355\u53f7\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)shippingNoMap));
        return mapPair;
    }

    private void setItemExtInfo(DgPerformOrderItemEo item) {
        HashMap extensionMap;
        if (StringUtils.isNotBlank((CharSequence)item.getExtension()) && (extensionMap = (HashMap)JSONObject.parseObject((String)item.getExtension(), HashMap.class)).containsKey("imgPath")) {
            item.setImgUrl(extensionMap.get("imgPath").toString());
        }
    }

    private void setLineExtInfo(DgPerformOrderLineEo item) {
        HashMap extensionMap;
        if (StringUtils.isNotBlank((CharSequence)item.getExtension()) && (extensionMap = (HashMap)JSONObject.parseObject((String)item.getExtension(), HashMap.class)).containsKey("imgPath")) {
            item.setImgUrl(extensionMap.get("imgPath").toString());
        }
    }

    @Override
    public RestResponse<DgEsPerformOrderStatusCountRespDto> queryCount(DgEsPerformOrderReqDto filter) {
        return new RestResponse((Object)this.esPerformOrderDomain.queryCount(filter));
    }

    @Override
    public RestResponse<List<PerformOrderReportRespDto>> queryByIds(List<Long> ids) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List shipmentInfoEos = ((IPerformOrderInfoDomain)this.domain).selectByIds(ids);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shipmentInfoEos)) {
            return null;
        }
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyProperties(dtoList, (Object)shipmentInfoEos, (String[])new String[]{"list", "navigatepageNums"});
        return new RestResponse(dtoList);
    }

    @Override
    public RestResponse<PageInfo<RebateOrderRespDto>> queryByPageForRebate(RebateOrderReqDto rebateOrderReqDto) {
        DgEsPerformOrderReqDto filter = new DgEsPerformOrderReqDto();
        List<Object> codeList = new ArrayList();
        LambdaQueryWrapper billOrderEoQueryWrapper = new LambdaQueryWrapper();
        if (Objects.nonNull(rebateOrderReqDto.getRbBillId())) {
            billOrderEoQueryWrapper.eq(BillOrderEo::getOrderId, (Object)rebateOrderReqDto.getRbBillId());
            List billOrderEos = this.billOrderDomain.getMapper().selectList((Wrapper)billOrderEoQueryWrapper);
            codeList = billOrderEos.stream().map(BillOrderEo::getCode).collect(Collectors.toList());
            filter.setNotInOrderList(codeList);
        }
        filter.setDeliveryCompleteDateStart(rebateOrderReqDto.getDeliveryCompleteDateStart());
        filter.setDeliveryCompleteDateEnd(rebateOrderReqDto.getDeliveryCompleteDateEnd());
        if (Objects.nonNull(rebateOrderReqDto.getOrderNo())) {
            filter.setOrderNo(rebateOrderReqDto.getOrderNo());
        }
        if (Objects.equals(rebateOrderReqDto.getOrderType(), StatisticalObjEnum.SALE_ORDER.getCode())) {
            filter.setBizModel("F2B_ORDER");
        }
        if (Objects.equals(rebateOrderReqDto.getOrderType(), StatisticalObjEnum.SHIPPING_ORDER.getCode())) {
            filter.setBizModel("NVOICE_ORDER");
        }
        if (Objects.nonNull(rebateOrderReqDto.getCustomerCode())) {
            filter.setCustomerCode(rebateOrderReqDto.getCustomerCode());
        }
        if (Objects.nonNull(rebateOrderReqDto.getShopId())) {
            filter.setShopId(rebateOrderReqDto.getShopId());
        }
        PageInfo dgEsPerformOrderRespDtoPageInfo = this.esPerformOrderDomain.queryEsByPage(filter);
        PageInfo pageInfo = (PageInfo)BeanUtil.copyProperties((Object)dgEsPerformOrderRespDtoPageInfo, PageInfo.class, (String[])new String[]{"list"});
        ArrayList<RebateOrderRespDto> respDtoList = new ArrayList<RebateOrderRespDto>();
        for (DgEsPerformOrderRespDto dgEsPerformOrderRespDto : dgEsPerformOrderRespDtoPageInfo.getList()) {
            RebateOrderRespDto rebateOrderRespDto = new RebateOrderRespDto();
            rebateOrderRespDto.setOrderNo(dgEsPerformOrderRespDto.getSaleOrderNo());
            rebateOrderRespDto.setOrderStatus(dgEsPerformOrderRespDto.getOrderStatus());
            rebateOrderRespDto.setOrderType(dgEsPerformOrderRespDto.getOrderType());
            rebateOrderRespDto.setCustomerCode(dgEsPerformOrderRespDto.getCustomerCode());
            rebateOrderRespDto.setCustomerName(dgEsPerformOrderRespDto.getCustomerName());
            rebateOrderRespDto.setOrderedQuantity(Integer.valueOf(dgEsPerformOrderRespDto.getGoodsTotalNum().intValue()));
            rebateOrderRespDto.setActualPaymentAmount(dgEsPerformOrderRespDto.getPayAmount());
            rebateOrderRespDto.setTotalOrderAmount(dgEsPerformOrderRespDto.getOrderTotalAmount());
            rebateOrderRespDto.setTransactionAmount(dgEsPerformOrderRespDto.getGoodsTotalAmount());
            rebateOrderRespDto.setReceiptConfirmationTime(dgEsPerformOrderRespDto.getConfirmReceiveTime());
            rebateOrderRespDto.setPayTime(dgEsPerformOrderRespDto.getPayTime());
            rebateOrderRespDto.setDeliveryTime(dgEsPerformOrderRespDto.getPlanDeliveryTime());
            rebateOrderRespDto.setCreateTime(dgEsPerformOrderRespDto.getCreateTime());
            if (codeList.contains(dgEsPerformOrderRespDto.getSaleOrderNo())) continue;
            respDtoList.add(rebateOrderRespDto);
        }
        pageInfo.setList(respDtoList);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<DgPerformOrderItemLatitudeRespDto>> queryItemLatitudeByPage(DgPerformOrderItemLatitudeReqDto filter) {
        Page pageInfo = ((IPerformOrderInfoDomain)this.domain).queryItemLatitudeByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        if (pageInfo != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getResult())) {
            List orderLineIds = pageInfo.getResult().stream().map(DgPerformOrderItemLatitudeRespDto::getId).collect(Collectors.toList());
            List dgPerformOrderLineAmountDtos = this.dgPerformOrderLineAmountDomain.queryByOrderLineIdsAndAccountType(orderLineIds, DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
            Map<Long, BigDecimal> orderLineSaleAmountMap = dgPerformOrderLineAmountDtos.stream().collect(Collectors.toMap(DgPerformOrderLineAmountDto::getOrderLineId, DgPerformOrderLineAmountDto::getAmount, (e1, e2) -> e1));
            List orderIds = pageInfo.getResult().stream().map(DgPerformOrderItemLatitudeRespDto::getOrderId).distinct().collect(Collectors.toList());
            List addrEos = ((ExtQueryChainWrapper)this.dgPerformOrderAddrDomain.filter().in((Object)"order_id", orderIds)).list();
            Map addrEoMap = addrEos.stream().collect(Collectors.toMap(DgPerformOrderAddrEo::getOrderId, Function.identity(), (e1, e2) -> e1));
            HashMap oaAuditEoMap = Maps.newHashMap();
            for (DgPerformOrderItemLatitudeRespDto orderLineDto : pageInfo.getResult()) {
                orderLineDto.setSaleAmount(orderLineSaleAmountMap.get(orderLineDto.getId()));
                orderLineDto.setSupplyPrice(Optional.ofNullable(orderLineDto.getSaleAmount()).orElse(BigDecimal.ZERO).divide(Optional.ofNullable(orderLineDto.getCalcItemNum()).orElse(orderLineDto.getItemNum()), 2, RoundingMode.HALF_UP));
                DgPerformOrderAddrEo addrEo = (DgPerformOrderAddrEo)addrEoMap.get(orderLineDto.getOrderId());
                if (addrEo != null) {
                    orderLineDto.setOrderAddress((DgPerformOrderAddrDto)BeanUtil.copyProperties((Object)addrEo, DgPerformOrderAddrDto.class, (String[])new String[0]));
                }
                DgBusinessAuditEo oaAuditEo = oaAuditEoMap.getOrDefault(orderLineDto.getOrderId(), this.queryAuditEo(orderLineDto.getOrderId(), orderLineDto.getSaleOrderNo()));
                orderLineDto.setExternalAuditRemark(oaAuditEo.getAuditDesc());
                orderLineDto.setExternalAuditTime(oaAuditEo.getAuditTime());
                orderLineDto.setExternalAuditPerson(oaAuditEo.getCreatePerson());
                oaAuditEoMap.put(orderLineDto.getOrderId(), oaAuditEo);
                list.add(orderLineDto);
            }
        }
        respDtoPageInfo.setList((List)list);
        return new RestResponse((Object)respDtoPageInfo);
    }

    private DgBusinessAuditEo queryAuditEo(Long orderId, String saleOrderNo) {
        DgBusinessAuditEo eo = (DgBusinessAuditEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgBusinessAuditDomain.filter().eq((Object)"business_id", (Object)orderId)).eq((Object)"business_no", (Object)saleOrderNo)).eq((Object)"business_type", (Object)1)).eq((Object)"audit_type", (Object)"9")).orderByDesc((Object)"create_time")).last("limit 1")).one();
        return Optional.ofNullable(eo).orElse(new DgBusinessAuditEo());
    }

    private Map<String, String> getLogisticsNos(List<String> orderNos) {
        HashMap logisticsNoMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderNos)) {
            return logisticsNoMap;
        }
        try {
            List noticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.noticeOrderDomain.filter().in((Object)"relevance_no", orderNos)).ne((Object)"order_status", (Object)"ono_cancel")).list();
            Map noticeOrderEoListMap = noticeOrderEos.stream().filter(x -> TransportStyleEnum.LOGISTICS.getCode().equals(x.getTransportStyle())).collect(Collectors.toMap(DgOutNoticeOrderEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
            noticeOrderEoListMap.forEach((k, v) -> logisticsNoMap.put(k, v.getLogisticsOrderNo()));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7269\u6d41\u5355\u53f7\u5f02\u5e38\uff1a{},{}", (Object)e, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        logger.info("\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)logisticsNoMap));
        return logisticsNoMap;
    }

    private Map<String, String> getShippingNos(List<String> orderNos) {
        HashMap shippingNoMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderNos)) {
            return shippingNoMap;
        }
        try {
            List syncRecordEos = ((ExtQueryChainWrapper)this.performNoticeSyncRecordDomain.filter().in((Object)"business_no", orderNos)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)syncRecordEos)) {
                Map<String, List<DgPerformNoticeSyncRecordEo>> syncRecordEosListMap = syncRecordEos.stream().collect(Collectors.groupingBy(DgPerformNoticeSyncRecordEo::getBusinessNo));
                List recordIds = syncRecordEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                List syncRecordShippingEos = ((ExtQueryChainWrapper)this.performNoticeSyncRecordShippingDomain.filter().in((Object)"record_id", recordIds)).list();
                if (CollectionUtil.isNotEmpty(syncRecordEosListMap)) {
                    Map<Long, List<DgPerformNoticeSyncRecordShippingEo>> syncRecordShippingEosListMap = syncRecordShippingEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getConsignmentNo())).collect(Collectors.groupingBy(DgPerformNoticeSyncRecordShippingEo::getRecordId));
                    orderNos.forEach(v -> {
                        if (syncRecordEosListMap.containsKey(v)) {
                            List recordEos = (List)syncRecordEosListMap.get(v);
                            HashSet shippingNosList = new HashSet();
                            recordEos.forEach(j -> {
                                List recordShippingEoList;
                                if (syncRecordShippingEosListMap.containsKey(j.getId()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(recordShippingEoList = (List)syncRecordShippingEosListMap.get(j.getId())))) {
                                    Set shippingNos = recordShippingEoList.stream().map(DgPerformNoticeSyncRecordShippingEo::getConsignmentNo).collect(Collectors.toSet());
                                    shippingNosList.addAll(shippingNos);
                                }
                            });
                            shippingNoMap.put(v, org.apache.commons.collections.CollectionUtils.isEmpty(shippingNosList) ? null : String.join((CharSequence)",", new ArrayList(shippingNosList)));
                        }
                    });
                } else {
                    syncRecordEos.forEach(syncRecord -> {
                        OutNoticeResultJsonVo outNoticeResultJsonVo = (OutNoticeResultJsonVo)JSON.parseObject((String)syncRecord.getNoticeResultJson(), OutNoticeResultJsonVo.class);
                        if (Objects.nonNull(outNoticeResultJsonVo) && !CollectionUtils.isEmpty((Collection)outNoticeResultJsonVo.getShippingInfoList())) {
                            HashSet shippingNoList = new HashSet();
                            outNoticeResultJsonVo.getShippingInfoList().stream().filter(shippingInfoVo -> StringUtils.equals((CharSequence)shippingInfoVo.getStatus(), (CharSequence)"NORMAL")).forEach(shippingInfoVo -> {
                                if (!StringUtils.isEmpty((CharSequence)shippingInfoVo.getShippingNo())) {
                                    shippingNoList.add(shippingInfoVo.getShippingNo());
                                }
                            });
                            if (!CollectionUtils.isEmpty(shippingNoList)) {
                                shippingNoMap.put(syncRecord.getBusinessNo(), String.join((CharSequence)",", new ArrayList(shippingNoList)));
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7269\u6d41\u4fe1\u606f\u5f02\u5e38\uff1a{}\uff0c{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        logger.info("shippingNoMap:{}", (Object)JSONObject.toJSONString((Object)shippingNoMap));
        return shippingNoMap;
    }

    private List<String> querySaleOrderNosByConsignmentNos(List<String> consignmentNos) {
        ArrayList saleOrderNosList = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(consignmentNos)) {
            return saleOrderNosList;
        }
        return this.performNoticeSyncRecordShippingDomain.querySaleOrderNos(consignmentNos);
    }

    private Map<String, String> getInvoiceStatusBySaleOrderNo(List<String> businessNos) {
        List orderBillRecordDtos = this.dgPerformOrderInfoDomain.listSaleOrderBillRecordWhetherInvoiceBySaleOrderNoList(businessNos);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orderBillRecordDtos)) {
            return Collections.emptyMap();
        }
        Map<String, String> map = orderBillRecordDtos.stream().collect(Collectors.toMap(SaleOrderBillRecordDto::getSaleOrderNo, SaleOrderBillRecordDto::getWhetherInvoice, (v1, v2) -> v1));
        return map;
    }
}

