/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.customer.tob;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dao.das.IDgShopDas;
import com.yunxi.dg.base.center.report.domain.customer.ICsRCustomerBusinessTypeDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsOrgCustomerRelationDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationDepartmentDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationEnterpriseDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationSalesmanDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationShopDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.user.IEmployeeDomain;
import com.yunxi.dg.base.center.report.domain.user.IUsOrganizationDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsRRelationSalesmanDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsRRelationShopDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgCsRRelationDepartmentDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.DgOrganizationLevelDto;
import com.yunxi.dg.base.center.report.dto.customer.request.OrgCusShpRelationReqDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCustomerRelatedShopRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.OrgCusShpRelationRespDto;
import com.yunxi.dg.base.center.report.dto.shop.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.report.dto.shop.response.DgShopRespDto;
import com.yunxi.dg.base.center.report.enums.DgCustomerBusinessTypeEnum;
import com.yunxi.dg.base.center.report.eo.DgShopEo;
import com.yunxi.dg.base.center.report.eo.EmployeeEo;
import com.yunxi.dg.base.center.report.eo.customer.CsRCustomerBusinessTypeEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationDepartmentEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationEnterpriseEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationShopEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerAreaEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.center.report.eo.customer.DgRRelationSalesmanEo;
import com.yunxi.dg.base.center.report.service.customer.tob.IDgOrgCustomerRelationService;
import com.yunxi.dg.base.center.report.utils.RequestUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Sets;
import org.springframework.stereotype.Service;

@Service
public class DgOrgCustomerRelationServiceImpl
implements IDgOrgCustomerRelationService {
    @Resource
    private IDgCsOrgCustomerRelationDomain dgCsOrgCustomerRelationDomain;
    @Resource
    private IDgCsRRelationDepartmentDomain dgCsRRelationDepartmentDomain;
    @Resource
    private IDgCsRRelationSalesmanDomain dgCsRRelationSalesmanDomain;
    @Resource
    private IDgCsRRelationEnterpriseDomain dgCsRRelationEnterpriseDomain;
    @Resource
    private IDgCsRRelationShopDomain dgCsRRelationShopDomain;
    @Resource
    private ICsRCustomerBusinessTypeDomain iCsRCustomerBusinessTypeDomain;
    @Resource
    private IDgCustomerAreaDomain iDgCustomerAreaDomain;
    @Resource
    private IUsOrganizationDomain iUsOrganizationDomain;
    @Resource
    private IEmployeeDomain iEmployeeDomain;
    @Resource
    private IDgShopDomain iDgShopDomain;
    @Resource
    private IDgShopDas shopDas;

    @Override
    public PageInfo<CsOrgCustomerRelationDto> queryTobCustomerRelationPage(CsOrgCustomerRelationPageReqDto reqDto) {
        PageInfo pageInfo = new PageInfo();
        List<Integer> businessType = Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType());
        List<Long> areaIds = this.getChildByAreaIds(reqDto.getAreaIds());
        reqDto.setAreaIds(areaIds);
        pageInfo = this.dgCsOrgCustomerRelationDomain.queryPage(reqDto, businessType);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return pageInfo;
        }
        this.setRRelationDepartmentAndSalesman(pageInfo.getList());
        return pageInfo;
    }

    @Override
    public List<DgCustomerRelatedShopRespDto> queryCustomerRelatedShopList(CsOrgCustomerRelationPageReqDto reqDto) {
        List<Integer> businessType = Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType());
        List<Long> areaIds = this.getChildByAreaIds(reqDto.getAreaIds());
        reqDto.setAreaIds(areaIds);
        if (reqDto.getStatus() == null) {
            reqDto.setStatus(Integer.valueOf(4));
        }
        return this.dgCsOrgCustomerRelationDomain.queryCustomerRelatedShop(reqDto, businessType);
    }

    @Override
    public PageInfo<CsOrgCustomerRelationDto> queryCustomerRelationPage(CsOrgCustomerRelationPageReqDto reqDto) {
        PageInfo pageInfo = new PageInfo();
        ArrayList<Integer> businessType = new ArrayList<Integer>();
        if (CollectionUtils.isEmpty((Collection)reqDto.getBusinessTypeList())) {
            businessType.addAll(Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType(), DgCustomerBusinessTypeEnum.TYPE_DSFX.getType(), DgCustomerBusinessTypeEnum.TYPE_ZYKH.getType()));
        } else {
            businessType.addAll(reqDto.getBusinessTypeList());
        }
        List<Long> areaIds = this.getChildByAreaIds(reqDto.getAreaIds());
        reqDto.setAreaIds(areaIds);
        pageInfo = this.dgCsOrgCustomerRelationDomain.queryPage(reqDto, businessType);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return pageInfo;
        }
        this.setRRelationDepartmentAndSalesman(pageInfo.getList());
        return pageInfo;
    }

    @Override
    public Map<Long, List<DgOrganizationLevelDto>> mapDepartmentLevel(Map<Long, Long> departmentIdOrgIdMap) {
        HashMap<Long, List<DgOrganizationLevelDto>> map = new HashMap<Long, List<DgOrganizationLevelDto>>();
        if (CollectionUtils.isEmpty(departmentIdOrgIdMap)) {
            return map;
        }
        String rootOrganizationIdStr = RequestUtil.getHeader("Root-Organization-Id");
        Long rootOrganizationId = StrUtil.isNotBlank((CharSequence)rootOrganizationIdStr) ? Long.valueOf(rootOrganizationIdStr) : null;
        ArrayList organizationDtoList = new ArrayList();
        this.iUsOrganizationDomain.listChildOrgByOrgIdAndFuncType(Collections.singletonList(rootOrganizationId), "human_resource", organizationDtoList);
        if (CollectionUtils.isEmpty(organizationDtoList)) {
            return map;
        }
        Map organizationDtoMap = organizationDtoList.stream().collect(Collectors.toMap(CsOrganizationPageRespDto::getId, Function.identity(), (k1, k2) -> k1));
        departmentIdOrgIdMap.forEach((departmentId, orgId) -> {
            ArrayList<DgOrganizationLevelDto> departmentLevelList = new ArrayList<DgOrganizationLevelDto>();
            this.getDepartmentLevel((Long)departmentId, (Long)orgId, organizationDtoMap, (List<DgOrganizationLevelDto>)departmentLevelList);
            map.put((Long)departmentId, (List<DgOrganizationLevelDto>)departmentLevelList);
        });
        return map;
    }

    @Override
    public PageInfo<OrgCusShpRelationRespDto> queryTobOrgCusShpRelationPage(OrgCusShpRelationReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        ServiceContext.getContext().setAttachment("data_limit_authority_selector", DgCustomerEo.class.getName());
        ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "1");
        QueryWrapper shopWrapper = new QueryWrapper();
        shopWrapper.eq((Object)"code", (Object)reqDto.getShopCode());
        shopWrapper.eq((Object)"dr", (Object)0);
        DgShopEo shopEo = (DgShopEo)this.shopDas.getMapper().selectOne((Wrapper)shopWrapper);
        reqDto.setShopId(shopEo.getId());
        List orgCusShpRelationRespDtoList = this.dgCsOrgCustomerRelationDomain.queryTobOrgCusShpRelationList(reqDto);
        return new PageInfo(orgCusShpRelationRespDtoList);
    }

    @Override
    public PageInfo<OrgCusShpRelationRespDto> queryTobOrgCusShpRelationNoShopPage(OrgCusShpRelationReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        ServiceContext.getContext().setAttachment("data_limit_authority_selector", DgCustomerEo.class.getName());
        ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "1");
        List orgCusShpRelationRespDtoList = this.dgCsOrgCustomerRelationDomain.queryTobOrgCusShpRelationNoShopList(reqDto);
        return new PageInfo(orgCusShpRelationRespDtoList);
    }

    private void getDepartmentLevel(Long departmentId, Long orgId, Map<Long, CsOrganizationPageRespDto> organizationDtoMap, List<DgOrganizationLevelDto> departmentLevelList) {
        CsOrganizationPageRespDto organizationDto = organizationDtoMap.get(departmentId);
        DgOrganizationLevelDto levelDto = (DgOrganizationLevelDto)BeanUtil.toBean((Object)organizationDto, DgOrganizationLevelDto.class);
        levelDto = Objects.isNull(levelDto) ? new DgOrganizationLevelDto() : levelDto;
        departmentLevelList.add(levelDto);
        if (Objects.equals(orgId, departmentId) || Objects.isNull(organizationDto)) {
            Collections.reverse(departmentLevelList);
            return;
        }
        Long parentId = organizationDto.getParentId();
        this.getDepartmentLevel(parentId, orgId, organizationDtoMap, departmentLevelList);
    }

    @Override
    public List<Long> getChildByAreaIds(List<Long> areaIds) {
        ArrayList<Long> areaIdList = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(areaIds)) {
            return areaIdList;
        }
        List areaEos = this.iDgCustomerAreaDomain.selectByIds(areaIds);
        if (CollectionUtils.isNotEmpty((Collection)areaEos)) {
            HashSet indexPaths = Sets.newHashSet();
            for (DgCustomerAreaEo eo : areaEos) {
                indexPaths.add(eo.getIndexPath());
                areaIdList.add(eo.getId());
            }
            List areaDtos = this.iDgCustomerAreaDomain.getChildByIndexPaths((Set)indexPaths);
            areaIdList.addAll(areaDtos.stream().map(BaseDto::getId).collect(Collectors.toList()));
        }
        return areaIdList;
    }

    private void setRRelationDepartmentAndSalesman(List<CsOrgCustomerRelationDto> list) {
        List relationIds = list.stream().map(CsOrgCustomerRelationDto::getId).distinct().collect(Collectors.toList());
        List customerIdList = list.stream().map(CsOrgCustomerRelationDto::getCustomerId).distinct().collect(Collectors.toList());
        Map<Long, Long> departmentIdOrgIdMap = list.stream().collect(Collectors.toMap(CsOrgCustomerRelationDto::getDepartmentId, CsOrgCustomerRelationDto::getOrganizationId, (k1, k2) -> k1));
        Map<Long, List<DgCsRRelationDepartmentEo>> rRelationDepartmentMap = ((List)Optional.ofNullable(this.dgCsRRelationDepartmentDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsRRelationDepartmentEo.class).in(DgCsRRelationDepartmentEo::getRelationId, relationIds))).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgCsRRelationDepartmentEo::getRelationId));
        List rRelationSalesmanEos = Optional.ofNullable(this.dgCsRRelationSalesmanDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgRRelationSalesmanEo.class).in(DgRRelationSalesmanEo::getRelationId, relationIds))).orElse(new ArrayList());
        Map<Long, List<DgRRelationSalesmanEo>> rRelationSalesmanEoMap = rRelationSalesmanEos.stream().collect(Collectors.groupingBy(DgRRelationSalesmanEo::getRelationId));
        List salesmanIdList = rRelationSalesmanEos.stream().map(DgRRelationSalesmanEo::getSalesmanId).collect(Collectors.toList());
        Map employeeEoMap = ((List)Optional.ofNullable(this.iEmployeeDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(EmployeeEo.class).in(CollectionUtils.isNotEmpty(salesmanIdList), BaseEo::getId, salesmanIdList))).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        List rRelationShopEos = Optional.ofNullable(this.dgCsRRelationShopDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsRRelationShopEo.class).in(DgCsRRelationShopEo::getRelationId, relationIds))).orElse(new ArrayList());
        Map<Long, List<DgCsRRelationShopEo>> rRelationShopEoMap = rRelationShopEos.stream().collect(Collectors.groupingBy(DgCsRRelationShopEo::getRelationId));
        DgShopQueryReqDto queryReqDto = new DgShopQueryReqDto();
        queryReqDto.setIdList(rRelationShopEos.stream().map(DgCsRRelationShopEo::getShopId).collect(Collectors.toList()));
        Map dgShopRespDtoMap = ((List)Optional.ofNullable(this.iDgShopDomain.listShopByCondition(queryReqDto)).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (k1, k2) -> k1));
        Map<Long, List<DgCsRRelationEnterpriseEo>> rRelationEnterpriseEoMap = ((List)Optional.ofNullable(this.dgCsRRelationEnterpriseDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsRRelationEnterpriseEo.class).in(DgCsRRelationEnterpriseEo::getRelationId, relationIds))).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgCsRRelationEnterpriseEo::getRelationId));
        Map<Long, List<DgOrganizationLevelDto>> departmentLevelMap = this.mapDepartmentLevel(departmentIdOrgIdMap);
        List typeEos = this.iCsRCustomerBusinessTypeDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(CsRCustomerBusinessTypeEo.class).in(CsRCustomerBusinessTypeEo::getCustomerId, customerIdList));
        Map<Long, List<CsRCustomerBusinessTypeEo>> typeMap = ((List)Optional.ofNullable(typeEos).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(CsRCustomerBusinessTypeEo::getCustomerId));
        Map<Long, List<DgBusinessAreaLevelDto>> areaLevelMap = this.mapAreaLevel(list.stream().map(CsOrgCustomerRelationDto::getAreaId).collect(Collectors.toList()));
        list.forEach(o -> {
            o.setDepartmentList(BeanUtil.copyToList((Collection)((Collection)rRelationDepartmentMap.get(o.getId())), DgCsRRelationDepartmentDto.class));
            o.setSalesmanList(((List)Optional.ofNullable(rRelationSalesmanEoMap.get(o.getId())).orElse(new ArrayList())).stream().map(e -> {
                EmployeeEo employeeEo = (EmployeeEo)employeeEoMap.get(e.getSalesmanId());
                if (Objects.isNull(employeeEo)) {
                    return new CsRRelationSalesmanDto();
                }
                CsRRelationSalesmanDto salesmanDto = new CsRRelationSalesmanDto();
                salesmanDto.setSalesmanId(employeeEo.getId());
                salesmanDto.setSalesmanCode(employeeEo.getEmployeeNo());
                salesmanDto.setSalesmanName(employeeEo.getName());
                salesmanDto.setPosition(e.getPosition());
                return salesmanDto;
            }).collect(Collectors.toList()));
            o.setEnterpriseIdList(((List)Optional.ofNullable(rRelationEnterpriseEoMap.get(o.getId())).orElse(new ArrayList())).stream().map(DgCsRRelationEnterpriseEo::getEnterpriseId).collect(Collectors.toList()));
            List relationShopEos = Optional.ofNullable(rRelationShopEoMap.get(o.getId())).orElse(new ArrayList());
            o.setShopIdList(relationShopEos.stream().map(DgCsRRelationShopEo::getShopId).collect(Collectors.toList()));
            o.setShopList(relationShopEos.stream().map(e -> {
                DgShopRespDto shopRespDto = (DgShopRespDto)dgShopRespDtoMap.get(e.getShopId());
                CsRRelationShopDto shopDto = new CsRRelationShopDto();
                if (Objects.isNull(shopRespDto)) {
                    return shopDto;
                }
                shopDto.setShopId(e.getShopId());
                shopDto.setShopCode(shopRespDto.getStoreCode());
                shopDto.setShopName(shopRespDto.getStoreName());
                return shopDto;
            }).collect(Collectors.toList()));
            o.setBusinessTypeList(((List)Optional.ofNullable(typeMap.get(o.getCustomerId())).orElse(new ArrayList())).stream().map(CsRCustomerBusinessTypeEo::getBusinessType).collect(Collectors.toList()));
            o.setCustomerTypeId(CollectionUtils.isEmpty((Collection)relationShopEos) ? null : ((DgCsRRelationShopEo)relationShopEos.get(0)).getCustomerTypeId());
            o.setDepartmentLevelList(Objects.isNull(o.getDepartmentId()) ? Collections.emptyList() : (List)departmentLevelMap.get(o.getDepartmentId()));
            o.setBusinessAreaLevelList(Objects.isNull(o.getAreaId()) ? null : (List)areaLevelMap.get(o.getAreaId()));
        });
    }

    @Override
    public Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel(List<Long> areaIdList) {
        if (CollectionUtils.isEmpty(areaIdList)) {
            return Collections.emptyMap();
        }
        List respDtoList = this.iDgCustomerAreaDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BaseEo::getId, areaIdList));
        if (CollectionUtils.isEmpty((Collection)respDtoList)) {
            return Collections.emptyMap();
        }
        List indexPathIdList = respDtoList.stream().filter(dto -> Objects.nonNull(dto.getIndexPath())).map(dto -> Arrays.stream(dto.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Map<Long, List> indexPathIdsMap = respDtoList.stream().collect(Collectors.toMap(BaseEo::getId, o -> Arrays.stream(o.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList()), (k1, k2) -> k1));
        Map indexPathEoMap = ((List)Optional.ofNullable(this.iDgCustomerAreaDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BaseEo::getId, indexPathIdList))).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        HashMap<Long, List<DgBusinessAreaLevelDto>> resultMap = new HashMap<Long, List<DgBusinessAreaLevelDto>>();
        for (Long areaId : areaIdList) {
            List indexPathIds = indexPathIdsMap.get(areaId);
            if (CollectionUtils.isEmpty((Collection)indexPathIds)) continue;
            ArrayList<DgBusinessAreaLevelDto> levelDtoList = new ArrayList<DgBusinessAreaLevelDto>();
            for (Long indexPathId : indexPathIds) {
                if (Objects.equals(indexPathId, 0L)) continue;
                DgCustomerAreaEo customerAreaEo = (DgCustomerAreaEo)indexPathEoMap.get(indexPathId);
                DgBusinessAreaLevelDto levelDto = (DgBusinessAreaLevelDto)BeanUtil.toBean((Object)customerAreaEo, DgBusinessAreaLevelDto.class);
                levelDtoList.add(levelDto);
            }
            resultMap.put(areaId, levelDtoList);
        }
        return resultMap;
    }
}

