/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.convert.inventory.DgOutResultOrderConverter;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDomain;
import com.yunxi.dg.base.center.report.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.trade.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutResultOrderEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.IDgOutResultOrderService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgOutResultOrderServiceImpl
extends BaseServiceImpl<DgOutResultOrderDto, DgOutResultOrderEo, IDgOutResultOrderDomain>
implements IDgOutResultOrderService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgOutResultOrderServiceImpl.class);
    String tableName = "cs_out_result_order";
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;
    @Resource
    private IDgPerformOrderInfoDas iDgPerformOrderInfoDas;

    public DgOutResultOrderServiceImpl(IDgOutResultOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgOutResultOrderDto, DgOutResultOrderEo> converter() {
        return DgOutResultOrderConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgOutResultOrderDto>> queryList(DgOutResultOrderPageReqDto dto) {
        return new RestResponse((Object)((IDgOutResultOrderDomain)this.domain).queryList(dto));
    }

    @Override
    public RestResponse<PageInfo<DgOutResultOrderDto>> queryPage(DgOutResultOrderPageReqDto dto) {
        PageInfo dgDeliveryNoticeOrderDtoPageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            dgDeliveryNoticeOrderDtoPageInfo = this.getOutResultOrderEsList(dto);
        } else {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
            dgDeliveryNoticeOrderDtoPageInfo = new PageInfo(((IDgOutResultOrderDomain)this.domain).queryList(dto));
        }
        return new RestResponse(dgDeliveryNoticeOrderDtoPageInfo);
    }

    @Override
    public RestResponse<DgOutResultOrderDto> queryByDocumentNo(String documentNo) {
        DgOutResultOrderDto DgOutResultOrderDto2 = ((IDgOutResultOrderDomain)this.domain).queryDocumentNoDetail(documentNo);
        if (null != DgOutResultOrderDto2 && StringUtils.equals((CharSequence)DgOutResultOrderDto2.getDisplayBusinessType(), (CharSequence)"1001")) {
            DgPerformOrderInfoDto orderInfoDto = new DgPerformOrderInfoDto();
            orderInfoDto.setSaleOrderNo(DgOutResultOrderDto2.getRelevanceNo());
            List dgPerformOrderAddrDtos = this.iDgPerformOrderInfoDas.queryOrderAddr(orderInfoDto);
            if (CollectionUtil.isNotEmpty((Collection)dgPerformOrderAddrDtos)) {
                DgPerformOrderAddrDto dgPerformOrderAddrDto = (DgPerformOrderAddrDto)dgPerformOrderAddrDtos.get(0);
                DgOutResultOrderDto2.setContacts(dgPerformOrderAddrDto.getReceiveName());
                DgOutResultOrderDto2.setPhone(dgPerformOrderAddrDto.getReceivePhone());
                DgOutResultOrderDto2.setProvince(dgPerformOrderAddrDto.getProvince());
                DgOutResultOrderDto2.setCity(dgPerformOrderAddrDto.getCity());
                DgOutResultOrderDto2.setDistrict(dgPerformOrderAddrDto.getCounty());
                DgOutResultOrderDto2.setDetailAddress(dgPerformOrderAddrDto.getReceiveAddress());
            }
        }
        return new RestResponse((Object)DgOutResultOrderDto2);
    }

    private PageInfo<DgOutResultOrderDto> getOutResultOrderEsList(DgOutResultOrderPageReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgOutResultOrderDto orderItemPageDto = (DgOutResultOrderDto)BeanUtil.copyProperties((Object)docValue, DgOutResultOrderDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgOutResultOrderPageReqDto reqDto) throws Exception {
        log.info("ES\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

