/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.inventory.InventoryPreemptionConverter;
import com.yunxi.dg.base.center.report.domain.entity.ISaleOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryPreemptionDto;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryPreemptionPageReqDto;
import com.yunxi.dg.base.center.report.enums.OtherOrderStatusEnum;
import com.yunxi.dg.base.center.report.enums.PerformOrderStatusEnum;
import com.yunxi.dg.base.center.report.enums.SourceTypeEnum;
import com.yunxi.dg.base.center.report.enums.TransferOrderStatus;
import com.yunxi.dg.base.center.report.eo.inventory.InventoryPreemptionEo;
import com.yunxi.dg.base.center.report.service.inventory.IInventoryPreemptionService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InventoryPreemptionServiceImpl
extends BaseServiceImpl<InventoryPreemptionDto, InventoryPreemptionEo, IInventoryPreemptionDomain>
implements IInventoryPreemptionService {
    private static final Logger log = LoggerFactory.getLogger(InventoryPreemptionServiceImpl.class);
    @Resource
    private ISaleOrderDomain saleOrderDomain;

    public InventoryPreemptionServiceImpl(IInventoryPreemptionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryPreemptionDto, InventoryPreemptionEo> converter() {
        return InventoryPreemptionConverter.INSTANCE;
    }

    @Override
    public PageInfo<InventoryPreemptionDto> queryPage(InventoryPreemptionPageReqDto dto) {
        log.info("\u5206\u9875\u67e5\u8be2\u5e93\u5b58\u9884\u5360\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List<InventoryPreemptionDto> list = this.queryList(dto);
        if (CollectionUtils.isEmpty(list)) {
            return new PageInfo();
        }
        BigDecimal totalNum = list.stream().map(InventoryPreemptionDto::getPreemptNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        list.forEach(o -> o.setTotalPreemptNum(totalNum));
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public List<InventoryPreemptionDto> queryList(InventoryPreemptionPageReqDto dto) {
        List inventoryPreemptionDtos = ((IInventoryPreemptionDomain)this.domain).queryList(dto);
        if (CollectionUtils.isEmpty((Collection)inventoryPreemptionDtos) || inventoryPreemptionDtos.get(0) == null) {
            return Collections.emptyList();
        }
        this.setOrderStatus(inventoryPreemptionDtos);
        return inventoryPreemptionDtos;
    }

    private void setOrderStatus(List<InventoryPreemptionDto> inventoryPreemptionDtos) {
        inventoryPreemptionDtos.forEach(o -> {
            if (ObjectUtil.equal((Object)SourceTypeEnum.TRANSFER_ORDER.code(), (Object)o.getSourceType()) || ObjectUtil.equal((Object)SourceTypeEnum.TRANSFER_POSITION_ORDER.code(), (Object)o.getSourceType())) {
                if (ObjectUtil.isNotNull((Object)TransferOrderStatus.getByCode((String)o.getOrderStatus()))) {
                    o.setOrderStatusName(TransferOrderStatus.getByCode((String)o.getOrderStatus()).getDesc());
                }
            } else if (ObjectUtil.equal((Object)SourceTypeEnum.INSIDE_SALES_ORDER.code(), (Object)o.getSourceType()) || ObjectUtil.equal((Object)SourceTypeEnum.SALES_OUTBOUND.code(), (Object)o.getSourceType()) || ObjectUtil.equal((Object)SourceTypeEnum.OUT_SALE_PREEMPT.code(), (Object)o.getSourceType())) {
                if (ObjectUtil.isNotNull((Object)PerformOrderStatusEnum.getByCode((String)o.getOrderStatus()))) {
                    o.setOrderStatusName(PerformOrderStatusEnum.getByCode((String)o.getOrderStatus()).getDesc());
                }
            } else if (ObjectUtil.isNotNull((Object)OtherOrderStatusEnum.getByCode((String)o.getOrderStatus()))) {
                o.setOrderStatusName(OtherOrderStatusEnum.getByCode((String)o.getOrderStatus()).getDesc());
            }
        });
    }
}

