/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.share;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.share.SeparateRuleChannelSkuConverter;
import com.yunxi.dg.base.center.report.domain.share.ISeparateRuleChannelSkuDomain;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualWarehouseDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.share.SeparateRuleChannelSkuDto;
import com.yunxi.dg.base.center.report.dto.share.SeparateRuleChannelSkuPageReqDto;
import com.yunxi.dg.base.center.report.eo.share.SeparateRuleChannelSkuEo;
import com.yunxi.dg.base.center.report.service.share.IDgVirtualWarehouseService;
import com.yunxi.dg.base.center.report.service.share.ISeparateRuleChannelSkuService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SeparateRuleChannelSkuServiceImpl
extends BaseServiceImpl<SeparateRuleChannelSkuDto, SeparateRuleChannelSkuEo, ISeparateRuleChannelSkuDomain>
implements ISeparateRuleChannelSkuService {
    @Resource
    private IDgVirtualWarehouseService dgVirtualWarehouseService;

    public SeparateRuleChannelSkuServiceImpl(ISeparateRuleChannelSkuDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SeparateRuleChannelSkuDto, SeparateRuleChannelSkuEo> converter() {
        return SeparateRuleChannelSkuConverter.INSTANCE;
    }

    @Override
    public PageInfo<SeparateRuleChannelSkuDto> queryPage(SeparateRuleChannelSkuPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List separateRuleChannelSkuDtos = ((ISeparateRuleChannelSkuDomain)this.domain).queryList(dto);
        List warehouseCodes = separateRuleChannelSkuDtos.stream().map(SeparateRuleChannelSkuDto::getWarehouseCode).collect(Collectors.toList());
        DgVirtualWarehousePageReqDto virtualWarehousePageReqDto = new DgVirtualWarehousePageReqDto();
        virtualWarehousePageReqDto.setWarehouseCodeList(warehouseCodes);
        List dgVirtualWarehouseDtos = (List)RestResponseHelper.extractData(this.dgVirtualWarehouseService.queryListWithOrg(virtualWarehousePageReqDto));
        Map dgVirtualWarehouseDtoMap = dgVirtualWarehouseDtos.stream().collect(Collectors.toMap(DgVirtualWarehouseDto::getWarehouseCode, Function.identity(), (v2, v1) -> v2));
        for (SeparateRuleChannelSkuDto separateRuleChannelSkuDto : separateRuleChannelSkuDtos) {
            DgVirtualWarehouseDto dgVirtualWarehouseDto = dgVirtualWarehouseDtoMap.getOrDefault(separateRuleChannelSkuDto.getWarehouseCode(), new DgVirtualWarehouseDto());
            separateRuleChannelSkuDto.setChannelOrganizationName(dgVirtualWarehouseDto.getChannelOrganizationName());
        }
        return new PageInfo(separateRuleChannelSkuDtos);
    }
}

