/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.inventory.dispatcher.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.dao.das.IDgDispatcherOperateLogDas;
import com.yunxi.dg.base.center.report.dao.das.IDgDispatcherOrderDas;
import com.yunxi.dg.base.center.report.dao.das.IDgDispatcherOrderDetailDas;
import com.yunxi.dg.base.center.report.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgTransferOrderDomain;
import com.yunxi.dg.base.center.report.dto.agg.DgBasisOrderRelOrderInfoRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgRelOrderReqDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.request.DgDispatcherOperateLogDataReqDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.request.DgDispatcherOrderDataQueryReqDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.request.DgDispatcherOrderDetailDataReqDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.request.DgDispatcherOrderItemDetailQueryReqDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.response.DgDispatcherOperateLogDataRespDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.response.DgDispatcherOrderDataAndDetailRespDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.response.DgDispatcherOrderDataRespDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.response.DgDispatcherOrderDetailDataRespDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.response.DgDispatcherOrderDetailSummaryRespDto;
import com.yunxi.dg.base.center.report.dto.dispatcher.response.DgDispatcherOrderItemDetailRespDto;
import com.yunxi.dg.base.center.report.enums.TransferOrderEnum;
import com.yunxi.dg.base.center.report.eo.inventory.DgDispatcherOperateLogEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgDispatcherOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgTransferOrderEo;
import com.yunxi.dg.base.center.report.service.agg.IDgBasisOrderRelOrderInfoService;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.inventory.dispatcher.IDgDispatcherOrderDataService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgDispatcherOrderDataServiceImpl
implements IDgDispatcherOrderDataService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(DgDispatcherOrderDataServiceImpl.class);
    String DgDispatcherOrderTableName = "in_dispatcher_order";
    String DgDispatcherOrderDetailTableName = "in_dispatcher_order_detail";
    public static final String YES = "0";
    public static final String NO = "1";
    private static final String[] ORDER_NOS = new String[]{"orderNo", "externalOrderNo"};
    @Resource
    private IDgDispatcherOrderDas IDgDispatcherOrderDas;
    @Resource
    private IDgDispatcherOrderDetailDas IDgDispatcherOrderDetailDas;
    @Resource
    private IDgDispatcherOperateLogDas IDgDispatcherOperateLogDas;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private IDgBasisOrderRelOrderInfoService dgBasisOrderRelOrderInfoService;
    @Resource
    private IDgTransferOrderDomain dgTransferOrderDomain;
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;

    @Override
    public RestResponse<PageInfo<DgDispatcherOrderDataRespDto>> queryDispatcherOrderByPage(DgDispatcherOrderDataQueryReqDto reqDto) {
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBizDateStart())) {
            reqDto.setBizDateStart(reqDto.getBizDateStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBizDateEnd())) {
            reqDto.setBizDateEnd(reqDto.getBizDateEnd() + " 23:59:59");
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getDispatcherCauseList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getWarehouseCodeList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getOperationWayList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getOperationPersonList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getInventoryPropertyList()) || StringUtils.isNotBlank((CharSequence)reqDto.getOperationTimeStart()) && StringUtils.isNotBlank((CharSequence)reqDto.getOperationTimeEnd())) {
            reqDto.setIsChildCondition(Boolean.valueOf(true));
        }
        PageInfo pageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            pageInfo = this.getDgDispatcherOrderEsList(reqDto);
        } else {
            PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
            pageInfo = new PageInfo(this.IDgDispatcherOrderDas.queryDispatcherOrderByPage(reqDto));
        }
        this.wrap(pageInfo.getList());
        return new RestResponse(pageInfo);
    }

    public void wrap(List<DgDispatcherOrderDataRespDto> itemPageDtoList) {
        if (CollectionUtil.isEmpty(itemPageDtoList)) {
            return;
        }
        List transferNos = itemPageDtoList.stream().map(DgDispatcherOrderDataRespDto::getTransferOrderNo).collect(Collectors.toList());
        List transferOrderEos = ((ExtQueryChainWrapper)this.dgTransferOrderDomain.filter().in((Object)"transfer_order_no", transferNos)).select(new String[]{"transfer_order_no", "order_type"}).list();
        if (CollectionUtil.isEmpty((Collection)transferOrderEos)) {
            return;
        }
        Map<String, String> code2orderTypeMap = transferOrderEos.stream().peek(r -> r.setOrderType(StringUtils.defaultString((String)r.getOrderType(), (String)r.getType()))).collect(Collectors.toMap(DgTransferOrderEo::getTransferOrderNo, DgTransferOrderEo::getOrderType, (k1, k2) -> k2));
        for (DgDispatcherOrderDataRespDto respDto : itemPageDtoList) {
            respDto.setTransferOrderType(code2orderTypeMap.get(respDto.getTransferOrderNo()));
        }
    }

    @Override
    public RestResponse<PageInfo<DgDispatcherOrderItemDetailRespDto>> queryDispatcherOrderItemsByPage(DgDispatcherOrderItemDetailQueryReqDto reqDto) {
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBizDateStart())) {
            reqDto.setBizDateStart(reqDto.getBizDateStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBizDateEnd())) {
            reqDto.setBizDateEnd(reqDto.getBizDateEnd() + " 23:59:59");
        }
        PageInfo pageInfo = new PageInfo();
        if (this.esQuery.booleanValue()) {
            pageInfo = this.getDgDispatcherOrderDetailEsList(reqDto);
        } else {
            PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
            List dgDispatcherOrderItemDetailRespDtos = this.IDgDispatcherOrderDas.queryDispatcherOrderItemsByPage(reqDto);
            pageInfo = new PageInfo(dgDispatcherOrderItemDetailRespDtos);
        }
        if (CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(o -> {
                o.setWeight(BigDecimalUtils.parse((String)o.getWeight()).stripTrailingZeros().toPlainString());
                o.setVolume(BigDecimalUtils.parse((String)o.getVolume()).stripTrailingZeros().toPlainString());
            });
            Set orderNos = pageInfo.getList().stream().map(DgDispatcherOrderItemDetailRespDto::getOrderNo).collect(Collectors.toSet());
            Map<String, BigDecimal> ratioMap = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in((Object)"document_code", orderNos)).list().stream().collect(Collectors.toMap(o -> o.getDocumentCode() + "_" + o.getSkuCode(), r -> BigDecimal.ZERO.compareTo(r.getNum()) == 0 ? BigDecimal.ONE : BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
            pageInfo.getList().stream().filter(r -> ratioMap.containsKey(r.getOrderNo() + "_" + r.getSkuCode())).forEach(r -> {
                BigDecimal ratio = (BigDecimal)ratioMap.get(r.getOrderNo() + "_" + r.getSkuCode());
                r.setDispatcherQuantity(BigDecimalUtils.divide((BigDecimal)r.getDispatcherQuantity(), (BigDecimal)ratio, (int)6));
                r.setInQuantity(BigDecimalUtils.divide((BigDecimal)r.getInQuantity(), (BigDecimal)ratio, (int)6));
                r.setOutQuantity(BigDecimalUtils.divide((BigDecimal)r.getOutQuantity(), (BigDecimal)ratio, (int)6));
                r.setPlanQuantity(BigDecimalUtils.divide((BigDecimal)r.getPlanQuantity(), (BigDecimal)ratio, (int)6));
                r.setProcessedQuantity(BigDecimalUtils.divide((BigDecimal)r.getProcessedQuantity(), (BigDecimal)ratio, (int)6));
                r.setProcessingQuantity(BigDecimalUtils.divide((BigDecimal)r.getProcessingQuantity(), (BigDecimal)ratio, (int)6));
                r.setUntreatedQuantity(BigDecimalUtils.divide((BigDecimal)r.getUntreatedQuantity(), (BigDecimal)ratio, (int)6));
            });
        }
        return new RestResponse(pageInfo);
    }

    @Override
    public RestResponse<List<DgDispatcherOrderDataRespDto>> queryDispatcherOrderInfo(DgDispatcherOrderDataQueryReqDto queryDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (queryDto.getId() != null) {
            queryWrapper.eq(BaseEo::getId, (Object)queryDto.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getOrderNo())) {
            queryWrapper.like(DgDispatcherOrderEo::getOrderNo, (Object)queryDto.getOrderNo());
        }
        List eoList = this.IDgDispatcherOrderDas.getMapper().selectList((Wrapper)queryWrapper);
        List<Object> dtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            dtoList = eoList.stream().map(e -> {
                DgDispatcherOrderDataRespDto respDto = new DgDispatcherOrderDataRespDto();
                DtoHelper.eo2Dto((BaseEo)e, (BaseVo)respDto);
                if (StringUtils.isNotBlank((CharSequence)e.getCertificate())) {
                    respDto.setCertificateList((List)Lists.newArrayList((Object[])e.getCertificate().split(",")));
                }
                return respDto;
            }).collect(Collectors.toList());
        }
        return new RestResponse(dtoList);
    }

    @Override
    public RestResponse<PageInfo<DgDispatcherOrderDataAndDetailRespDto>> queryDispatcherOrderAndDetailByPage(DgDispatcherOrderDataQueryReqDto reqDto) {
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCreateTimeStart())) {
            reqDto.setCreateTimeStart(reqDto.getCreateTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCreateTimeEnd())) {
            reqDto.setCreateTimeEnd(reqDto.getCreateTimeEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBizDateStart())) {
            reqDto.setBizDateStart(reqDto.getBizDateStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBizDateEnd())) {
            reqDto.setBizDateEnd(reqDto.getBizDateEnd() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOperationTimeStart())) {
            reqDto.setOperationTimeStart(reqDto.getOperationTimeStart() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOperationTimeEnd())) {
            reqDto.setOperationTimeEnd(reqDto.getOperationTimeEnd() + " 23:59:59");
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getDispatcherCauseList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getWarehouseCodeList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getOperationWayList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getOperationPersonList()) || CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList()) || StringUtils.isNotBlank((CharSequence)reqDto.getOperationTimeStart()) && StringUtils.isNotBlank((CharSequence)reqDto.getOperationTimeEnd())) {
            reqDto.setIsChildCondition(Boolean.valueOf(true));
        }
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.IDgDispatcherOrderDas.queryDispatcherOrderAndDetail(reqDto));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<DgDispatcherOrderDetailDataRespDto>> queryDispatcherOrderDetailByPage(DgDispatcherOrderDetailDataReqDto queryDto) {
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List dtoList = this.IDgDispatcherOrderDetailDas.queryDispatcherOrderDetailByPage(queryDto);
        PageInfo dtoPageInfo = new PageInfo(dtoList);
        this.unitProcess(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<List<DgDispatcherOrderDetailDataRespDto>> queryDispatcherOrderDetailByList(DgDispatcherOrderDetailDataReqDto queryDto) {
        List dtoList = this.IDgDispatcherOrderDetailDas.queryDispatcherOrderDetailByList(queryDto);
        this.unitProcess(dtoList);
        return new RestResponse((Object)dtoList);
    }

    private void unitProcess(List<DgDispatcherOrderDetailDataRespDto> dtoList) {
        if (CollectionUtil.isNotEmpty(dtoList)) {
            Set orderNos = dtoList.stream().map(DgDispatcherOrderDetailDataRespDto::getOrderNo).collect(Collectors.toSet());
            Map<String, BigDecimal> ratioMap = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in((Object)"document_code", orderNos)).list().stream().collect(Collectors.toMap(o -> o.getDocumentCode() + "_" + o.getSkuCode(), r -> BigDecimal.ZERO.compareTo(r.getNum()) == 0 ? BigDecimal.ONE : BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
            dtoList.stream().filter(r -> ratioMap.containsKey(r.getOrderNo() + "_" + r.getSkuCode())).forEach(r -> {
                BigDecimal ratio = (BigDecimal)ratioMap.get(r.getOrderNo() + "_" + r.getSkuCode());
                r.setDispatcherBasicQuantity(r.getDispatcherQuantity());
                r.setProcessingBasicQuantity(r.getProcessingQuantity());
                r.setProcessedBasicQuantity(r.getProcessedQuantity());
                r.setUntreatedBasicQuantity(r.getUntreatedQuantity());
                r.setDispatcherQuantity(BigDecimalUtils.divide((BigDecimal)r.getDispatcherQuantity(), (BigDecimal)ratio, (int)6));
                r.setInQuantity(BigDecimalUtils.divide((BigDecimal)r.getInQuantity(), (BigDecimal)ratio, (int)6));
                r.setOutQuantity(BigDecimalUtils.divide((BigDecimal)r.getOutQuantity(), (BigDecimal)ratio, (int)6));
                r.setQuantity(BigDecimalUtils.divide((BigDecimal)r.getQuantity(), (BigDecimal)ratio, (int)6));
                r.setCancelQuantity(BigDecimalUtils.divide((BigDecimal)r.getCancelQuantity(), (BigDecimal)ratio, (int)6));
                r.setPlanQuantity(BigDecimalUtils.divide((BigDecimal)r.getPlanQuantity(), (BigDecimal)ratio, (int)6));
                r.setProcessedQuantity(BigDecimalUtils.divide((BigDecimal)r.getProcessedQuantity(), (BigDecimal)ratio, (int)6));
                r.setProcessingQuantity(BigDecimalUtils.divide((BigDecimal)r.getProcessingQuantity(), (BigDecimal)ratio, (int)6));
                r.setUntreatedQuantity(BigDecimalUtils.divide((BigDecimal)r.getUntreatedQuantity(), (BigDecimal)ratio, (int)6));
            });
        }
    }

    @Override
    public RestResponse<PageInfo<DgDispatcherOperateLogDataRespDto>> queryDispatcherOperateLogByPage(DgDispatcherOperateLogDataReqDto queryDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getOrderNo())) {
            queryWrapper.like(DgDispatcherOperateLogEo::getOrderNo, (Object)queryDto.getOrderNo());
        }
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List eoList = this.IDgDispatcherOperateLogDas.getMapper().selectList((Wrapper)queryWrapper);
        PageInfo eoPageInfo = new PageInfo(eoList);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgDispatcherOperateLogDataRespDto.class);
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<DgDispatcherOrderDetailSummaryRespDto> queryDispatcherOrderDetailCount(DgDispatcherOrderDetailDataReqDto reqDto) {
        DgDispatcherOrderDetailSummaryRespDto dgDispatcherOrderDetailSummaryRespDto = this.IDgDispatcherOrderDetailDas.queryDispatcherOrderDetailCount(reqDto);
        return new RestResponse((Object)dgDispatcherOrderDetailSummaryRespDto);
    }

    @Override
    public List<DgBasisOrderRelOrderInfoRespDto> queryRelOrderByOrderNo(String orderNo) {
        log.info("\u6839\u636e\u6536\u53d1\u5dee\u5f02\u5355\u53f7\u83b7\u53d6\u5173\u8054\u5355\u636e\u4fe1\u606f\u53c2\u6570:" + orderNo);
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)orderNo), (String)"\u6536\u53d1\u5dee\u5f02\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List transferOrderDtos = this.dgTransferOrderDomain.queryTransferOrderByOrderNo(orderNo);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)transferOrderDtos), (String)"\u6839\u636e\u6536\u53d1\u5dee\u5f02\u5355\u53f7\u627e\u4e0d\u5230\u76f8\u5173\u8c03\u62e8\u5355\u4fe1\u606f");
        ArrayList<String> orderNos = new ArrayList<String>();
        orderNos.add(orderNo);
        List<DgBasisOrderRelOrderInfoRespDto> allRelOrderInfoList = transferOrderDtos.stream().map(transferOrderDto -> {
            DgBasisOrderRelOrderInfoRespDto relOrderInfoRespDto = new DgBasisOrderRelOrderInfoRespDto();
            relOrderInfoRespDto.setDocumentNo(transferOrderDto.getTransferOrderNo());
            relOrderInfoRespDto.setOrderNo(transferOrderDto.getTransferOrderNo());
            TransferOrderEnum transferOrderEnum = TransferOrderEnum.getByCode((String)transferOrderDto.getOrderType());
            relOrderInfoRespDto.setOrderType(transferOrderEnum.getDesc());
            relOrderInfoRespDto.setBusinessType(transferOrderDto.getType());
            relOrderInfoRespDto.setOrderStatus(transferOrderDto.getOrderStatus());
            relOrderInfoRespDto.setCreateTime(transferOrderDto.getCreateTime());
            if (Objects.nonNull(transferOrderDto.getBizDate())) {
                relOrderInfoRespDto.setBizDate(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)transferOrderDto.getBizDate()));
            }
            if (StringUtils.isNotBlank((CharSequence)transferOrderDto.getPreOrderNo())) {
                orderNos.add(transferOrderDto.getTransferOrderNo());
            }
            return relOrderInfoRespDto;
        }).collect(Collectors.toList());
        for (String relevanceNo : orderNos) {
            DgRelOrderReqDto dgRelOrderReqDto = new DgRelOrderReqDto();
            dgRelOrderReqDto.setRelevanceNo(relevanceNo);
            List relOrderInfoList = (List)RestResponseHelper.extractData(this.dgBasisOrderRelOrderInfoService.queryRelOrderByRelevanceNo(dgRelOrderReqDto));
            Optional.ofNullable(relOrderInfoList).ifPresent(allRelOrderInfoList::addAll);
        }
        AtomicInteger ai = new AtomicInteger(1);
        allRelOrderInfoList.forEach(r -> r.setId(Long.valueOf(ai.getAndIncrement())));
        return allRelOrderInfoList;
    }

    private PageInfo<DgDispatcherOrderDataRespDto> getDgDispatcherOrderEsList(DgDispatcherOrderDataQueryReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.DgDispatcherOrderTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgDispatcherOrderDataRespDto orderItemPageDto = (DgDispatcherOrderDataRespDto)BeanUtil.copyProperties((Object)docValue, DgDispatcherOrderDataRespDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(DgDispatcherOrderDataQueryReqDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u6536\u53d1\u5dee\u5f02\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getProcessingQuantity())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            if (YES.equals(reqDto.getProcessingQuantity())) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"isProcessList", (String[])new String[]{YES})});
            } else {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"isProcessList", (String[])new String[]{NO})});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getUntreatedQuantity())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            if (YES.equals(reqDto.getUntreatedQuantity())) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"isWaitList", (String[])new String[]{YES})});
            } else {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)"isWaitList", (String[])new String[]{NO})});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u6536\u53d1\u5dee\u5f02\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    private PageInfo<DgDispatcherOrderItemDetailRespDto> getDgDispatcherOrderDetailEsList(DgDispatcherOrderItemDetailQueryReqDto dto) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.DgDispatcherOrderDetailTableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initDetailSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                DgDispatcherOrderItemDetailRespDto orderItemPageDto = (DgDispatcherOrderItemDetailRespDto)BeanUtil.copyProperties((Object)docValue, DgDispatcherOrderItemDetailRespDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initDetailSearchVo(DgDispatcherOrderItemDetailQueryReqDto reqDto) throws Exception {
        log.info("ES\u76d8\u70b9\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrderNo())) {
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u76d8\u70b9\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

