/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.pda.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.report.dao.das.IDgOutResultOrderDetailDas;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderAddrDas;
import com.yunxi.dg.base.center.report.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.report.dao.das.IOutNoticeOrderDetailDas;
import com.yunxi.dg.base.center.report.dao.das.IOutNoticeOrderOperateLogDas;
import com.yunxi.dg.base.center.report.dao.das.inventory.IDgOutNoticeOrderDas;
import com.yunxi.dg.base.center.report.dao.das.inventory.IDgPhysicsWarehouseDas;
import com.yunxi.dg.base.center.report.dao.das.inventory.IDgTransferOrderDas;
import com.yunxi.dg.base.center.report.dao.vo.DeliveryOrderRespVo;
import com.yunxi.dg.base.center.report.dto.pda.CsDeliveryOrderRespDto;
import com.yunxi.dg.base.center.report.dto.pda.CsDeliveryQueryReqDto;
import com.yunxi.dg.base.center.report.dto.pda.DeliveryAddressDto;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.report.eo.OutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.OutNoticeOrderOperateLogEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutResultOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgPhysicsWarehouseEo;
import com.yunxi.dg.base.center.report.service.pda.IPdaDeliveryOrderService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PdaDeliveryOrderServiceImpl
implements IPdaDeliveryOrderService {
    private static Logger logger = LoggerFactory.getLogger(PdaDeliveryOrderServiceImpl.class);
    @Resource
    private IDgOutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private IDgTransferOrderDas transferOrderDas;
    @Resource
    private IDgPerformOrderInfoDas performOrderInfoDas;
    @Resource
    private IDgPerformOrderAddrDas performOrderAddrDas;
    @Resource
    private IOutNoticeOrderOperateLogDas outNoticeOrderOperateLogDas;
    @Resource
    private IOutNoticeOrderDetailDas outNoticeOrderDetailDas;
    @Resource
    private IDgOutResultOrderDetailDas dgOutResultOrderDetailDas;
    @Resource
    private IDgPhysicsWarehouseDas physicsWarehouseDas;

    @Override
    public PageInfo<CsDeliveryOrderRespDto> queryDeliveryOrderPage(CsDeliveryQueryReqDto queryReqDto) {
        logger.info("\u53d1\u8d27\u5355\u5206\u9875\u67e5\u8be2\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)queryReqDto));
        if (queryReqDto.getStartItemTotalNum() != null && queryReqDto.getEndItemTotalNum() != null && queryReqDto.getStartItemTotalNum() == queryReqDto.getEndItemTotalNum()) {
            queryReqDto.setItemTotalNum(queryReqDto.getStartItemTotalNum());
            queryReqDto.setStartItemTotalNum(null);
            queryReqDto.setEndItemTotalNum(null);
        }
        List displayBusinessTypeList = Optional.ofNullable(queryReqDto.getDisplayBusinessTypeList()).orElse(new ArrayList());
        if (StrUtil.isNotBlank((CharSequence)queryReqDto.getDisplayBusinessType())) {
            displayBusinessTypeList.add(queryReqDto.getDisplayBusinessType());
        }
        queryReqDto.setDisplayBusinessTypeList(displayBusinessTypeList);
        PageInfo deliveryOrderRespVoPageInfo = this.outNoticeOrderDas.queryDeliveryOrderPage(queryReqDto);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)deliveryOrderRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List result = deliveryOrderRespVoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            List documentNos = result.stream().map(DeliveryOrderRespVo::getDocumentNo).collect(Collectors.toList());
            List outNoticeOrderDetails = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outNoticeOrderDetailDas.filter().in((Object)"document_no", documentNos)).orderByDesc((Object)"line_no")).list();
            Map<String, Map<String, List<OutNoticeOrderDetailEo>>> orderSkuQuantityMap = outNoticeOrderDetails.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailEo::getDocumentNo, Collectors.groupingBy(OutNoticeOrderDetailEo::getSkuCode)));
            Map orderSkuNameMap = outNoticeOrderDetails.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailEo::getDocumentNo, Collectors.mapping(OutNoticeOrderDetailEo::getSkuName, Collectors.toSet())));
            Map<String, BigDecimal> orderTotalQuantityMap = outNoticeOrderDetails.stream().collect(Collectors.groupingBy(OutNoticeOrderDetailEo::getDocumentNo, Collectors.mapping(OutNoticeOrderDetailEo::getPlanQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            List outResultOrderDetails = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgOutResultOrderDetailDas.filter().in((Object)"pre_order_no", documentNos)).orderByDesc((Object)"line_no")).list();
            Map<String, Map<String, List<DgOutResultOrderDetailEo>>> orderSkuQuantityResultMap = outResultOrderDetails.stream().collect(Collectors.groupingBy(DgOutResultOrderDetailEo::getPreOrderNo, Collectors.groupingBy(DgOutResultOrderDetailEo::getSkuCode)));
            Map orderSkuNameResultMap = outResultOrderDetails.stream().collect(Collectors.groupingBy(DgOutResultOrderDetailEo::getPreOrderNo, Collectors.mapping(DgOutResultOrderDetailEo::getSkuName, Collectors.toSet())));
            List outPhysicsWarehouseCodes = result.stream().map(DeliveryOrderRespVo::getOutPhysicsWarehouseCode).distinct().collect(Collectors.toList());
            Map physicsWarehouseMap = this.physicsWarehouseDas.getMapByCodes(outPhysicsWarehouseCodes);
            Map<String, List<DeliveryOrderRespVo>> map = result.stream().collect(Collectors.groupingBy(DeliveryOrderRespVo::getRelevanceTableName));
            Map<String, DeliveryAddressDto> deliveryAddressMap = this.getDeliveryAddress(map);
            Map<String, List<OutNoticeOrderOperateLogEo>> historyShippingCodeMap = this.getHistoryShippingCode(result);
            List list = result.stream().map(info -> {
                DgPhysicsWarehouseEo physicsWarehouse;
                Map skuOrderMap;
                CsDeliveryOrderRespDto deliveryOrderRespDto = new CsDeliveryOrderRespDto();
                CubeBeanUtils.copyProperties((Object)deliveryOrderRespDto, (Object)info, (String[])new String[0]);
                if (deliveryAddressMap.containsKey(info.getRelevanceNo())) {
                    DeliveryAddressDto deliveryAddressDto = (DeliveryAddressDto)deliveryAddressMap.get(info.getRelevanceNo());
                    deliveryOrderRespDto.setProvince(deliveryAddressDto.getProvince());
                    deliveryOrderRespDto.setCity(deliveryAddressDto.getCity());
                    deliveryOrderRespDto.setArea(deliveryAddressDto.getArea());
                    deliveryOrderRespDto.setStreet(deliveryAddressDto.getStreet());
                    deliveryOrderRespDto.setAddr(deliveryAddressDto.getAddr());
                    deliveryOrderRespDto.setReceiveName(deliveryAddressDto.getReciveName());
                    deliveryOrderRespDto.setReceivePhone(deliveryAddressDto.getRecivePhone());
                    deliveryOrderRespDto.setAddress(deliveryAddressDto.getAddress());
                    deliveryOrderRespDto.setSellerRemark(deliveryAddressDto.getSellerRemark());
                    deliveryOrderRespDto.setBuyerRemark(deliveryAddressDto.getBuyerRemark());
                    deliveryOrderRespDto.setRemark(deliveryAddressDto.getRemark());
                    deliveryOrderRespDto.setSaleOrderNo(deliveryAddressDto.getSaleOrderNo());
                    deliveryOrderRespDto.setPlatformOrderNo(deliveryAddressDto.getPlatformOrderNo());
                }
                if (historyShippingCodeMap.containsKey(info.getDocumentNo())) {
                    List outNoticeOrderOperateLogEos = (List)historyShippingCodeMap.get(info.getDocumentNo());
                    String historyShippingCode = outNoticeOrderOperateLogEos.stream().map(OutNoticeOrderOperateLogEo::getShippingCode).filter(StringUtils::isNotBlank).collect(Collectors.joining(";"));
                    deliveryOrderRespDto.setHistoryShippingCode(historyShippingCode);
                }
                if (MapUtils.isNotEmpty((Map)orderTotalQuantityMap)) {
                    deliveryOrderRespDto.setItemTotalNum((BigDecimal)orderTotalQuantityMap.get(info.getDocumentNo()));
                }
                if (MapUtils.isNotEmpty((Map)orderSkuNameMap)) {
                    Set skuNameSet = (Set)orderSkuNameMap.get(info.getDocumentNo());
                    deliveryOrderRespDto.setItemInfo(StringUtils.join((Iterable)skuNameSet, (String)";"));
                }
                if (MapUtils.isNotEmpty((Map)orderSkuNameMap) && MapUtils.isNotEmpty((Map)(skuOrderMap = (Map)orderSkuQuantityMap.get(info.getDocumentNo())))) {
                    ArrayList skuNameList = new ArrayList();
                    ArrayList skuDisplayNameList = new ArrayList();
                    List skuQuantityStr = skuOrderMap.entrySet().stream().map(entry -> {
                        BigDecimal value = ((List)entry.getValue()).stream().map(OutNoticeOrderDetailEo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(0, 1);
                        skuNameList.add(((OutNoticeOrderDetailEo)((List)entry.getValue()).get(0)).getSkuName());
                        skuDisplayNameList.add(((OutNoticeOrderDetailEo)((List)entry.getValue()).get(0)).getSkuDisplayName());
                        return (String)entry.getKey() + "*" + value.toString();
                    }).collect(Collectors.toList());
                    deliveryOrderRespDto.setItemExtInfo(StringUtils.join(skuQuantityStr, (String)";"));
                    deliveryOrderRespDto.setItemInfo(StringUtils.join(skuNameList, (String)";"));
                    deliveryOrderRespDto.setSkuDisplayNameSetStr(StringUtils.join(skuDisplayNameList, (String)";"));
                }
                if (MapUtils.isNotEmpty((Map)orderSkuNameResultMap) && (StringUtils.isEmpty((CharSequence)deliveryOrderRespDto.getItemExtInfo()) || StringUtils.isEmpty((CharSequence)deliveryOrderRespDto.getSnCode()) || StringUtils.isEmpty((CharSequence)deliveryOrderRespDto.getSnCodeExtInfo())) && MapUtils.isNotEmpty((Map)(skuOrderMap = (Map)orderSkuQuantityResultMap.get(info.getDocumentNo())))) {
                    List skuSnCodeStr = skuOrderMap.values().stream().flatMap(Collection::stream).filter(o -> StringUtils.isNotBlank((CharSequence)o.getSnCode())).map(outResultOrderDetailEo -> outResultOrderDetailEo.getSnCode() + "(sku:" + outResultOrderDetailEo.getSkuCode() + ")").collect(Collectors.toList());
                    List snCodeStr = skuOrderMap.values().stream().flatMap(Collection::stream).map(DgOutResultOrderDetailEo::getSnCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                    deliveryOrderRespDto.setSnCode(StringUtils.join(snCodeStr, (String)";"));
                    deliveryOrderRespDto.setSnCodeExtInfo(StringUtils.join(skuSnCodeStr, (String)";"));
                }
                if (!"fail".equals(deliveryOrderRespDto.getPushStatus())) {
                    deliveryOrderRespDto.setPushMsg(null);
                }
                if ((physicsWarehouse = (DgPhysicsWarehouseEo)physicsWarehouseMap.get(deliveryOrderRespDto.getOutPhysicsWarehouseCode())) != null) {
                    deliveryOrderRespDto.setInterconnectionWms(physicsWarehouse.getInterconnectionFlag());
                    deliveryOrderRespDto.setThirdWarehouseCode(physicsWarehouse.getThirdCode());
                }
                return deliveryOrderRespDto;
            }).collect(Collectors.toList());
            respDtoPageInfo.setList(list);
        }
        return respDtoPageInfo;
    }

    public Map<String, List<OutNoticeOrderOperateLogEo>> getHistoryShippingCode(List<DeliveryOrderRespVo> result) {
        List documentNoList = result.stream().map(DeliveryOrderRespVo::getDocumentNo).distinct().collect(Collectors.toList());
        List outNoticeOrderOperateLogEoList = ((ExtQueryChainWrapper)this.outNoticeOrderOperateLogDas.filter().in((Object)"out_notice_order_no", documentNoList)).select(new String[]{"id,out_notice_order_no,shipping_code"}).list();
        return ((List)Optional.ofNullable(outNoticeOrderOperateLogEoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(OutNoticeOrderOperateLogEo::getOutNoticeOrderNo));
    }

    public Map<String, DeliveryAddressDto> getDeliveryAddress(Map<String, List<DeliveryOrderRespVo>> map) {
        List orderNo;
        List<DeliveryOrderRespVo> deliveryOrderRespVos;
        HashMap<String, DeliveryAddressDto> addressDtoMap = new HashMap<String, DeliveryAddressDto>();
        if (map.containsKey(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode()) && CollectionUtils.isNotEmpty(deliveryOrderRespVos = map.get(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode()))) {
            orderNo = deliveryOrderRespVos.stream().map(DeliveryOrderRespVo::getRelevanceNo).distinct().collect(Collectors.toList());
            List transferOrderNo = ((ExtQueryChainWrapper)this.transferOrderDas.filter().select(new String[]{"transfer_order_no,province,city,area,address,contact,contact_phone"}).in((Object)"transfer_order_no", orderNo)).list();
            transferOrderNo.forEach(info -> {
                DeliveryAddressDto addressDto = new DeliveryAddressDto();
                addressDto.setProvince(info.getProvince());
                addressDto.setCity(info.getCity());
                addressDto.setArea(info.getArea());
                addressDto.setStreet(info.getStreet());
                addressDto.setAddr(info.getAddress());
                addressDto.setAddress(info.getProvince() + info.getCity() + info.getArea() + info.getAddress());
                addressDto.setReciveName(info.getContact());
                addressDto.setRecivePhone(info.getContactPhone());
                addressDtoMap.put(info.getTransferOrderNo(), addressDto);
            });
        }
        if (map.containsKey(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode()) && CollectionUtils.isNotEmpty(deliveryOrderRespVos = map.get(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode()))) {
            orderNo = deliveryOrderRespVos.stream().map(DeliveryOrderRespVo::getRelevanceNo).distinct().collect(Collectors.toList());
            List saleOrderNo = ((ExtQueryChainWrapper)this.performOrderInfoDas.filter().select(new String[]{"id,sale_order_no,platform_order_no,seller_remark,buyer_remark,remark"}).in((Object)"sale_order_no", orderNo)).list();
            List idList = saleOrderNo.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(idList)) {
                List saleOrderAddress = ((ExtQueryChainWrapper)this.performOrderAddrDas.filter().in((Object)"order_id", idList)).list();
                Map addressEoMap = ((List)Optional.ofNullable(saleOrderAddress).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgPerformOrderAddrEo::getOrderId, Function.identity(), (v1, v2) -> v2));
                saleOrderNo.forEach(info -> {
                    DeliveryAddressDto addressDto = new DeliveryAddressDto();
                    addressDto.setBuyerRemark(info.getBuyerRemark());
                    addressDto.setSellerRemark(info.getSellerRemark());
                    addressDto.setPlatformOrderNo(info.getPlatformOrderNo());
                    addressDto.setSaleOrderNo(info.getSaleOrderNo());
                    addressDto.setRemark(info.getRemark());
                    if (addressEoMap.containsKey(info.getId())) {
                        DgPerformOrderAddrEo performOrderAddrEo = (DgPerformOrderAddrEo)addressEoMap.get(info.getId());
                        addressDto.setProvince(performOrderAddrEo.getProvince());
                        addressDto.setCity(performOrderAddrEo.getCity());
                        addressDto.setArea(performOrderAddrEo.getCounty());
                        addressDto.setStreet(performOrderAddrEo.getStreet());
                        addressDto.setAddr(performOrderAddrEo.getReceiveAddress());
                        addressDto.setReciveName(performOrderAddrEo.getReceiveName());
                        addressDto.setRecivePhone(performOrderAddrEo.getReceivePhone());
                        addressDto.setAddress(this.getAddressInfo(performOrderAddrEo));
                    }
                    addressDtoMap.put(info.getSaleOrderNo(), addressDto);
                });
            }
        }
        return addressDtoMap;
    }

    public String getAddressInfo(DgPerformOrderAddrEo performOrderAddrEo) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getProvince())) {
            stringBuilder.append(performOrderAddrEo.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getCity())) {
            stringBuilder.append(performOrderAddrEo.getCity());
        }
        if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getCounty())) {
            stringBuilder.append(performOrderAddrEo.getCounty());
        }
        if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getStreet())) {
            stringBuilder.append(performOrderAddrEo.getStreet());
        }
        if (StringUtils.isNotBlank((CharSequence)performOrderAddrEo.getReceiveAddress())) {
            stringBuilder.append(performOrderAddrEo.getReceiveAddress());
        }
        return stringBuilder.toString();
    }
}

