/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditResultEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditTypeEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderAuditDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAuditDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAuditEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgSaleOrderAuditDomainImpl
extends BaseDomainImpl<DgSaleOrderAuditEo>
implements IDgSaleOrderAuditDomain {
    @Resource
    private IDgSaleOrderAuditDas das;

    public ICommonDas<DgSaleOrderAuditEo> commonDas() {
        return this.das;
    }

    @Override
    public void saveSaleOrderAudit(Long orderId, DgSaleAuditTypeEnum saleAuditTypeEnum, DgSaleAuditResultEnum saleAuditEnum) {
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        if (StringUtils.isBlank((CharSequence)requestUserCode)) {
            requestUserCode = "system";
        }
        DgSaleOrderAuditEo saleOrderAuditEo = new DgSaleOrderAuditEo();
        saleOrderAuditEo.setOrderId(orderId);
        saleOrderAuditEo.setAuditor(requestUserCode);
        saleOrderAuditEo.setAuditTime(new Date());
        saleOrderAuditEo.setAuditResult(saleAuditEnum.getCode());
        saleOrderAuditEo.setAuditType(saleAuditTypeEnum.getType());
        this.das.insert((BaseEo)saleOrderAuditEo);
    }

    @Override
    public void saveSaleOrderAudit(Long orderId, String saleAuditType, DgSaleAuditResultEnum saleAuditEnum) {
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        if (StringUtils.isBlank((CharSequence)requestUserCode)) {
            requestUserCode = "system";
        }
        DgSaleOrderAuditEo saleOrderAuditEo = new DgSaleOrderAuditEo();
        saleOrderAuditEo.setOrderId(orderId);
        saleOrderAuditEo.setAuditor(requestUserCode);
        saleOrderAuditEo.setAuditTime(new Date());
        saleOrderAuditEo.setAuditResult(saleAuditEnum.getCode());
        saleOrderAuditEo.setAuditType(saleAuditType);
        this.das.insert((BaseEo)saleOrderAuditEo);
    }

    @Override
    public DgSaleOrderAuditEo selectByOrderIdAndAuditType(Long orderId, DgSaleAuditTypeEnum saleAuditTypeEnum) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DgSaleOrderAuditEo::getOrderId, (Object)orderId);
        wrapper.eq(DgSaleOrderAuditEo::getAuditType, (Object)saleAuditTypeEnum.getType());
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.orderByDesc(BaseEo::getCreateTime);
        return (DgSaleOrderAuditEo)this.das.getMapper().selectOne((Wrapper)wrapper);
    }
}

