/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.trade.dao.das.IOrderAuditDas;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderAuditDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderAuditDto;
import com.yunxi.dg.base.center.trade.eo.OrderAuditEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class OrderAuditDomainImpl
extends BaseDomainImpl<OrderAuditEo>
implements IOrderAuditDomain {
    @Resource
    private IOrderAuditDas das;
    @Resource
    private IContext context;

    public ICommonDas<OrderAuditEo> commonDas() {
        return this.das;
    }

    @Override
    public OrderAuditEo queryNewestByOrderNoAndAuditType(String orderNo, Integer auditType) {
        return this.das.queryNewestByOrderNoAndAuditType(orderNo, auditType);
    }

    @Override
    public void auditLogSave(DgAfterSaleOrderAuditDto auditDto, String type, String afterSaleOrderNo) {
        OrderAuditEo orderAuditEo = new OrderAuditEo();
        orderAuditEo.setOrderType(OptBizTypeEnum.RETURN.getType());
        orderAuditEo.setAuditStatus(auditDto.getAuditStatus());
        orderAuditEo.setAuditDesc(auditDto.getAuditDesc());
        orderAuditEo.setTradeNo(afterSaleOrderNo);
        if (StringUtils.isBlank((CharSequence)auditDto.getAuditor())) {
            orderAuditEo.setAuditor(this.context.userName());
        }
        if (auditDto.getAuditTime() == null) {
            orderAuditEo.setAuditTime(new Date());
        }
        this.das.insert((BaseEo)orderAuditEo);
    }
}

